//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//
//      Bad Dogs
//      
//  (C) 2005, M Daugherty
//  gromit@ix.netcom.com
//  
//  Submitted for the IRTC Ray Tracing Competition
//  March - April 2005, "Catastrophe"
//    
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//
//  Primary scene file 
//  Apr 30, 2005
//
//  Requires 
//      - Scene.inc
//      - Mapleleaf.inc
//      - Grass.inc
//    
//
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//
//  You are free to use this for 
//  non-commercial purposes as long as 
//  you include attribution to original author.
//  All other rights reserved.
//                          
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                                            

//%%%%%%%%%%%%% Declarations & Options %%%%%%%%%%%%%%%%%%%
//
//
//
//  Render at +h1024 +w768
//            +h800  +w600  



#version 3.6;                                            

#include "colors.inc"


// Option Settings
//


#declare Lights_Num     = 1;
#declare Camera_Num     = 1;
#declare Include_Tree   = 1;
#declare Include_Cat    = 1;
#declare Include_Dog1   = 1;      
#declare Include_Dog2   = 1;
#declare Include_Saw    = 1;
#declare Include_Grass  = 1;
#declare Radiosity_On   = 1;


// Global Settings and Radiosity
//
global_settings {   
    assumed_gamma 1.0


    #if (Radiosity_On)
    radiosity {
        pretrace_start 0.08
        pretrace_end   0.04
        count 35
        
        nearest_count 5
        error_bound 1.8
        recursion_limit 3
        
        low_error_factor 0.5
        gray_threshold 0.0
        minimum_reuse 0.015
        brightness 1
        
        adc_bailout 0.01/2
    }
    
    #default {finish {ambient 0 } }
    
    #end
    
}



// Lights
//
#switch (Lights_Num)
    
    // Test light
    #case (1)
    light_source { 
         <45, 90, 40> * 100
         color rgb<1.7,1.5,1.2>
         parallel point_at 0
    }
   

    #break
    
    // Light used for final render
    #case (2)       
     light_source {
        <40,75,40> *2000
        color White
         parallel point_at 0
    }
    #break
    
#end // switch (Lights_Num)


// Camera
//

#switch (Camera_Num)
    
    // Camera used for final render
    #case (1)

    #declare Bump = <-0.15,0,-0.1>*12;
    #declare Bump = Bump + <-1.0,0,0.5>;
    
    camera {          
        sky <-0.43,0,-1> 
        location <7.5, 38, 4.7>+Bump
 
        up z
        right<-.75,0,0>
        
        look_at <2.5, 0, -1> +Bump
        
        angle 36
    }
    # break
 
    
    // Birds Eye
    #case (2)
    camera {
        up z
        right<-.75,0,0>
        location <0,44,0>
        look_at  <0,5,0>

    }
    # break 
    
    // Branch Level
    #case (3)
    camera {
        location <4,33,6>

        up z
        right<-.75,0,0>

        look_at  <2,30,0>

    }
    # break
    
    #case (4)
    camera {
        location <4,10,6>

        up z
        right<-.75,0,0>

        look_at  <0,0,0>

    }
    # break 
    
    #case (5)
    camera {
        location <14,-9.5,16>

        up z
        right<-.75,0,0>

        look_at  <0,-10,-3>

    }
    # break
    
#end

// Declare some textures before the include files
//


#declare default_WingsMat = texture{pigment{Red}}

#declare t_Black = texture{pigment{Gray10}} 

#declare t_White = texture{pigment{White}} 

#declare t_Pink  = texture{pigment{Pink}}

// Declare tree texture layers...  
#declare n_Tree =
normal {granite 0.75  scale .25 //scale <.6,4,.6>  
  
}


#declare t1 = 
texture {
    pigment {
          rgb <0.75, 0.65, 0.45>*.8
          
    
    }
    normal {n_Tree}

}

#declare t2 = 
texture{
    pigment {
        crackle color_map {
            [0.0 color Clear]
            [0.15 rgbt <.2,.2,.2,.8>]
            [0.30 color Clear]
        } 
        turbulence .23
        scale 0.25
    }
    normal {n_Tree}
}

#declare t3 = 
texture {
    pigment {
        bozo color_map {
            [0.5 rgbt <.84,.8,.76,.8>]
            [1.0 rgbt <1,1,1,1>]
        } 
        turbulence .3
        scale 0.5
    }
    normal {n_Tree}        
}

#declare t_Tree = 
    texture {t1}
    texture {t2}
    texture {t3}

#declare t_Cut = texture{}


#declare t_Branch = texture {t_Tree scale <0.5,0.5,.8>} //rotate 90*z}


#declare t_Cat  =  
texture {
    pigment{Gray15}
}

#declare t_Dog1 =  
texture {
    pigment{rgb <.9,.9,.4>}
    normal {granite 0.2}
} 


#declare t_Dog2 =  
texture {
    
    pigment {
        rgb <.75,.36,.15>*.65
    }
    
    finish {
        ambient .2
        diffuse .4
        specular .25
        roughness .5
        metallic
        reflection {
          .15
          metallic
        }
     }

            
    normal {granite 0.3 scale .2}
}

#declare t_Saw = 
texture {
    pigment{Gray}
    normal { wood scale 0.05} 
    finish {
        reflection {
          .33 metallic
        } 
    }      
}

#declare t_Handle = texture {pigment{rgb < .3,.2,.1 > }}
#declare t_Leaf = 
texture{
    pigment{rgb<0.43,.62,.051>}
}

#declare t_Grass =     
texture {
    pigment{rgb<.35,1,.1>}
    finish {specular 0.8 roughness 0.25 }
}


#include "Scene.inc"    
#include "MapleLeaf.inc"
#include "Grass.inc"


//%%%%%%%%%%%%% Start Scene  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//

#declare GrassBaseHeight = -11;

// Sky Sphere
sky_sphere {
    pigment {
        gradient y color_map {
            [0.0 White]
            [0.4 Navy]
            
        }
    }                
}


// Grass/ Ground Plane
plane {y, GrassBaseHeight 
    pigment {
        rgb <.25, .36, .18>
        }
}



// Side walk
/*
box {<-1,0,-1> <1,0.1,1> pigment {White}
    scale <0.5,1,20>
    translate <-10,-5,0>
}    
*/

// %%%%%%%%%%%%%%%%%%%% Draw Tree %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// 


#if (Include_Tree)
    // Draw the tree 
    object {Tree}
    
    //object{Tree_Branch}
    object{Branch}
    
    
    object {LeafCluster}
    
    
    // Draw some leaves down below
 
    #declare R3 = seed(1408); 
    
    object {Leaf rotate 360*rand(R3)*y translate <   5,GrassBaseHeight+2,  2>}
    object {Leaf rotate 360*rand(R3)*y translate <  7,GrassBaseHeight+2, -6>}
    object {Leaf rotate 360*rand(R3)*y translate < -21,GrassBaseHeight+2, -8>}
    object {Leaf rotate 360*rand(R3)*y translate <  16,GrassBaseHeight+2,  8>}
        
#end // if (Include_Tree)


// %%%%%%%%%%%%%%%%%%%% Draw Cat %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// 

#if (Include_Cat)
    object {Cat}
#end // if (Include_Cat)



// %%%%%%%%%%%%%%%%%%%% Draw Dog 1 on Left %%%%%%%%%%%%%%%%%%%%%%%%%%%
// 

#if (Include_Dog1)
    object {Dog1}    
#end // if (Include_Dog1)


// %%%%%%%%%%%%%%%%%%%% Draw Dog 2 on Right %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// 


#if (Include_Dog2)
    object {Dog2}    
#end // if (Include_Dog2)


// %%%%%%%%%%%%%%%%%%%% Draw Saw %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// 

#if (Include_Saw)
    object {Saw}
#end // if (Include_Saw)


// %%%%%%%%%%%%%%%%%%%% Draw Saw %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// 

#if (Include_Grass) 
    #declare XMin = -23; // -20
    #declare XMax = 20;  // 18
    #declare ZMin = -33;// -25
    #declare ZMax = 21;  // 20
    
    
    #declare XMesh = .15;
    #declare ZMesh = .15;
    #declare R1 = seed(1343);
    #declare R2 = seed(36236);
    #declare R3 = seed(14);
    
    
    #declare XCount = XMin;
    #while (XCount < XMax)
        #declare ZCount = ZMin;
        #while (ZCount < ZMax)
            //sphere {0,.05  pigment {Orange}
            
            object{Grass scale 0.02*<.5,.25,.5>
                rotate rand(R1)*180*y rotate 30*rand(R2)*x
                translate <XCount+rand(R1),GrassBaseHeight,ZCount+rand(R1)> 
            }
    
            
            #declare ZCount = ZCount + ZMesh;
        #end  // While (ZCount)
        #declare XCount = XCount + XMesh;
    #end  // while (XCount)
#end // if (Include_Grass)



/*
difference {
    cylinder{<0,0,0> <0,.1,0> 1 }
    intersection {
        box {<0,-1,0> <1,1,1> rotate 0*y}  // (-) is CW
        box {<0,-1,0> <1,1,1> rotate 0*y}   // (+) is CCW
    }    
    pigment {Orange}
    scale <30,1,30>
    translate <0,40,0>
}


#declare Line = 
union {
#declare Count = 0;
    #while (Count < 40)
        
        object {Leaf rotate 90*x translate <0,0,Count>}
        
        #declare Count = Count + 1;
    #end  // While (ZCount)
    
}    

object{ Line rotate 50*y }
*/ 

#declare Group =
union {
    object {Leaf rotate 180*y rotate 50*x translate <0,0,0>}
    object {Leaf rotate 180*y rotate 50*x translate <-1,0,1>}
    object {Leaf rotate 180*y rotate 50*x translate <1,0,1>}
    object {Leaf rotate 180*y rotate 50*x translate <0,0,3>}
} 

#declare Group2 =
union {
    object {Group translate <0,0,6>  }
    object {Group rotate 30*y translate <2,0,2> }
    object {Group rotate -30*y translate <-2,0,2> }

}
//object{Leaf scale 15 rotate -75*x}



#declare R1 = seed(1343);
#declare R2 = seed(3243);  
    
#declare Min = 0; // -20
#declare Max = 2;  // 18
#declare RMin = 0;// -25
#declare RMax = 30;  // 20


#declare Mesh = 1;
#declare RMesh = 1;

       
#declare RCount = RMin;
#while (RCount < RMax)
    #declare Count = Min;
    #while (Count < Max*RCount/4)
       
        object {Group2 rotate (90*rand(R2)-45)*y translate <0,45,RCount> rotate (45*rand(R1)+(82+RCount/4))*y translate <0,0,-.2>}
        object {Group2 rotate (90*rand(R2)-42)*y translate <0,45,RCount> rotate (30*rand(R1)+(-10-RCount/4))*y translate<1,0,0>}
        
        #declare Count = Count + Mesh;
    #end  // While (ZCount)
    #declare RCount = RCount + RMesh;
#end  // while (XCount)



#declare R1 = seed(1258);
#declare R2 = seed(7843);

#declare Min = 0; // -20
#declare Max = 4;  // 18
#declare RMin = 0;// -25
#declare RMax = 20;  // 20


#declare Mesh = 1;
#declare RMesh = 1;

       
#declare RCount = RMin;
#while (RCount < RMax)
    #declare Count = Min;
    #while (Count < Max*RCount/4)
  
        object {Group2 rotate (90*rand(R2)-45)*y translate <0,44,RCount> rotate (45*rand(R1)+90)*y translate<0,0,0>}
        object {Group2 rotate (90*rand(R2)-45)*y translate <0,44,RCount> rotate (30*rand(R1)-15)*y translate<0,0,2>}
        
        #declare Count = Count + Mesh;
    #end  // While (ZCount)
    #declare RCount = RCount + RMesh;
#end  // while (XCount)
