/**************************************************************
 * Persistence Of Vision Ray Tracer Scene Description File
 *
 * File name  : minesweeper.pov
 * Version    : 3.6.1a
 * Date       : March 2, 2005
 * Author     : John Munson
 * Description: What happens when minesweeper becomes 
 *              semi-real and you click the wrong space.
 **************************************************************/

/**************************************************************
 * TODO: possibly change explosion
 *       add object interaction
 *       animate
 **************************************************************/

#version 3.6
#include "shapes.inc"
                      
// %%%%%%%%%%%%%%%%%%%%% Control Center %%%%%%%%%%%%%%%%%%%%% //
#declare quick_render  =0;
#declare use_radiosity =2;  //2 for higher quality
#declare use_foc_blur  =1;
                      
// %%%%%%%%%%%%%%%%%%%%% Global Settings %%%%%%%%%%%%%%%%%%%% //
global_settings {
  ambient_light rgb 1
  assumed_gamma 1
  max_trace_level 25
  
  #if (use_radiosity=1)     // low quality (faster)
    radiosity {
      pretrace_start 0.08
      pretrace_end   0.01
      count 20
      nearest_count 3
      error_bound 3.0
      recursion_limit 1
      low_error_factor 1
      gray_threshold 0.0
      minimum_reuse 0.015
      brightness 0.75
      always_sample off
    }
  #end
  #if(use_radiosity=2)      // high quality (sloooow)
    radiosity {             
      pretrace_start 0.08
      pretrace_end   0.005
      count 400
      error_bound 0.1
      recursion_limit 1
    }
  #end
} 

// %%%%%%%%%%%%%%%%%%%%% Camera %%%%%%%%%%%%%%%%%%%%%%%%%%%%% //
#declare cl=<105,40,-45>;  // camera location  Brdcntr=<43,0,-18>
#declare la=<60,0,-18>;    // look at

camera {
  location cl
  look_at  la
    
  up <0,1,0>
  right x*image_width/image_height  // keep standard aspect ratio
  
  #if(use_foc_blur)
    focal_point <23*3,0,11*-3> // object in focus
    aperture 1.5               // a nice compromise
    blur_samples 100           // more samples, higher quality image
  #end    
} 
    
// %%%%%%%%%%%%%%%%%%%%% Lights %%%%%%%%%%%%%%%%%%%%%%%%%%%%% //
light_source {
  <1000, 10000, -15000> 
  color rgb <1.0, 0.9, 0.78>*2 
  rotate y*30
  rotate x*30
}

// %%%%%%%%%%%%%%%%%%%%% Sky Sphere %%%%%%%%%%%%%%%%%%%%%%%%% //
sphere {              
  <0, 0, 0>, 1
  texture {
    pigment {
      gradient y
      color_map {
        [0.0 color rgb < 1.0, 1.0, 1.0 >]
        [0.3 color rgb < 0.5, 0.6, 1.0 >]
      }
    }
    finish { diffuse 0 ambient 1 }
  }
  scale 10000
  hollow on
  no_shadow
}

// %%%%%%%%%%%%%%%%%%%%% Materials %%%%%%%%%%%%%%%%%%%%%%%%%% //
#default {
   texture {
      pigment {green 1}
      finish {ambient 0.0 diffuse 0.6}
   }
} /**/
  
// %%%%%%%%%%%%%%%%%%%%% Objects %%%%%%%%%%%%%%%%%%%%%%%%%%%% //
// Time:43, 58 bombs left
#declare Board =    // number, e=empty=0, b=bomb=9, f=flag=10; u=unclicked=11, r=killed spot=12 
array[16][30] {     // array[y][x]
  {11,11,11,11,11,11,11,11,11,11,11,11,11,11, 1, 0, 0, 1,10, 2, 2, 1, 2, 1, 1, 1,10, 1, 1,10},   
  {11,11,11,11,11,11,11,11,11,11,11, 9,11, 9, 3, 2, 1, 1, 2,10, 2,10, 3,10, 3, 2, 1, 1, 1, 1},   
  { 9,11, 9,11, 9,11,11,11,11,11,11,11,11,11,10,10, 1, 1, 2, 2, 2, 1, 3,10,10, 1, 0, 1, 1, 1},   
  {11,11,11,11, 9,11,11,11, 9,11,11,11,11,11, 3, 2, 1, 2,10, 3, 1, 1, 2, 3, 2, 1, 0, 1,10, 2},   
  {11, 9,11,11,11,11,11,11,11,11,11,11, 9, 9, 1, 0, 1, 4,10,10, 1, 2,10, 2, 0, 0, 0, 1, 3,10},   
  {11,11,11,11,11, 9, 9,11,11, 9,11,11, 9, 3, 1, 0, 1,10,10, 4, 1, 2,10, 2, 0, 0, 0, 1, 3,10},
  {11,11,11,11,11,11,11,11,11,11,11,11, 1, 2, 1, 1, 2, 4,10, 2, 0, 1, 1, 1, 0, 1, 1, 2,10, 3},
  {11,11,11,11, 9,11,11, 9, 2,11,11, 1, 1, 1,10, 1, 2,10, 4, 3, 2, 1, 0, 0, 1, 2,10, 2, 2,10},
  {11,11,11,11,11,11,11, 9,11,11,11, 9, 2, 1, 1, 1, 2,10, 4,10,10, 2, 1, 0, 1,10, 2, 1, 1, 1},
  {11,11,11,11,11,11, 9,11, 9,11,11, 9, 3, 1, 1, 0, 1, 1, 3,10, 6,10, 2, 0, 1, 2, 2, 2, 1, 1},
  {11,11, 9,11, 9,11,11,11,11,11,11,11,11,10, 1, 0, 0, 0, 1, 2,10,10, 4, 1, 1, 2,10, 4,10, 1},
  {11,11,11,11, 9,11,11,11,11, 9,11,11,11, 2, 2, 2, 2, 1, 0, 1, 3, 9,11,12,11,11, 9, 9,11,11},   // killed=Board[11][23]
  { 9,11,11,11,11, 2,11,11,11,11, 9,11, 9, 1, 1,10,10, 2, 0, 1, 2,11,11, 9, 9,11,11,11,11, 9},
  { 9,11, 9,11,11, 9,11,11,11,11, 9,11,11, 3, 3, 4,10, 3, 2, 3,10, 3, 9,11,11,11, 9,11,11,11},
  {11,11,11,11,11, 9,11,11,11,11, 9, 9,11, 9, 9,11,11,11, 9, 9,11, 9,11,11,11,11, 9,11,11, 9},
  {11,11,11,11,11, 9,11, 9, 9,11,11,11,11,11,11,11, 9,11,11,11, 9,11,11, 9, 9,11,11,11,11,11}   
}

#declare Block=
  #if(quick_render)
    box{<-1,0,-1>, <1,2,1>
  #else
    object{Round_Box(<-1,0,-1>, <1,2,1>, .2, 1)
  #end
      pigment{rgb .4}
    }

#declare Flag=
  union{
    union{
      sphere{<0,2,0>,.5}
      cylinder{<0,2,0>,<0,4.5,0>,.1}
      pigment{rgb 0}
      //finish{Phong_Dull}
    }
    cone{<0,4,0>,.5,<1,4,0>,.1 scale <1,1,.2> pigment{red 1}}
  }

#declare Bomb=
  union{
    sphere{0,.8}
    cylinder{<.99,0,0>,<-.99,0,0>,.1}
    cylinder{<.99,0,0>,<-.99,0,0>,.1 rotate y*45}
    cylinder{<.99,0,0>,<-.99,0,0>,.1 rotate y*-45}
    cylinder{<0,0,.99>,<0,0,-.99>,.1}
    cylinder{<0,0,.99>,<0,0,-.99>,.1 rotate x*45}
    cylinder{<0,0,.99>,<0,0,-.99>,.1 rotate x*-45}
    cylinder{<0,-.99,0>,<0,.99,0>,.1}
    cylinder{<0,-.99,0>,<0,.99,0>,.1 rotate z*45}
    cylinder{<0,-.99,0>,<0,.99,0>,.1 rotate z*-45}
    pigment{rgb 0} 
    finish {phong 1 phong_size 300 reflection {0,.75}}
    translate y*1
  }

//Display Box
#declare Disp_Box=
  union{
    difference{
      box{<-3.4,0,-2>,<3.4,2,2> pigment{rgb .65}}
      box{<-2.9,1.75,-1.5>,<2.9,2.1,1.5> pigment{rgb 0}}
    } /**/
    union{  
      sphere{<-3.15,2,-1.75>,.15}
      sphere{<-3.15,2,1.75>,.15}
      sphere{<3.15,2,-1.75>,.15}
      sphere{<3.15,2,1.75>,.15}
      pigment{rgb <0.39, 0.41, 0.43>}
      finish {
        ambient 0.35
        brilliance 2
        diffuse 0.3
        metallic
        specular 0.80
        roughness 1/20
        reflection 0.1
      }
    }
  }

#include "svn_seg.inc"
//Time count
#declare Tm_Cnt=
union{
  object{Disp_Box}
  union{
    object{Svn_Seg(0) translate x*-4}
    object{Svn_Seg(4)}
    object{Svn_Seg(3) translate x*4}  
    scale .5 translate y*1.75
  }
}

//Bomb count
#declare Bm_Cnt=
union{
  object{Disp_Box}
  union{
    object{Svn_Seg(0) translate x*-4}
    object{Svn_Seg(5)}
    object{Svn_Seg(8) translate x*4}  
    scale .5 translate y*1.75
  }
}

//Dead head
#declare Head=
sphere{0,1
  pigment{
		image_map { png "dead.png"
			map_type 1        // spherical
      interpolate 0     // none
		}
		rotate z*-90
		rotate y*-90
	}  
	rotate x*-45
	scale 2
}


// %%%%%%%%%%%%%%%%%%%%% Scene %%%%%%%%%%%%%%%%%%%%%%%%%%%%%% //                
object{Head translate <45,2,6> }
object{Tm_Cnt scale 1.5 translate <81,0,6>}
object{Bm_Cnt scale 1.5 translate <6,0,6>}


#declare Spc=3;                      // unit spacing
#declare Expld=<23*Spc,0,11*-Spc>;   // explosion point
#declare R1 = seed(3);

#local Y=0;
#while (Y<16)

  #local X=0;
  #while (X<30)    
    #local obj=Board[Y][X];
                                               
    #local loc=<X*Spc,0,Y*-Spc>; 
    #local dist=sqrt(pow(Expld.x-loc.x,2)+pow(Expld.z-loc.z,2));
    #local xDir=select (Expld.x-loc.x, -1, 0, 1);
    #local zDir=select (Expld.z-loc.z, -1, 0, 1);
    
    #local mov=<xDir,-2,zDir>*10*(dist*dist)/pow(2,dist);
    
    #if (obj=11) // Block
      object{Block rotate <rand(R1),rand(R1),rand(R1)>*mov.y*45 translate loc - mov}
    #end
    #if (obj=9)  // Bomb      
      object{Bomb rotate <rand(R1),rand(R1),rand(R1)>*mov.y*45 translate loc - mov}
    #end
    #if (obj=10) // Flagged Block
      union{
        object{Flag}
        object{Block}
        rotate <rand(R1),rand(R1),rand(R1)>*mov.y*45
        translate loc - mov 
      }
    #end
    /*#if (obj=12) // Killed Block/explosion
      union{
        object{Block pigment {red 1 filter .9}}
        object{Bomb}
        rotate <rand(R1),rand(R1),rand(R1)>*mov.y*45
        translate loc - mov 
      }
    #end*/ 
    #if (obj>0 & obj<9) // Numbers
      text{
        ttf "raavi.ttf" str(obj,0,0) .1,0
        rotate x*90
        scale 2 translate <-.5,0,-.75>
                                                                              
        rotate <rand(R1),rand(R1),rand(R1)>*mov.y*45       
        translate (loc - mov + y*.5 )
        
        #if(obj=1) pigment{blue 1} #end
        #if(obj=2) pigment{green .5} #end
        #if(obj=3) pigment{red 1} #end
        #if(obj=4) pigment{blue .5} #end
        #if(obj=6) pigment{rgb <0,.5,.5>} #end
        #if(obj=5 | obj>6) pigment{rgb .9} #end // didn't write colors for unused numbers
      } 
    #end
                                      
    #local X=X+1;
  #end
    
  #local Y=Y+1;
#end   /**/

// Media Cloud
sphere{ <0,0,0>,1.5  
  pigment { color rgbt 1 } hollow
  interior{ 
    media{
      scattering { 4, .2 } //type 4
      density{spherical}
      density{granite}
    }                     
  }
  scale <9,9,9> 
  translate Expld
} /**/   

// %%%%%%%%%%%%%%%%%%%%% Floor %%%%%%%%%%%%%%%%%%%%%%%%%%%%%% //
union{
  difference{
    plane {
      y, 0    
      texture {
        pigment {
          rgb <0.847059, 0.847059, 0.74902>//rgb 0//
        }  
      }  
      #if (!quick_render)
        finish{
          reflection { 0.5 , 1.0 
            fresnel on
            metallic 0.8                                            
          }                                                       
          conserve_energy                                          
        }         
      #end
    }
    cylinder{Expld+<0,-4,0>,Expld+<0,2,0>,12}
  }
  intersection{  
    height_field{
      png
      "cracked.png"
      translate -<.5,1,.5>   
    	scale <24,2,24>
    	translate y *.0001
    	pigment{
        onion 
        color_map{
          [.1 color 0]
          [.6 color rgb <0.847059, 0.847059, 0.74902>]
        }
        scale 18
      }  
      normal{agate .25 scale 5 turbulence .25}
    	#if (!quick_render)
        finish{
          reflection { 0.5 , 1.0 
            fresnel on
            metallic 1                                            
          }                                                       
          conserve_energy                                          
        }         
      #end
    }/**/
    cylinder{                          
      <0,-4,0>,<0,0,0>,12
      texture{pigment {rgb <0.847059, 0.847059, 0.74902>}}//rgb 0}}//  
      #if (!quick_render)
        finish{
          reflection { 0.5 , 1.0 
            fresnel on
            metallic 0.8                                            
          }                                                       
          conserve_energy                                          
        } /**/        
      #end
    }
    translate Expld 
  }       
}

 

