global_settings {
  assumed_gamma 1.0
}
#include "colors.inc"
#include "woods.inc"
#declare INCHES = 1/12   ;
#declare FEET   = 1      ;
#declare inch = 1/12;
sky_sphere{ pigment{color rgb<1,1,1>}}

//cylinder { <-30, 0, 0>, <30, 0, 0>, .1 pigment {color rgb <7,0,0>}}
//cylinder { <0, -30, 0>, <0, 30, 0>, .1 pigment {color rgb <0,7,0>}}
//cylinder { <0, 0, -30>, <0, 0, 30>, .1 pigment {color rgb <0,0,7>}}     



light_source
{
 <6.5, 6, 6.5>
 color rgb <1, .9, .9>
  fade_distance 3
  fade_power 1
  }


camera {
  location <10,2.5,7>   
  look_at  <0,4,4>           
  } 
  









plane { y, 8
pigment {color <1.3,1.3,1.3>}normal { bumps .08 scale .025 }}  //seling
 

plane { y, 0 
    texture  {
      checker
      texture { T_Wood5 scale .5 rotate <0, -90, 0>} 
      texture { T_Wood5 scale .5 rotate <0, 0, 0>} 
      }}  //flor  
                                    
plane { z, 0 
pigment {color <0,1,1>}normal { bumps .08 scale .025 }}   //left wall    

plane { x, 0 
pigment {color <0,1,1>}normal { bumps .08 scale .025}}   //right wall       


//***************************** window *********************************/

#declare WindowTex= texture {pigment {color <1,1,1>}}      ;

#declare WindowIM=   box { 0, 1   
           
 texture {
 pigment {
      image_map {
        "WTC"
        interpolate 2 // smooth it
        once   // don't tile image, just one copy
      }
      // transform it to unit-size (-1 to +1)
    }
   }
 rotate <0, 0, 0>
 scale < -3, 4,  0.0001>
translate <3,0 ,0>
}   

#declare WindowSill=union{ 

box { <0, 0, 0>, <(3*12)+(4.5*2), 4.5, 1>  texture {  WindowTex } translate <-4.5,4*12 ,0>}     
box { <0, 0, 0>, <4.5, (4*12), 1> texture {  WindowTex } translate <-4.5,0 ,0>}
box { <0, 0, 0>, <4.5, (4*12), 1>  texture {  WindowTex } translate <(3*12),0 ,0>}
box { <0, 0, 0>, <(3*12)+(4.5*2)+1, 1, 2> texture {  WindowTex } translate <-5,0 ,0>}
cylinder { <0, .5, 2>, <(3*12)+(4.5*2)+1, .5, 2>, .5 translate <-5,0 ,0> texture {  WindowTex }}
cylinder { <0, .50, 0>, <0, .50, 2>, .5 translate <-5,0 ,0> texture {  WindowTex }}
cylinder { <0, .50, 0>, <0, .50, 2>, .5 translate <(3*12)+(4.5*2)+1-5,0 ,0> texture {  WindowTex }}
sphere { <0, 0.5, 02>, 0.5 translate <-5,0 ,0> texture {  WindowTex }}
sphere { <0, 0.5, 02>, 0.5 translate <(3*12)+(4.5*2)+1-5,0 ,0> texture {  WindowTex }}
box { <0, 0, 0>, <(3*12)+(4.5*2), 3.5, 1> texture {  WindowTex } translate <-4.5,-3.5 ,0>}




}
#declare WindowLadis=union{ 
box { <0, 0, 0>, <3*12, 1.5, .5> rotate <0, 0, 0> texture {  WindowTex } translate <0,(2*12)-0.75 ,0> }
box { <0, 0, 0>, <3*12, 1.5, .5> rotate <0, 0, 0> texture {  WindowTex } translate <0,1  ,0> }
box { <0, 0, 0>, <1.5, (2*12)-0.75, .5> rotate <0, 0, 0> texture {  WindowTex } translate <0,1  ,0> }
box { <0, 0, 0>, <1.5, (2*12)-0.75, .5> rotate <0, 0, 0> texture {  WindowTex } translate <3*12 - 1.5,1  ,0> }

box { <0, 0, 0>, <1.5, (2*12)-0.75, .25> rotate <0, 0, 0> texture {WindowTex} translate <0,1+(2*12) ,0> }
box { <0, 0, 0>, <1.5, (2*12)-0.75, .25> rotate <0, 0, 0> texture {WindowTex} translate <3*12 - 1.5,1+(2*12) ,0> }
box { <0, 0, 0>, <3*12, 1.5, .25> rotate <0, 0, 0> texture {  WindowTex } translate <0,(4*12)-1.5 ,0> }}

#declare Window=union{
object {WindowSill scale inch }  
object {WindowLadis scale inch }
object {WindowIM } 

}

object {Window translate <2,27*inch ,0>}



//***************************** mollding *********************************/

#declare mollding=union{
box { 0, <12, 2, .25> pigment {color <1,1,1>}}
cylinder { <0, 1.75, .25>, <12, 1.75, .25>, .25 pigment {color <1,1,1>}}
} 


object {mollding scale inch scale <20,1,1> translate <0,8-(2*inch) ,0>}
object {mollding scale inch scale <20,1,-1>  rotate <0, -90, 0>translate <0,8-(2*inch) ,0>} 

#declare FlorBord = 
difference {
  box { 0, <12, 5, 1> pigment {color <1,1,1>}} // Start with this shape
  box {  <-10, -2, 0>, <13, 2, 1> pigment {color <1,1,1>}rotate <90+45, 0, 0>translate<0,5,1>} // This will be "cut out" of Shape1
}

object {FlorBord scale inch scale <20,1,1> }    
object {FlorBord scale inch scale <20,1,-1>  rotate <0, -90, 0>} 





//***************************** tabal *********************************/
 
#declare Leg=intersection{
   box { <-.3, 0, -.3>, <.3, 3.5, .3> }
   plane {-x, 0 rotate < 0, 0,  1> translate <-.3, 3.5,  0> }
   plane { x, 0 rotate < 0, 0, -1> translate < .3, 3.5,  0> }
   plane {-z, 0 rotate < 1, 0,  0> translate < 0, 3.5, -.3> }
   plane { z, 0 rotate <-1, 0,  0> translate < 0, 3.5,  .3> }
   texture { T_Wood7 scale .3  rotate <-90, 0, 0> }
}

#declare TopBoard1=box { <-3.5, -.05, -.6>, <3.5, .05, .6> 
   texture { T_Wood7 scale <.3, .15, .03>  rotate <0, 90, 4>}    
}

#declare TopBoard2=object { TopBoard1 scale <1, 1, -1> }

#declare Top=union{
   object { TopBoard2 translate <0, 0, -1.8> }
   object { TopBoard1 translate <0, 0,  -.6> }
   object { TopBoard2 translate <0, 0,   .6> }
   object { TopBoard1 translate <0, 0,  1.8> }
}

#declare Apron1=box { <-2.7, 0, -.05>, <2.7, .3, .05> 
         texture { T_Wood7 scale .3 rotate <0, -91, 0> } 
}

#declare Apron2=box { <-.05, 0, -1.7>, <.05, .3, 1.7> 
         texture { T_Wood7 scale .3 rotate <0, 1, 0> } 
}

#declare Table=union{
   object { Leg translate <-3, 0, -2> }
   object { Leg translate <-3, 0,  2> }
   object { Leg translate < 3, 0, -2> }
   object { Leg translate < 3, 0,  2> }
   object { Apron1 translate <0, 3.2, -2.2> }
   object { Apron1 translate <0, 3.2,  2.2> }
   object { Apron2 translate <-3.2, 3.2, 0> }
   object { Apron2 translate < 3.2, 3.2, 0> }
   object { Top translate <  0, 3.5, 0> }
}



object { Table rotate <0, -92, 0> scale <.4,.85,.57> translate <1,0 ,5>}






   
    
    
//***************************** Monator *********************************/    
#declare MonatorTex= texture { pigment { color    rgb <1,1,0.5>}     normal { bumps .2 scale .05 }}      ;        //        rgb <0.4, 0.40, .3>}

#declare MonatorScren=     box { 0, <11, 8.5,.000001 >   
           
 texture {
 finish {ambient 1.5}
 pigment {
      image_map {
        png "bsod.png"
        interpolate 2 // smooth it
        once   // don't tile image, just one copy
      }
    }
   }
 rotate <0, -90, 0>
 scale <1,8.5,11>
   translate < 15.75, 3,2>       }
#declare Monatorbass1=  

difference { 
 sphere { <0, 6.2 - 1.25, 0>, 6.2 texture {pigment { color rgb <0.4, 0.40, .3>}}} 
 plane { y, 0  texture {pigment { color rgb <0.4, 0.40, .3>}}inverse }
 translate < 8, 0, 7.5>
}


#declare Monatorbass2=difference 
 { 
 sphere { <0, -8.25 + 1.5, 0>, 8.25  texture {pigment { color rgb <0.4, 0.40, .3>}}} 
 plane { y, 0  texture {pigment { color rgb <0.4, 0.40, .3>}} }              
 translate < 8, -2.25, 7.5>
  rotate <0, 0, -2>}









#declare Monator=union{
 object {Monatorbass1  }
 object {Monatorbass2  }
 box { 0, <1, 7.5, 11>  translate < 0, 02, 02>     texture { MonatorTex}  }       // 
 box { 0, <14, 3, 10.5>  translate < 0.5,0, 2.25>   texture {  MonatorTex} }
 object {MonatorScren}
 difference {
  box { 0, <1.5, 13.5, 15> texture {MonatorTex}} // Start with this shape
  box { 0, <5, 8.5, 11>translate < 0, 3,2> texture {MonatorTex}} // This will be "cut out" of Shape1
  translate < 14.5, 0,0>}


triangle {<0,  9.5, 2>,< 0,  9.5, 13>,< 14.5,  13.5,  0>  texture {MonatorTex} }
triangle {< 0,  9.5, 13>,< 14.5,  13.5,  0>,< 14.5,  13.5,  15>  texture {MonatorTex} }   //top

triangle {< 0,  9.5, 13>,< 14.5,  13.5,  15>,< 0,  2, 13> texture { MonatorTex }}   //right       
triangle {< 14.5,  13.5,  15>,< 0,  2, 13>,< 14.5,  0,  15> texture { MonatorTex }}   
triangle {< 0,  2, 13>,< 14.5,  0,  15>,< 14.5,  0,  13> texture { MonatorTex }} 

triangle {<0,  9.5, 2>,< 0,  2, 2>,< 14.5,  13.5,  0> texture { MonatorTex }}
triangle {< 0,  2, 2>,< 14.5,  0,  0>,< 14.5,  13.5,  0> texture {  MonatorTex} }    //left
triangle {< 0,  2, 2>,< 14.5,  0,  0>,< 14.5,  0,  2> texture { MonatorTex} } 



}
object {Monator scale inch rotate <0, 9, 2> translate < 0.5, 3+(2.25/12), 5.5> }
 

//***************************** CPU *********************************/
#declare CPUC1= texture { pigment { color Black+(Silver*.05)}}                 ;
#declare CPUC2= texture { pigment { color Silver}}                ;
                                    
                                    
#declare CPUT=union{
sphere { <0, 0, 0>, 0.5 scale <6, 6, 0>translate<8,7.5,0> texture {CPUC2} }
sphere { <0, 0, 0>, 0.5 scale <6, 6, 0>translate<8,7.5,7> texture {CPUC2} }
box { <0, 0, 0>, <14, 14.5, 7> texture {CPUC1} }
cylinder { <0, 0, 0>, <0, 14.5, 0>, 3.5 scale <0.5, 0, 0> translate<14,0,3.5> texture{CPUC1}}
sphere { <0, 0, 0>, 0.5 scale <.3, 1, 1>translate<15.75,7,3.5> texture {CPUC2} }
}                                    
object {CPUT scale inch rotate <0, -5, 0> translate < 0.5, 0.0, 2.5> }   




//***************************** cloc *********************************/  
#declare ClocTex= texture { pigment { color rgb .1}}
#declare cloc=union{ 

box { 0, <-5, -.5, 8> texture {ClocTex} rotate <0, 00, 0> translate <0, 0,0>}
box { 0, <-5, -.5, 8> texture {ClocTex} rotate <0, 00, -80> translate < 0, 0,0>}



difference {
  cylinder { <0, 0, .5>, <0, 0, 7.5>, 4.5 }
  plane { y, 0}
  plane { y, 0 rotate <0, 00, -80> inverse}    
texture {ClocTex}}




text {
  ttf         
  "crystal.ttf",  
  "Sep 10",      // the string to create
  .1,              // the extrusion depth
  0               // inter-character spacing
texture { pigment { color rgb <1,1,0>}}
rotate <0, -90, 0>
translate < 0.4, 1.5,.5>
rotate <0, 00, 20>
scale 2
finish {ambient .75}}
text {
  ttf         
  "crystal.ttf",  
  " 9:53",      // the string to create
  .1,              // the extrusion depth
  0               // inter-character spacing
texture { pigment { color rgb <1,1,0>}}
rotate <0, -90, 0>
translate < 0.4, .5,.75>
rotate <0, 00, 20>
scale 2
finish {ambient .75}} 
translate < 05, .75,0>}

object {cloc  scale inch rotate <0, -30, 0> translate < 1.5, 3,3.5>}  //                                                                         
                                                                            
                                                                            
                                                                            

                                                                    
                                                                            
                       
//***************************** Chair *********************************/



#declare chair_wood_z    = texture { T_Wood13 finish { phong 0.8 } }
#declare chair_wood_y    = texture { chair_wood_z rotate 90*x }
#declare chair_wood_x    = texture { chair_wood_z rotate 90*y }

// Windsor chair

#declare WindsorChair = union {

  // left front leg
  intersection {
    sphere { < 0, 0, 0 > 1
             scale < 11/16*INCHES, 16*INCHES, 11/16*INCHES>
             texture { chair_wood_y }
             rotate 14*x
             rotate -9*z
           }
    box    { < -4*INCHES, -8.0*INCHES, -3*INCHES >
             <  4*INCHES,  8.4*INCHES,  3*INCHES > }
    translate <-7*INCHES, 8*INCHES, -(6+3/4)*INCHES>
  }

  // right front leg
  intersection {
    sphere { < 0, 0, 0 > 1
             scale < 11/16*INCHES, 16*INCHES, 11/16*INCHES>
             texture { chair_wood_y }
             rotate 14*x
             rotate  9*z
           }
    box    { < -4*INCHES, -8.0*INCHES, -3*INCHES >
             <  4*INCHES,  8.4*INCHES,  3*INCHES > }
    translate < 7*INCHES, 8*INCHES, -(6+3/4)*INCHES>
  }

  // left back leg
  intersection {
    sphere { < 0, 0, 0 > 1
             scale < 11/16*INCHES, 16*INCHES, 11/16*INCHES>
             texture { chair_wood_y }
             rotate -17*x
             rotate -17*z
           }
    box    { < -3*INCHES, -8.0*INCHES, -3*INCHES >
             <  3*INCHES,  7.5*INCHES,  3*INCHES > }
    translate <-7*INCHES, 8*INCHES, (7+1/4)*INCHES>
  }

  // right back leg
  intersection {
    sphere { < 0, 0, 0 > 1
             scale < 11/16*INCHES, 16*INCHES, 11/16*INCHES>
             texture { chair_wood_y }
             rotate -17*x
             rotate  17*z
           }
    box    { < -3*INCHES, -8.0*INCHES, -3*INCHES >
             <  3*INCHES,  7.5*INCHES,  3*INCHES > }
    translate <7*INCHES, 8*INCHES, (7+1/4)*INCHES>
  }

  // left outer leg crossbar
  union {
    cone      { < -7*INCHES, 0, -(6+3/4)*INCHES > (3/16)*INCHES
                < -7*INCHES, 0, -(4+3/4)*INCHES > (1/ 2)*INCHES }
    cylinder  { < -7*INCHES, 0, -(4+3/4)*INCHES >
                < -7*INCHES, 0,  (5+1/4)*INCHES > (1/ 2)*INCHES }
    cone      { < -7*INCHES, 0,  (5+1/4)*INCHES > (1/ 2)*INCHES
                < -7*INCHES, 0,  (7+1/4)*INCHES > (3/16)*INCHES }
    texture   { chair_wood_z }
    translate 8*INCHES*y
  }

  // right outer leg crossbar
  union {
    cone      { <  7*INCHES, 0, -(6+3/4)*INCHES > (3/16)*INCHES
                <  7*INCHES, 0, -(4+3/4)*INCHES > (1/ 2)*INCHES }
    cylinder  { <  7*INCHES, 0, -(4+3/4)*INCHES >
                <  7*INCHES, 0,  (5+1/4)*INCHES > (1/ 2)*INCHES }
    cone      { <  7*INCHES, 0,  (5+1/4)*INCHES > (1/ 2)*INCHES
                <  7*INCHES, 0,  (7+1/4)*INCHES > (3/16)*INCHES }
    texture   { chair_wood_z }
    translate 8*INCHES*y
  }

  // front inner leg crossbar
  union {
    cone      { < -7*INCHES, 0, -(2+1/4)*INCHES > (3/16)*INCHES
                < -5*INCHES, 0, -(2+1/4)*INCHES > (1/ 2)*INCHES }
    cylinder  { < -5*INCHES, 0, -(2+1/4)*INCHES >
                <  5*INCHES, 0, -(2+1/4)*INCHES > (1/2)*INCHES }
    cone      { <  5*INCHES, 0, -(2+1/4)*INCHES > (1/ 2)*INCHES
                <  7*INCHES, 0, -(2+1/4)*INCHES > (3/16)*INCHES }
    texture   { chair_wood_x }
    translate 8*INCHES*y
  }

  // back inner leg crossbar
  union {
    cone      { < -7*INCHES, 0, (2+1/4)*INCHES > (3/16)*INCHES
                < -5*INCHES, 0, (2+1/4)*INCHES > (1/ 2)*INCHES }
    cylinder  { < -5*INCHES, 0, (2+1/4)*INCHES >
                <  5*INCHES, 0, (2+1/4)*INCHES > (1/2)*INCHES }
    cone      { <  5*INCHES, 0, (2+1/4)*INCHES > (1/ 2)*INCHES
                <  7*INCHES, 0, (2+1/4)*INCHES > (3/16)*INCHES }
    texture   { chair_wood_x }
    translate 8*INCHES*y
  }

  // seat
  difference {
    union {
      intersection {
        prism { linear_sweep cubic_spline
               -(1/2)*INCHES, (1/2)*INCHES,
               15,
               <        5*INCHES,       -8*INCHES >,
               <        0*INCHES, -(8+1/2)*INCHES >,
               <       -5*INCHES,       -8*INCHES >,
               < -(7+7/8)*INCHES,       -5*INCHES >,
               < -(8+5/8)*INCHES,    (1/2)*INCHES >,
               < -(8+1/2)*INCHES,  (3+1/2)*INCHES >,
               < -(6+5/8)*INCHES,  (6+5/8)*INCHES >,
               <        0*INCHES,  (9+1/4)*INCHES >,
               <  (6+5/8)*INCHES,  (6+5/8)*INCHES >,
               <  (8+1/2)*INCHES,  (3+1/2)*INCHES >,
               <  (8+5/8)*INCHES,    (1/2)*INCHES >,
               <  (7+7/8)*INCHES,       -5*INCHES >,
               <        5*INCHES,       -8*INCHES >,
               <        0*INCHES, -(8+1/2)*INCHES >,
               <       -5*INCHES,       -8*INCHES >
        }
        box   { < -9*INCHES, -3/4*INCHES,       -9*INCHES >
                <  9*INCHES,  3/4*INCHES,  (3+1/2)*INCHES >
        }
      }
      intersection {
        cylinder { < 0, -1/2*INCHES, 0 >
                   < 0,  1/2*INCHES, 0 > (9+3/8)*INCHES }
        box      { < -9*INCHES, -3/4*INCHES,  (3+1/2)*INCHES >
                   <  9*INCHES,  3/4*INCHES,        9*INCHES >
        }
      }
    }
    sphere   { < 0, (71+7/8)*INCHES, 0 > (72+1/8)*INCHES }
    texture  { chair_wood_z }
    rotate 5*x
    translate < 0, 16*INCHES, 0 >
  }

  // chair back rail

  union {
    difference {
      cylinder { <0, 11*INCHES, -(1/2)*INCHES>
                 <0, 11*INCHES,  (1/2)*INCHES> (9+1/4)*INCHES }
      cylinder { <0, 11*INCHES, -(5/8)*INCHES>
                 <0, 11*INCHES,  (5/8)*INCHES> (8+1/4)*INCHES }
      box      { <-10*INCHES,  (8+1/2)*INCHES, -1*INCHES>
                 < 10*INCHES,        0*INCHES,  1*INCHES> }
      texture { chair_wood_z translate 11*INCHES*y }
    }
    box { <-(1/2)*INCHES,    0*INCHES, -(1/2)*INCHES >
          < (1/2)*INCHES, -9.5*INCHES,  (1/2)*INCHES >
          texture { chair_wood_y }
          rotate  18*z     translate <-(8+2/4)*INCHES, (8+3/4)*INCHES, 0 >
    }
    box { <-(1/2)*INCHES,    0*INCHES, -(1/2)*INCHES >
          < (1/2)*INCHES, -9.5*INCHES,  (1/2)*INCHES >
          texture { chair_wood_y }
          rotate -18*z     translate < (8+2/4)*INCHES, (8+3/4)*INCHES, 0 >
    }

    rotate 20*x
    translate <0, 15*INCHES, (3+1/2)*INCHES>
  }

  // chair back rungs
  #declare rung_1_base = < -6.00*INCHES, 15.99*INCHES, 5.85*INCHES >  ;
  #declare rung_2_base = < -4.50*INCHES, 15.90*INCHES, 6.85*INCHES >  ;
  #declare rung_3_base = < -2.75*INCHES, 15.84*INCHES, 7.60*INCHES >  ;
  #declare rung_4_base = < -0.88*INCHES, 15.80*INCHES, 7.97*INCHES >  ;
  #declare rung_5_base = <  0.88*INCHES, 15.80*INCHES, 7.97*INCHES >  ;
  #declare rung_6_base = <  2.75*INCHES, 15.84*INCHES, 7.60*INCHES >  ;
  #declare rung_7_base = <  4.50*INCHES, 15.90*INCHES, 6.85*INCHES >  ;
  #declare rung_8_base = <  6.00*INCHES, 15.99*INCHES, 5.85*INCHES >  ;

  cylinder { <0, 0, 0> <0, 14.5*INCHES, 0> (1/4*INCHES)
             texture { chair_wood_y }
             rotate  12.26*x
             rotate   5.80*z
             translate rung_1_base }

  cylinder { <0, 0, 0> <0, (16.5*INCHES), 0> (1/4*INCHES)
             texture { chair_wood_y }
             rotate   9.60*x
             rotate   3.68*z
             translate rung_2_base }

  cylinder { <0, 0, 0> <0, (17.5*INCHES), 0> (1/4*INCHES)
             texture { chair_wood_y }
             rotate   7.84*x
             rotate   2.15*z
             translate rung_3_base }

  cylinder { <0, 0, 0> <0, (18.0*INCHES), 0> (1/4*INCHES)
             texture { chair_wood_y }
             rotate   7.16*x
             rotate   0.82*z
             translate rung_4_base }

  cylinder { <0, 0, 0> <0, (18.0*INCHES), 0> (1/4*INCHES)
             texture { chair_wood_y }
             rotate   7.16*x
             rotate  -0.82*z
             translate rung_5_base }

  cylinder { <0, 0, 0> <0, (17.5*INCHES), 0> (1/4*INCHES)
             texture { chair_wood_y }
             rotate   7.84*x
             rotate  -2.15*z
             translate rung_6_base }

  cylinder { <0, 0, 0> <0, (16.5*INCHES), 0> (1/4*INCHES)
             texture { chair_wood_y }
             rotate   9.60*x
             rotate  -3.68*z
             translate rung_7_base }

  cylinder { <0, 0, 0> <0, 14.5*INCHES, 0> (1/4*INCHES)
             texture { chair_wood_y }
             rotate  12.26*x
             rotate  -5.80*z
             translate rung_8_base }

  pigment { color Black } // shouldn't be used
 
}

// -------------------------------------------------------------

object { WindsorChair scale 1.1 rotate <0, 100, 0> translate < 2, 0.0, 5>}