//===========================
//  L'ultime catastrophe
//
//  Topic IRTC Avril 2005
//
//  Helen - Mars 2005
//==========================

// --- Includes de base

#include "colors.inc"
#include "couleurs.inc"
#include "textures.inc"
#include "functions.inc"

// --- includes pour l'arbre

#include "txttree.inc" 
#include "maketree.pov"
#include "arbre_mort.inc" 

// --- include des cailloux

#include "caillou.inc"

global_settings { max_trace_level 15}

//*************************
// CAMERA
//*************************

camera	// plus prs
{
        location <0,3,-20>
        look_at <0,4,0> 
	angle 40      
}


//************************
// LUMIERES
//************************

#declare lum1 =
light_source
{
         <50,20,300> White*1.2//Gray35//White*2     //<-20,30,-15>
         //area_light <2, 0, 0>, <0, 0, 2>, 3, 3
         //adaptive 1
         //jitter
         
} 

#declare lum3=
light_source
{
        <-50,50,-50> color rgb <1,0.92,0.85> *0.5 
         shadowless 
	
}




light_source {lum1}
light_source {lum3}



//====================
// 	SOL
//====================



plane 
{
      	<0, 1, 0>, 0
	pigment { rgb <0.97, 0.25, 0.11.5> } //{ rgbf <0.97, 0.25, 0.11.5> }
                   
     
                finish { 
                        reflection .1 
                        ambient .5 
                        diffuse .5 
                        specular .5 
                        roughness .5 
                        } 
                
      
                
                normal {granite .2}
                interior {ior 2} 
      
	
}

//===========================================
//	montagnes du fond
//===========================================

#declare Fun0=function {x*0 + y*1 + z*0}//plan
#declare Pig1=function{pigment{wrinkles color_map{[0 rgb 1][1 rgb 0]} scale 2}}
#declare Pig2=function{pigment{waves color_map{[0 rgb 1][1 rgb 0]} scale 2}}

//----- sol au fond

isosurface {
            function {Fun0(x,y,z)+ Pig1(x,y,z).gray}
		open
            threshold .5    
            
            accuracy 0.001
            contained_by {box {-3,3}}
            max_gradient 2.253
		pigment
	 {
    		bozo
    	color_map
	 {
      [0.00  color VeryDarkBrown]
      [0.33  color Gray35]
      [0.66  color rgb <193,22,2>/255]
      
   	 }
}
           scale <50,40,20>
	   
           translate <-1,0.2,200>
            }

//----- sol au fond  droite

isosurface {
            function {Fun0(x,y,z)+ Pig1(x,y,z).gray}
		open
            threshold .5    
            
            accuracy 0.001
            contained_by {box {-3,3}}
            max_gradient 2.253
		pigment
	 {
    		bozo
    	color_map
	 {
      [0.00  color VeryDarkBrown]
      [0.33  color Gray35]
      [0.66  color rgb <193,22,2>/255]//193-22-2
      
   	 }
}
           scale <50,40,20>
	   
           translate <6,0.2,500>
            }



//===========================================
//	l'atmosphre.. ?
//===========================================

fog 
        {
        distance 150//250
        color rgb <0.97, 0.35, 0.09> 
        turbulence 0.2
        turb_depth 0.3
        fog_type 2
        fog_offset 20//10
        fog_alt 4//3
        }

//==========================================
//   le soleil
//==========================================

sphere
{
  <0,0,0>,50
  pigment {Red}
  pigment
	 {
    		bozo
    	color_map
	 {
      [0.00  color White]
      [0.33  color Yellow]
      [0.66  color DarkOrange]//193-22-2
      
   	 }
	   scale 3.5
	 }
  finish  {diffuse 0.9}
  
  translate <110,70,600>
}

//************************************
//      L'arbre mort
//      provient du..
//      fichier include arbre_mort.inc
//************************************

object
{
        arbre_mort 
        scale 0.20 
        rotate z*60
        translate <5,0.3,0>
}


//*******************************
// les cailloux
// proviennent du fichier
// caillou.inc
//*******************************

#declare petit_caillou =
object	// petit caillou
{
	caillou
	scale 0.15
	translate <2.2,0.2,-1>
}

//	 petit caillou

#declare r3=seed(1);
#declare r4=seed(2);
#declare rc=seed(3); // variable pour changer la taille des cailloux

#declare pos=0;
#declare nb = 0;
#while (nb < 4000)
    
object 
{
	petit_caillou
        scale rand(rc)
	translate x*-50
	translate z*-40
        translate y*-0.1
	translate <rand(r3)*50, 0, rand(r3)*300>
}  
#declare pos=pos+1; 
#declare nb=nb+1;

#end

//*********************************
// fabrication de la fume
// 
// Merci Olivier...
//********************************

 //------------ une fume jaune

#declare fumee_jaune = 
cylinder 
{
        <0,-1,0>,<0,5,0>,1 hollow //le "conteneur"
pigment
        {
        White transmit 1        //contour invisible...
        }                       
  
interior
        {
        media 
                {
                emission White*1                //pour de la fume fine, un metteur suffit
                samples 1,1                     
                density {                       //la densit, c'est un peu le pigment du media
                        cylindrical  
                        color_map {[0 Black][.7 Black][1 color rgb <0.875, 0.820, 0.027>]} //jaune autour de l'axe
                        warp {turbulence .5 omega .7}            //on souffle dessus !
                        }                    
   
                }
        }
  
} 

//------------------------------------------------

//------------ une fume orange

#declare fumee_orange = 
cylinder 
{
        <0,-1,0>,<0,5,0>,1 hollow //le "conteneur"
pigment
        {
        White transmit 1        //contour invisible...
        }                       
  
interior
        {
        media 
                {
                emission White*1                //pour de la fume fine, un metteur suffit
                samples 1,1                     
                density {                       //la densit, c'est un peu le pigment du media
                        cylindrical  
                        color_map {[0 Black][.7 Black][1 color DarkOrange]} //orange fonc autour de l'axe
                        warp {turbulence .5 omega .7}            //on souffle dessus !
                        }                    
   
                }
        }
  
} 

//-----------------------------------------

//--------- une fume rouge

#declare fumee_rouge = 
cylinder 
{
        <0,-1,0>,<0,5,0>,1 hollow //le "conteneur"
pigment
        {
        White transmit 1        //contour invisible...
        }                       
  
interior
        {
        media 
                {
                emission White*1                //pour de la fume fine, un metteur suffit
                samples 1,1                     
                density {                       //la densit, c'est un peu le pigment du media
                        cylindrical  
                        color_map {[0 Black][.7 Black][1 color rgb <0.875, 0.196, 0.027>]} //rouge autour de l'axe
                        warp {turbulence .5 omega .7}            //on souffle dessus !
                        }                    
   
                }
        }
  
}

// --- Positionnement des fumes

object // celle du cratre
{
        fumee_orange
        scale <1.5,0.6,1.5>//1.2
        rotate y*90
        translate <-7.5,0,13.5>
}


object  // fumee rouge devant
{
        fumee_rouge
        scale <2,1.5,2>
        translate <0,0,-1.5>
}

//***************************
// crateres
//***************************

// --- Fabrication des cratres

#declare cratere =
height_field 
{ 
  png "crat_dat.png"
  smooth
  pigment
	 {
    		leopard
    	color_map
	 {
      [0.00  color VeryDarkBrown]
      [0.33  color Gray35]
      [0.66  color DarkGreen]
      
   	 }
 	 }
  
}

// --- Positionnement des cratres

object // Attention ! Celui-l va avec la fume orange
       // ne pas le dplacer sans elle
{
        cratere
        scale <9, 5, 9>
        translate <-12, -1.2,10> 
} 

object // celui-l se trouve devant
{
        cratere
        scale <8, 3, 8>
        translate <-3.3, -0.7,-3.8> 
} 

//*********************************************
//    Un gros caillou devant le tronc d'arbre
//*********************************************

//=====================================
//	autre caillou - genre facettes
//=====================================

#declare R = 1.0;

// ----------------------------------------

                    
#declare F=function{pigment{
  crackle 
  turbulence 0.1
  color_map { [0 rgb 1] [1 rgb 0] }
  scale 0.5
  }
}
#declare caillou_facettes =
isosurface {
        function { x*x + y*y +z*z -1 + F(x,y,z).gray*0.3 }
        max_gradient 3.2
        contained_by{sphere{0,R}}

	pigment
	 {
    		leopard
    	color_map
	 {
      [0.00  color rgb  <0.97, 0.25, 0.11>]
      [0.33  color Gray35]
      [0.66  color DarkGreen]
      
   	 }
 	 }
  finish {diffuse 0.9}
        //pigment {rgb .9}
        //finish {phong 0.5 phong_size 10}
		//translate <0,0.5,-1>
}

object
{
  caillou_facettes
  scale <0.9,0.7,0.9>
  translate <4.6,0.2,-2.4>//4.5
}

object // celle du cratre
{
        fumee_orange
        scale <1.4,0.5,1.4>//1.2
        //rotate y*90
        translate <4.5,0,-3.5>
}


