/*  Atlas carrying the world - by khayyam (Pierre Schwartz) - may/june 2005

       ============ IRTC June 2005 ===========

Do you remember Atlas's legend ? this giant was condamned by Zeus to carry the world.

how to render it ?
- first generate the grass with the height field generator by Francois Dispot
    settings  : size         -> 30x30x2  
                height_field -> hf.png
                density      -> density.png
    (result in grass.inc)
- then generate the curtain with Megapov. to render it, megapov-render drap.pov. it will create drape.msh
- download the jpeg picture for the earth -> http://earthobservatory.nasa.gov/Newsroom/BlueMarble/Images/land_shallow_topo_2048.jpg
  and save it as earth.jpg
- then render the main picture.

tools used : gimp for the png files + 
             the link macro by Chris Colefax for the rope 
             nothing else.
             

*/

global_settings{
        max_trace_level 5 
}


#include "colors.inc"   
#include "textures.inc"                      
#include "stones1.inc"
                          	
background{White}

#declare cam_pos = <15,10,-53>;

camera{location cam_pos
       look_at <0,15,0>}
       
light_source{<-40,100,-18>,
             White
             area_light<20,0,0>,<0,0,7.2>,4,5
             orient 
             jitter
             adaptive 1
            }       


light_source{cam_pos, White}       

#declare srand=seed(5);

///////////////////////////////////////////////
///////////////// textures ////////////////////
///////////////////////////////////////////////

#declare coul_ecorce=rgb <255,153,77>/255;
#declare tex_tronc=texture
{
   pigment
   {
       crackle 
       turbulence .4 
       lambda 3 
       color_map
       {
          [0  color coul_ecorce*.3]
          [.1 color coul_ecorce*.4]
          [.6 color coul_ecorce*.8]
          [1  color coul_ecorce*1.2]
       }
   }       
   normal
   {
       crackle 
       turbulence .4 
       lambda 3 
       normal_map
       {
          [0  bumps 0]
          [.1 bumps .5]
          [.6 bumps .7]
          [1  bumps .1]
       }
   }
   
   finish
   {
       ambient .1
   } 
   scale 5
}

#declare tex_sol=texture
{
      pigment
      {
          checker Yellow Orange 
          scale 20
      }
      finish
      {
           ambient .2
           reflection .2
           phong .3
      }
} 


#declare texGrass = texture{
         pigment{ gradient y
                  turbulence 0.4
                  colour_map{
                             [0  colour rgb <97,148,3>/255]
                             [.5 colour rgb <88,134,26>/255]
                             [.9 colour rgb <116,177,33>/255]
                             }
                 //scale <0.0001,0.0001,0.15>
                 }
         finish{ ambient 0.2 diffuse 0.6 phong 0.4 phong_size 60}
}

////////////////////////////////////////////////////
///////////// objets ///////////////////////////////
//////////////////////////////////////////////////// 

#declare PANCARTE=union
{
box{<-1,-.5,0>,<1,.5,.1> pigment{White}} 

  difference
  {
      cylinder{<-.8,0,.05>,<-.85,0,.05>,.1}
      cylinder{<-1,0,.05>,<0,0,.05>,.08}
      
      scale <1,1.5,1>
      translate y*.63
      texture{Polished_Brass}
  }  
  
  difference
  {
      cylinder{<.8,0,.05>,<.85,0,.05>,.1}
      cylinder{<1,0,.05>,<0,0,.05>,.08}
      
      scale <1,1.5,1>
      translate y*.63  
      texture{Polished_Brass}
  }
  
  union
  {
   box{<-1,.5,0> ,<1,.55,.1> }
   box{<-1,-.5,0>,<1,-.55,.1> }
   box{<-1,-.5,0>,<-1.05,.5,.1>}
   box{<1,-.5,0>,<1.05,.5,.1>}

   difference{
      cylinder{<-1,.5,0>,<-1,.5,.1>,.05}
      box{<-2,.5,-.1>,<0,0,.2>}
   }
    
   difference{
      cylinder{<1,.5,0>,<1,.5,.1>,.05}
      box{<2,.5,-.1>,<0,0,.2>}
   }
    
   difference{
      cylinder{<1,-.5,0>,<1,-.5,.1>,.05}
      box{<2,-.5,-.1>,<0,0,.2>}
   } 
   
   difference{
      cylinder{<-1,-.5,0>,<-1,-.5,.1>,.05}
      box{<-2,-.5,-.1>,<0,0,.2>}
   }
   
   pigment{Black}
  }
  text
  {
   ttf "Verdana.ttf" "Do not touch !" .2,0 
   scale .25
   translate z*-.002   
   translate <-.87,.1,0>
   pigment{Black}
  }

  text
  {
   ttf "Verdana.ttf" "FRAGILE" .2,0 
   scale .25
   translate z*-.002   
   translate <-.6,-.3,0>
   pigment{Black}
  }

 scale 2
}

#declare loupiotte=union
{
     difference
     {
         cone{<0,0,0>,0,<0,3,0>,5}
         cone{<0,0,0>,0,<0,3,0>,5 translate y*.5}
     
        scale <.6,1,.6>
     }     
     light_source{<0,2.5,-.5> 2*White}
          
     texture{DMFWood6}
}

#declare poteau=union
{
    cylinder{<0,0,0>,<0,.5,0> 2}
    torus{2,.25 translate y*.25}
    cylinder{<0,.25,0>,<0,8,0>,.3}
    sphere{<0,8,0>,.8}
   
    torus{.6,.1 translate y*7}
    
    texture{Bright_Bronze}
}

// link by Chris Colefax

#declare Rope = sphere {<0, 0, 0>, 1
   pigment {wrinkles color_map {[0 rgb <.6, .4, .2>] [1 rgb <.5, .4, .1>]}}
   normal {radial .75 frequency 11 scallop_wave rotate z * 90 warp {turbulence .2 octaves 2 lambda 4}}
   scale <.9, 1.1, 1.1>}

#declare BARRIERE=union
{
      object{poteau translate <15,-2,-18>}
      object{poteau translate <-15,-2,-18>}   
      
      object{poteau translate <-25,-2,0>}
      object{poteau translate <25,-2,0>}   
      
       
      #declare link_object = Rope;
      #declare link_count = 150;
      #declare link_twist = -.1;

      #declare link_looseness = 1; 
      #declare link_point1 = <15, 5, -18>;
      #declare link_point2 = <-15, 5, -18>;
      #include "LINK.INC"  
      
      #declare link_looseness = .8;
      #declare link_point1 = <-15, 5, -18>;
      #declare link_point2 = <-25, 5, 0>;
      #include "LINK.INC"
      
      #declare link_looseness = .8;
      #declare link_point1 = <25, 5, 0>;
      #declare link_point2 = <15, 5,-18>;
      #include "LINK.INC"
}

#declare ECRITEAU=union
{
     box{<-2,0,-2>,<2,.2,0>}
     box{<-2,0,-2>,<2,5,-1.9>}
     cylinder{<2,5,-1.9>,<-2,5,-1.9>,.05}
     box{<-2,0,0>,<2,3,.1>  
         rotate x*60 
         translate <0,5,-2>
        }  
        
     union
     {
       text
       {
        ttf "Verdana.ttf" "Atlas portant le monde" .2,0 
        scale .2
        translate <-.2,-.5,-.2>
       }
       
       #declare i=0;
       #while (i<10)
            text  {  ttf "Verdana.ttf" "blablablablablablablablablablabla" .2,0   scale .12    translate <0,-.8-i*.15,-.2>     }
            #declare i=i+1;
       #end
       
       
       rotate x*60 
       translate <-1,6.25,.5>  
       pigment{Red}  
     }
    
     texture
     { 
         pigment
         {
            color rgb <200,200,200>/255
         }
         finish
         {
             reflection .2
             brilliance .3
             phong .1
             phong_size .1            
         
         }
     
     }
}


#declare EARTH=sphere
{
   <0,0,0>,8.3 
   texture
   {
       uv_mapping
       pigment
       {
           image_map 
           { 
               jpeg "earth.jpg" 
           }
       }     
   }
   rotate y*-60
   rotate x*-30
   translate <-1.5,24.2,0>
}

#declare SOCLE=union
{
     box{<-15,0,-15><15,-2,15> }
     cylinder{<0,0,0>,<0,2,0>,13}   
     texture
     {
        T_Stone10
     }
}
 
#declare spline_tronc=spline{
        natural_spline
        0 <-3.26,1.5,0>
        .1<-3.17,3.41,0>
        .2<-3.29,5.14,0>
        .3<-7.17,9.34,0>
        .4<-6.93,12.18,0>
        .5 <-4.84,13.02,0>
        .6<-7.17,16.12,0>       
        .7<-15.42,20.7,0>
        .8<-14.23,24.9,0>
        .86<-11.9,28.1,0>
        .93<-8.03,30.62,0>
        1 <-1.7,38.9,0>     
}       
 
#declare spline_br_gauche=spline{
        natural_spline
        0 <-12.35,18.9,0>
        .16  <-14.1,21.04,0>
        .33  <-14.6,22.05,0>
        .5  <-17.03,23.15,1.9>
        .62  <-20.31,22.8,2.8>
        .75  <-23.44,21.33,6.08>
        .87  <-27.45,20.6,5.05>
        1  <-31.6,24.2,9.59>
} 

#declare spline_br_gauche2=spline{
        natural_spline
        0 <-31.04,23.8,9.13>
        .13  <-31.5,24.3,9.52>
        .24  <-32.13,24.13,10.03>
        .37  <-33.6,24.13,10.33>
        .5  <-35.07,24.47,8.93>
        .6  <-32.53,24.6,8.93>
        .7  <-31.94,24.6,10.45>
        .8  <-34.11,24.71,11.92>
        .9  <-37.42,24.36,13.11>
        1  <-39,22.62,13.08>
} 

#declare spline_br_droite=spline{
        natural_spline
        0    <-7.3,10.68,0>
        .13  <-5.50,14.45,3.87>
        .25  <-2.55,16.98,5.94>
        .37  <3.87,16.77,6.53>
        .5   <8.95,14.24,3.68>
        .63  <14.03,15.36,10.48>
        .75  <17.04,17.97,11.77>
        .87  <21.41,18.88,13.4>
        1    <22.96,17.31,17.78>
}  

#declare spline_br_droite_derriere=spline{
        natural_spline
        0    <-7.7,12.35,-2.3>
        .17  <-5.47,14.16,-3.33>
        .36  <-1.2,14.71,-3.08>
        .5   <5.32,15.07,-3.59>
        .67  <7.67,18.46,-2.57>
        .83  <8.17,23.57,-1.45>
        1    <4.92,29.84,0> 
}  

#declare spline_branche_verti=spline{
        natural_spline
        0 <-4.47,14.8,5.95>
       .25   <-3.31,17.03,5.95>
       .5   <-5,19.9,5.95>
       .63   <-7.43,24.55,7.05>
       .83   <-5,29.51,7.23>
        1  <-7.32,34.9,8.57>
}

//////////////////////////////////////////
///////////// macro //////////////////////
//////////////////////////////////////////

/*#macro extrude(spl, ep1, ep2, nb)
      #local i=0;
      #local temp=spl(i);
      #local epaisseur_courante=ep1;
      
      union
      {
      #while (i<1-nb)
          cylinder{temp,spl(i+nb),epaisseur_courante}
          sphere{spl(i+nb), epaisseur_courante*(1+.1*rand(srand))-.05}                                                     
                                                     
          #local temp=spl(i+nb);
          //#local epaisseur_courante=ep1-i*(ep1-ep2);
          #local epaisseur_courante=(epaisseur_courante-nb*(ep1-ep2));     
          
          #local i=i+nb;
      #end
      texture{tex_tronc}
      }
      
#end // macro extrude*/

// extrude macro with sweep sphere
#macro extrude(spl, ep1, ep2, nb)
      #local i=0;
      sphere_sweep{
         linear_spline
         100
         #while (i<100) 
               spl(i/100),ep1-i/100*(ep1-ep2)
          
            #local i=i+1;
         #end 
      
      texture{tex_tronc}
      }

#end // macro extrude 2


///////////////////////////////////////////////
////////////// scne //////////////////////////
///////////////////////////////////////////////

EARTH 
SOCLE  
object{ECRITEAU translate <-8,-2,-15>}
plane{y,0 texture{tex_sol} translate y*-2}     

BARRIERE

extrude(spline_tronc             , 4.1,.1,.0008)
extrude(spline_br_gauche         , 1.5, 1,.00005)
extrude(spline_br_gauche2        , 1, 0,.00005)    
extrude(spline_br_droite         , 2.5, 0,.0008)    
extrude(spline_br_droite_derriere, 2 , 0,.0008) 


//box{<-100,-5,19>,<50,90,18> pigment{color rgb <128,255,128>/255}}
#declare Drap = mesh {
    #include "drape.msh"
    uv_mapping
    texture {
        pigment {
            color rgb<128,255,128>/255
            scale <1/10, 3/50, 1>
        }
    }
}  

object{Drap  scale <5,4,1> translate <-10,138.1,15>}    

//object{loupiotte translate <-40,40,18>}
//object{loupiotte translate <30,40,18>}   

object{PANCARTE scale 1.2 translate <0,-.35,-18.1>}

#debug "##### reading grass #### \n"
#declare GRASS=union{
        #include "grass.inc" 
        texture{texGrass}
        translate <-17,0,-13>
}  

GRASS