#version unofficial MegaPov 1.10;

#macro WriteClothFile(nomfile, n1, n2, nlng, ks, ht)

	#debug "\nWriting new .cth file\n"
	#fopen file nomfile write
	#write(file, n1, ",", n2, ",", nlng, ",", ks, ",\n")
	
	#local l1 = nlng*(n1-1);
	#local l2 = nlng*(n2-1);
	#local st = seed(1234);
	#local i=0;
	#while (i<n1)
		#local j=0;
		#while (j<n2)
			#local tempx = -l1/2 + i*nlng;
			#local tempz = -l2/2 + j*nlng;
			#local vtemp = <tempx, 0, tempz>;
			#local vtemp = vaxis_rotate(vtemp, z, -50);
            #local tempy = ht + (-1+2*rand(st))*nlng*0.1;
			#local vtemp = vtemp + tempy*y + 2*x;
			#write(file, vtemp.x, ",", vtemp.y, ",", vtemp.z, ", 0.0, 0.0, 0.0,\n")
			#local j=j+1;
		#end
		#local i=i+1;
	#end
	#fclose file
#end


#declare Cube = union {
    box { < -20, -9, 8>, < 27, -10, 13> }
    
}



#declare Obstacle = union {
    plane { y,0 translate y*-35}
	object { Cube }
}

  WriteClothFile("drape.cth", 120, 80, 2/5, 60, 15)

simcloth {
    environment Obstacle
    friction 0.0
    gravity -1*y
	neighbors 1
	internal_collision off
    damping 0.85
    intervals 0.05
    iterations 8000
    input "drape.cth"
    output "drape.cth"
    mesh_output "drape.msh"
    smooth_mesh on
    uv_mesh on
}      

#declare Drap = mesh {
    #include "drape.msh"
    uv_mapping
    texture {
        pigment {
            checker color rgb<1, .5, .2> color rgb<1, .8 ,.4>
            scale <1/10, 3/50, 1>
        }
    }
} 

camera {location <84,2,-60> angle 40 look_at <0,-5,0> }
light_source { -20*z+5*y+2*x, color rgb .5 shadowless }

light_source { <10,20,-10>*3, color rgb 1.2
	spotlight
	radius 20
	falloff 30
	tightness 2
	point_at 0
}


object { Drap translate .05*y }
object { Obstacle translate <.05,-.1,.2>
	pigment { rgb .95 }
} 

