// Persistence of Vision Ray Tracer Scene Description File
// File: pencil.inc
// Vers: 3.6
// Desc: Creates a pencil and a pencil cup
// Date: 6/24/05
// Auth: David Nash
// Todo: Using a prism for the barrel is a problem because it
//       isn't "solid" and I can't carve away a tip.  So change
//       the barrel and create a sharpened variation.  Other
//       variations could be round barrels with different patterns,
//       broken pencils, different markings, etc.

// ==========================
// License
// ==========================
// This work is licensed under the Creative Commons
// Attribution-ShareAlike License. To view a copy of
// this license, visit
// http://creativecommons.org/licenses/by-sa/2.5/ 
// or send a letter to
//      Creative Commons
//      559 Nathan Abbott Way
//      Stanford, California 94305, USA.

// ==========================
// Include files and variables
// ==========================
#version 3.6;
#include "colors.inc"
#include "metals.inc"

// ==========================
// Textures
//      T_Graph_Paper   a texture mimicing graph paper
//      T_Barrel    texture for the barrel of the pencil
//      T_ClipA     main texture for the metal clip
//      T_ClipB     secondary texture for the dark parts of the clip
//      T_Eraser    texture of the eraser
//      T_Text      texture of the text on the pencil
//      T_CupA      texture for the barrel of the cup
//      T_CupB      texture for the rims
// ==========================
#declare T_Graph_Paper = 
texture {
  pigment {
    gradient x
    color_map {
      [0.45 White]
      //[0.45 Cyan] the fade looks more like a real printed page
      [0.55 Cyan]
      [0.55 White]
    }
  }
}
texture {
  pigment {
    gradient z
    color_map {
      [0.45 White transmit 1]
      //[0.45 Cyan]
      [0.55 Cyan]
      [0.55 White transmit 1]
    }
  }
}

#declare T_Barrel =
texture{
  pigment {
    CoolCopper
  }
  normal { wood 0.5 turbulence 0.1 scale 0.1}
  finish {
    phong 1 phong_size 100
    ambient .15
    diffuse .7
  }
}

#declare T_Clip_A = 
texture{ T_Chrome_4A }         

#declare T_Clip_B = 
texture{ T_Chrome_3A }

#declare T_Eraser =
texture {
  pigment { Pink }
  finish { ambient 0.2 diffuse 0.4 phong 0.25 phong_size 5 }
}

#declare T_Text =
texture {
    pigment { Black }
    finish { ambient 0.1 diffuse 0.2 phong 0.1 phong_size 2.5 }
}    

#declare T_CupA =
texture {
    pigment {
        gradient y
        color_map {
            [0.40 White transmit 1]
            [0.40 Gray20]
            [0.60 Gray20]
            [0.60 White transmit 1]
        }
    }
    finish { ambient 0.1 diffuse 0.2 phong 0.1 phong_size 2.5 } 
    rotate x*45
    scale 0.8
}
texture {
    pigment {
        gradient y
        color_map {
            [0.40 White transmit 1]
            [0.40 Gray20]
            [0.60 Gray20]
            [0.60 White transmit 1]
        }
    }
    finish { ambient 0.1 diffuse 0.2 phong 0.1 phong_size 2.5 } 
    rotate x*-45
    scale 0.8
}

#declare T_CupB =
texture {
    pigment { Gray60 }
    finish { ambient 0.1 diffuse 0.2 phong 0.1 phong_size 2.5 } 
}

// ==========================
// Models
//      Floor   a floor for display
//      Barrel  pencil subpart - the wooden six-sided barrel
//      Clip    pencil subpart - the metal clip at the end
//      Eraser  pencil subpart - the eraser
//      Pencil  a union of the barrel, clip, and eraser
//      Cup     a cup to hold the pencils
// ==========================

#declare Floor=
plane { y, -1.0 texture {T_Graph_Paper}}

#declare Barrel =
difference {
    union {
        prism {                                
          linear_sweep
          linear_spline
          -15,         // height 1
          15,         // height 2
          6,           // number of points
          <1,0>, <0.5, 0.866>, <-0.5, 0.866>, <-1,0>, <-0.5,-0.866>, <0.5,-0.866>
          texture { T_Barrel rotate x*90}
          scale <0.9, 1, 0.9>
          rotate x*90
          
        } //prism
        cylinder {z*15.01, z*-15, 0.25 pigment {Black}}
    } // union    
    text { ttf "crystal.ttf", "USA   Top Office        No.2", .1, 0
        rotate <90,90,0>
        scale 0.9
        translate <-0.30,.8,-0>
        texture {T_Text}
    } // text    
} // difference

#declare Clip =   
// TODO: Add rivet marks where the clip is pressed into the eraser and barrel
union {
  cylinder {z*0.3, z, .9 }
  torus { 0.85, 0.1 rotate x*90 translate z*0.4}
  torus { 0.85, 0.1 rotate x*90 translate z*0.6}
  torus { 0.85, 0.1 rotate x*90 translate z*0.8}
  cylinder {-z*0.3, -z, .9 }
  torus { 0.85, 0.1 rotate x*90 translate -z*0.4}
  torus { 0.85, 0.1 rotate x*90 translate -z*0.6}
  torus { 0.85, 0.1 rotate x*90 translate -z*0.8}
  difference {
    cylinder {z*0.3, -z*0.3, .9 }
    #declare Ridges=60;
    #declare I=0;
    #while (I<60)
        cylinder {z*0.175, -z*0.175, .05 translate y*.925 rotate z*(360*(I/Ridges)) texture{T_Clip_B}}
        sphere {z*0.175, .05 translate y*.925 rotate z*(360*(I/Ridges)) texture{T_Clip_B}}
        sphere {-z*0.175, .05 translate y*.925 rotate z*(360*(I/Ridges)) texture{T_Clip_B}}
        #declare I=I+1;
    #end
  } //difference  
  texture {T_Clip_A}
} //union
 
#declare Eraser = 
superellipsoid { <1, 0.4>
    scale 0.9
    texture { T_Eraser }
}

#declare Pencil = 
union{
    object {Eraser translate -z*1.5}
    object {Clip}
    object {Barrel translate z*16}
}

#declare Cup =
union {
    cylinder {y*0, y*20, 10 open texture {T_CupA}}
    // floor
    cylinder {y*-.1, y*0.1, 10 texture {T_CupB}}
    // bottom lip
    torus { 9.8, .4 texture {T_CupB}}
    //top lip
    torus { 9.8, .4 translate y*20 texture {T_CupB}}
} // union         


// ----------------------------------------
// Placement
// ----------------------------------------
/*
object {Floor}
object {Cup} 
object {Pencil rotate x*90 rotate y*-110 rotate z*10 rotate x*3 translate <-10, 31, 0>}
object {Pencil rotate x*90 rotate y*-140 rotate x*-10 rotate z*-3 translate <0, 31, -10>}
object {Pencil rotate x*90 rotate y*-130 rotate x*-10 rotate z*10 translate <-7.5, 31, -7.5>}
*/