//    --- In A Dark Room --- 
//    IRTC submission for may-june 2005, topic "Forces of Nature"
//    (C) 2005 JYR
//    jyrehby@hotmail.com
//  
//    +w1200 +h1600 +am2 +a0.12
//    +w768 +h1024 +am2 +a0.12
//    +w240 +h320 -a -f

#declare Radiosity = on;

global_settings {
    max_trace_level 5 
    assumed_gamma 2.2
    
    #if (Radiosity)
        
        //--- for 1st pass
        /*
        radiosity {
            count 500
            recursion_limit 2
            error_bound .8
            low_error_factor .35
            minimum_reuse .005
            media on            
            nearest_count 12
            pretrace_start .08
            pretrace_end .005
            adc_bailout .015
            save_file "darkroom.rad"
        }
        */ 
        //--- for 2nd pass
        radiosity {
            count 500
            recursion_limit 2
            error_bound .8
            low_error_factor 1
            minimum_reuse .005
            normal on
            nearest_count 12
            pretrace_start 1
            pretrace_end 1
            adc_bailout .015
            load_file "darkroom.rad"
            always_sample off
        }        
        
        
        #default {finish {ambient 0}}
        
    #else
        #default {finish {ambient 0.075}}
    #end
}

//--- an standard perspective camera looking straight in the z direction
#declare Camera_look_at  = <-.8, -3.75, 0>;

#declare Camera_location = Camera_look_at - 12*z ;
camera {
    location  Camera_location 
    look_at   Camera_look_at      
    right     x*image_width/image_height
    angle     62        
}

//--- a white background to see through the window if no radiosity is used
background {rgb 1}

//--- the main light source: the sun
#declare Sun = 
light_source {
    <600, 800, 0> rgb 3.2 
    spotlight point_at <6, 4, 0> radius .25 falloff .25
};


//--- inside fill lights when no radiosity is used
#declare Floor_fill_light =
light_source {
    <-4.5, -9.95, 0> rgb <.28, .28, .12>*.5
    shadowless 
};

#declare Sunbeam_fill_light =
union {
    light_source {
        <-4.5, -9.95, 0>*.2+<7, 5.4, 0>*.8, rgb <.2, .2, .25>*.2    
        shadowless
    }
    light_source {
        <-4.5, -9.95, 0>*.5+<7, 5.4, 0>*.5, rgb <.2, .2, .25>*.2
        shadowless
    }
    light_source {
        <-4.5, -9.95, 0>*.8+<7, 5.4, 0>*.2, rgb <.2, .2, .25>*.2
        shadowless
    }
};    

//--- a high ambient half-sphere outside the window casts light inside the room
//    if radiosity is used
#declare Glare =
sphere {
    <7, 4, 0>, 5 inverse 
    clipped_by {plane {x, 7 inverse}}        
    no_shadow 
    texture {
        pigment {rgb 35} 
        finish {ambient 1 diffuse 0}
    }
};


//--- the rods in the windows
#declare Rods = 
merge {
    cylinder {-3.6*z, 3.6*z, .08}
    cylinder {-6*y, 6*y, .08}
    translate <6, 4, 0>
    pigment {rgb .1}    
};


//--- the window
#declare Window = 
intersection {
    cylinder {-1.001*x, 1.001*x, 8}
    box {<-1.1, 8, -3.5>, <1.1,-1,3.5>}    
    plane {x-.75*y, -.5}    
};    



//--- the room 

#declare Dry_wall = 
texture {
    pigment {rgb .6}
    normal {granite  scale .004}    
};

#declare Wet_wall = 
texture {
    pigment {
        dents scale <8, 4, 8.2>/24
        color_map {
            [0   rgb .6]
            [.19 rgb <.45, .45, .475>]
            [.5  rgb <.61, .63, .56 >]
            [1   rgb .6]
        }            
    }
    normal {granite  scale .004}    
};

#declare Room = 
intersection {
    box {<-14.5, -10.01, -15>,<5, 12, 12> inverse}
    plane {x, 7}
    object {Window inverse translate 6*x}    
    texture {
        gradient <.04, 1, .07> scale 24 translate 14*y
        texture_map {[0  Wet_wall][1  Dry_wall]        
        }               
    }        
};


//--- the floor 
#declare Floor_normal =
normal {brick 1 turbulence .08  brick_size <2, 1, 30> mortar .075 translate <1, -.2, 0>};

#declare Floor = 
plane {
    y, -10    
    texture {        
        pigment {
            wood turbulence .05 translate <130, -10, 0> rotate 5*x scale <.05, .05, 1>
            color_map {
                [0   rgb .05]
                [.04 rgb .05]
                [.05 rgb <.38, .28, .11>]
                [.18 rgb <.40, .27, .11>]
                [.22 rgb <.57, .43, .20>]
                [.58 rgb <.53, .36, .20>]
                [.62 rgb <.37, .29, .16>]
            }
        }        
        normal {Floor_normal}        
    }   
    texture {        
        pigment {
            marble turbulence .05 scale 5*x 
            color_map {
                [0 rgbt <.57, .43, .20,   1>]
                [1 rgbt <.37, .29, .16, .5>]
            }
        }
        normal {Floor_normal}        
    }    
};

//--- the sunbeam
#declare Sunbeam = 
box {
    -<2.7, 12, 3.75>, <2.20, 12, 3.75>
    rotate -36.5*z
    translate (<-4.5, -10, 0>*.5+<7, 6, 0>*.5)
    hollow 
    no_shadow
    interior {
        media {
            scattering {1, .18 extinction 0}
            density {bozo scale  .02 color_map {[.94 rgb 0][.941 rgb 6]}}
        }
        media {
            scattering {1, .008 extinction 0}
            density {bozo scale 1.2 color_map {[0 rgb <.6, .6, 1>*1.25][1 rgb <.3, .3, .4>]}}         
        }
    }
    pigment {rgbt 1}
};    



//--- locate the trees along a grid
#include "trees.inc"
#declare Forest = 
union {
    object {Tree (2.5 , 2.2 ) rotate   10*y rotate < 3, 0, -4.5> translate <1.25, 0, -2.8 >}
    object {Tree (2.8 , 2.5 ) rotate  -30*y rotate <-6, 0, -3.8> translate <1.15, 0, -1.45>}
    object {Tree (2.35, 2.45) rotate   65*y rotate <-4, 0, -3.6> translate <1.3 , 0, - .1 >}
    object {Tree (2.1 , 2.6 ) rotate  160*y rotate < 4, 0, -4.2> translate <1.4 , 0,  1.5 >}
    object {Tree (2.5 , 2.25) rotate  -90*y rotate < 3, 0, -3.5> translate <1.35, 0,  3.1 >}
         
    object {Tree (2.2 , 2.1 ) rotate   90*y rotate <-2, 0, -3  > translate < .15, 0, -3.05>}
    object {Tree (2.6 , 2.45) rotate -135*y rotate < 5, 0, -3.8> translate <-.05, 0, -1.55>}
    object {Tree (2.45, 2.15) rotate  135*y rotate < 8, 0, -2.6> translate < .05, 0,   .15 >}
    object {Tree (2.9 , 2.4 ) rotate   40*y rotate <-3, 0, -2.2> translate <-.1 , 0,  1.42>}
    object {Tree (2.0 , 2.65) rotate  -60*y rotate <-5, 0, -3.6> translate <   0, 0,  2.9 >}
    
    
    object {Tree (2.6 , 2.5 ) rotate  120*y rotate < 6, 0, -5.8> translate <-1.15, -.35, -2.95>}
    object {Tree (2.5 , 2.3 ) rotate    0*y rotate <-1, 0, -5.2> translate <-1.45, -.3 , -1.48>}
    object {Tree (2.65, 2.25) rotate   70*y rotate < 5, 0, -5.1> translate <-1.55, -.28, - .15>}
    object {Tree (2.75, 2.0 ) rotate  -75*y rotate < 3, 0, -5.4> translate <-1.35, -.32,  1.54>}
    object {Tree (2.25, 2.35) rotate -160*y rotate <-2, 0, -5.3> translate <-1.3 , -.25,  3.05>}        
};
  
  
//--- now we just have to put all the elements together

object {Sun}
#if (Radiosity)         
    object {Glare}
#else    
    object {Floor_fill_light}
    object {Sunbeam_fill_light}    
#end
object {Room}  
object {Rods}
object {Floor}
object {Forest translate <-3.15, -8>}
object {Sunbeam}



