#include "functions.inc"

//--- a wrinkled normal
#declare Leaves_normal =
normal {
    pigment_pattern {wrinkles} 2
    scale .2
};


//--- a layered texture for the leaves
#if (Radiosity) 
    #local Ambient_value = 0;
    #local Diffuse_value = .45;
#else
    #local Ambient_value = .4;
    #local Diffuse_value = .6;
#end

#declare Leaves_texture = 
texture {  
    pigment {
        bozo scale .1 turbulence 1.5
        color_map {
            [.35 rgb 1 transmit 1]      
            [.4  rgb <.2, .4, .15> transmit 0]
        }
    }
    normal {Leaves_normal}
    finish {ambient Ambient_value diffuse Diffuse_value}    
}
texture {
    pigment {
        bozo scale .1 turbulence 1.5
        color_map {
            [.5  rgb 1 transmit 1]
            [.55 rgb <.32, .57, .25> transmit 0]
        }
    }
    normal {Leaves_normal}
    finish {ambient Ambient_value diffuse Diffuse_value}    
}        
texture {
    pigment {
        bozo  scale .1 turbulence 1.5
        color_map {
            [.75 rgb 1 transmit 1]      
            [.80  rgb <.55, .68, .2> transmit  0]
        }
    }    
    normal {Leaves_normal}
    finish {ambient Ambient_value diffuse Diffuse_value}    
};


//--- an isosurface based on a sphere and a random noise
#macro Leaves (V, H)
isosurface {
    function {f_sphere (x, y, z, 1) + .25*f_snoise3d (H*x, V*y, H*z)}
    evaluate 3, 1.29, .7
    threshold 0
    contained_by {sphere {0, 1.25}}
    max_gradient 15.3    
}
#end 


//--- the limbs, actually random parts to be seen through random holes in the crown
#macro Limbs (V, H)
isosurface {
    function {f_snoise3d (H*x, V*y, H*z)}
    evaluate 4, 1.29, .7
    threshold -.350// -.28
    contained_by {sphere {0, 1}}
    max_gradient 4.5    
}

#end 
 
 
//--- the trunk 
#macro Trunk ()
isosurface {
    function {x*x+z*z+.01*y + .05*f_snoise3d (8*x, y, 8*z)}
    threshold .025
    contained_by {box {<-.5, -2, -.5>,<.5, 0, .5>}}
    max_gradient 1.8
    scale <.75,1,.78>
}
#end


//--- an individual tree
#macro Tree (V, H)
union {
    union {
        object {Trunk () scale <.25*H, 1, .25*H>}
        object {
            Limbs (V, H) 
            scale .25*<H, V, H>
        }
        texture {
            pigment {rgb <.45, .40, .30>}
            normal {Leaves_normal scale .05}
            #if (Radiosity) finish {ambient 0} #end            
        }         
    }  
    object {
        Leaves (V, H)                
        scale .25*<H, V, H>
        texture {Leaves_texture}        
    }
    translate (min (0, -2.5+.5*H+.5*V))*y // to make the smaller trees actually shorter
}
#end