#include "functions_perso.inc"
#include "math.inc"

#declare sE = seed(2340) ;

#declare rayon = .04 ;
#declare D_Electron = function (x,y,z,n) {
  torical(x,y,z,rayon)*pow(max(0,1-(1-x)*n/2),2)*(z>=0)
} 

#declare C_Electron = <.4,.75,.9> ;
#declare C_Electronf = <.4,.75,.9,1> ;
#macro Electron(R,In)
  torus {
    1,rayon/R
    pigment {color rgbt 1}
    finish {ambient 0 diffuse 0}
    hollow
    no_shadow
    interior {
      media {
        emission C_Electron*8*In
        density {
          function {D_Electron(x,y,z,R)}
          density_map {
            [0 color rgb .22]
            [1 color rgb 1]
          }
        }
      }
    }
  }
  scale R
#end

#macro NuagE(N,In)
  union {
    #declare i=0 ;
    #while(i<N)
      #declare i=i+1 ;
      #declare om = rand(sE) ;
      #declare omeg = acosd(1-2*om) ;
      object {
        Electron(5+3*(1-pow(1-rand(sE),2)),In)
        rotate (360*rand(sE)*y) 
        rotate omeg*z
        rotate (360*rand(sE))*y  
      }
    #end
  }
#end  