// Persistence of Vision Ray Tracer Scene Description File
// File: wreck.pov
// Vers: 3.5
// Desc: Basic Scene Example
// Date: 01/06/05
// Auth: Sean Day
//   

// I don't expect to win any awards for code style or commenting but if it is of any use, 
// you are welcome to use it however you like.
// Thanks to Mike Williams for his Isosurface tutorial (very usefull information)
// and Christoph Hormann for his excellent isowood library (I don't use it but for this scene but
// it was very usefull for working out how to break the wood.)


#version 3.5;

#include "colors.inc"     
#include "functions.inc"
#include "transforms.inc"

#declare showLandscape                  = 1;    
#declare showGround                     = 1;      
#declare showWater                      = 1;    
#declare showIsoRocks                   = 1;  
#declare useTestTex                     = 0;   
#declare useArea                        = 1;   
#declare showPlank                      = 1;          
#declare showShells                     = 1;  
#declare useFocalBlur                   = 0;


#declare hfQuality                      = 5; //1-10            
#declare isoAccuracy                    = 0.001;

#declare use_rad=0;  // radiosity: 0=no rad, 1=load, 2=save

global_settings{
 assumed_gamma 1.0
 ambient_light 0.0 
 #if (use_rad)
 radiosity{ 
  // save settings: modified Outdoor settings from rad_def.inc
  #if (use_rad=2) 
    pretrace_start 0.08
    pretrace_end   0.01
    count 250
    nearest_count 20
    error_bound 0.1
    recursion_limit 2
    low_error_factor .9
    gray_threshold 0
    minimum_reuse 0.015
    brightness 0.3
    adc_bailout 0.01/2
    save_file "cave.rad"
  #else
    // load settings  
    pretrace_start 1 pretrace_end 1 
    load_file "cave.rad" 
    error_bound 0.1    // it's important to specify the same value used to save data
    recursion_limit 2  // also the same if specified
    always_sample off  // no more samples: specially useful with focal blur
  #end
 }
 #end
}



// ----------------------------------------

camera {
  location  <-25, 135, -350>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <0, 90, 0>  
  rotate <0, 0, 0>       
  #if(useFocalBlur)
  aperture 1.5           // [0...N] larger is narrower depth of field (blurrier)
  blur_samples 40        // number of rays per pixel for sampling
  focal_point <65, 7.925, -35>    // point that is in focus <X,Y,Z>
  confidence 0.90           // [0...<1] when to move on while sampling (smaller is less accurate)
  variance 1/10000            // [0...1] how precise to calculate (smaller is more accurate)   
  #end
}


// a very basic sky but it is never going to be seen. However it should effect the radiosity and the water colours.

sky_sphere {
  pigment {
    bozo                
    omega 0.7   
    octaves 10
    lambda 3
    turbulence 0.45
    scale <15, 1, 1>
    sine_wave
    color_map {
      [0.0 rgb <0.2,0.4,1.0>]
      [0.7 rgb <0.3,0.5,1.0>]
      [0.925 rgb <0.25,0.35,1>]
      [0.985 rgb <1,1,1>]
    }                          
    scale 0.1
  }
}


light_source {
  <0, 5000, 0>            // light's position (translated below)
  color rgb <2.075, 1.5752, 1.1825>*1.25  //rgb <2, 1.25, 0.6> // light's color        
  // light_source { ...
  // put this inside a light_source to add light fading
#if(useArea)
  area_light
  <120, 0, 0> <0, 0, 120> // lights spread out across this distance (x * z)
  10, 10                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
#end
  fade_distance 5000
  fade_power 2          
  rotate <-70, -60, 0>

}  

#if(use_rad=0)          // if not using radiosity add some low level light
light_source {
  <-100, 50, -200>            // light's position (translated below)
  color rgb <2.075, 1.5752, 1.1825>*0.125 //rgb <2, 1.25, 0.6> // light's color        
  // light_source { ...
  // put this inside a light_source to add light fading
#if(useArea)
  area_light
  <100, 0, 0> <0, 0, 100> // lights spread out across this distance (x * z)
  10, 10                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
#end
  fade_distance 100
  fade_power 2          
  shadowless
}  
#end


#declare generalRand = seed(18581);   

// Macro to return a random number

#macro gr(num)
        rand(generalRand)*num
#end

// Shell texture

#declare crusty_tex = texture
{
                pigment { bozo turbulence 0.1 omega 0.6 lambda 2.5 colour_map { [ 0.0 rgb <1, 0.96, 0.9>*0.7 ] [0.8 rgb <0.9, 0.75, 0.35>*0.3 ] } scale 0.05 } 
                finish { phong 0.25 phong_size 5 ambient 0 }//diffuse 0.75 brilliance 0.85 }
                normal { leopard bump_size 15 scale 0.008 turbulence 1 omega 0.6  }
}
#declare crusty_bit = difference
        {
                sphere { <0, 0, 0> 1 }
                sphere { <0, 0, -0.7> 0.45 }
        }


#declare shell = union
{
        #declare cCount = 0;
        union
        {
        #while (cCount < 65)                                                   
                #declare zCrust = 0.025+gr(0.35);
                object { crusty_bit rotate <-40, 0, 0> scale 0.1-gr(0.065) translate <0, -1+((zCrust/0.75)*0.9), -zCrust> rotate <0, 0, gr(360)> }
                
            
                #declare cCount = cCount+1;
        #end                        
        #while (cCount < 90)                                                   
                #declare zCrust = 0.35+gr(0.35);
                object { crusty_bit rotate <-40, 0, 0> scale 0.1-gr(0.065) translate <0, -1+((zCrust/0.75)*0.9), -zCrust> rotate <0, 0, gr(360)> }
                
            
                #declare cCount = cCount+1;
        #end    

        texture { crusty_tex } 
        }  
        // lines                                          
        
        #declare lRotate = 0;
        union
        {
        #while(lRotate < 360)
                union
                {
                        cone { <-0.95, 0, 0.0> 0.065 <-0.07, 0, -0.75> 0.035 }     
                        sphere { <-0.95, 0, 0.0> 0.065 }
                        sphere { <-0.07, 0, -0.75> 0.035 }
                        rotate <0, 0, lRotate+gr(4)-gr(4)> 
                
                }
                #declare lRotate = lRotate+22.5;   

        #end
                torus { 0.05, 0.05 scale <1, 0.8, 1> rotate <-90, 0, 0> translate <0, 0, -0.755> }                   
                texture
                {
                        pigment { bozo turbulence 0.1 omega 0.6 lambda 2.5 colour_map { [ 0.0 rgb <1, 0.96, 0.9>*0.25] [0.8 rgb <0.9, 0.8, 0.5>*0.7 ] } scale 0.05 } 
                        finish { phong 0.2 phong_size 25 ambient 0 }// diffuse 0.625 brilliance 0.85 }
                        normal { bozo bump_size 5 scale 0.08 turbulence 1 omega 0.6  }
                }

        }

        cone { <0, 0, -0.75> 0.1 <0, 0, 0.05> 1  }        

        texture
        {
                pigment
                {
                        gradient z 
                        omega 0.6 
                        lambda 4
                        turbulence 0.265
                        colour_map
                        {
                                [ 0.0 rgb <0.9, 0.7, 0.4>*0.25]
                                [ 0.75 rgb <0.9, 0.875, 0.85>*0.6 ]
                                [ 1.0 rgb <0.3, 0.2, 0.075>*0.3 ]    
                        }
                        scale 0.1
                }
                finish { phong 0.135 phong_size 30 ambient 0 }// diffuse 0.625 }
                normal 
                {     
                        average
                        normal_map
                        {
                                [ 1.0 gradient z bump_size 1.2 scallop_wave turbulence 0.02 scale 0.075 
                                        slope_map 
                                        {
                                                [0   <0, 1>]   // start at bottom and slope up
                                                [0.5 <1, 1>]   // halfway through reach top still climbing
                                                [0.5 <1,-1>]   // abruptly slope down
                                                [1   <0,-1>]   // finish on down slope at bottom
                                        }
                                ]
                                [ 1.0  bozo bump_size 5 scale 0.08 turbulence 1 omega 0.6 ]
                        }
                }
        }   
        scale <1.1, 1.1, 1.2>
}


#declare rock_base = texture
{
        pigment { granite triangle_wave omega 0.6 lambda 3 turbulence 0.275 
                color_map {  [ 0.0 rgb <0.175, 0.175, 0.175> ] [ 1.0 rgb <0.425, 0.425, 0.425> ] } 
                scale 0.25 
                }
        finish { ambient 0 diffuse 0.5 }
}

#declare rock_tex_1 = texture
{   
        pigment 
        {
                wrinkles            
                turbulence 0.1   
                omega 0.7 lambda 4
                color_map
                {
                        [ 0.0 rgbt <1, 1, 1, 1> ]// rgbt <0.15, 0.09, 0.015, 0.05> ] 
                        [ 0.5 rgbt <1, 1, 1, 1> ]// rgbt <0.15, 0.09, 0.015, 0.05> ] 
                        [ 0.5 rgbt <0.15, 0.09, 0.015, 1> ] //rgbt 1 ]
                        [ 0.8 rgbt <0.15, 0.09, 0.015, 0.25> ] //rgbt 1 ]
                        [ 1.0 rgbt <0.15, 0.091, 0.015, 0.1> ] //rgbt 1 ]
                }                         
                scale 25
        }
        finish { ambient 0 diffuse 0.45 specular 0 phong 0 }
}          

#declare rock_tex_2 = texture
{   
        pigment 
        {
                wrinkles  
                scallop_wave          
                turbulence 0.1   
                omega 0.7 lambda 4
                color_map
                {
                        [ 0.0 rgbt <0.15, 0.09, 0.015, 0.1> ] //rgbt 1 ]
                        [ 0.5 rgbt <0.15, 0.09, 0.015, 0.5> ] //rgbt 1 ]
                        [ 0.75 rgbt <0.15, 0.091, 0.015, 1> ] //rgbt 1 ]
                        [ 0.75 rgbt <1, 1, 1, 1> ]// rgbt <0.15, 0.09, 0.015, 0.05> ] 
                        [ 1.0 rgbt <1, 1, 1, 1> ]// rgbt <0.15, 0.09, 0.015, 0.05> ] 
                }                         
                scale 15
        }
        finish { ambient 0 diffuse 0.45 specular 0 phong 0 }


}          

#declare rock_tex_3 = texture
{   
        pigment 
        {
                bozo scallop_wave           
                turbulence 0.7 
                omega 0.7 lambda 4 octaves 10 
                scale 0.56
                color_map
                {
                        [ 0.0 rgbt 1 ]
                        [ 0.9 rgbt 1 ]
                        [ 0.925 rgbt <0.0075, 0.06, 0.0005, 1> ] 
                        [ 0.975 rgbt <0.0075, 0.06, 0.0005, 0.4> ] 
                        [ 1.0 rgbt <0.0075, 0.06, 0.0005, 0> ] 
                 }
        } 
        finish { ambient 0 diffuse 0.5 specular 0 phong 0 }
        scale 20


}
#declare rock_tex_4 = texture
{   
        pigment 
        {
                granite            
                turbulence 0.2 
                omega 0.6 lambda 2.5 
                color_map
                {
                        [ 0.0 rgbt 1 ]
                        [ 0.1 rgbt 1 ]
                        [ 0.15 rgbt <0.1, 0.06, 0.01, 1> ] 
                        [ 0.3 rgbt <0.1, 0.06, 0.01, 0.1> ] 
                        [ 0.45 rgbt <0.1, 0.06, 0.01, 1> ] 
                        [ 0.5 rgbt 1 ]
                        [ 0.6 rgbt 1 ]
                        [ 0.65 rgbt <0.0075, 0.06, 0.0005, 1> ] 
                        [ 0.75 rgbt <0.0075, 0.06, 0.0005, 0.05> ] 
                        [ 0.9 rgbt <0.0075, 0.06, 0.0005, 1> ] 
                        [ 0.95 rgbt 1 ]
                        [ 1.0 rgbt 1 ]
                 }
                scale 0.1
        }          
        finish { ambient 0 diffuse 0.45 specular 0 phong 0 }


}

#declare rock_tex_5 = texture
{   
        pigment 
        {
                gradient y            
                turbulence 0.0085
                omega 0.575 lambda 3.0 
                scale <1, 1, 1>
                color_map
                {
                        [ 0.0 rgbt <0.05, 0.01, 0.0001, 0.025> ]
                        [ 0.4 rgbt <0.085, 0.025, 0.0003, 0.075> ]
                        [ 0.65 rgbt <0.125, 0.04, 0.0006, 0.3> ]
                        [ 0.7 rgbt <0.2, 0.15, 0.005, 0.75> ]
                        [ 0.8 rgbt <0.3, 0.25, 0.0125, 1> ]
                        
                        [ 0.8 rgbt <1, 1, 1, 1> ]
                        [ 1.0 rgbt <1, 1, 1, 1> ]
                        
                 }       
                 translate <0, 0.4, 0>
                 scale <300, 300, 300>
        }  


        
}




#declare land_tex_1 = texture
{   
        pigment 
        {
                granite            
                turbulence 0.05   
                omega 0.7 lambda 4
                scale <0.25, .25, 0.25>        
                color_map
                {
                        [ 0.0 rgbt <0.15, 0.09, 0.015, 0.5> ] 
                        [ 0.4 rgbt <0.15, 0.09, 0.015, 1> ] 
                        [ 0.4 rgbt 1 ]
                        [ 1.0 rgbt 1 ]
                }
        }
        finish { ambient 0 diffuse 0.45 specular 0 phong 0 brilliance 0.9 }


}

#declare land_tex_2 = texture
{   
        pigment 
        {
                wrinkles cubic_wave           
                turbulence 0.225   
                omega 0.7 lambda 4
                scale <0.15, .15, 0.15>        
                color_map
                {
                        [ 0.0 rgbt <0.15, 0.09, 0.015, 0.1> ] 
                        [ 0.4 rgbt <0.15, 0.09, 0.015, 1> ] 
                        [ 0.4 rgbt 1 ]
                        [ 1.0 rgbt 1 ]
                }
        }
        finish { ambient 0 diffuse 0.45 specular 0 phong 0 brilliance 0.9 }


}

#declare land_tex_3 = texture
{   
        pigment 
        {
                wrinkles sine_wave           
                turbulence 0.35   
                omega 0.65 lambda 4
                scale 0.05
                color_map
                {
                        [ 0.0 rgbt 1 ]
                        [ 0.7 rgbt 1 ]
                        [ 0.7 rgbt <0.15, 0.09, 0.015, 1> ] 
                        [ 1.0 rgbt <0.15, 0.09, 0.015, 0.3> ] 
                 }
        }
        finish { ambient 0 diffuse 0.45 specular 0 phong 0 brilliance 0.9 }


}
#declare land_tex_4 = texture
{   
        pigment 
        {
                bozo scallop_wave           
                turbulence 0.7 
                omega 0.7 lambda 4 octaves 10 
                scale 0.56
                color_map
                {
                        [ 0.0 rgbt 1 ]
                        [ 0.9 rgbt 1 ]
                        [ 0.925 rgbt <0.0075, 0.06, 0.0005, 1> ] 
                        [ 0.975 rgbt <0.0075, 0.06, 0.0005, 0.4> ] 
                        [ 1.0 rgbt <0.0075, 0.06, 0.0005, 0> ] 
                 }
        }
        finish { ambient 0 diffuse 0.45 specular 0 phong 0 brilliance 0.9 }


}
#declare land_tex_5 = texture
{   
        pigment 
        {
                granite            
                turbulence 0.2 
                omega 0.6 lambda 2.5 
                scale 0.01
                color_map
                {
                        [ 0.0 rgbt 1 ]
                        [ 0.1 rgbt 1 ]
                        [ 0.15 rgbt <0.1, 0.06, 0.01, 1> ] 
                        [ 0.3 rgbt <0.1, 0.06, 0.01, 0.1> ] 
                        [ 0.45 rgbt <0.1, 0.06, 0.01, 1> ] 
                        [ 0.5 rgbt 1 ]
                        [ 0.6 rgbt 1 ]
                        [ 0.65 rgbt <0.0075, 0.06, 0.0005, 1> ] 
                        [ 0.75 rgbt <0.0075, 0.06, 0.0005, 0.05> ] 
                        [ 0.9 rgbt <0.0075, 0.06, 0.0005, 1> ] 
                        [ 0.95 rgbt 1 ]
                        [ 1.0 rgbt 1 ]
                 }
        }
        finish { ambient 0 diffuse 0.45 specular 0 phong 0 brilliance 1.21 }

}

#declare land_tex_6 = texture
{   
        pigment 
        {
                gradient z            
                turbulence 0.275
                omega 0.626 lambda 3.0 
                scale <10, 5, 1>
                color_map
                {
                        [ 0.0 rgbt <1, 1, 1, 1> ]
                        [ 0.1 rgbt <1, 1, 1, 1> ]
                        [ 0.1 rgbt <0.3, 0.25, 0.0125, 1> ]
                        [ 0.25 rgbt <0.21, 0.155, 0.0055, 0.75> ]
                        [ 0.35 rgbt <0.175, 0.05, 0.001, 0.3> ]
                        [ 0.4 rgbt <0.12, 0.04, 0.0003, 0.075> ]
                        [ 0.8 rgbt <0.075, 0.016, 0.0001, 0.01> ]
                        [ 0.8 rgbt <1, 1, 1, 1> ]
                        [ 1.0 rgbt <1, 1, 1, 1> ]
                 }
        }

}




#if(useTestTex)                       
#declare rock_tex = texture
{
       rock_base scale 10
}
#else                        
#declare rock_tex_dry = texture
{
       rock_base scale 10
}
texture
{
        rock_tex_1
}
texture
{
        rock_tex_2
}
texture
{
        rock_tex_3
}
texture
{
        rock_tex_4
}
texture
{
        rock_tex_5
        finish { ambient 0 diffuse 0.45 specular 0 phong 0 }
}  

#declare rock_tex_wet = texture
{
       rock_base scale 10
}
texture
{
        rock_tex_1
}
texture
{
        rock_tex_2
}
texture
{
        rock_tex_3
}
texture
{
        rock_tex_4
}
texture
{
        rock_tex_5
        finish { ambient 0 diffuse 0.35 specular 0.5 roughness 0.001 phong 0.5 phong_size 150 }
}


#declare rock_tex = texture 
{
        gradient y    
        scale 100        
        texture_map 
        {
                [ 0.0 rock_tex_wet scale 0.01 ]
                [ 0.25 rock_tex_wet scale 0.01 ]
                [ 0.425 rock_tex_dry scale 0.01 ]
                [ 1.0 rock_tex_dry scale 0.01 ]
         }
}


#end

#if(useTestTex)
#declare land_tex = texture
{
        rock_base
}      
#else 

#declare land_tex_dry = texture
{
        rock_base
}      
texture
{
        land_tex_1
}
texture
{
        land_tex_2
}
texture
{
        land_tex_3
}
texture
{
        land_tex_4
}
texture
{
        land_tex_5
} 
texture
{
        land_tex_6 
        finish { ambient 0 diffuse 0.4 specular 0 phong 0 brilliance 0.85 }
}            


#declare land_tex_wet = texture
{
        rock_base
}      
texture
{
        land_tex_1
}
texture
{
        land_tex_2
}
texture
{
        land_tex_3
}
texture
{
        land_tex_4
}
texture
{
        land_tex_5
} 
texture
{
        land_tex_6                                                                           
        finish { ambient 0 diffuse 0.35 specular 0.5 roughness 0.001 phong 0.5 phong_size 150 }
}          

#declare land_tex = texture 
{
        gradient z            
//        turbulence 0.275
//        omega 0.526 lambda 2.5 
        texture_map 
        {
                [ 0.0 land_tex_dry ]
                [ 0.25 land_tex_dry ]
                [ 0.375 land_tex_wet ]
                [ 1.0 land_tex_wet ]
         }
}
#end


// ----------------------------------------

#declare Land1=function{pattern{quilted poly_wave
   turbulence 0.275 scale <1.1, 1, 1.2> translate <-0.7, 0, 0.4> }}
#declare Land2=function{pattern{marble 
   turbulence 0.32 scale <1.25, 1, 1> }}
#declare Land3=function{pattern{crackle 
   turbulence 0.3 scale <0.7, 1, 0.25> rotate <0, 0, 0> translate <0.6, 0, 0.2> }}
#declare Land4=function{pigment{leopard  
   turbulence 0.125 color_map { [ 0 rgb 0 ] [ 1 rgb 1 ] } scale 0.05  translate <0.2, 0, 0.2> }}
#declare Land5=function{pattern{granite 
   turbulence 0.05 scale 0.25  }}
#declare Land6=function{pattern{wrinkles cubic_wave 
   turbulence 0.225 scale 0.15  }}



//#declare Land=function{Land1(x,0,z)*0.3 +Land2(x,0,z)*0.2+Land3(x,0,z)*0.2}
//#declare Land=function{Land1(x,0,z)*0.6}
//#declare Land=function{Land1(x,0,z)*0.6+Land2(x*1,0,z*2)*0.2}
//#declare Land=function{Land1(x,0,z)*0.6+Land2(x*1,0,z*2)*0.2+Land3(x*0.5,0,z*0.5)*0.16+Land4(x*5,0,z*5)*0.006}

//#declare Land=function{Land4(x*0.25, 0, z*0.25).grey*2}//+Land5(x, 0, z)*0.003+Land6(x, 0, z)*0.025}
#declare Land=function{Land4(x*0.25, 0, z*0.25).grey+Land5(x, 0, z)*0.003+Land6(x, 0, z)*0.03}

#macro Place_Shell(Land_Surface, Shell, Pos, Norm)
    //Allow the user to pass scalars as vectors
    #local Pos = Pos + <0,0,0>;

    //Trace onto the surface
    #local N = <0,0,0>;
    #local S = trace(Land_Surface, Pos, z, N);

    //Check if we hit the surface
    #if (vlength(N)>0)   
    #warning "Hit Shell"
        //place the shell
        object {
            Shell
  
            //Adjust the Normal if the user wants us to
            #if (Norm)
                Reorient_Trans(z,N)
            #end

            //Translate to final position
            translate S
        }
    #else
        #warning "Miss Shell"
    #end
#end // End Macro


#if(showLandscape)
// Main land
#declare land = height_field{function 500*hfQuality,500*hfQuality {Land(x,0,y)} 
   hollow
   texture { land_tex }
   translate <-0.5,0,-0.5>
   scale <50, 50, 50>       
//   rotate <0, 45, 0>    
//   rotate <-30, 0, 0>
//   translate <-20, 185, -175>               

 rotate <90, 0, 0>   
 scale 10

}
object { land }
#if(showShells)   

#macro placeShellCluster(obj, shellLoc)
        // place one shell in location
        #declare shellScale = 2+gr(0.25);
        #declare shelln = object { shell rotate <0, 0, gr(360)> scale <shellScale, shellScale, shellScale+gr(0.1)>  }
        
        Place_Shell(obj, shelln, shellLoc, on)
        
        // place rest of cluster
        #declare shellCount=1+gr(4);
        #declare cShell = 0;  
        #declare zrot = 0;
        #while(cShell < shellCount)
                #declare zrot=zrot+45+(gr(35));
                #declare shellScale = 2+gr(0.25);       
                #declare shellLocRotate=vrotate(<6+gr(5), 0, 0>, <0, 0, zrot>);
                
                #declare shellLoc2 = shellLoc+shellLocRotate;
                #declare shelln = object { shell rotate <0, 0, gr(360)> scale <shellScale, shellScale, shellScale+gr(0.1)> }
                
                Place_Shell(obj, shelln, shellLoc2, on)        
                
                #declare cShell=cShell+1;
        #end                               

#end

// place clusters

placeShellCluster(land, <-160, 95, 0>)
placeShellCluster(land, <-95, 115, 0>)
placeShellCluster(land, <-117, 85, 0>)
placeShellCluster(land, <-30, 44, 0>)
placeShellCluster(land, <50, 6, 0>)
placeShellCluster(land, <100, 5, 0>)
placeShellCluster(land, <150, 10, 0>)
placeShellCluster(land, <180, 14, 0>)
placeShellCluster(land, <195, 30, 0>)


#end // end show shells

  
#end


#declare Ground1=function{pattern{ripples 
   turbulence 0.275 scale 0.02   }}

#declare Ground2=function{pattern{agate 
   agate_turb 0.42 scale 0.008 rotate <0, 20, 0> }}

#declare Ground=function{Ground1(x, 0, z)*0.009+Ground2(x,0,z)*0.001}

#declare GroundTex1 = texture
{
        pigment
        {
                granite
                colour_map
                {
                        [ 0.0 rgb <1, 0.975, 0.927> ]
                        [ 1.0 rgb <1, 0.95, 0.84> ]
                }                                    
                scale 0.01
        } 
        finish { phong 1 phong_size 400 ambient 0 diffuse 0.8 brilliance 0.7 }       
        normal { granite scale 0.01 }  
    
}              

#declare GroundTex2 = texture
{
        pigment
        {
                granite
                colour_map
                {
                        [ 0.0 rgb <0.24, 0.1, 0.12> ]
                        [ 1.0 rgb <0.10, 0.085, 0.07> ]
                }                                    
                scale 0.01
        } 
        finish { phong 1 phong_size 400 ambient 0 diffuse 0.8 brilliance 0.7 }       
        normal { granite scale 0.01 }   
  
}

#declare GroundTex3 = texture
{
        pigment
        {
                granite
                colour_map
                {
                        [ 0.0 rgb <0.5, 0.3, 0.09> ]
                        [ 1.0 rgb <0.3, 0.175, 0.012> ]
                }                                    
                scale 0.01
        } 
        finish { phong 1 phong_size 400 ambient 0 diffuse 0.8 brilliance 0.7 }       
        normal { granite scale 0.01 } 
    
}

#declare GroundTex4 = texture
{
        pigment
        {
                granite
                colour_map
                {
                        [ 0.0 rgb <1, 0.7, 0.2> ]
                        [ 1.0 rgb <0.9, 0.6, 0.1> ]
                }                                    
                scale 0.01
        } 
        finish { phong 1 phong_size 400 ambient 0 diffuse 0.8 brilliance 0.7 }       
        normal { granite scale 0.01 }   
      
}

#declare GroundTex5 = texture
{
        pigment
        {
                granite
                colour_map
                {
                        [ 0.0 rgb <1, 1, 0.7> ]
                        [ 1.0 rgb <0.9, 0.9, 0.6> ]
                }                                    
                scale 0.01
        } 
        finish { phong 1 phong_size 400 ambient 0 diffuse 0.8 brilliance 0.7 }       
        normal { granite scale 0.01 }    
     
}

#if(showGround)
// Main land
union
{
   height_field{function 200*hfQuality,200*hfQuality {Ground(x,0,y)} 
   translate <-0.5,0,-0.5>   
   rotate <0, 50, 0>
   rotate <-2, 0, 0>
   scale <750, 300, 750>       
   translate <0, -40, -100> 
}
plane {
  y, // <X Y Z> unit surface normal, vector points "away from surface"
  0 // distance from the origin in the direction of the surface normal
  hollow on // has an inside pigment?      
  rotate <-6, 0, -14>       
  translate <0, -130, 0>
} 
   texture
   {   
        wood   
        omega 0.7
        lambda 4
        turbulence <0.0525, 0.041, 0.051>      
        //turbulence 0.351
        scale <500, 125, 30>
        //scale <150, 50, 23>
        texture_map
        {

                [ 0.0 GroundTex1 ]
                [ 0.31 GroundTex1 ]
                [ 0.325 GroundTex2 ]
                [ 0.35 GroundTex3 ]
                [ 0.4 GroundTex3 ]
                [ 0.5 GroundTex4 ]
                [ 0.625 GroundTex4 ]
                [ 0.9 GroundTex5 ]

        }     
        rotate <92, -15, 0>     
   }
   
}  

#end







#declare Water1=function{pattern{waves 
   turbulence 0.275 scale 0.1   }}
#declare Water2=function{pattern{ripples 
   turbulence 0.325 scale 0.05   }}


#declare Water=function{Water1(x, 0, z)*0.015+Water2(x, 0, z)*0.05}


            
#declare C_Sea=rgb <62,64,63>/64;

#declare seaTex = texture
{
        pigment{rgbf <C_Sea.red,C_Sea.green,C_Sea.blue,0.925>}
        finish 
        {
                phong 1//4
                phong_size 100
                specular 1//2
                roughness 0.0005
                ambient 0
                diffuse 0.25      
                reflection {0.2,1 fresnel on}
                conserve_energy
        }
}


#declare bubbleTex = texture 
{ 
        seaTex 
}       
texture
{
        pigment 
        { 
                bozo   
                scallop_wave
                turbulence 0.395
                octaves 9
                omega 0.675
                lambda 3.25
                pigment_map
                {
                        [ 0.0 rgbt <1, 1, 1, 1.0> ]  
                        [ 0.89 rgbt <1, 1, 1, 1.0> ]  
                        [ 0.98 rgbt <1, 1, 1, 0.7> ]  
                        [ 0.9995 rgbt <1, 1, 1, 0.005> ]  
                        [ 1.0 rgbt <1, 1, 1, 0> ]  
                        
                }
                scale <1.0, 0.3, 0.6>
                
        }
        finish { phong 1 phong_size 70 specular 1 roughness 0.01 ambient 0 diffuse 0.6 brilliance 0.6 }
}

#if(showWater)
// Main land
   height_field{function 500*hfQuality,500*hfQuality {(sin(y*pi*10)+1)/65+f_ridged_mf(x*6, y*10,z*1, 1.1,2.5,6,1.28,5,1)*0.0125 } //{Water(x,0,y)}  

   translate <-0.5,0,-0.5>   
   rotate <0, 50, 0>
   scale <750, 300, 750>       
   translate <0, 0, -100> 
    

#if(useTestTex)
    texture{
                pigment{rgbf <C_Sea.red,C_Sea.green,C_Sea.blue,0.925>}
                finish {
                    ambient 0
                    diffuse 0.25      
                }
            }
#else        
        material 
        {
                texture
                {     
                        gradient y 
                        omega 0.585
                        turbulence 0.0125
                        texture_map
                        {
                                [ 0.0 seaTex ]
                                [ 0.54 seaTex ]
                                [ 0.554 bubbleTex ]
                                [ 0.585 bubbleTex ]
                                [ 0.6 seaTex ]
                                [ 1.0 seaTex ]
                        }  
                        scale <10, 200, 10>
                        translate <0, -300, 0>
                }                       
        

         
                interior 
                {
                        ior 1.34
                        dispersion 1.01    
                        fade_distance 150
                        fade_power 1001
                        fade_color <0.0, 0.1, 0.075, 0.5>
                        media {absorption (1-C_Sea)*0.1
                }     
    }
} 
#end


}  
#end



// add some rocks


  #declare fn_rock_1=function {
    pigment {                              
      wrinkles    
      turbulence 0.1  
        
      colour_map
      {     
        [ 0 rgb 0 ]
        [ 1 rgb 1 ]
      }               
         
  
  }

} 

  #declare fn_rock_2=function {
    pigment {                              
      wrinkles    
      scallop_wave
      turbulence 0.1  
        
      colour_map
      {     
        [ 0 rgb 0 ]
        [ 1 rgb 1 ]
      }               
         
  
  }

} 


#if(showIsoRocks)
union
{
        #declare largeRightRock=isosurface 
        {
                function{f_rounded_box(x,y,z, 0.1, 0.8, 0.2, 0.45)-(fn_rock_2(x*1,y*1,z*1).grey*0.2)-(fn_rock_1(x*1,y*1.5,z*1.25).grey*0.1)}
        //        function{f_sphere(x,y,z, rsize)-(fn_rock_2(x*0.1,y*0.1,z*0.1).grey*8)}
                threshold 0
                contained_by {box { <-1.05, -0.5, -0.75> <1.05, 0.5, 0.75> } }
                accuracy isoAccuracy
                max_gradient 4.411  
                scale 80
                rotate <0, 0, 75>
                rotate <0, -35, 0>            
                translate <40, 0, 110> 
        }  
        
        object { largeRightRock } 



        #declare smallRock = isosurface 
        {
                function{f_sphere(x,y,z, 0.4)-(fn_rock_2(x*1.25,y*1.4,z*1.3).grey*0.175)-(fn_rock_1(x*1,y*1,z*1).grey*0.08)}
        //        function{f_sphere(x,y,z, rsize)-(fn_rock_2(x*0.1,y*0.1,z*0.1).grey*8)}
                threshold 0
                contained_by {box { <-0.765, -0.65, -0.625> <0.765, 0.65, 0.625>   } }
                accuracy isoAccuracy
                max_gradient 3.125  
                scale <60, 80, 70> 
                rotate <10, 20, -20>
                translate <-50, 0, 105> 
        }   
        
        object { smallRock }



        isosurface 
        {
                function{f_rounded_box(x,y,z, 0.02, 0.6, 0.15, 0.35)-(fn_rock_2(x*1.2,y*1.1,z*1.3).grey*0.15)-(fn_rock_1(x*1,y*1.25,z*1.15).grey*0.2)}
        //        function{f_sphere(x,y,z, rsize)-(fn_rock_2(x*0.1,y*0.1,z*0.1).grey*8)}
                threshold 0
                contained_by {box { <-0.9, -0.45, -0.7> <0.9, 0.45, 0.7>   } }
                accuracy isoAccuracy
                max_gradient 3.8  
                scale 55
                rotate <0, 60, 0>
                rotate <-50, 0, 10>            
                translate <-95, -15, 54> 
        }




        #declare largeLeftRock = isosurface 
        {
                function{f_rounded_box(x,y,z, 0.4, 0.7, 0.4, 0.55)-(fn_rock_2(x*1,y*1,z*1).grey*0.3)-(fn_rock_1(x*1,y*1.5,z*1.25).grey*0.15)}
        //        function{f_sphere(x,y,z, rsize)-(fn_rock_2(x*0.1,y*0.1,z*0.1).grey*8)}
                threshold 0
                contained_by {box { <-0.95, -0.85, -0.95> <0.95, 0.85, 0.95> } }
                accuracy isoAccuracy
                max_gradient 4.6  
                scale <100, 80, 80>
                rotate <0, 0, 100>
                rotate <20, -15, 0>            
                translate <-135, -10, -10> 
        }   

        object { largeLeftRock }
 
        texture { rock_tex }
}

// add some shells
// Big rock on left

#declare rockShell = object { shell rotate <180, 0, gr(360)> scale <2.6, 2.6, 2.75> }
Place_Shell(largeLeftRock, rockShell, <-124, 45, -1000>, on)        

#declare rockShell = object { shell rotate <180, 0, gr(360)> scale <2.7, 2.75, 2.7> }
Place_Shell(largeLeftRock, rockShell, <-119, 39, -1000>, on)        

#declare rockShell = object { shell rotate <180, 0, gr(360)> scale <2.5, 2.5, 2.45> }
Place_Shell(largeLeftRock, rockShell, <-113.5, 47, -1000>, on)        

#declare rockShell = object { shell rotate <180, 0, gr(360)> scale <2.55, 2.55, 2.5> }
Place_Shell(largeLeftRock, rockShell, <-123, 31, -1000>, on)        

// three cluster
#declare rockShell = object { shell rotate <180, 0, gr(360)> scale <2.55, 2.55, 2.5> }
Place_Shell(largeLeftRock, rockShell, <-87, 24, -1000>, on)        

#declare rockShell = object { shell rotate <180, 0, gr(360)> scale <2.75, 2.72, 2.7> }
Place_Shell(largeLeftRock, rockShell, <-83, 28, -1000>, on)        

#declare rockShell = object { shell rotate <180, 0, gr(360)> scale <2.6, 2.575, 2.6> }
Place_Shell(largeLeftRock, rockShell, <-92, 22, -1000>, on)        


// two cluster
#declare rockShell = object { shell rotate <180, 0, gr(360)> scale <2.5, 2.55, 2.55> }
Place_Shell(largeLeftRock, rockShell, <-131, 21, -1000>, on)        

#declare rockShell = object { shell rotate <180, 0, gr(360)> scale <2.6, 2.575, 2.5> }
Place_Shell(largeLeftRock, rockShell, <-126, 16, -1000>, on)        

// small rock  
// four cluster
#declare rockShell = object { shell rotate <180, 0, gr(360)> scale <2.65, 2.65, 2.6> }
Place_Shell(smallRock, rockShell, <-50, 7, -1000>, on)        

#declare rockShell = object { shell rotate <180, 0, gr(360)> scale <2.75, 2.75, 2.65> }
Place_Shell(smallRock, rockShell, <-44, 10, -1000>, on)        

#declare rockShell = object { shell rotate <180, 0, gr(360)> scale <2.55, 2.55, 2.5> }
Place_Shell(smallRock, rockShell, <-56, 6, -1000>, on)        

#declare rockShell = object { shell rotate <180, 0, gr(360)> scale <2.75, 2.7, 2.75> }
Place_Shell(smallRock, rockShell, <-47, 4, -1000>, on)        

// two cluster
#declare rockShell = object { shell rotate <180, 0, gr(360)> scale <2.65, 2.65, 2.6> }
Place_Shell(smallRock, rockShell, <-33, 10, -1000>, on)        

#declare rockShell = object { shell rotate <180, 0, gr(360)> scale <2.80, 2.75, 2.7> }
Place_Shell(smallRock, rockShell, <-38, 13, -1000>, on)        


// Right side rock
// three cluster
#declare rockShell = object { shell rotate <180, 0, gr(360)> scale <2.5, 2.55, 2.45> }
Place_Shell(largeRightRock, rockShell, <44, 11, -1000>, on)        

#declare rockShell = object { shell rotate <180, 0, gr(360)> scale <2.6, 2.575, 2.5> }
Place_Shell(largeRightRock, rockShell, <49, 7, -1000>, on)        

#declare rockShell = object { shell rotate <180, 0, gr(360)> scale <2.6, 2.575, 2.5> }
Place_Shell(largeRightRock, rockShell, <54, 12, -1000>, on)        

// four cluster
#declare rockShell = object { shell rotate <180, 0, gr(360)> scale <2.5, 2.55, 2.45> }
Place_Shell(largeRightRock, rockShell, <20, 11, -1000>, on)        

#declare rockShell = object { shell rotate <180, 0, gr(360)> scale <2.6, 2.575, 2.5> }
Place_Shell(largeRightRock, rockShell, <25, 12, -1000>, on)        

#declare rockShell = object { shell rotate <180, 0, gr(360)> scale <2.6, 2.55, 2.55> }
Place_Shell(largeRightRock, rockShell, <27, 21, -1000>, on)        

#declare rockShell = object { shell rotate <180, 0, gr(360)> scale <2.7, 2.675, 2.6> }
Place_Shell(largeRightRock, rockShell, <14, 10, -1000>, on)        

#end

// nameplate

#if(showPlank)
#declare fn_wood_1=function {
    pigment {                              
      wood    
      turbulence <0.015, 0.1, 0>  
        
      colour_map
      {     
        [ 0 rgb 0 ]
        [ 1 rgb 1 ]
      }     
      scale 0.015
//      scale <0.025, 1, 0.025> 
      rotate <0, 90.5, 0>
      rotate <0, 0, 2>
      scale <2, 1, 1>          
         
  
  }

}



#local fn_break=         
  function{
    pattern{
      wrinkles   
      omega 0.55
      turbulence 0.124
      scale 0.1
    }
  }
#declare fn_plank = function{f_rounded_box(x,y,z,0.02,2,0.04,0.28)}
#declare fn_plank_break = function{x-1.45+fn_break(0,y,z)}    
#declare fn_plank_break2 = function{-x-1.45+fn_break(0,y,z)}    


#declare plank_dirt_1 = texture
{
        pigment
        {
                wrinkles    
                sine_wave
                turbulence 0.3
                omega 0.575
                lambda 4                
                colour_map
                {                                  
                        [ 0.0 rgbt <1, 1, 1, 1> ]
                        [ 0.05 rgbt <1, 1, 1, 1> ]
                        [ 0.05 rgbt <0.1, 0.06, 0.001, 1> ]
                        [ 0.3 rgbt <0.1, 0.06, 0.001, 0> ]
                        [ 0.6 rgbt <0.1, 0.06, 0.001, 1> ]
                        [ 0.6 rgbt <1, 1, 1, 1> ]
                        [ 0.65 rgbt <1, 1, 1, 1> ]
                        [ 0.65 rgbt <0, .025, 0.001, 1> ]
                        [ 0.9 rgbt <0.025, .0125, 0.001, 0> ]
                        [ 0.95 rgbt <0.025, .0125, 0.001, 1> ]
                        [ 0.95 rgbt <1, 1, 1, 1> ]
                        [ 1.0 rgbt <1, 1, 1, 1> ]
                }                                   
                scale 0.5
        }
        finish { specular 0 ambient 0 diffuse 0.325 }
        normal { wrinkles 0.5 scale 0.025 }
}    

#declare plank_dirt_2 = texture
{
        pigment 
        {
                gradient x
                triangle_wave 
                omega 0.657
                lambda 4  
                turbulence 0.75
                colour_map  
                {
                        [ 0.0 rgbt <0.3, 0.22, 0.125, 0> ]
                        [ 1.0 rgbt <0.3, 0.22, 0.125, 1> ]                        
                }                                                       
                scale 0.75
        }                                                
        finish { ambient 0 diffuse 0.325 specular 0 }   
        normal { granite 0.5 scale 0.025 }
}

#declare wet_tex = texture { 
        pigment { rgbt <0.9, 0.9, 0.95, 0.9> }
        finish { specular 1 roughness 0.0005 phong 0.8 phong_size 200 ambient 0 diffuse 0.2 brilliance 5 }
        normal { ripples 0.15 turbulence 0.7 scale 0.15 }
}                               


#declare plateMetalDry = texture
{
        pigment 
        {
                agate
                turbulence 0.25
                omega 0.62
                lambda 3.5 
                colour_map
                {
                        [ 0.0 rgb <0.5, 0.4, 0.0025> ]
                        [ 1.0 rgb <0.3, 0.3, 0.00325> ]
                }              
                scale 0.1                       
        }
        finish  { specular 0.3 roughness 0.02 ambient 0 diffuse 0.7 reflection 0.02 metallic }
}
texture { plank_dirt_1 }
texture { plank_dirt_2 }     

#declare plateMetalWet = texture
{
        pigment 
        {
                agate
                turbulence 0.25
                omega 0.62
                lambda 3.5 
                colour_map
                {
                        [ 0.0 rgb <0.5, 0.4, 0.0025> ]
                        [ 1.0 rgb <0.3, 0.3, 0.00325> ]
                }              
                scale 0.1                       
        }
        finish  { specular 0.3 roughness 0.02 ambient 0 diffuse 0.7 reflection 0.02 metallic }
}
texture { plank_dirt_1 }
texture { plank_dirt_2 }   
texture { wet_tex }
  
#if(useTestTex)
#declare plateMetal = texture
{
        pigment 
        {
           rgb <0.5, 0.4, 0.0025>
        }
        finish  { ambient 0 diffuse 0.7 }
}
#else
#declare plateMetal = texture
{
        bozo 
//        turbulence 0.5
//        omega 0.225
//        lambda 2.5
        texture_map
        {
                [ 0.0 plateMetalDry ]
                [ 0.1 plateMetalDry ]
                [ 0.2 plateMetalWet ]
                [ 0.28 plateMetalWet ]
                [ 0.34 plateMetalDry ]
                [ 0.4 plateMetalDry ]
                [ 0.48 plateMetalWet ]
                [ 0.56 plateMetalWet ]
                [ 0.65 plateMetalDry ]
                [ 0.7 plateMetalDry ]
                [ 0.9 plateMetalWet ]
                [ 1.0 plateMetalWet ]
        }
} 
#end

#declare plate_back_dry = texture 
{
        pigment 
        {
                rgb 0.001
        }                
        normal 
        {
                spotted bump_size 0.4 cubic_wave turbulence 0.015 omega 0.6 lambda 3 scale 0.03
        } 
        finish
        {
                ambient 0 phong 1 phong_size 80
        }
}
texture { plank_dirt_1 }
texture { plank_dirt_2 }

#declare plate_back_wet = texture 
{
        pigment 
        {
                rgb 0.001
        }                
        normal 
        {
                spotted bump_size 0.4 cubic_wave turbulence 0.015 omega 0.6 lambda 3 scale 0.03
        } 
        finish
        {
                ambient 0 phong 1 phong_size 80
        }
}
texture { plank_dirt_1 }
texture { plank_dirt_2 }
texture { wet_tex }

#if(useTestTex)
#declare plate_back = texture
{
        pigment 
        {
                rgb 0.001
        }                
        finish
        {
                ambient 0 
        }
}
#else
#declare plate_back = texture
{
        bozo 
//        turbulence 0.5
//        omega 0.225
//        lambda 2.5
        texture_map
        {
                [ 0.0 plate_back_dry ]
                [ 0.1 plate_back_dry ]
                [ 0.2 plate_back_wet ]
                [ 0.28 plate_back_wet ]
                [ 0.34 plate_back_dry ]
                [ 0.4 plate_back_dry ]
                [ 0.48 plate_back_wet ]
                [ 0.56 plate_back_wet ]
                [ 0.65 plate_back_dry ]
                [ 0.7 plate_back_dry ]
                [ 0.9 plate_back_wet ]
                [ 1.0 plate_back_wet ]
        }
}
#end

#declare plank_tex_base = texture 
{                                
        pigment 
        {                              
                wood    
                turbulence <0.015, 0.1, 0>  
                omega 0.565 
                lambda 2.5  
                colour_map
                {     
                        [ 0 rgb <0.14, 0.0594, 0.008> ]
                        [ 1 rgb <0.05, 0.021, 0.004> ]
                }     
                scale 0.015
                rotate <0, 90.5, 0>
                rotate <0, 0, 2>
                scale <2, 1, 1>          
        }         
        finish { phong 0.2 phong_size 25 ambient 0 diffuse 0.65  }         
}                            
  
#declare plank_tex_dry = texture
{
        plank_tex_base
}
texture { plank_dirt_1 }
texture { plank_dirt_2 }

#declare plank_tex_wet = texture
{
        plank_tex_base
}
texture { plank_dirt_1 }
texture { plank_dirt_2 }
texture { wet_tex }

#if(useTestTex)
#declare plank_tex = texture
{
        plank_tex_base
}
#else
#declare plank_tex = texture
{
        bozo 
//        turbulence 0.5
//        omega 0.225
//        lambda 2.5
        texture_map
        {
                [ 0.0 plank_tex_dry ]
                [ 0.1 plank_tex_dry ]
                [ 0.2 plank_tex_wet ]
                [ 0.28 plank_tex_wet ]
                [ 0.34 plank_tex_dry ]
                [ 0.4 plank_tex_dry ]
                [ 0.48 plank_tex_wet ]
                [ 0.56 plank_tex_wet ]
                [ 0.65 plank_tex_dry ]
                [ 0.7 plank_tex_dry ]
                [ 0.9 plank_tex_wet ]
                [ 1.0 plank_tex_wet ]
        }
}
#end

// name plaque
union
{                  
        isosurface 
        {
                function
                {
                        max(        
                                max(
                                        fn_plank(x,y,z),
                                        fn_plank_break2(x,y,z)*0.05
                                   ),
                                fn_plank_break(x,y,z)*0.075
                           )+f_wrinkles(x*5,y*35,z*25)*0.005+fn_wood_1(x,y,z).grey*0.001}
                threshold 0
                contained_by {box { <-1.45, -0.05, -0.29> <1.45, 0.05, 0.29> } }
                accuracy isoAccuracy
                max_gradient 6.8  
                texture { plank_tex }
          rotate <-90, 0, 0>
          scale 7         
          translate <0.2, 0.1, 0.5>
                
        }     

        union
        {        
                text {
                  ttf             // font type (only TrueType format for now)
                  "timrom.ttf",  // Microsoft Windows-format TrueType font file name
                  "PERSISTENCE",      // the string to create
                  0.2,              // the extrusion depth
                  0              // inter-character spacing
                  translate <-3.25, 0, 0>
                }
                text {
                  ttf             // font type (only TrueType format for now)
                  "timrom.ttf",  // Microsoft Windows-format TrueType font file name
                  "1991",      // the string to create
                  0.2,              // the extrusion depth
                  0              // inter-character spacing
                  translate <-0.925, -0.84, 0>
                }
                
                box { <-4, -1.1, 0> <4, -0.975, 0.2> }   
                box { <-4, 0.8, 0> <4, 0.925, 0.2> }
                box { <-4, -0.976, 0> <-3.875, 0.81, 0.2> }
                box { <3.875, -0.976, 0> <4, 0.81, 0.2> }
                cylinder { <-3.875, -0.975, 0> <-3.875, -0.975, 0.2> 0.124 }
                cylinder { <3.875, -0.975, 0> <3.875, -0.975, 0.2> 0.124 }
                cylinder { <-3.875, 0.8, 0> <-3.875, 0.8, 0.2> 0.124 }
                cylinder { <3.875, 0.8, 0> <3.875, 0.8, 0.2> 0.124 }
            
        
                texture { plateMetal }
        }
        box { <-3.9, -1.0, 0.05> <3.9, 0.9, 0.2> 
                texture { plate_back }
        }                                                                      
        
        scale 6.75   
        rotate <84, -21, -11>
        translate <65, 7.925, -35>


}

#end