// Persistence of Vision Ray Tracer Scene Description File
// File: eggplate.pov
// Vers: 3.5
// Date: 08/01/05
// Auth: Steve Shelby
//                  

#version 3.5;

#include "asm.inc"

global_settings {
  assumed_gamma 1.0
}
// radiosity (global illumination) settings
global_settings {
  radiosity {
    pretrace_start 0.08           
    pretrace_end   0.04           
    count 100                      
    nearest_count 5               
    error_bound 1.8               
    recursion_limit 3             
    low_error_factor .5           
    gray_threshold 0.5           
    minimum_reuse 0.015         
    brightness 1                  

    adc_bailout 0.01/2
    normal on                   
    
  }
}


// ----------------------------------------

camera {
  location  <0.0, 14, -19>
  
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <0.0, 0.3,  0.0>
  angle 20
}



light_source {   // Arealight
  <0.0, 0.0, 0.0>
  color rgb <0.040, 0.030, 0.020>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 3, 3
  adaptive 1
  jitter
  rotate -90.0*y
  translate  <-18, 10.0, -15>
}


light_source {   // Arealight 
  <0.0, 0.0, 0.0>
  color rgb <0.200, 0.280, 0.200>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 6, 6
  adaptive 1
  jitter
  rotate <180.0, 90.0, 180.0>
  translate  <18.0, 12.0, 4>
}


light_source {   // Arealight 
  <0.0, 0.0, 0.0>
  color rgb <0.15, 0.15, 0.10>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 6, 6
  adaptive 1
  jitter
  translate  <0.0, 10.0, -18.0>
}

// ----------------------------------------



box { // table top
  <-1, -1, -1>, <1, 1, 1>
  material {
    texture
      {      
         pigment
         {
            image_map
            {
               jpeg   "C:\My Documents\My Pictures\Textures\tabletop4.jpg"
              
            }
         }      
         
      }
      
    scale <1, 0.5, 0.5>
    rotate <90.0, 180, 0>
    translate <0.5, 0, 0.5>
    }
  scale <12.0, 0.5, 18.0>
  translate <0, -0.5, 2>
}



#declare egg=
object
{
#declare MyObject = sphere { <0,.8,0> , 1}
 
object {asm(MyObject,1.75,1.25,1,1,1,1)texture {pigment {
    color rgb <0.9, 0.9, 0.7>}
    normal 
 
 {
            gradient x , 0.5
            normal_map
            {  
               [0.0   
                  granite , 0.6
                  scale  0.06
               ]
               [0.2   
                  granite , 0.1
                  scale  0.0001
               ]
               [0.8   
                  granite , 0.1
                  scale  0.0001
               ]
               [1.0   
                  granite , 0.6
                  scale  0.06
               ]
            }
            scale  4.0
            translate 1.8 * x
         }
  finish {
    ambient 0.25
    diffuse 0.4 
    specular 0.4 
    roughness 0.2  
  } 
  }
  }
  }
  object {  
  egg
  translate <-0.5, 0, -1.5 >
  rotate 30*y
  }
  
  object {  
  egg
  translate <1, 0, 1.5 >
  rotate -30*y
  }
  
  object {  
  egg
  translate <0.5, 0, -1.5 >
  rotate -60*y
  } 
  
  
lathe { //plate
  
  cubic_spline 
  
  8, // number of points
  <0, 0>,<0, 0>, <2.5, 0>, <3.5, .5>, <3.5, .7>, <2.5, .2>, <0, .2>, <0, .2>  
  
  pigment {
    color rgb <0.95,0.95,.85>     
    }
    
  finish {
    ambient 0.03          
    diffuse 0.8          
    brilliance 1.0       
    phong 0.8          
    phong_size 40         
    specular 0.9      
    roughness 0.005         
    reflection {      
      0.3                        
    }
    conserve_energy            
  } 
   
}



box { // wall001
  <-1, -1, -1>, <1, 1, 1>
  material  // wall1
   {   
      texture
      {      
         pigment
         {
            image_map
            {
               jpeg   "C:\My Documents\My Pictures\Textures\room1.jpg"
               once
            }
         }
      }
   

    scale <2.0, 2.0, 1.0>
    translate <-1.0, -1.0, 0.0>
    }
    finish
    {
    ambient 0.1
  }
  scale <20.0, 15.0, 1.0>
  translate  <0, 7.5, 20.0>
}




box { // wall002
  <-1, -1, -1>, <1, 1, 1>
   material  // wall2
   {   
      texture
      {      
         pigment
         {
            image_map
            {
               jpeg   "C:\My Documents\My Pictures\Textures\room2.jpg"
               once
            }
         }
      }
   

    scale <2.0, 2.0, 1.0>
    translate <-1.0, -1.0, 0>
  }
  
  finish
    {
    ambient .1
    }
    
  scale <20.0, 15.0, 1.0>
  rotate 90.0*y
  translate  <20.0, 7.5, 0>
}


box { // wall003
  <-1, -1, -1>, <1, 1, 1>
   material  // wall3
   {   
      texture
      {      
         pigment
         {
            image_map
            {
               jpeg   "C:\My Documents\My Pictures\Textures\room3.jpg"
               once
            }
         }
      }
   

    scale <2.0, 2.0, 1.0>
    translate <-1.0, -1.0, 0>
    }
    
    finish
    {
    ambient .1
  }
  scale <20.0, 15.0, 1.0>
  rotate -180.0*y
  translate <0, 7.5, -20.0>
}


box { // wall004
  <-1, -1, -1>, <1, 1, 1>
  material  // wall4
   {   
      texture
      {      
         pigment
         {
            image_map
            {
               jpeg   "C:\My Documents\My Pictures\Textures\room4.jpg"
               once
            }
         }
      }
   

    scale <2.0, 2.0, 1.0>
    translate <-1.0, -1.0, 0>
    }
    
    finish
    {
    ambient 0.1
  }
  scale <20.0, 15.0, 1.0>
  rotate -90.0*y
  translate  <-20.0, 7.5, 0>
}


box { // ceiling
  <-1, -1, -1>, <1, 1, 1>
  material 
   {   
      texture
      {      
         pigment
         {
            rgb <0.8, 0.8, 0.5>
         }
      }
   

    scale <2.0, 2.0, 1.0>
    translate <-1.0, -1.0, 0>
    }
    
    finish
    {
    ambient .1
  }
  scale <22.0, 22.0, 1.0>
  rotate 90.0*x
  translate  26*y
}


