//  Persistence of Vision Raytracer V3.5
//  World definition file.
//
//  Contains 1 lights, 4 materials and 10 primitives.
//
//  This file was generated for POV-Ray V3.5 by
//  Moray V3.5 For Windows Copyright (c) 1993-2003 Lutz + Kretzschmar
//

//  Date : 07/23/2005    (23.07.2005)
//
/*
default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

global_settings {
  adc_bailout 0.003922
  ambient_light <0.0,0.0,0.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  noise_generator 2
  charset ascii
  radiosity {
    brightness       1.0
    count            80
    error_bound      0.6
    gray_threshold   0.0
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    4
    recursion_limit  1
    #if (version>3.1)
      adc_bailout      0.005
      max_sample       -1.0
      media            off
      normal           on
      always_sample    0

      pretrace_start   0.08
      pretrace_end     0.01
    #end
  }
  photons {
    adc_bailout       0.01
    count             50000
    gather            20, 100
    media             1, 1.0
    jitter            0.4
    max_trace_level   5
    autostop          0.5
    radius            0.0
    expand_thresholds 0.2, 35.0
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Camera01
  location  <     -1.180,      -3.485,       5.949>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.35783,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         39.60000    // Vertical      29.700
  look_at   <      0.039,      -0.151,       0.036>
}

//
// *******  L I G H T S *******
//

light_source {   // Light001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 0.686>*2.0000
  photons {
    refraction on
  }
  translate  <-5.418304, 16.042568, 18.688764>
}
*/

//
// ********  MATERIALS  *******
//

#include "plaque.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare Cylndr001 = object {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    translate  -1.0*z
    photons {
      target 1.0
      refraction on
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.75, 0.5, 0.0>
  }
}




//
// ********  OBJECTS  *******
//

/*plane { // Plane001
  z,0
  material {
    WallTex
  }
}*/


#declare RndCube001 = merge {
  sphere { <1.9900, 0.7400, 0.0400>, 0.0100 }
  sphere { <1.9900, -0.7400, 0.0400>, 0.0100 }
  sphere { <-1.9900, -0.7400, 0.0400>, 0.0100 }
  sphere { <-1.9900, 0.7400, 0.0400>, 0.0100 }
  sphere { <1.9900, 0.7400, -0.0400>, 0.0100 }
  sphere { <1.9900, -0.7400, -0.0400>, 0.0100 }
  sphere { <-1.9900, -0.7400, -0.0400>, 0.0100 }
  sphere { <-1.9900, 0.7400, -0.0400>, 0.0100 }
  cylinder { <1.9900, 0.7400, 0.0400>, <-1.9900, 0.7400, 0.0400>, 0.0100 }
  cylinder { <1.9900, -0.7400, 0.0400>, <-1.9900, -0.7400, 0.0400>, 0.0100 }
  cylinder { <1.9900, -0.7400, -0.0400>, <-1.9900, -0.7400, -0.0400>, 0.0100 }
  cylinder { <1.9900, 0.7400, -0.0400>, <-1.9900, 0.7400, -0.0400>, 0.0100 }
  cylinder { <1.9900, 0.7400, -0.0400>, <1.9900, 0.7400, 0.0400>, 0.0100 }
  cylinder { <1.9900, -0.7400, -0.0400>, <1.9900, -0.7400, 0.0400>, 0.0100 }
  cylinder { <-1.9900, -0.7400, -0.0400>, <-1.9900, -0.7400, 0.0400>, 0.0100 }
  cylinder { <-1.9900, 0.7400, -0.0400>, <-1.9900, 0.7400, 0.0400>, 0.0100 }
  cylinder { <1.9900, 0.7400, 0.0400>, <1.9900, -0.7400, 0.0400>, 0.0100 }
  cylinder { <1.9900, 0.7400, -0.0400>, <1.9900, -0.7400, -0.0400>, 0.0100 }
  cylinder { <-1.9900, 0.7400, -0.0400>, <-1.9900, -0.7400, -0.0400>, 0.0100 }
  cylinder { <-1.9900, 0.7400, 0.0400>, <-1.9900, -0.7400, 0.0400>, 0.0100 }
  box { <-1.9900, -0.7400, -0.0500> <1.9900, 0.7400, 0.0500> }
  box { <-1.9900, -0.7500, -0.0400> <1.9900, 0.7500, 0.0400> }
  box { <-2.0000, -0.7400, -0.0400> <2.0000, 0.7400, 0.0400> }
  photons {
    target 1.0
    refraction on
  }
}
#declare Text = union {
  text {   // TText001
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "Thomas de Groot",
    0.1,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <0.4, 0.4, 1.0>
    translate  <-1.55, 0.281156, 0.0>
  }

  text {   // TText002
    ttf      "C:\WINDOWS\Fonts\Ariali.ttf",
    "Again(st) Minimalism",
    0.1,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <0.3, 0.3, 1.0>
    translate  <-1.55, -0.080445, 0.0>
  }

  text {   // TText003
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "2005",
    0.1,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <0.3, 0.3, 1.0>
    translate  <-1.55, -0.5, 0.0>
  }

  material {
    LetterBlackTex
    // Transform to world space
    translate  -0.5*z
  }
}
#declare Plaque = difference {
  object { RndCube001 }
  object { Text }
  photons {
    target 1.0
    refraction on
  }
}

#declare NameTag =
union { // CSG001
  object { Plaque }
  object { Cylndr001 }
  object { // Cylndr002 -> Cylndr001
    Cylndr001
    photons {
      target 1.0
      refraction on
    }
    rotate -0.0*z
    translate  -1.0*y
  }
  object { // Cylndr003 -> Cylndr001
    Cylndr001
    photons {
      target 1.0
      refraction on
    }
    rotate -0.0*z
    translate  3.5*x
  }
  object { // Cylndr004 -> Cylndr001
    Cylndr001
    photons {
      target 1.0
      refraction on
    }
    rotate -0.0*z
    translate  <3.5, -1.0, 0.0>
  }
  photons {
    target 1.0
    refraction on
  }
  translate  0.3*z
  material {
    Plexiglas
    // Transform to world space
  }
  scale <1, 1, -1>
  rotate <90, 0, 0>
}

object {NameTag
  scale 0.2
  translate <-1.65, 0, -2.4>
}


