//Art Gallery scene for August 2005 IRTC
// PoVRay 3.6 Scene File " Artglry.pov"
// created by   Chris Holtorf  
// Date:   08/31/05
//--------------------------------------------------------------------------
#version 3.6;

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	  // Standard Color definitions
#include "textures.inc"	  // Standard Texture definitions
#include "functions.inc"  // internal functions usable in user defined functions
#include "metals.inc"

#include "StairRiser.inc"  
#include "PoolLadder.inc"
#include "StairRailing.inc"
#include "Water_Texture.inc"
#include "Paintings.inc"
#include "txttree.inc"
#include "Mesh.inc"

camera {
   perspective
   location <47.5, 70, 240>
   right <1.31122, 0, -0.241833>
   up <0.00825233, 0.998964, 0.0447441>
   direction <0.181187, -0.0454987, 0.982396>
   angle 35.9886
   look_at <215.69, 48.2284, 1152.08>
}

global_settings {
  assumed_gamma 1.5 
  ambient_light rgb<0.0,0.0,0.0> 
  max_trace_level 10
  irid_wavelength     <0.25,0.18,0.14>
  max_intersections   64
  number_of_waves     10
  noise_generator     2
  adc_bailout 1/255
  
  radiosity {
    pretrace_start 0.08                 // start pretrace at this size
    pretrace_end   0.01                 // end pretrace at this size
    count 120                           // higher -> higher quality (1..1600) [35]
    nearest_count 12  //20              // higher -> higher quality (1..10) [5]
    error_bound 0.02                    // higher -> smoother, less accurate [1.8]
    recursion_limit 3                   // how much interreflections are calculated (1..5+) [3]
    low_error_factor 0.75               // reduce error_bound during last pretrace step
    gray_threshold 0.75                 // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015                 // reuse of old radiosity samples [0.015]
    brightness 1                        // brightness of radiosity effects (0..1) [1]

    //adc_bailout 0.01/2
    normal on                           // take surface normals into account [off]
    media on                            // take media into account [off]
    //save_file "radiosity.rd"          // save radiosity data
    //load_file "radiosity.rd"          // load saved radiosity data
    //always_sample off                 // turn sampling in final trace off [on]
    //max_sample 1.0                    // maximum brightness of samples
  }
  
  photons {
      spacing 0.5  //0.05
      jitter 1.0 
      media 100
      //save_file "photons.ph"
      //load_file "photons.ph"
    } 
} 

#declare Sun=rgb <248,236,222>/255;
light_source { 9000*y  Sun
  area_light <50, 0, 0> <0, 0, 50> 4,4 
        jitter 
        circular 
        orient
  rotate -x*60 rotate  y*(90)
   
    photons {
             reflection off
             refraction on
            } 

}   

#declare C_Sky=rgb <90,131,255>/255;
sky_sphere {
  //texture {
  pigment {
    gradient y
    color_map {
      [0 C_Sky*0.05]
      [0.4 C_Sky]
    }
  }
  scale 2
  translate -y
} 

//--------------------------------------------------------------------------

//Textures

//Concrete Texture
#declare Concrete1 = material {
texture {
  pigment { color rgb <0.99, 0.99, 0.99> }
  normal { bumps 0.01 }
  //finish  { ambient 1 diffuse 0 }
  }
 } 

//Glass Texture
#declare Glass = material  
   { texture { pigment { color rgbf <1.0, 1.0, 1.0, 0.7> }      
         finish { ambient 0.0 diffuse 0.0 specular 1.0 roughness 0.001 reflection 0.1 } }   
      interior { ior 1.5 }
   }
  
//---------------------------------------------------------------------------
//---------------------------- objects in scene ----------------------------
//---------------------------------------------------------------------------


// Ground Floor
#declare GroundFloor =  difference {
                                    box {<0, -6, 0> < 34*12,  0,  96*12> material { Concrete1 }} 
                                    box {<0, -12, 624> < 16*12,  6,  1008> material { Concrete1 }}
                                   } 
                            
 object { GroundFloor photons { target reflection off refraction on }}

//Pool Sides
#declare PoolSides =  difference {
                                    box {<-6, -7*12-6, 606> < 16*12+18,  0,  1028> material { Concrete1 }} 
                                    box {<0, -7*12, 612> < 16*12+12,  6,  1020> material { Concrete1 }}
                                   } 
                            
 object { PoolSides photons { target reflection off refraction on }}

// Left Side Wall
#declare LSWall =  box {<-6, -7*12, 0> < 0,  8*12,  96*12> material { Concrete1 }}
                            
 object { LSWall photons { target reflection off refraction on }} 
 
// Right Side Wall
#declare RSWall =  box {<32*12, -7*12, 0> < 32*12+6,  16*12,  96*12-48> material { Concrete1 } }
                            
 object { RSWall photons { target reflection off refraction on }}   
 
// Back Wall
#declare BWall = union { 
                         box {<-6, -6, 96*12> < 34*12+6,  8*12,  96*12+6> material { Concrete1 }}
                         box {<20*12, 8*12, 96*12> < 34*12,  16*12,  96*12+6> material { Concrete1 }}
                        }
                            
 object { BWall photons { target reflection off refraction on }}

// Front Wall
#declare FWall = union { 
                         box {<-6, -6, 0> < 34*12+6,  8*12,  6> material { Concrete1 }}
                         box {<20*12, 0, 0> < 34*12,  16*12,  6> material { Concrete1 }}
                        }
                            
 object { FWall photons { target reflection off refraction on }}

// 2nd Floor
#declare Floor2 =  union {
                           box {<240, 8*12-6, 1008> < 34*12,  8*12,  96*12> material { Concrete1 }} 
                           box {<288, 8*12-6, 960> < 336,  8*12,  1008> material { Concrete1 }}
                          }
                            
 object { Floor2 photons { target reflection off refraction on }}
 
// Ceiling
#declare Ceiling =  box {<240, 16*12-6, 1008> < 34*12,  16*12,  96*12> material { Concrete1 }}
                            
 object { Ceiling }
 
// 2nd Floor Support 1
#declare FlSupt1 =  box {<240, 0.25, 1008> < 264,  8*12-6.25,  1014> material { Concrete1 }}
                            
 object { FlSupt1 photons { target reflection off refraction on }} 
 
// 2nd Floor Support 2
#declare FlSupt2 =  box {<240, 0.25, 1014.25> < 246,  8*12-6.25,  1038> material { Concrete1 }}
                            
 object { FlSupt2 photons { target reflection off refraction on }}

// Roof Support 
#declare RoofSupt =  box {<240, 8*12+0.25, 1012> < 244,  16*12-6.25,  1008> material { Concrete1 }}
                            
 object { RoofSupt photons { target reflection off refraction on }} 
 object { RoofSupt translate<48,0,0> photons { target reflection off refraction on }}
 object { RoofSupt translate<92,0,0> photons { target reflection off refraction on }}
 
//Stair Riser
object { Riser material { Concrete1 } photons { target reflection off refraction on }}

//Stair Tread
#declare Tread = prism {                                
                        linear_sweep    
                        linear_spline  
                        0,         
                        12,         
                        6,           
                        // (--- the <u,v> points ---)
                        < 2.75,0.2>, < 24,1.5>, < 24,3>, < -24,3>, < -24,1.5>, 
                        <-2.75,0.2> 
                       }

//Steps
#declare Steps = union{
                        #declare Nr = 0;     // start
                        #declare EndNr = 11; // end
                        #while (Nr< EndNr) 

                        object{Tread rotate<-90,0,0> translate<312,8*Nr+4.75,Nr*12+828+12>} 

                        #declare Nr = Nr + 1;  // next Nr
                        #end // --------------- end of loop 

                        rotate<0,0,0> 
                        translate<0,0,0>} // end of union 
                        
object { Steps material { Concrete1 } photons { target reflection off refraction on }}

//Glass Panel   
//Front Wall
#declare GlassPanel1 = box { <1,1,0> <47,44.5,0.5> material { Glass } } 
#declare GlassPanel1a = box { <0,0,0> <39,11,0.5> material { Glass } }

 object { GlassPanel1 translate<240,8*12,1010> photons { target reflection off refraction on }}
 object { GlassPanel1 translate<336,8*12,1010> photons { target reflection off refraction on }}
 object { GlassPanel1a translate<292,8*12+78,1010> photons { target reflection off refraction on }} 
 object { GlassPanel1 translate<240,12*12-3,1010> photons { target reflection off refraction on }}
 object { GlassPanel1 translate<336,12*12-3,1010> photons { target reflection off refraction on }}
 
//Glass Door
#declare GlassDoor = union {
                            box { <1,1,0> <39,77.5,0.5> material { Glass } photons { target reflection off refraction on }} //door panel
                            box {<30, 39, -1.25> < 40,45,0> texture { T_Chrome_2C } photons { target reflection off refraction on }}  //door push bar
                            box {<0, 34.5, -0.5> < 4,35.5,0> texture { T_Chrome_2C } photons { target reflection off refraction on }}  //door hinge
                            box {<0, 70, -0.5> < 4,72,0> texture { T_Chrome_2C } photons { target reflection off refraction on }}  //door hinge
                            box {<0, 5, -0.5> < 4,7,0> texture { T_Chrome_2C } photons { target reflection off refraction on }}  //door hinge
                           }
  object { GlassDoor rotate<0,-15,0> translate<292,8*12,1010> }                             

//Side Wall
#declare GlassPanel2 = box { <0,1,1> <0.5,89,44.66> material { Glass } photons { target reflection off refraction on }}
#declare GlassFrame2a = box { <1,0,0.3> <-1,90,1.2> texture { T_Chrome_2C } photons { target reflection off refraction on }}
#declare GlassFrame2b = box { <-1,-1,-1> <1,1,138> texture { T_Chrome_2C } photons { target reflection off refraction on }}  

 object { GlassPanel2 translate<242,8*12,1012> }
 object { GlassPanel2 translate<242,8*12,1056.666> photons { target reflection off refraction on }} 
 object { GlassPanel2 translate<242,8*12,1103.333> photons { target reflection off refraction on }}
 object { GlassFrame2a translate<242,8*12,1056.666> photons { target reflection off refraction on }}
 object { GlassFrame2a translate<242,8*12,1103.333> photons { target reflection off refraction on }} 
 
//Pool Ladder
 object { PoolLadder texture { T_Chrome_2C } rotate<0,90,0> translate<16*12+12,0,815> photons { target reflection off refraction on }}
 
//Stair Rails
 object { StairRail texture { T_Chrome_2C } photons { target reflection off refraction on }} 
 object { StairRail texture { T_Chrome_2C } translate<43,0,0> photons { target reflection off refraction on }}

//Water
polygon { 4, <0, 612>, <16*12+12, 612>, <16*12+12, 1020>, <0, 1020> rotate <90,0,0> translate<0,-14,0> material { Wtexture } photons { target reflection off refraction on } }

//Paintings
object { Painting1 translate <22*12+6,12*12,96*12-2> photons { collect off }}
object { Painting2 translate <22*12+58,12*12,96*12-2> photons { collect off }}
object { Painting3 translate <22*12+110,12*12,96*12-2> photons { collect off }}  

//Sign
object { GSign scale <15,15,1> rotate <0,0,90> translate <257,8,1002> texture { T_Chrome_2C } photons { target reflection off refraction on }}
  
//Sculpture
object { Doughnut scale 0.12 rotate <0,0,0> translate <96,40,90*12> texture { T_Chrome_2C } photons { target reflection off refraction on }}
object { cylinder { <0,0,0>, <0,24,0>,10 } translate <96,0,90*12> texture { T_Chrome_2C } photons { target reflection off refraction on }}
  


 
//Trees
#declare txtTree=texture{txtTree_5}
#declare txtLeaf=texture{txtLeaf_1}
#declare Leaf=object{#include "gtleaf8.inc"}    // declares the Leaf object
#declare Tree1=object{#include "gttree8.inc"
}                        

#declare Foliage1=object{#include "gtfoliage8.inc"
        texture{txtLeaf} 
}

#declare sfactor = <3,5,3>;
#declare sfactor2 = <3.2,4,3.2>;                                                      
union{
     object{Tree1 scale sfactor rotate<0,20,0> translate<-2*12,0,101*12>}
     object{Foliage1 scale sfactor rotate<0,20,0> translate<-2*12,0,101*12>}
     photons { collect off }
}

union{
     object{Tree1 scale sfactor2 rotate<0,-50,0> translate<11*12,0,108*12>}
     object{Foliage1 scale sfactor2 rotate<0,-50,0> translate<11*12,0,108*12>}
     photons { collect off }
} 

union{
     object{Tree1 scale sfactor rotate<0,-80,0> translate<24*12,0,106*12>}
     object{Foliage1 scale sfactor rotate<0,-80,0> translate<24*12,0,106*12>}
     photons { collect off }
}  
