#declare r=.02;
#declare e=.007;
#declare sw=.1;
#declare sl=.4;
#declare ss=.2;

#declare paperclip = union {
  cylinder { <sw+r+e,0,sl>,<sw+r+e,0,-ss>, r }
  intersection {
    plane { -z, -sl }
    object { torus { sw+r+e, r } translate sl*z }
  }
  cylinder { <-sw-r-e,0,sl>,<-sw-r-e,0,-sl>, r }
  intersection {
    plane { z, -sl }
    object { torus { sw, r } translate -sl*z-(r+e)*x }
  }
  cylinder { <sw-r-e,0,ss>,<sw-r-e,0,-sl>, r }
  intersection {
    plane { -z, -ss }
    object { torus { sw-r-e, r } translate ss*z}
  }
  cylinder { <-sw+r+e,0,ss>,<-sw+r+e,0,-ss>, r }

  translate r*y

    texture { steel }
}

/* pencil params */
#declare plen=5;
#declare pwid=.3;
#declare ptlen=pwid*2.5;
#declare mlen=.35;
#declare minn=.8;
#declare mout=.98;
#declare elen=.20;
#declare fudge=.1;
#declare stripes=4;

#macro cys(k)
<cos((k*60+30)*pi/180),sin((k*60+30)*pi/180)>
#end

#declare pencil = union {
  difference {
    intersection {
      object {
        prism {
  	  bezier_spline linear_sweep
          0,1.1,24,
          #declare i=0;
          #while (i<6)
	    cys(i),
	    cys(i)   + fudge*cys(i+1.5),
	    cys(i+1) - fudge*cys(i+2.5),
	    cys(i+1)
          #declare i=i+1;
	  #if (i<6)
	  ,
          #end
	  #end
        }
        texture { yellowwood }
      }
      object {
        cone { <0,1,0>, 0, <0,-.1,0>, 1.1*plen/ptlen }
        texture { penciltip }
      }
      scale <pwid/2,plen,pwid/2>
    }
    object {
      text {
        ttf "arialbd.ttf" "STANDARD   2HB" .2,x/10
      }
      translate <0,-.4,.1>
      scale <pwid/2,pwid/2.5,pwid/2.5>
      rotate 180*z
      rotate -90*x
      rotate 90*z
      translate <pwid/2, 1.7, .01>
      rotate 60*y
      texture { darkwood }
    }
  }

  object {
    lathe { /* TODO use an SOR for this? */
      bezier_spline
	stripes*8,
        #declare i=0; 
        #while (i<stripes)
	  <mout,i>,<mout,i+.2>,<minn,i+.3>,<minn,i+.5>,
          <minn,i+.5>,<minn,i+.7>,<mout,i+.7>,<mout,i+.8>
	#declare i=i+1;
	#if (i<stripes)
        ,
	#end
        #end
    }
    scale <pwid/2,-mlen/stripes,pwid/2>
    texture { darksteel }
  }
  object {
    lathe {
      bezier_spline
	4,
	<mout*pwid/2.05,-mlen>,
	<mout*pwid/2.05,-mlen-elen>,
	<mout*pwid/2.05,-mlen-elen>,
	<0,-mlen-elen>
    }
    texture { eraser }
  }
  rotate 90*z
  translate <(plen-mlen-elen)/2,pwid/2,0>
}

object { pencil rotate 105*y translate <7.7,-.9,-.2> }
object { paperclip rotate -30*y translate <8.9,-.9,1.3> }
object { paperclip scale <-1,1,1> rotate 40*y translate <9.5,-.9,2.0> }
object { paperclip scale <-1,1,1> rotate 55*y translate <9.4,-.9,2.9> }
