#declare keyboard=union {

// the keyboard and keyboard bezel

#declare h=.1;
#declare cylr=.5;
#declare cylh=.15;
#declare cyls=.15;
#declare b=.15;

// key shape macro
#macro key_base(length, wwidth)
difference {
  object {
    prism {
      bezier_spline conic_sweep
      1,1-b,16
      <-.45,-.45>,<-.4,-.5>,<.4,-.5>,<.45,-.45>,
      <.45,-.45>,<.5,-.4>,<.5,.4>,<.45,.45>,
      <.45,.45>,<.4,.5>,<-.4,.5>,<-.45,.45>,
      <-.45,.45>,<-.5,.4>,<-.5,-.4>,<-.45,-.45>
    }     
    translate <0,-1,0>
    scale     <1,-h/b,1>

    matrix <1,   0, 0,
            0,   1, .8,
            0,   0, 1,
            0,   0, 0>
  }


  object {
    cylinder {
      <0,0,-1>,<0,0,1>,cylr
    }
    scale <1,cyls,1>
    translate <0,cylh,0>
  }

  scale <length,1,wwidth>

  bounded_by { box { <-length/2,0,-wwidth/2>, <length/2,h,wwidth/2> } }
}
#end

// various sorts of key text placements
// on top
#macro keytext(length, wwidth, s_top, s_adj)
  object {
    text {
      ttf "arialbd.ttf" s_top 1, 0
    }
    rotate 90*x
    scale wwidth*s_adj/3
    translate <.15-length/2,0.1,wwidth*(2-s_adj)/6>
  }
#end
// on top and bottom
#macro keytext2s(length, wwidth, s_top, s_bot, s_adj)
union {
  keytext(length,wwidth,s_top, s_adj)
  object { keytext(length,wwidth,s_bot,1) translate -z*0.45*wwidth }
}
#end
// staggered
#macro keytextstag(length, wwidth, s_top, s_bot,offs)
union {
  object { keytext(length,wwidth,s_top,1) scale <.9,1,1> translate -.03*x }
  object { keytext(length,wwidth,s_bot,1) scale <.6,1,.6> translate <offs,0,-.35*wwidth> }
}
#end
// centered
#macro keytextmid(length,wwidth,s)
object {
  text {
    ttf "arialbd.ttf" s_top 1, 0
  }
  rotate 90*x
  scale wwidth/4
  translate <.12-length/2,0.1,0>
}
#end

// macro to label a key
#macro make_label(kkey, label)
union {
  difference {
    object { kkey }
    object { label }
    texture { t_keyboard }
  }
  intersection {
    object { kkey }
    object { label }
    texture { whitelabel }
  }
}
#end

// key with top text
#macro key(length,wwidth,s_top)
#declare kkey = key_base(length,wwidth)
#declare klabel = keytext(length,wwidth,s_top,1)
make_label(kkey,klabel)
#end

// key with top and bottom text
#macro key2(length,wwidth,s_top,s_bot)
#declare kkey = key_base(length,wwidth)
#declare klabel = keytext2s(length,wwidth,s_top,s_bot,1)
make_label(kkey,klabel)
#end

// key with top and bottom text
#macro key2s(length,wwidth,s_top,s_bot,s_adj)
#declare kkey = key_base(length,wwidth)
#declare klabel = keytext2s(length,wwidth,s_top,s_bot,s_adj)
make_label(kkey,klabel)
#end

// key with top and bottom text, staggered
#macro keystag(length,wwidth,s_top,s_bot,offs)
#declare kkey = key_base(length,wwidth)
#declare klabel = keytextstag(length,wwidth,s_top,s_bot,offs)
make_label(kkey,klabel)
#end

// key with mid text
#macro keymid(length,wwidth,s_top)
#declare kkey = key_base(length,wwidth)
#declare klabel = keytextmid(length,wwidth,s_top)
make_label(kkey,klabel)
#end

// function keys
object { key(2/3,1/2,"Esc") translate <-16/3,-.4,-2.0> }
object { key(2/3,1/2,"F1") translate <-14/3,-.4,-2.0> }
object { key(2/3,1/2,"F2") translate <-12/3,-.4,-2.0> }
object { key(2/3,1/2,"F3") translate <-10/3,-.4,-2.0> }
object { key(2/3,1/2,"F4") translate <-8/3,-.4,-2.0> }
object { key(2/3,1/2,"F5") translate <-6/3,-.4,-2.0> }
object { key(2/3,1/2,"F6") translate <-4/3,-.4,-2.0> }
object { key(2/3,1/2,"F7") translate <-2/3,-.4,-2.0> }
object { key(2/3,1/2,"F8") translate <-0/3,-.4,-2.0> }
object { key(2/3,1/2,"F9") translate <2/3,-.4,-2.0> }
object { key(2/3,1/2,"F10") translate <4/3,-.4,-2.0> }
object { key(2/3,1/2,"F11") translate <6/3,-.4,-2.0> }
object { key(2/3,1/2,"F12") translate <8/3,-.4,-2.0> }
object { keystag(2/3,1/2,"PrtSc","Sys Req",-.05) translate <10/3,-.4,-2.0> }
object { keystag(2/3,1/2,"Pause","Break",.05) translate <12/3,-.4,-2.0> }
object { key_base(2/3,1/2) texture { t_keyboard } translate <14/3,-.4,-2.0> } /* TODO windows */
object { key_base(2/3,1/2) texture { t_keyboard } translate <16/3,-.4,-2.0> } /* TODO menu */

// numerics
// TODO a number of these need tuneups
object { key2(3/4,3/4,"!","1") translate <-20/4,-.4,-2.8> }
object { key2s(3/4,3/4,"@","2",.75) translate <-17/4,-.4,-2.8> }
object { key2(3/4,3/4,"#","3") translate <-14/4,-.4,-2.8> }
object { key2(3/4,3/4,"$","4") translate <-11/4,-.4,-2.8> }
object { key2s(3/4,3/4,"%","5",.8) translate <-8/4,-.4,-2.8> }
object { make_label(key_base(3/4,3/4), // [6 ^] key
  union {
    object { prism {
      -.1,.2,7,
	  <-.25,.12>,<-.17,.25>,<-.09,.12>,
	  <-.12,.12>,<-.17,.21>,<-.22,.12>,
	  <-.25,.12>
	  } translate .03 * z }
    object { keytext(3/4,3/4,"6",1) translate -z*0.45*3/4 }    
  })
  translate <-5/4,-.4,-2.8>
}
object { key2s(3/4,3/4,"&","7",.85) translate <-2/4,-.4,-2.8> }
object { make_label(key_base(3/4,3/4), // [8 *] key
  union {
    union {
      object { box { <-.01,-.1,-.08>, <.01,.1,.08> } }
      object { box { <-.01,-.1,-.08>, <.01,.1,.08> } rotate 60*y }
      object { box { <-.01,-.1,-.08>, <.01,.1,.08> } rotate 120*y }
      translate <-.17,0,.20>
    }
    object { keytext(3/4,3/4,"8",1) translate -z*0.45*3/4 }    
  })
  translate <1/4,-.4,-2.8>
}
object { key2s(3/4,3/4,"(","9",.9) translate <4/4,-.4,-2.8> }
object { key2s(3/4,3/4,")","0",.9) translate <7/4,-.4,-2.8> }
object { make_label(key_base(3/4,3/4),
union {
  object { keytext(3/4,3/4,"_",1) translate <.02,0,.1> }
  object { keytext(3/4,3/4,"-",1) translate -z*0.45*3/4 }
}) translate <10/4,-.4,-2.8> }
object { key2(3/4,3/4,"+","=") translate <13/4,-.4,-2.8> }
object { // backspace key
#declare bksp=union {
    object {
      text {
        ttf "arialbd.ttf" "Bk Sp" 1, 0
      }
      rotate 90*x
      scale 1/6
      translate <-1/8,0.1,0>
    }
    object { prism {
      -.1,.2,8,
	<.1,.1>,<-.1,.1>,<-.1,.14>,<-.2,.09>,
	<-.1,.04>,<-.1,.08>,<.1,.08>,<.1,.1>
	}
    translate <-.25,0,-.045>
    }
}

  make_label(key_base(5/4,3/4),bksp)
  translate <17/4,-.4,-2.8>
}

object { keymid(2/3,3/4,"Home") translate <16/3,-.4,-2.8> }

// QWERTY row
/* tab */
object {
#declare tab_arrow=prism {
   0,.2,13,
     <.24,.3>,<-.1,.3>,<-.1,.34>,<-.2,.29>,
     <-.1,.24>,<-.1,.28>,<.24,.28>,<.24,.3>,

     <-.2,.34>,<-.22,.34>,<-.22,.24>,<-.2,.24>,<-.2,.34>
}
 make_label(
   key_base(3/4,3/4),
   union{object{tab_arrow translate -.05*z}
         object{tab_arrow scale <-1,1,-1> translate .2*z }}
 )
 translate <-21.5/4,-.4,-3.55>
}
object { key(3/4,3/4,"Q") translate <-18.5/4,-.4,-3.55> }
object { key(3/4,3/4,"W") translate <-15.5/4,-.4,-3.55> }
object { key(3/4,3/4,"E") translate <-12.5/4,-.4,-3.55> }
object { key(3/4,3/4,"R") translate <-9.5/4,-.4,-3.55> }
object { key(3/4,3/4,"T") translate <-6.5/4,-.4,-3.55> }
object { key(3/4,3/4,"Y") translate <-3.5/4,-.4,-3.55> }
object { key(3/4,3/4,"U") translate <-0.5/4,-.4,-3.55> }
object { key(3/4,3/4,"I") translate <2.5/4,-.4,-3.55> }
object { key(3/4,3/4,"O") translate <5.5/4,-.4,-3.55> }
object { key(3/4,3/4,"P") translate <8.5/4,-.4,-3.55> }
object { key2(3/4,3/4,"{","[") translate <11.5/4,-.4,-3.55> }
object { key2(3/4,3/4,"}","]") translate <14.5/4,-.4,-3.55> }
object { make_label(key_base(3.5/4,3/4), // [\ |] key
    object { prism {
      -.2,.2,15,
        <-.26,.19>,<-.26,.29>,<-.23,.29>,<-.23,.19>,<-.26,.19>,
        <-.26,.07>,<-.26,.17>,<-.23,.17>,<-.23,.07>,<-.26,.07>,
	<-.31,-.04>,<-.27,-.04>,<-.16,-.22>,<-.20,-.22>,<-.31,-.04>
    } }
  )
  translate <17.75/4,-.4,-3.55>
}
object { keymid(2/3,3/4,"PgUp") translate <16/3,-.4,-3.55> }

// asdf row
object { key2(4/4,3/4,"Caps","Lock") translate <-21/4,-.4,-4.3> } // TODO? shoddy, probably invis
object { key(3/4,3/4,"A") translate <-17.5/4,-.4,-4.3> }
object { key(3/4,3/4,"S") translate <-14.5/4,-.4,-4.3> }
object { key(3/4,3/4,"D") translate <-11.5/4,-.4,-4.3> }
object { key(3/4,3/4,"F") translate <-8.5/4,-.4,-4.3> }
object { key(3/4,3/4,"G") translate <-5.5/4,-.4,-4.3> }
object { key(3/4,3/4,"H") translate <-2.5/4,-.4,-4.3> }
object { key(3/4,3/4,"J") translate <0.5/4,-.4,-4.3> }
object { key(3/4,3/4,"K") translate <3.5/4,-.4,-4.3> }
object { key(3/4,3/4,"L") translate <6.5/4,-.4,-4.3> }
object { key2(3/4,3/4,":",";") translate <9.5/4,-.4,-4.3> }
object { key2(3/4,3/4,"\"","'") translate <12.5/4,-.4,-4.3> }
object { keymid(5.5/4,3/4,"Enter") translate <16.75/4,-.4,-4.3> } // TODO? shoddy, probably invis
object { keymid(2/3,3/4,"PgDn") translate <16/3,-.4,-4.3> }
// if i need any more, I'll make them

#declare taperb=.03;
#declare errb=.05;
#declare deepb=.15;
#declare vw=1.58; // vent width

// bezel
difference {
  object {
    prism {
      bezier_spline
      -.6,-.3,32
        <-6,-.15>,<-6,-2>,<-6,-4>,<-6,-7>,
        <-6,-7>,<-6,-7.05>,<-5.95,-7.1>,<-5.9,-7.1>,
        <-5.9,-7.1>,<-2,-7.1>,<0,-7.1>,<2,-7.1>,
        <2,-7.1>,<2.2,-7.1>,<2.3,-7.5>,<2.5,-7.5>,
        <2.5,-7.5>,<4,-7.5>,<5,-7.5>,<5.9,-7.5>,
        <5.9,-7.5>,<5.95,-7.5>,<6,-7.45>,<6,-7.4>,
        <6,-7.4>,<6,-4>,<6,-2>,<6,-.15>,
        <6,-.15>,<2,-.15>,<-2,-.15>,<-6,-.15>
    }
  }

#declare o=5;

  object {
    prism {
      bezier_spline conic_sweep
      1+errb,1-taperb,32
        <-6,o-vw>,<-6,o-vw-1>,<-6,o-4>,<-6,o-7>,
        <-6,o-7>,<-6,o-7.05>,<-5.95,o-7.1>,<-5.9,o-7.1>,
        <-5.9,o-7.1>,<-2,o-7.1>,<0,o-7.1>,<2,o-7.1>,
        <2,o-7.1>,<2.2,o-7.1>,<2.3,o-7.5>,<2.5,o-7.5>,
        <2.5,o-7.5>,<4,o-7.5>,<5,o-7.5>,<5.9,o-7.5>,
        <5.9,o-7.5>,<5.95,o-7.5>,<6,o-7.45>,<6,o-7.4>,
        <6,o-7.4>,<6,o-4>,<6,o-vw-1>,<6,o-vw>,
        <6,o-vw>,<2,o-vw>,<-2,o-vw>,<-6,o-vw>
    }
    translate -o*z-y
    scale <1,deepb/taperb,1>
    translate -.3*y
  }

#declare vb=0.03; // vent border
  box { <2*vb-6,-.4,vb-vw>, <6-2*vb,-.2,-0.15-vb> }

  texture {blackplastic}
}

// TODO: vent, mediakeys, little pieces of plastic in the troughs

#declare voff=-vw/2;
#declare routmedia=3/8;
#declare boxmedia=2.8-routmedia;

// the vent itself
difference {
  box { <2*vb-6,-.4,vb-vw>, <6-2*vb,-.31,-0.15-vb> }
  box { <-boxmedia,-1,voff-routmedia>, <boxmedia,1,voff+routmedia> }
  cylinder { <-boxmedia,-1,voff>, <-boxmedia,1,voff>, routmedia }
  cylinder { < boxmedia,-1,voff>, < boxmedia,1,voff>, routmedia }	
  texture { venttexture }
}

#declare rmedia=.25;
#declare rinmedia=.20;
#declare hmedia=.03;
#macro cono(inradius, outradius, height, llen)
#declare border=outradius-inradius;
#declare nlen = sqrt (height*height + border*border);
intersection {
  union { cone { (-llen/2+outradius)*x-height*y, outradius,
                 (-llen/2+outradius)*x         , inradius }
          cone { ( llen/2-outradius)*x-height*y, outradius,
                 ( llen/2-outradius)*x         , inradius } 
          box { <-llen/2+outradius,-height,-outradius>,<llen/2-outradius,0,outradius> }
  }
  plane { (z*height + y*border) / nlen, height * inradius / nlen }
  plane { (-z*height + y*border) / nlen, height * inradius / nlen }
  bounded_by { box { <-llen,-height,-outradius>, <llen, 0, outradius> } }
}
#end

// power button 
difference {
  cono(rinmedia,rmedia,hmedia,1)
  cylinder { 0, .18*z, .015}
  difference {
    torus { .1, .015 }
    box { <-.02,-1,0>, <.02,1,1> } 
  }
  translate (<-boxmedia-rmedia+1/2,-.3,voff>)
  texture {shinyplastic}
}

// other buttons
difference {
  cono(rinmedia,rmedia,hmedia,4)
  box { <-1.01,-1,-1> <-0.99,1,1> }
  box { <-0.01,-1,-1> < 0.01,1,1> }
  box { < 0.99,-1,-1> < 1.01,1,1> }

#declare sqp=object { prism {
      .9,1.1,5,
      <-1,-1>, <-1,1>, <1,1>, <1,-1>, <-1,-1>
  } translate -1*y scale .1 }

#declare trip=object {
    prism {
      linear_spline conic_sweep
	.9,1.1,4,
	<-1,1>,<-1,-1>,<1,0>,<-1,1>
    }
    translate -1*y
    scale .1
  }

  // stop
  object { sqp translate 1.5*x }

  // fast-forward
#declare ffp=union {
    object {
      sqp
      scale <.25,1,1>
      translate .2*x
    }
    object {trip translate .075*x}
    object {trip translate -.125*x}
  }
  object { ffp translate -.5*x }

  // rewind
  object { ffp scale <-1,1,1> translate -1.47*x }

  // play/pause
  object { trip translate .35*x }
  object { sqp matrix <.2,0,0,0,1,0,.2,0,1,.5,0,0> }
  object { sqp scale <.4,1,1> translate .6*x }
  object { sqp scale <.4,1,1> translate .7*x }

  translate <boxmedia+rmedia-2,-.3,voff>
  texture {shinyplastic}
}

// media bezel 
difference {
  union {
    cylinder { <-boxmedia,-.35,voff>, <-boxmedia,-.3,voff>, routmedia }
    cylinder { < boxmedia,-.35,voff>, < boxmedia,-.3,voff>, routmedia }
    box { <-boxmedia,-.35,voff-routmedia>, <boxmedia,-.3,voff+routmedia> }
  }
  object {  cono (rmedia, routmedia, .04, 2*(boxmedia+routmedia)) scale <1,-1,1> translate <0,-.33,voff>}
  
  texture { shinyblackplastic }
}

}
