#include "metals.inc"

#declare fov=.693;

camera {
  location <.3, 7, -18.1>
  up fov*y
  right fov*x*4/3
  look_at <0, 4.4, 0>
}

//#declare soft_shadows=1;
//#declare fancy_screen=1;
#declare fancywood=2;

light_source {
	<50, 24, -70>
	color rgb <.9,.75,.5>
#ifdef ( soft_shadows )
	area_light 10*x, 10*y,25,25
	circular orient
	adaptive 1
#end
}

light_source {
	<-100, 60, -30>
	color rgb <.8,.9,.9>
#ifdef ( soft_shadows )
	area_light 5*z, 10*y,10,10
	adaptive 1
#end
}

light_source {
	<48, 100, -10>
	color rgb <.8,.6,.5>
#ifdef ( soft_shadows )
	area_light 10*z, 10*y,10,10
	circular orient
	adaptive 1
#end
}

#include "textures.pov"

#include "shinybezel.pov"
#include "key.pov"
#declare laptop = union {
#include "screenbezel.pov"
object { screenbezel rotate 10*x }

  // the screen hinges
  #declare screenhinge=union {
    cylinder { <-.5,0,0>, <.5,0,0>, .15 texture { blackplastic } }
    box { <-.5,-.3,-.15>, <.5,0,.15> texture { blackplastic } }
    cylinder { <-.7,0,0>, <.7,0,0>, .05 texture { T_Chrome_3C} }
    translate <-4.95,0,0>
  }

  object { screenhinge }
  object { screenhinge scale <-1,1,1> }

  object { shinybezel texture { shinyplastic } }

  object { keyboard }
}
object { laptop rotate -1*y }

// TODO: get rid of sky sphere
sky_sphere { S_Cloud5 }

// table
// TODO better table
union {
  box { <-30,-2.3,-20>, <30, -.9, 3.5> }
  cylinder { <-30, -2.4, 3.5>, <30, -2.4, 3.5>, 1.5 }
  texture { tabletop }
}

// wall
object {
  plane { -z, -6 }
  texture { paint }
}
#include "poster.pov"
object {
  poster
  translate <-1.5, 20, 5.98>
}

#include "detritus.pov"
