
#declare brandname = object {
  text { ttf "arialbd.ttf" "POVSHIBA" 1,0 }
  scale .3
  translate <-.7,.3,-.2>
  bounded_by { box { <-2,0,-1>,<2,1,1> } }
}

#declare screenbezel=union {
  #declare bbwid=.8;

  // screen image
  object {
    box { <-6,bbwid,0>, <6,9+bbwid,.1> }
    texture {
      pigment {
        image_map { png "screen.png" 
#ifdef (fancy_screen)
interpolate 2
#end
}
        scale <12,9,1>
        translate <-6,bbwid,1>
      }
      finish { ambient 1 diffuse 0 specular 0 }
    }
/*    texture {
      pigment { color rgbt 1 }
      finish { ambient 0 diffuse 0 specular .1 roughness .2 /* reflection { .05, .3 } */}
    } */
    no_shadow
  }
#ifdef (fancy_screen)
  // screen smudge layer
  object {
    box { <-6,bbwid,-.02>, <6,9+bbwid,.02> }
    texture { smudges }
    no_shadow
  }
#end

  // screen illumination
#ifdef (soft_shadows)
  light_source {
    <0,4.5+bbwid,.025>
    color rgb .5
    area_light 10*x, 4.5*y,24,20
    adaptive 1
  }
  object { // filter for light to go through
    box { <-6,bbwid,0>, <6,9+bbwid,.1> }
    texture {
      pigment {
        image_map { png "check.png" filter all 1 }
        scale <12,9,1>
        translate <-6,bbwid,1>
      }
    }
    no_image
    no_reflection
  }
#end

  // screen backstop
  object {
    box { <-6,bbwid,.1>, <6,9+bbwid,.25> }
    texture { pigment { color rgb 0 } }
  }

  // oval rubber pad
#declare ovalrubberpad = union {
    cylinder {-.2*x,.2*x,.07}
    sphere { -.2*x, .07 }
    sphere { .2*x, .07 }
    scale <1,1,.13>
  }
  object { ovalrubberpad translate <-5,9.3+bbwid,-.05> texture { blackrubber } }
  object { ovalrubberpad translate < 5,9.3+bbwid,-.05> texture { blackrubber } }

#declare roundrubberpad = object { sphere { 0,.09 } scale <1,1,.1> }
  object { roundrubberpad translate <-1.5,9.3+bbwid,-.05> texture { blackrubber } }
  object { roundrubberpad translate < 1.5,9.3+bbwid,-.05> texture { blackrubber } }

  // screen bezel bottom thickness
  #declare bbbot=-.25;

  // bezel
  // the top part of the bezel
  difference {
    object {
      prism {
	bezier_spline
	  -0.25,.05,24,
          <6.5,9+bbwid>,<6.5,9.05+bbwid>,<6.5,9.15+bbwid>,<6.5,9.2+bbwid>, // right edge
	  <6.5,9.2+bbwid>,<6.5,9.4+bbwid>,<6.4,9.45+bbwid>,<6.2,9.5+bbwid>, // top right
	  <6.2,9.5+bbwid>,<2,9.6+bbwid>,<-2,9.6+bbwid>,<-6.2,9.5+bbwid>, // top edge
	  <-6.2,9.5+bbwid>,<-6.4,9.45+bbwid>,<-6.5,9.4+bbwid>,<-6.5,9.2+bbwid>, // top left
	  <-6.5,9.2+bbwid>,<-6.5,9.15+bbwid>,<-6.5,9.05+bbwid>,<-6.5,9+bbwid>, // left edge
	  <-6.5,9+bbwid>,<-2,9+bbwid>,<2,9+bbwid>,<6.5,9+bbwid>
      }
      rotate -90*x
      texture { blackplastic_smudgy_x }      
    }

    // recesses for the pads
    object { ovalrubberpad scale <1.13,1.4,1>
	       translate <-5,9.3+bbwid,-.05> texture { blackplastic }}
    object { ovalrubberpad scale <1.13,1.4,1>
	       translate < 5,9.3+bbwid,-.05> texture { blackplastic }}
    object { cylinder { <-1.5,9.3+bbwid,-.06>, <-1.5,9.3+bbwid,-.04>, .1 }
    texture { blackplastic }}
    object { cylinder { < 1.5,9.3+bbwid,-.06>, < 1.5,9.3+bbwid,-.04>, .1 }
    texture { blackplastic }}

    // hole for hook
    box { <.2,9.26+bbwid,-.09>, <.8,9.38+bbwid,.1> texture { shinyblackplastic }}

    bounded_by { box { <-6.5,9+bbwid,-.05>, <6.5,9.6+bbwid,.25> } }
  }
  box { <-6.5,bbwid,-.05>, <-6.0,9+bbwid,.25> texture { blackplastic_smudgy_y }}
  box { < 6.0,bbwid,-.05>, < 6.5,9+bbwid,.25> texture { blackplastic_smudgy_y }}

  // bottom edge
  difference {
    intersection {
      object {
        prism {
	  -0.25,.05,8,
	  <-6.3,bbbot>,<6.3,bbbot>,<6.3,bbbot>,<6.5,bbbot+.2>,<6.5,bbwid>,
	  <-6.5,bbwid>,<-6.5,bbbot+.2>,<-6.3,bbbot> // bottom left
        }
        rotate -90*x
      }
      // round the bottom edge
      union {
        box { <-6.5,bbbot+.1,-.1>,<6.5,9.6+bbwid,.3> }
        object { cylinder { <-6.5,0,0>,<6.5,0,0>,.1 }
                 scale <1,1,1.5> translate <0,bbbot+.1,.10> }
      }
      texture { blackplastic_smudgy_x }
    }

    box { <-5.5,-2,-1>, <-4.4,0.2,1> texture { blackplastic }} // screen hinge left
    box { < 4.4,-2,-1>, < 5.5,0.2,1> texture { blackplastic }} // screen hinge right

    // little circular dohickies on the bottom corners
    object { torus { .2,.01 } 
             rotate 90*x translate < 6.1,.17,-.05>
	     texture { blackplastic } }
    object { torus { .2,.01 } 
             rotate 90*x translate <-6.1,.17,-.05>
	     texture { blackplastic } }

    object { brandname texture { blackplastic }}

    bounded_by { box { <-6.5,bbbot,-.05>, <6.5,bbwid,.25> }}
  }

  // this is some sort of squarish thing on the mid side of the laptop
#declare dinkysidething=object { superellipsoid {<.3,.2>} scale <.02,.2,.02> translate <6.3,5,-.05> texture { blackplastic }}
  object { dinkysidething }
  object { dinkysidething scale <-1,1,1> }
   
  // hook
  object {
    prism { // the hook itself
      bezier_spline conic_sweep
	0.94,1,20,
	<0,.1>,<.05,.1>,<.15,.1>,<.2,.1>,
	<.2,.1>,<.2,-.1>,<.2,-.3>,<.2,-.5>,
	<.2,-.5>,<.2,-.6>,<0,-.6>,<-.2,-.3>,
	<-.2,-.3>,<-.15,-.25>,<-.1,-.25>,<-.05,-.25>,
	<-.05,-.25>,<0,-.25>,<0,-.1>,<0,.1>
    }
    translate <.21,9.27-.93+bbwid,0>
    texture { shinyblackplastic }
  }

  // little plastic thingies above the hook
#declare littleplasticthingie=object {
    superellipsoid {<.3,.5>} scale <.02,.1,.1> translate <0,9.53+bbwid,.06> texture {shinyplastic} }
  object { littleplasticthingie translate -.60*x }
  object { littleplasticthingie translate -.48*x }
  object { littleplasticthingie translate -.36*x }
  object { littleplasticthingie translate -.24*x }
  object { littleplasticthingie translate -.12*x }
  object { littleplasticthingie translate -.00*x }
  object { littleplasticthingie translate  .12*x }
  object { littleplasticthingie translate  .24*x }
  object { littleplasticthingie translate  .36*x }

  intersection {
    object { brandname }
    box { <-2,0,-0.04>,<2,1,0> }
    texture { T_Chrome_2A }
  }
}

