#include "colors.inc"
#include "skies.inc"
#include "woods.inc"

#declare blackplastic=texture {
  pigment { rgb 0 } finish { diffuse .25 roughness .14 specular .1 ambient .1 }
}

// smudgy textures
#declare blackplastic_smudgy_x_nocrud=texture {
  bozo turbulence .3 scale <3,.2,.2>
  texture_map {
    [ 0  blackplastic ]
    [ .8 blackplastic ]
    [ 1 pigment { rgb 0 } finish { diffuse .2 roughness .05 specular .3 ambient .1 } ]
  }
}
#declare blackplastic_smudgy_x=texture {
  granite scale .45
  texture_map {
    [ 0 pigment { rgb .5 } finish { diffuse .3 roughness .3 specular 0 ambient .1 } ]
    [ .14 blackplastic_smudgy_x_nocrud ]
    [ 1 blackplastic_smudgy_x_nocrud ]
  }
}

#declare blackplastic_smudgy_y_nocrud=texture {
  bozo turbulence .3 scale <.2,3,.2>
  texture_map {
    [ 0  blackplastic ]
    [ .8 blackplastic ]
    [ 1 pigment { rgb 0 } finish { diffuse .3 roughness .05 specular .3 ambient .1 } ]
  }
}
#declare blackplastic_smudgy_y=texture {
  granite scale .45
  texture_map {
    [ 0 pigment { rgb .5 } finish { diffuse .2 roughness .3 specular 0 ambient .1 } ]
    [ .14 blackplastic_smudgy_y_nocrud ]
    [ 1 blackplastic_smudgy_y_nocrud ]
  }
}

#declare t_keyboard = texture {
  cylindrical scale .6
  texture_map {
    [0 pigment { rgb 0 } finish { diffuse .3 roughness .14 specular .1 ambient .1 } ]
    [1 pigment { rgb 0 } finish { diffuse .2 roughness .05 specular .3 ambient .1 } ]
  }
}

#declare smudges_nocrud = texture {
  bozo turbulence .3 scale <5,.4,.4>
  texture_map {
    [ 0 pigment {rgbt 1} ]
    [ .75 pigment { rgbt 1 } ]
    [ .8 pigment { rgbt <.6,.6,.6,.9> } finish { diffuse .05 roughness .2 } ]
    [ 1 pigment  { rgbt <.6,.6,.6,.9> } finish { diffuse .05 roughness .2 } ]
  }
}

#declare smudges=texture {
  granite scale .45
  texture_map {
   [ 0 pigment { rgbt <.6,.6,.6,.4> } finish { diffuse .1 roughness .3 specular 0 ambient .3 } ]
   [ .13 smudges_nocrud ]
   [ 1  smudges_nocrud ]
  }

}
#declare shinyblackplastic=texture {
  pigment { color rgb 0 }
  finish { diffuse .3 roughness .05 specular .4 ambient .1 reflection .1}
}
#declare blackrubber=texture {
  pigment { color rgb .07 }
  finish { diffuse .42 roughness .06 specular .15 ambient .1 }
}
#declare shinyplastic=texture {
  pigment { bozo scale .05 color_map { [0.0 color rgb .7] [1 rgb .6] } }
  finish { diffuse .3 specular .3 roughness .2 ambient .05}
}

#declare whitelabel = texture { pigment { color rgb .8 } }

// the vent has a lot of crud in it
#declare vent_nocrud = texture {
    hexagon // should be circular, but who gives...
	texture { pigment { color rgb 0 } }
	texture { blackplastic }
	texture { blackplastic }
    scale 0.05
  }
#declare venttexture = texture {
  granite scale .45
  texture_map {
   [ 0 pigment { rgb .6 } finish { diffuse .1 roughness .3 specular 0 ambient .3 } ]
   [ .16 vent_nocrud ]
   [ 1  vent_nocrud ]
  }
}

#declare paint = texture { 
  pigment { color rgb .9 } finish { diffuse .5 ambient .2 roughness .2 }
  normal { granite .03 }
}

/* for paper clip */

#declare steel = texture {
  bozo scale .3*<.1,.02,.4>
  texture_map {
    [ 0 T_Chrome_1B ]
    [ 1 T_Chrome_4D ]
  }
}

/* table texture */

#switch (fancywood)
#case (2)
#declare ttt = texture { T_Wood1 scale .1
  finish { diffuse .2 specular .5 roughness .03 brilliance .2 ambient .01 } }

#declare www = texture { pigment { color <.40, .20, .20> }
  finish { diffuse .2 specular .5 roughness .03 brilliance .2 ambient .01 } }

#declare tabletop = texture {
  gradient z scale -10 turbulence .001
  texture_map {
    [ .000 ttt rotate 90 * y ]
    [ .200 ttt rotate 90 * y ]
    [ .2001 www ]
    [ .2009 www ]
    [ .201 ttt rotate 45 * y translate -z ]
    [ .350 ttt rotate 45 * y translate -z ]
    [ .3501 www ]
    [ .3509 www ]
    [ .351 ttt rotate -45 * y translate -2*z ]
    [ .500 ttt rotate -45 * y translate -2*z ]
    [ .5001 www ]
    [ .5009 www ]
    [ .501 ttt rotate -90 * y translate -3*z ]
    [ 1 ttt rotate -90 * y translate -3*z ]
  }
  translate 3.5
}

#break
#case (1)

#declare tabletop = texture {T_Wood1 scale .1
  finish { diffuse .2 specular .5 roughness .03 brilliance .2 ambient .01 } }

#break
#else

#declare tabletop = texture { pigment { color rgb <.6,.3,.3> }
  finish { diffuse .2 specular .5 roughness .03 brilliance .2 ambient .01 } }

#end

/* pencil textures */

#declare graphite = texture {
  pigment { color rgb .35 }
  finish { ambient 0 diffuse .2 specular .2 roughness .1 }
}
#declare bzw=texture {
  bozo scale .2
  texture_map {
    [ 0.0 T_Wood10 ]
    [ 0.8 T_Wood10 ]
    [ 1.0 graphite ]
  }
}
#declare penciltip = texture {
  cylindrical
  warp { turbulence .25 lambda 4 }
  texture_map {
    [ 0.000 bzw ]
    [ 0.550 bzw ]
    [ 0.600 graphite ]
    [ 1.000 graphite ]
  }
}

#declare yellowwood = texture {
  pigment { color rgb < .9, .8, .1 > }
  finish { ambient .1 diffuse .5 specular .1 roughness .1 }
  normal { granite .3 scale .3}
}

#declare darkwood = texture {
  pigment { color rgb .2 }
  finish { ambient .1 diffuse .2 specular .3 roughness .1 }
  normal { granite .3 scale .3}
}

#declare eraser = texture {
  pigment {
    bozo scale .15
    pigment_map {
      [0 color rgb < .9, .6, .6 > ]
      [0.5 color rgb < .9, .6, .6 > ]
      [0.8 color rgb .1 ]
      [1 color rgb .1 ]
    }
  }
  finish { ambient .1 diffuse .6 roughness .3 }
}

#declare darksteel = texture {
  bozo scale .3*<.1,.02,.4>
  texture_map {
    [ 0 T_Chrome_1A ]
    [ 1 T_Chrome_2B ]
  }
}
