/*-------------------------------------------------------*/
/*-- bdawn.pov                                         --*/
/*-- "Before Dawn"                                     --*/
/*-- for POVRay 3.6                                    --*/
/*--                                                   --*/
/*-- 27-Aug-2005 Henrik Fisch                          --*/
/*-------------------------------------------------------*/

#include "colors.inc"
 
global_settings {
  max_trace_level 10
  
  photons {
    count 10000000
    autostop 0
    jitter .4
  }
}
 
// Camera
camera {
   perspective
   up <0,1,0>
   right x*image_width/image_height
   location <0,0.2,-5>
   look_at <0,0.2,0>
   angle 80
}

// Light
light_source {
   <-0.5,1,30>
   color rgb <1,1,1>*3.0
   photons {
      refraction on
      reflection on
   }
}
 
// Background
sphere {
   <0,0,0>, 1
   pigment {
      gradient y
      color_map {
         [0.0  color White]
         [0.08 color Black]
         [1.0  color Black]
      }
   }
   finish  { ambient 1.0 }
   hollow
   
   scale <1000,1000,1000>
}

// Floor
plane {
   y, 0
   pigment { color White }
   finish  { ambient 0.3 }
}

// Sphere with Edge
difference {
   sphere { <0,0,0>, 0.5 }
   box    { <0,-1,0>, <1,1,1> }

   pigment { color rgbf <1.0,0.4,0.4,1.0> }
   finish{
      specular 0.6 roughness 0.003
      diffuse 1.0 ambient 0.0
      reflection { 0.1, 0.3 }
   }
   interior {
      ior 1.3
   }
   photons {
      target
      refraction on
      reflection on
      collect off
   }

   rotate    <-90,180,-45>
   translate <1.3,0.5,-2.5>
}
   
// Edge of Sphere
intersection {
   sphere { <0,0,0>, 0.5 }
   box    { <0,-1,0>, <1,1,1> }

   pigment { color rgbf <1.0,0.4,0.4,1.0> }
   finish{
      specular 0.6 roughness 0.003
      diffuse 1.0 ambient 0.0
      reflection { 0.1, 0.3 }
   }
   interior {
      ior 1.3
   }
   photons {
      target
      refraction on
      reflection on
      collect off
   }

   rotate    <-90,194,0>
   translate <-0,0.001,-3.9>
}
   
// Cylinder
cylinder {
   <0,0,0>, <0,1,0>, 0.5
   pigment { color rgbf <0.4,0.4,1.0,1.0>  }
   finish{
      specular 0.6 roughness 0.003
      diffuse 1.0 ambient 0.0
      reflection { 0.1, 0.3 }
   }
   interior {
      ior 1.3
   }
   rotate <90,19,0>
   translate <-5.8,0.5,3>
}
   
// Box
box {
   <0,0,0>, <1,1,1>
   pigment { color rgbf <0.4,1.0,0.4,1.0>  }
   finish{
      specular 0.6 roughness 0.003
      diffuse 1.0 ambient 0.0
      reflection { 0.1, 0.3 }
   }
   interior {
      ior 1.3
   }
   rotate <0,23,0>
   translate <2.2,0,10>
}
