/**
 * file: Prime.pov
 *
 * copyright 2005 Brett Dickson
 */

#version 3.6;

global_settings {
    ambient_light 0
    max_trace_level 5
    assumed_gamma 1.2
}


camera {
    location <0, 250, -500>
    look_at <0, 0, 0>
        
    focal_point <0, 0, 0>
    aperture 9
    blur_samples 150
    confidence 0.9
    variance 0.0001
}


background { color rgb<0, 0, 0> }


plane {
    y, 0
    
    pigment{ rgb<1, 1, 1> }
    
    finish {
        ambient 0
    }
}

#declare LSeed = seed(77);

#declare LRadius = 9;
#declare LFalloff = 11;
#declare LDiff = 17;

#macro LightPath(path, step, length)
    #local cur_length = 0;
    
    union {
        #while (cur_length <= length)
            union {
                light_source { 
                    <0, 100, 0>, 
                    color rgb<1, 0, 0>
                    
                    spotlight
                    point_at <rand(LSeed) * LDiff, 0, rand(LSeed) * LDiff>
                    radius LRadius
                    falloff LFalloff
                }
                
                light_source { 
                    <0, 100, 0>, 
                    color rgb<0, 1, 0>
                    
                    spotlight
                    point_at <rand(LSeed) * LDiff, 0, rand(LSeed) * LDiff>
                    radius LRadius
                    falloff LFalloff
                }
                
                light_source { 
                    <0, 100, 0>, 
                    color rgb<0, 0, 1>
                    
                    spotlight
                    point_at <rand(LSeed) * LDiff, 0, rand(LSeed) * LDiff>
                    radius LRadius
                    falloff LFalloff
                }
                
                translate path * cur_length
            }

            #local cur_length = (cur_length + step);
        #end
    }
#end

object { 
    LightPath(x, 100, 2500) 
    
    translate x*-300
    rotate y*-50
}
