#include "paint.inc"


#declare BackWall = plane
        {
        
        -z, 0
        
        texture
                {
                BackPaint
                }
                
        }        


#declare ColumnPair = union
        {
        
        #local ColumnThird = superellipsoid
                {

                <2/13, 2/20>
                translate 1
                
                scale <13, 20, 16> / 2
                
                translate <8, 2, -16> // til appropriate plass iht brett (floor synker 2 ned, dvs <0, -2, -64>) 
                
                texture
                        {
                        LightPaint
                        }
                                
                }
                
        object
                {
                ColumnThird
                translate <0, 0, -48>
                }
        object
                {
                ColumnThird
                translate <0, 0, 0>
                }
                
        object
                {
                ColumnThird
                translate <0, 20, -48>
                }
        object
                {
                ColumnThird
                translate <0, 20, 0>
                }
                
        object
                {
                ColumnThird
                translate <0, 40, -48>
                }
        object
                {
                ColumnThird
                translate <0, 40, 0>
                }
                
        }



#declare Floor = superellipsoid
        {

        <2/32, 2/64>
        translate 1

        scale <32, 4, 64> / 2
        translate <0, -2, -64>
        texture {
                LightPaint
                }
                
        }

#declare Debris = prism   // prince m st mellom, z(27~37)
        {
        
        //
        //  3 4 5
        //
        //  1  2
        //

        0, 3,   // hyde

        5 * 5 + 24 * 4 + 2,   // kanter+1 for hvert flak + rand * 3+1 + ekstra

        <0,1>,          <13,1>,         <12,24>,        <1,27>,         <0,1>,

        <18,0>,         <28,2>,         <28,20>,        <19,18>,        <18,0>,
        
        <1,38>,         <9,37>,         <7,56>,         <0, 54>,        <1,38>,
        
        <10,46>,        <16,44>,        <16,60>,        <11,58>,        <10,46>,
        
        <19,37>,        <29,39>,        <27,56>,        <20,56>,        <19,37>,
        
        #local Arthur = seed (38415);
        #local big = 4;
        #local index = 0;
        #while (index < 24)

                #local base = <big,big> + <rand(Arthur) * (27 - big * 2), rand(Arthur) * (32 - big * 2)>;
                #if(rand(Arthur) < .5)
                        #local base = base + <0, 37>;
                        #end
                #local rotation = rand(Arthur) * 2 * pi;
                #local p_a = big * <cos(rotation + pi * 0/3), sin(rotation + pi * 0/3)> * (rand(Arthur) * .6 + .4);
                #local p_b = big * <cos(rotation + pi * 2/3), sin(rotation + pi * 2/3)> * (rand(Arthur) * .6 + .4);
                #local p_c = big * <cos(rotation + pi * 4/3), sin(rotation + pi * 4/3)> * (rand(Arthur) * .6 + .4);

                base + p_a, base + p_b, base + p_c, base + p_a,
                
                #local index = index + 1;
                
                #end
                
        <0, 0>, <0, 0>                 
        
        translate <0, 2, -64>
        
        texture {       LightPaint      }
        
        }
        

/*******        _VEGGER_        *******/


#declare Clip = box             // kutt til en frame
        {
        <-.001, -2.001, -65>, <32.001, 62.001, 1>
        }


#macro LightBrick (grosse, plassierung)

        intersection
                {
                
                superellipsoid
                        {
                        <2/grosse.x, 2/grosse.z>
                        translate 1
                        scale grosse / 2
                        translate plassierung
                        }
                        
                object  {
                        Clip
                        }

                texture
                        {
                        LightPaint
                        }

                }
                
        #end        
        
#macro DarkBrick (grosse, plassierung)

        intersection
                {
                
                superellipsoid
                        {
                        <2/grosse.x, 2/grosse.z>
                        translate 1
                        scale grosse / 2
                        translate plassierung
                        }
                        
                object  {
                        Clip
                        }

                texture
                        {
                        DarkPaint
                        }

                }
                
        #end        


              
#declare MidWall = union
        {
        
        object
                {
                LightBrick (<32, 21, 64>, <0, 41, -64>) 
                }
                
        object
                {
                LightBrick (<31, 21, 64>, <-15, 20, -64>) 
                }
        object
                {
                LightBrick (<31, 21, 64>, <16, 20, -64>) 
                }

        object
                {
                LightBrick (<30, 22, 64>, <-24, -2, -64>) 
                }
        object
                {
                LightBrick (<30, 22, 64>, <6, -2, -64>) 
                }
                
        }
        
#declare DarkWall = union
        {
        
        object
                {
                DarkBrick (<32, 21, 64>, <0, 41, -64>) 
                }
                
        object
                {
                LightBrick (<31, 21, 64>, <-15, 20, -64>) 
                }
        object
                {
                LightBrick (<31, 21, 64>, <16, 20, -64>) 
                }

        object
                {
                LightBrick (<30, 22, 64>, <-24, -2, -64>) 
                }
        object
                {
                LightBrick (<30, 22, 64>, <6, -2, -64>) 
                }
                
        }
        
#declare LeftWall = union
        {
        
        object
                {
                LightBrick (<32, 21, 64>, <0, 41, -64>)
                }
                
        object
                {
                LightBrick (<31, 21, 64>, <-15, 20, -64>)
                }
        object
                {
                LightBrick(<31, 21, 64>, <16, 20, -64>)
                }

        object
                {
                LightBrick(<36, 22, 64>, <0, -2, -64>)
                }
                
        }
                                
#declare RightWall = union
        {
        
        object
                {
                LightBrick(<32, 21, 64>, <0, 41, -64>)
                }
                
        object
                {
                LightBrick(<31, 21, 64>, <-15, 20, -64>)
                }
        object
                {
                DarkBrick(<31, 21, 64>, <16, 20, -64>)
                }

        object
                {
                LightBrick(<30, 22, 64>, <-24, -2, -64>)
                }
        object
                {
                LightBrick(<30, 22, 64>, <6, -2, -64>)
                }
                
        }



#declare Gate = union
        {
        
        cylinder
                {

                <-4, 2, -60>, <-4, 62, -60>, 4

                }

        cylinder
                {

                <-4, 2, -4>, <-4, 62, -4>, 4

                }
                
        // vert
        
        #local vert = union
                {        
                cylinder        {       <-4, 8, -48>, <-4, 62, -48>, 1  }
                cone    {       <-4, 2, -48>, 0, <-4, 8, -48>, 1        }
                }
                
        object  {       vert    }       
        object  {       vert    translate z * 16        }
        object  {       vert    translate z * 32        }
        
        // horiz
        
        #local horiz = cylinder
                {
                <-4, 11, -55.5>, <-4, 11, -8.5>, 1
                }
                
        object  {       horiz   }
        object  {       horiz   translate y * 8 }
        object  {       horiz   translate y * 16 }
        object  {       horiz   translate y * 24 }
        object  {       horiz   translate y * 32 }
        object  {       horiz   translate y * 40 }
        object  {       horiz   translate y * 48 }
                
                
        pigment {       White   }
        finish  {       ambient .2      reflection {    .3      }       }        

        }








