#declare Zaphod = seed(729);


#macro Torch (grosse)   // gir flamme <-g/2,0,-g/2> til <g/2,g,g/2>

        #macro FlameLight (max_dark)
                union
                        {
                        light_source
                                {
                                0, White
                                fade_distance 16
                                fade_power 1.5
                                }
                        sphere
                                {
                                0, .001
                                pigment
                                        {
                                        bumps 
                                        scale .00008
                                        color_map
                                                {
                                                [       0.0     rgbt <1, 1, 1, max_dark>        ]
                                                [       1.0     rgbt <1, 1, 1, 1>        ]                
                                                }
                                        }
                                no_image
                                no_reflection        
                                }
                        }
                #end        

        #local FlameOuter = merge
                {
                #local rad = .3;
                #local half_cute = pi * 1/9;
                sphere  {       0, rad  }
                cone
                        {        
                        <0, rad * sin(half_cute), 0>, rad * cos(half_cute),
                        <0, rad / sin(half_cute), 0>, 0
                        }
                pigment
                        {
                        rgbt <1, .5, 0, .6>
                        }
                finish
                        {
                        diffuse 0.1
                        ambient 0.9
                        }        
                no_shadow
                }
        
        #local FlameInner = merge
                {        
                #local rad = .22;
                #local half_cute = pi * 1/9;
                sphere  {       0, rad  }
                cone
                        {        
                        <0, rad * sin(half_cute), 0>, rad * cos(half_cute),
                        <0, rad / sin(half_cute), 0>, 0
                        }
                pigment
                        {
                        rgb <1, 1, 0>
                        }
                finish
                        {
                        diffuse 0.1
                        ambient 0.9
                        }        
                no_shadow
                }
        
        union
                {
                
                // lyset        
                        
                object
                        {

                        FlameLight (0.5)

                        translate grosse * <0, 1/3, 0>
                        
                        }
                        
                // masse sm flammebiter

                #local index = 0;
                
                #while (index < 700)
                
                        #local p_y = pow(rand(Zaphod), 1.76);

                        #if (p_y < 1/3)
                                        #local p_c = sin(acos(1 - p_y * 3)) / 2;
                                #else
                                        #local p_c = (1 - p_y) * 3 / 4;
                                #end
                        #if (rand(Zaphod) < .5)                
                                    #local p_c = -p_c;
                                #end
                        #local p_x = rand(Zaphod) * p_c;
                        #if (rand(Zaphod) < .5)                
                                    #local p_c = -p_c;
                                #end
                        #local p_z = rand(Zaphod) * p_c;        

                        #if (index < 240)
                                object
                                        {
                                        FlameInner
                                        translate <p_x, p_y, p_z> * grosse * 0.5 - y
                                        translate <p_y * (rand(Zaphod) - .5), (rand(Zaphod) - .5), p_y * (rand(Zaphod) - .5)>
                                        }
                                #end        
                
                        object
                                {
                                FlameOuter
                                translate <p_x, p_y, p_z> * grosse - y * 2
                                translate <p_y * (rand(Zaphod) - .5), (rand(Zaphod) - .5), p_y * (rand(Zaphod) - .5)> * 2
                                }

                        #local index = index + 1;
                
                        #end
                
                // holderen
                
                union
                        {

                        cone
                                {
                                y * -15, 0, y * -2.5, 2.5
                                } 
                        difference
                                {        
                                cone
                                        {
                                        y * -2.5, 2.5, 0, 4.5
                                        }
                                cone
                                        {
                                        y * -2.4, 2.0, .1, 4.0
                                        }
                                }        
                        cylinder
                                {
                                y * -6, <0, -6, 16>, 1
                                }        
                        pigment
                                {
                                Gray40
                                }
                        finish
                                {
                                phong 0.9
                                phong_size 60
                                metallic
                                }
                                
                        }
                        
                }        
                
        #end                
