//==================================
// D'aprs un livre sur les
// sculptures minimalistes
// et les oeuvres de Sol LeWitt
// pour le topic d'Aot 2005
// 
//
// Helen - Aot 2005
//==================================

// Temps de rendu : 800x600 = 1h41

// =====  includes  =====
#include "colors.inc"
#include "couleurs.inc"
#include "textures.inc"	
#include "finish.inc"



global_settings { max_trace_level 15}


light_source
{  
  <-1000, 1500, -1100>,1 
  
}


camera
{
location <0, 10, -20>
	look_at <0,0,0>//1
	angle 38 
}

//****************************************
// Le carrelage est d'Olivier
// Thanks...
//****************************************

// === joint===
plane { y, 0 pigment { Grey }}

// === carreau ===
#declare carreau=
superellipsoid 
{ 
  <0.1, 0.1> 
  pigment   { LightSteelBlue}
  finish {reflection 0.3}//0.3
}

// === pose d'un carrelage mono couleur ===
#declare posx=-30;	// point de dpart du carrealge sur l'axe X
#while (posx<34)	
	#declare posz=-10;
	#while (posz<50)
	object { carreau  
		translate <posx, -0.95, posz>}
	#declare posz=posz+2.0;		// espace entre les carreaux axe z
	#end
#declare posx=posx+2.0;		// espace entre les carreaux axe x
#end



//*********************************************
// fabrication des cubes vids
//*********************************************
#declare couleur= 
material {
	texture {
 pigment
                 {
                 White filter 0.8
                 }
         finish
                 {
                 ambient .1
                 diffuse .1
                 reflection .2
                 specular 1
                 roughness .001
                         irid
                         {
                         0.35
                        thickness .5
                         turbulence .5
                         }
}
                 }
         interior
                 {
                 ior 1.5
              //   fade_distance 5
               //  fade_power 1
               //  caustics 1
                 }  
     
}


#declare cube_vide =
difference
{
box
{
  <-1,0,0>, <1,2,2>
  material {couleur}
  
}

union
{
box
{
  <-0.8,0.2,-2>, <0.8,1.8,4>
  material {couleur}
  
}

box
{
  <-2,0.2,0.2>, <2,1.8,1.8>
  material {couleur}
}

box
{
  <-0.8,-4,0.2>, <0.8,4,1.8>
  material {couleur}
  
}
} // end union des trois objets qui feront les trous
  

} // end diffrence qui fera le cube vid


//=======================================
// un cube de cubes
//=======================================

#declare rang_cube_vide =
union
{
  #declare I=0;
  #while (I<5)
    #declare J=0;
    #while (J<5)
      #declare K=0;
      #while (K<5)
      object
      {
	cube_vide
	scale 0.70
	translate x*1.5*I
	translate z*1.5*J 
	translate y*1.5*K
      }
	#declare K=K+1;
      #end
      #declare J=J+1;
    #end
    #declare I=I+1;
  #end
}


// --- Positionnement de l'objet

object
{
  rang_cube_vide
  scale 0.7
  translate <-2.1,0.1,-5>
}
