#include "math.inc"
#include "shapes.inc"
#declare s=seed(65) ;

// ---------------- //
// --- Textures --- //
// ---------------- //

#declare T_Piece_noire = 
texture {pigment {
  marble
  turbulence .6
  color_map {
    [.000 color rgb <.32,.29,.24>]
    [.100 color rgb <.11,.08,.06>]
    [.150 color rgb <.02,.02,.02>]
    [1.00 color rgb <.02,.02,.02>]
  }
  rotate 80*x rotate 15*y
  scale .2
  translate <rand(s),rand(s),rand(s)>*100
  rotate (.5-rand(s))*45*y
}finish {
  ambient .3 diffuse .6
}}
texture {
  pigment {
    granite
    color_map {
      [.000 color rgbt <.00,.00,.00,1.00>]
      [.200 color rgbt <.12,.08,.06,.60>]
      [.600 color rgbt <.21,.23,.18,.40>]
      [.900 color rgbt <.00,.00,.00,1.0>]
      [1.00 color rgbt <.00,.00,.00,1.0>]
    }
    scale .5
    translate <rand(s),rand(s),rand(s)>*100
    rotate (.5-rand(s))*45*y

  }
  finish {
    ambient .3 diffuse .7
    specular 1. roughness .03
    reflection .06
    crand .06
  }
}

#declare T_Piece_blanche = 
texture {pigment {
  marble
  turbulence .6
  color_map {
    [.000 color rgb <.78,.79,.82>]
    [.100 color rgb <.9,.91,.95>]
    [.150 color rgb <.97,.97,.97>]
    [1.00 color rgb <.96,.96,.96>]
  }
  rotate 80*x rotate 15*y
  scale .2
  translate <rand(s),rand(s),rand(s)>*100
  rotate (.5-rand(s))*45*y
}finish {
  ambient .3 diffuse .6
}}
texture {
  pigment {
    granite
    color_map {
      [.000 color rgbt <1.0,1.0,1.0,1.0>]
      [.200 color rgbt <.94,.96,.97,.60>]
      [.600 color rgbt <.90,.85,.87,.40>]
      [.900 color rgbt <1.0,1.0,1.0,1.0>]
      [1.00 color rgbt <1.0,1.0,1.0,1.0>]
    }
    scale .6
    translate <rand(s),rand(s),rand(s)>*100
    rotate (.5-rand(s))*45*y
  }
  finish {
    ambient .3 diffuse .7
    specular .3 roughness .03
    reflection .08
  }
}

#declare T_Case_noire = 
texture {pigment {
  marble
  turbulence .6
  color_map {
    [.000 color rgb <.32,.29,.24>]
    [.100 color rgb <.11,.08,.06>]
    [.150 color rgb <.02,.02,.02>]
    [1.00 color rgb <.02,.02,.02>]
  }
  rotate 80*x rotate 15*y
  scale .2
  translate <rand(s),rand(s),rand(s)>*100  
  rotate (.5-rand(s))*45*y

}finish {
  ambient .3 diffuse .6
}}
texture {
  pigment {
    granite
    color_map {
      [.000 color rgbt <.00,.00,.00,1.00>]
      [.200 color rgbt <.12,.08,.06,.60>]
      [.600 color rgbt <.21,.23,.18,.40>]
      [.900 color rgbt <.00,.00,.00,1.0>]
      [1.00 color rgbt <.00,.00,.00,1.0>]
    }
    scale .5
    translate <rand(s),rand(s),rand(s)>*100  
    rotate (.5-rand(s))*45*y

  }
  finish {
    ambient .3 diffuse .7
    specular 1.4 roughness .02
    reflection .16
    crand .04
  }
}

#declare T_Case_blanche = texture {T_Piece_blanche}
texture {pigment {
  marble
  turbulence .6
  color_map {
    [.000 color rgb <.82,.83,.86>]
    [.100 color rgb <.93,.94,.97>]
    [.150 color rgb <.99,.99,.99>]
    [1.00 color rgb <.98,.98,.98>]
  }
  rotate 80*x rotate 15*y
  scale .2
  translate <rand(s),rand(s),rand(s)>*100  
  rotate (.5-rand(s))*45*y

}finish {
  ambient .3 diffuse .6
}}
texture {
  pigment {
    granite
    color_map {
      [.000 color rgbt <1.0,1.0,1.0,1.0>]
      [.200 color rgbt <.94,.96,.97,.60>]
      [.600 color rgbt <.90,.85,.87,.40>]
      [.900 color rgbt <1.0,1.0,1.0,1.0>]
      [1.00 color rgbt <1.0,1.0,1.0,1.0>]
    }
    scale .6
    translate <rand(s),rand(s),rand(s)>*100  
    rotate (.5-rand(s))*45*y

  }
  finish {
    ambient .3 diffuse .7
    specular 1.4 roughness .02
    reflection .2
    crand .03
  }
}
#declare T_Bois = 
texture{pigment {
    bozo
    color_map { 
      [0.00 0.25   color rgb < 0.504, 0.310, 0.078> * 0.7
                   color rgb < 0.531, 0.325, 0.090> * 0.8 ]
      [0.25 0.40   color rgb < 0.531, 0.325, 0.090> * 0.8
                   color rgb < 0.547, 0.333, 0.090> * 0.5 ]
      [0.40 0.50   color rgb < 0.547, 0.333, 0.090> * 0.5
                   color rgb < 0.504, 0.310, 0.075> * 0.6 ]
      [0.50 0.70   color rgb < 0.504, 0.310, 0.075> * 0.6 
                   color rgb < 0.559, 0.322, 0.102> * 0.4 ]
      [0.70 0.98   color rgb < 0.559, 0.322, 0.102> * 0.4
                   color rgb < 0.531, 0.325, 0.086> * 0.4 ]
      [0.98 1.00   color rgb < 0.531, 0.325, 0.086> * 0.4
                   color rgb < 0.504, 0.310, 0.078> * 0.7 ]
    }
    turbulence 0.04
    scale <0.05 0.05 1>*.6
}
finish {ambient .3 diffuse .6}
}
texture{pigment {
    wood
    color_map {
      [0.00 0.25   color rgbt < 0.404, 0.210, 0.078, 0.20>
                   color rgbt < 0.431, 0.225, 0.090, 0.80>]
      [0.25 0.40   color rgbt < 0.431, 0.225, 0.090, 0.80>
                   color rgbt < 0.447, 0.233, 0.090, 0.20>]
      [0.40 0.50   color rgbt < 0.447, 0.233, 0.090, 0.20>
                   color rgbt < 0.404, 0.210, 0.075, 0.60>]
      [0.50 0.70   color rgbt < 0.404, 0.210, 0.075, 0.60>
                   color rgbt < 0.459, 0.222, 0.102, 0.20>]
      [0.70 0.98   color rgbt < 0.459, 0.222, 0.102, 0.20>
                   color rgbt < 0.431, 0.225, 0.086, 0.40>]
      [0.98 1.00   color rgbt < 0.431, 0.225, 0.086, 0.40>
                   color rgbt < 0.404, 0.210, 0.078, 0.10>]
    }
    scale <0.20 0.20 1>*.6
    turbulence 0.08
    rotate <-2, 2, 0>
    rotate 90*y
}
finish {ambient .3 diffuse .6}
}


// ---------------------------- //
// --- Gomtrie des pices --- //
// ---------------------------- //

#declare h_maj=1.2;
#declare l_maj=.9;
#declare h_cav=1.1;
#declare l_cav=1.3;
#declare h_tou=1.1;
#declare l_tou=1.;


// ----------------- //
// -- Roi et dame -- //


// - Paramtres - //

#declare r1=.3 ;
#declare r2=.2 ;
#declare r3=.4 ;
#declare h=.35 ;
#declare c=1 ;

#declare e1=.04 ;
#declare e2=.02 ;

#declare rs=.15 ;
#declare es=.02 ;

// - Grandeurs intermdiaires - //

#declare b1=c*pow(h,2)/(pow(r1,2)/pow(r2,2)-1) ;
#declare a1=b1/pow(r2,2) ;
#declare b2=c/(pow(r3,2)/pow(r2,2)-1) ;
#declare a2=b2/pow(r2,2) ;

#declare theta1=180/pi*atan(a1*r1/(c*h)) ;
#declare l1=1+h+e1*cosd(theta1) ;
#declare d1=r1-e1*sind(theta1) ;
#declare theta2=180/pi*atan(a2*r3/c) ;
#declare l2=-e2*cosd(theta2) ;
#declare d2=r3-e2*sind(theta2) ;

// - Construction - //

#declare Corps = union {
  intersection {
    quadric {
      <a1, -c,  a1>,
      < 0,  0,   0>,
      < 0,  0,   0>, -b1 
   
      translate y 
    } 
    box {<-2,1,-2> <2,1+h,2>}
  }
  torus {d1 e1 translate l1*y}
  cylinder {<0,l1-e1,0> <0,l1+e1,0> d1}
  intersection {
    quadric {
      <a2, -c, a2>,
      < 0,  0,  0>,
      < 0,  0,  0>, -b2 
   
      translate y 
    } 
    box {<-2,0,-2> <2,1,2>}
  }
  torus {d2 e2 translate l2*y}
  cylinder {<0,l2-e2,0> <0,l2+e2,0> d2}
  sphere {0 rs scale <1,.8,1> translate (l1+e1+es)*y }
  difference {
    cylinder {<0,l1+e1*.9,0> <0,l1+e1+es,0> rs+es}
    torus {rs+es es translate (l1+e1+es)*y}
  }
}

#declare Dame = difference {
  object {Corps}
  #declare ii1=0 ;
  #while(ii1<6)
    cylinder {-.2*x .2*x .07 
      rotate 45*z translate <-r1*1.3,1+h,0>
      rotate 360/6*ii1*y}
    #declare ii1=ii1+1;
  #end
  translate (e2-l2)*y
}
#declare Dame_blanche = object {
  Dame 
  scale <l_maj,h_maj,l_maj>
  texture {T_Piece_blanche}
}
#declare Dame_noire = object {
  Dame 
  scale <l_maj,h_maj,l_maj>
  texture {T_Piece_noire}
}

#declare e3=.01 ;
#declare l3=.09 ;
#declare h3=.22 ;
#declare k3=.08 ;
#declare g3=.2 ;
#declare d3=.08 ;
#declare Roi = union {
  object {Corps}
  union {
    Round_Box_Union(<-l3/2,0,-d3/2>,<l3/2,h3,d3/2>,e3)
    Round_Box_Union(<-g3/2,k3,-d3/2>,<g3/2,k3+l3*l_maj/h_maj,d3/2>,e3)
    translate (l1+e1+es+.8*rs-2*e3)*y
  }
  translate (e2-l2)*y
}
#declare Roi_noir = object {
  Roi 
  scale <l_maj,h_maj,l_maj>
  texture {T_Piece_noire}
}
#declare Roi_blanc = object {
  Roi 
  scale <l_maj,h_maj,l_maj>
  texture {T_Piece_blanche}
}


// -------------- //
// -- Cavalier -- //

// - Paramtres - //

#declare r41=.27 ;
#declare r42=.18 ;
#declare h41=.3 ;
#declare e41=e2 ;
#declare e42=.03 ;

// - Grandeurs intermdiaires - //

#declare a4=pow(h41,2)/(pow(r41,2)-pow(r42,2)) ;
#declare b4=a4*pow(r42,2) ;

#declare theta4=180/pi*atan(a4*r41/(c*h41)) ;
#declare l4=-e41*cosd(theta4) ;
#declare d4=r41-e41*sind(theta4) ;

// - Construction - //


#declare Moitie = intersection {
  height_field {
    png "profil.png"  
    smooth
    scale <1,.12,1>
  }
  box {<0,.04,0> <1,1,1>}
  translate -.0401*y
}
#declare Tete = union {
  object {Moitie}
  object {Moitie scale <1,-1,1>}
  rotate -90*x
  rotate 90*y
}

#declare Cavalier = union {
  intersection {
    quadric {
      <a4, -1,  a4>,
      < 0,  0,   0>,
      < 0,  0,   0>, -b4 
   
      translate h41*y 
    } 
    box {<-2,0,-2> <2,h41,2>}
  }
  torus {r42-e42 e42 translate h41*y}
  cylinder {<0,h41-e42,0> <0,h41+e42,0> r42-e42}
  torus {d4 e41 translate l4*y}
  cylinder {<0,l4-e41,0> <0,l4+e41,0> d4}
  object {Tete translate <0,h41-.04,.55>}
  translate (e41-l4)*y
}
#declare Cavalier_noir = object {
  Cavalier 
  scale <l_cav,h_cav,l_cav>  
  texture {T_Piece_noire}
}
#declare Cavalier_blanc = object {
  Cavalier 
  scale <l_cav,h_cav,l_cav>   
  texture {T_Piece_blanche}
}


// ---------- //
// -- Tour -- //

// - Paramtres - //

#declare r51=.27 ;
#declare r52=.22 ;
#declare r53=.36 ;
#declare h5=.32 ;
#declare c5=1 ;
#declare t5=.8 ;

#declare e51=.04 ;
#declare e52=.02 ;

#declare p5=.2 ;
#declare g5=.12 ;
#declare q5=.09 ;

// - Grandeurs intermdiaires - //

#declare b51=c5*pow(h5,2)/(pow(r51,2)/pow(r52,2)-1) ;
#declare a51=b51/pow(r52,2) ;
#declare b52=c5/(pow(r53,2)/pow(r52,2)-1) ;
#declare a52=b52/pow(r52,2) ;

#declare theta51=180/pi*atan(a51*r51/(c5*h5)) ;
#declare l51=1+h5+e51*cosd(theta51) ;
#declare d51=r51-e51*sind(theta51) ;
#declare theta52=180/pi*atan(a52*r53/c5) ;
#declare l52=-e52*cosd(theta52) ;
#declare d52=r53-e52*sind(theta52) ;

#declare l53=1+h5+2*e51*cosd(theta51) ;
#declare d53=r51-2*e51*sind(theta51) ;
#declare d54=d53-p5*tand(90-theta51) ;
#declare d53b=d53+.1*h5*tand(90-theta51) ;

// - Construction - //

#declare Tour = difference {
  union {
    intersection {
      quadric {
        <a51, -c5,  a51>,
        < 0,  0,   0>,
        < 0,  0,   0>, -b51 
   
        translate y 
      } 
      box {<-2,1,-2> <2,1+h5,2>}
    }
    torus {d51 e51 translate l51*y}
    cylinder {<0,l53-e51,0> <0,l53,0> d51}
    intersection {
      quadric {
        <a52, -c5, a52>,
        < 0,  0,  0>,
        < 0,  0,  0>, -b52 
   
        translate y 
      } 
      box {<-2,0,-2> <2,1,2>}
    }
    torus {d52 e52 translate l52*y}
    cylinder {<0,l52-e52,0> <0,l52+e52,0> d52}
  }
  Round_Cone3(<0,l53-p5,0>,d54,<0,l53+.1*h5,0>,d53b,no)
  
  box {<-g5/2,l53-q5,-1><g5/2,2,1>}
  box {<-g5/2,l53-q5,-1><g5/2,2,1> rotate 90*y}
  
  translate (e52-l52)*y
  scale t5 
}

#declare Tour_blanche = object {
  Tour 
  scale <l_tou,h_tou,l_tou> 
  texture {T_Piece_blanche}
}
#declare Tour_noire = object {
  Tour 
  scale <l_tou,h_tou,l_tou>
  texture {T_Piece_noire}
}

// --------------- //
// --- Plateau --- //
// --------------- //

// -- paramtres -- //

#declare lc=1 ;
#declare lm=.1 ;
#declare epp1=.2 ;
#declare ep=.06 ;
#declare ec1=.001 ;
#declare ec2=.001 ;
#declare ec3=.006 ;
#declare erd=.0004 ;

// -- grandeurs intermdiaires -- //

#declare lp=4*lc+2*lm+2*ec2;
#declare epp=epp1-2*ec3 ;

#declare Plateau = union {
  // - bois - //
  difference {
    union {
      box {<0,-epp+ec3,0> <lp,ec3-ep,lp>}
      intersection {
        cylinder {<0,ec3-ep,ep> <lp,ec3-ep,ep> ep}
        plane {z 0 rotate -45*y translate lp/2*(z+x)}
        plane {z 0 rotate 45*y translate lp/2*(z+x)}
      }
      intersection {
        cylinder {<0,ec3-ep,ep> <lp,ec3-ep,ep> ep}
        plane {z 0 rotate -45*y translate lp/2*(z+x)}
        plane {z 0 rotate 45*y translate lp/2*(z+x)}
      
        translate -lp/2*(z+x) rotate 90*y
        translate lp/2*(z+x)
      }
      intersection {
        cylinder {<0,ec3-ep,ep> <lp,ec3-ep,ep> ep}
        plane {z 0 rotate -45*y translate lp/2*(z+x)}
        plane {z 0 rotate 45*y translate lp/2*(z+x)}
        
        translate -lp/2*(z+x) rotate 180*y
        translate lp/2*(z+x)
       }
       intersection {
         cylinder {<0,ec3-ep,ep> <lp,ec3-ep,ep> ep}
          plane {z 0 rotate -45*y translate lp/2*(z+x)}
         plane {z 0 rotate 45*y translate lp/2*(z+x)}
         
         translate -lp/2*(z+x) rotate 270*y
         translate lp/2*(z+x)
       }
       box {<ep,-2*ep,ep> <lp-ep,ec3,lp-ep>}
     }
     box {<lm,-epp/2,lm> <lp-lm,1,lp-lm>}    
     translate -(lm+ec2)*(z+x)
    
     texture {T_Bois}
  }
  #declare i6=0;
  #declare j6=0;
  #declare couleur=0;
  #while(j6<4)
    #while(i6<4)
    box {
      <i6*lc+ec1,-epp/2,j6*lc+ec1> <(i6+1)*lc-ec1,0,(j6+1)*lc-ec1>
      translate <rand(s),rand(s),rand(s)>*erd
    
      #if(couleur=0)
        texture {T_Case_blanche}
      #else
        texture {T_Case_noire}
      #end
    } 
    #declare i6=i6+1;
    #declare couleur = 1-couleur ;
  #end
    #declare i6=0;
    #declare j6=j6+1 ;
    #declare couleur = 1-couleur ;
  #end 
}


// ------------- //
// --- scne --- //
// ------------- //  

#declare dec=.03 ;

#declare Echecs = union {

object {Plateau}
object {Tour_noire 
  rotate (rand(s)-.5)*90*y scale <1,1,-1> 
  translate <.5*lc,0,.5*lc>+<rand(s),rand(s),rand(s)>*dec}
object {Dame_noire rotate (rand(s)-.5)*60*y scale <1,1,-1> 
  translate <1.5*lc,0,.5*lc>+<rand(s),rand(s),rand(s)>*dec}
object {Roi_noir rotate (rand(s)-.5)*10*y scale <1,1,-1> 
  translate <2.5*lc,0,.5*lc>+<rand(s),rand(s),rand(s)>*dec}
object {Cavalier_noir rotate (rand(s)-.5)*5*y scale <1,1,-1> 
  translate <3.5*lc,0,.5*lc>+<rand(s),rand(s),rand(s)>*dec}
object {Tour_blanche rotate (rand(s)-.5)*90*y 
  translate <.5*lc,0,3.5*lc>+<rand(s),rand(s),rand(s)>*dec}
object {Dame_blanche rotate (rand(s)-.5)*60*y 
  translate <1.5*lc,0,3.5*lc>+<rand(s),rand(s),rand(s)>*dec}
object {Roi_blanc rotate (rand(s)-.5)*10*y 
  translate <2.5*lc,0,3.5*lc>+<rand(s),rand(s),rand(s)>*dec}
object {Cavalier_blanc rotate (rand(s)-.5)*5*y 
  translate <3.5*lc,0,3.5*lc>+<rand(s),rand(s),rand(s)>*dec}

translate <-2,epp-ec3,-2>
}

/*
  
plane {
  y 0-epp 
  pigment {rgb <.8,.2,.15>}
  finish {
    ambient .3 diffuse .6 
    specular .5 roughness .6 
    crand .1
  }
}

light_source {
  <1.1,6,-1> 
  color rgb 1
  area_light .3*x .3*y 8 8 jitter  
}
camera {location <-2.5,5,2.5> look_at <2,0,2.3>}

global_settings {
  radiosity {
    count 200
    pretrace_end .02
  }
}*/