#include "math.inc"

// ------------------ //
// --- Paramtres --- //
// ------------------ //

#declare l_mon = 1 ;
#declare ep_mon = .6 ;
#declare er_mon = .3 ;
#declare lt_mon = .4 ;
#declare ht_mon = 1.4 ;
#declare et_mon = 4.2 ;

#declare x_mon = 40 ;
#declare ec_mon = 18 ;

#declare l_eta = 1.3*ec_mon ;
#declare p_eta = .8*l_eta ;
#declare ep_eta = .6 ;
#declare ee_eta = 1 ;
#declare te_eta = 2 ;

#declare hm_eta = 62 ;
#declare dh_eta = 5 ;

#declare x_raccord = x_mon+ec_mon*1.1 ;
#declare ec_raccord = ec_mon*1.1 ;
#declare mseed = seed(4536) ; 

// --------------- //
// --- Magasin --- //
// --------------- //

// -------------- //
// -- Textures -- //

#declare C_Murs1 = rgb <.97,.9,.75> ;
#declare C_Murs2 = rgb <.95,.85,.65> ;

#declare T_Murs = 
texture {
  pigment {
    wrinkles
    turbulence .2
    scale 1.5
    color_map {
      [.00 C_Murs1]
      [.3 C_Murs1]
      [.75 C_Murs2]
      [1.0 C_Murs2]   
    }
  }
  finish {ambient .3 diffuse .7}
  normal {agate .2 scale .55}
}

#declare T_Plancher = 
texture {
  pigment {
    wrinkles
    turbulence .2
    scale 1
    color_map {
      [0 rgb <.8,.79,.75>]
      [.2 rgb <.8,.79,.75>]
      [.8 rgb <.95,.94,.9>]
      [1 rgb <.95,.94,.9>]
    }
  }
  finish {ambient .3 diffuse .7}
}
texture {
  pigment {
    dents
    turbulence .03
    scale 1
    color_map {
      [0 rgbt <.79,.78,.77,.3>]
      [.04 rgbt <.85,.84,.8,.8>]
      [1 rgbt <.85,.84,.8,1>]
    }
  }
  finish {ambient .3 diffuse .7}
}

    
#declare T_Plafond = texture {
  pigment {rgb <.96,.96,.96>}
  finish {ambient .3 diffuse .7}
  normal {bozo .3 turbulence .2 scale 1e-3}
}


#declare P_WoodGrainPi1 = 
pigment {
    wood  
    turbulence <.1,.06,.1>
    octaves 3
    lambda 2.2
    scale <0.2, 1.5, 5>
    
    translate <20,5,0>
}
#declare P_WoodGrainPi2 =
pigment {
    wood  
    turbulence <0.1, 0.5, 1> 
    octaves 5
    lambda 3.25
    scale <0.75, 2.5, 5>
   
    translate -x*10
}
#declare C_WoodPi11 = rgb <0.85, 0.77, 0.65> ;
#declare C_WoodPi12 = rgb <0.80, 0.70, 0.60> ;

#declare M_WoodPi1 = color_map {
    [0.0, 0.2 color C_WoodPi11
              color C_WoodPi11]
    [0.2, 0.8 color C_WoodPi11
              color C_WoodPi12]
    [0.8, 1.0 color C_WoodPi12
              color C_WoodPi11]
} 

#declare C_WoodPi21 = rgbt <0.78, 0.65, 0.55, 0.100> ;
#declare C_WoodPi22 = rgbt <0.78, 0.65, 0.55, 0.500> ;
#declare C_WoodPi23 = rgbt <0.78, 0.65, 0.55, 0.650> ;
#declare C_WoodPi24 = rgbt <0.83, 0.75, 0.70, 0.975> ;
#declare C_WoodPi25 = rgbt <0.78, 0.65, 0.55, 1.000> ;

#declare M_WoodPi2 = color_map {
    [0.0, 0.1 color C_WoodPi21
              color C_WoodPi22]
    [0.1, 0.9 color C_WoodPi23
              color C_WoodPi24]
    [0.9, 1.0 color C_WoodPi24
              color C_WoodPi25]
}
#declare T_Plintes =     
texture { 
  pigment { P_WoodGrainPi1  color_map { M_WoodPi1 }} 
  finish {ambient .3 diffuse .7}
  rotate 90*y rotate -90*x
}
texture { 
  pigment { P_WoodGrainPi2  color_map { M_WoodPi2 }} 
  finish {ambient .3 diffuse .7}
  rotate 90*y rotate -90*x
}
texture {
  pigment {rgbt <C_Murs2.red,C_Murs2.green,C_Murs2.blue,.8>}
  finish {ambient .3 diffuse .7}
}

// --------------- //
// -- Gomtrie -- //

#declare Murs = union {
  box {<-151,-1,0> <x_raccord,101,1>
    texture {T_Murs}}
  box {<x_raccord,-1,0> <151,101,1>
    texture {T_Murs translate <rand(mseed),rand(mseed),rand(mseed)>*100}}
  
  cylinder {<x_raccord,0,0> <x_raccord,100,0> .02
    scale <1,1,1>
    pigment {
      marble
      turbulence .2
      scale <.1,.4,.1>
      color_map {
        [0 rgbt <.02,.02,.02,.1>]
        [.5 rgbt <.1,.1,.1,1>]
        [1 rgbt <.1,.1,.1,1>]
      }
      translate 40*y
    }
  }
  
  #declare i_rac = -4 ;
  #while(i_rac<4)
    cylinder {<x_raccord+i_rac*ec_raccord,0,0> <x_raccord+i_rac*ec_raccord,100,0> .02
      scale <1,1,1>
      pigment {
        marble
        turbulence .2
        scale <.1,.4,.1>
        color_map {
          [0 rgbt <.02,.02,.02,.2>]
          [.3 rgbt <.1,.1,.1,1>]
          [1 rgbt <.1,.1,.1,1>]
        }
        translate 40*y
      }
    }  
    #declare i_rac=i_rac+1;
  #end
  
  
  difference {
    cylinder {<0,-1,0> <0,101,0> 151}
    cylinder {<0,-1,0> <0,101,0> 150}
    pigment {image_map {png "ImageFond.png" map_type 2}}
  }
}
  
#declare h_plan = 15 ;
#declare Plancher = box {
  <-101,-1,1> <201,h_plan,-151>
  texture {T_Plancher}
}

#declare Plafond = box {
  <-101,100,1> <201,101,-151>
  texture {T_Plafond}
}

#declare h_pli = 4.5 ;
#declare ep_pli = .8 ;
#declare er_pli = .3 ;
#declare Plintes = union {
  box {<-101,-1,1> <201,h_plan+h_pli-er_pli,-ep_pli>}
  box {<-101,-1,1> <201,h_plan+h_pli,-ep_pli+er_pli>}
  cylinder {<-101,h_plan+h_pli-er_pli,-ep_pli+er_pli>
            <201,h_plan+h_pli-er_pli,-ep_pli+er_pli>
            er_pli}
  texture {T_Plintes}
}
            
#declare Magasin = union {
  object {Murs}
  object {Plancher}
  object {Plintes}
  object {Plafond}
}

// ---------------- //
// --- tagres --- //
// ---------------- //

// -------------- //
// -- Textures -- //

#declare T_Montants = texture {
  pigment {C_Murs1}
  finish {ambient .3 diffuse .7 specular .04 roughness .1}
}

#declare P_WoodGrainE1 = 
pigment {
    wood  
    turbulence <.1,.06,.1>
    octaves 3
    lambda 2.2
    scale <0.2, 1.5, 5>
    rotate <2,4,0>
    translate <20,5,0>
}
#declare P_WoodGrainE2 =
pigment {
    wood  
    turbulence <0.1, 0.5, 1> 
    octaves 5
    lambda 3.25
    scale <0.75, 2.5, 5>
    rotate <3, 6, 2>
    translate -x*10
}
#declare C_WoodE11 = rgb <0.85, 0.77, 0.65> ;
#declare C_WoodE12 = rgb <0.80, 0.70, 0.60> ;

#declare M_WoodE1 = color_map {
    [0.0, 0.2 color C_WoodE11
              color C_WoodE11]
    [0.2, 0.8 color C_WoodE11
              color C_WoodE12]
    [0.8, 1.0 color C_WoodE12
              color C_WoodE11]
} 

#declare C_WoodE21 = rgbt <0.78, 0.65, 0.55, 0.100> ;
#declare C_WoodE22 = rgbt <0.78, 0.65, 0.55, 0.500> ;
#declare C_WoodE23 = rgbt <0.78, 0.65, 0.55, 0.650> ;
#declare C_WoodE24 = rgbt <0.83, 0.75, 0.70, 0.975> ;
#declare C_WoodE25 = rgbt <0.78, 0.65, 0.55, 1.000> ;

#declare M_WoodE2 = color_map {
    [0.0, 0.1 color C_WoodE21
              color C_WoodE22]
    [0.1, 0.9 color C_WoodE23
              color C_WoodE24]
    [0.9, 1.0 color C_WoodE24
              color C_WoodE25]
}
#declare T_Etageres   =         
    texture { 
      pigment { P_WoodGrainE1  color_map { M_WoodE1 }} 
      finish {ambient .3 diffuse .7}
    }
    texture { 
      pigment { P_WoodGrainE2  color_map { M_WoodE2 }} 
      finish {ambient .3 diffuse .7}
    }


// --------------- //
// -- Gomtrie -- //

#declare Montant = union {
    box {<-l_mon/2,-1,0> <l_mon/2,101,-ep_mon+er_mon>}
    box {<-(l_mon-er_mon)/2,-1,0> <(l_mon-er_mon)/2,101,-ep_mon>}
    cylinder {<-(l_mon/2-er_mon),-1,-ep_mon+er_mon>
              <-(l_mon/2-er_mon),101,-ep_mon+er_mon>
              er_mon}
    cylinder {<l_mon/2-er_mon,-1,-ep_mon+er_mon>
              <l_mon/2-er_mon,101,-ep_mon+er_mon>
              er_mon}

  texture {T_Montants}
}

#declare Montant2 = difference {
  union {
    box {<-l_mon/2,-1,0> <l_mon/2,101,-ep_mon+er_mon>}
    box {<-(l_mon-er_mon)/2,-1,0> <(l_mon-er_mon)/2,101,-ep_mon>}
    cylinder {<-(l_mon/2-er_mon),-1,-ep_mon+er_mon>
              <-(l_mon/2-er_mon),101,-ep_mon+er_mon>
              er_mon}
    cylinder {<l_mon/2-er_mon,-1,-ep_mon+er_mon>
              <l_mon/2-er_mon,101,-ep_mon+er_mon>
              er_mon}
    }
  box {<-(l_mon-er_mon/2)/2,-1,0> <(l_mon-er_mon/2)/2,101,-ep_mon+er_mon/2>}
  #declare i_mon=1 ;
  #while(i_mon<101) 
    box {<-lt_mon/2,i_mon,0> <lt_mon/2,i_mon+ht_mon,-1>}
    #declare i_mon=i_mon+et_mon ;
  #end

  texture {T_Montants}
}

#declare Montants = union {
  object {Montant translate x_mon*x}
  object {Montant translate (x_mon+ec_mon)*x}
  object {Montant translate (x_mon+2*ec_mon)*x}
}


#declare Etagere = union {
  intersection {
    union {
      cylinder {<0,0,0> <0,-ep_eta,0> l_eta/2}
      torus {l_eta/2 ep_eta/2 translate -ep_eta/2*y }
  
      scale <1,1,p_eta/l_eta>
    }
    plane {z 0}
    
  }
  #declare Equerre = union {
    difference {
      box {<-(l_mon-er_mon*1.1)/2,-te_eta-ep_eta,-ep_mon-te_eta>
           <(l_mon-er_mon*1.1)/2,-ep_eta,-ep_mon>}
      cylinder {<-l_mon,-te_eta-ep_eta,-ep_mon-te_eta>
           <l_mon,-te_eta-ep_eta,-ep_mon-te_eta>
           te_eta-ee_eta}
      cylinder {<0,-ep_eta-.8*te_eta,-ep_mon-ee_eta-1> <0,-ep_eta-.8*te_eta,0> l_mon/6}
    }
    intersection {
      cylinder {<-(l_mon-er_mon*1.1)/2,-ep_eta,-ep_mon-te_eta> 
                <(l_mon-er_mon*1.1)/2,-ep_eta,-ep_mon-te_eta> 
                ee_eta}
      box {<-l_mon,-ep_eta,-ep_mon-te_eta+.01> <l_mon,-ep_eta-ee_eta,-ep_mon-te_eta-ee_eta>}
    }
    intersection {
      cylinder {<-(l_mon-er_mon*1.1)/2,-ep_eta-te_eta,-ep_mon> 
                <(l_mon-er_mon*1.1)/2,-ep_eta-te_eta,-ep_mon> 
                ee_eta}
      box {<-l_mon,-ep_eta-te_eta+.01,-ep_mon> <l_mon,-ep_eta-te_eta-ee_eta,-ep_mon-ee_eta>}
    }
    
    scale <1,1,1.2>
  }
  object {Equerre translate ec_mon/2*x}
  object {Equerre translate -ec_mon/2*x}
}


#declare Etageres = union {
  object {Etagere 
    translate <x_mon+ec_mon/2,    hm_eta,0>    
    texture {T_Etageres translate <rand(mseed)*30,rand(mseed),rand(mseed)>*2}}
  object {Etagere 
    translate <x_mon+3*ec_mon/2,hm_eta-dh_eta,0>
    texture {T_Etageres translate <rand(mseed)*30,rand(mseed),rand(mseed)>*2}}
  object {Etagere 
    translate <x_mon+ec_mon/2,    hm_eta-2*dh_eta,0>
    texture {T_Etageres translate <rand(mseed)*30,rand(mseed),rand(mseed)>*2}}
  object {Etagere 
    translate <x_mon+3*ec_mon/2,hm_eta-3*dh_eta,0>
    texture {T_Etageres translate <rand(mseed)*30,rand(mseed),rand(mseed)>*2}}
  object {Etagere 
    translate <x_mon+ec_mon/2,    hm_eta-4*dh_eta,0>
    texture {T_Etageres translate <rand(mseed)*30,rand(mseed),rand(mseed)>*2}}
  object {Etagere 
    translate <x_mon+3*ec_mon/2,hm_eta-5*dh_eta,0>
    texture {T_Etageres translate <rand(mseed)*30,rand(mseed),rand(mseed)>*2}}
}

// ------------ //
// --- Jeux --- //
// ------------ //


#declare Jeux = union {
  
  #include "rubik.pov"
  object {Rubik 
    rotate 195*y
    scale 1.6
    translate <x_mon+ec_mon/2-1.5,hm_eta,-p_eta*.3>}


  #include "Echecs.pov"
  object {Echecs 
    rotate -88*y
    scale 1.8
    translate <x_mon+3*ec_mon/2,hm_eta-dh_eta,-p_eta*.25>}


  #include "Go.pov"
  object {Go
    rotate -.7*y
    scale 1.4
    translate <x_mon+ec_mon/2,hm_eta-2*dh_eta,-p_eta*.25>}

  #include "abalone.pov"
  object {Abalone
    bounded_by {cylinder {<0,-.1,0> <0,1,0> 8}}
    rotate 30*y
    scale .6
    translate <x_mon+3*ec_mon/2,hm_eta-3*dh_eta,-p_eta*.25>
  
  }

  #include "Dames.pov"
  object {Dames
    scale 1.4
    translate <x_mon+ec_mon/2,hm_eta-4*dh_eta,-p_eta*.25>
  }
  
  #include "Othello.pov"
  object {Othello
    scale 1.4
    translate <x_mon+3*ec_mon/2,hm_eta-5*dh_eta,-p_eta*.25>
  }
 
}

// ------------------ //
// --- Etiquettes --- //
// ------------------ //

#declare T_Etiquettes = texture {
  pigment {rgbt <1.0,.9,.63,.9>}
  finish {ambient .3 diffuse .7 }//crand .05}
}

#declare an_eti = 40 ;
#declare ta_eti = 4.2 ;

#declare N_Etiquettes = normal {
  granite .14 scale .16}

#macro Etiquette(texte) union {
  box {<-ta_eti/2,0,-.02> <ta_eti/2,-ta_eti/2,.02>
    texture {
      pigment {
        image_map {
          png texte 
          map_type 0 
          once 
          interpolate 2
        }
        scale <ta_eti,ta_eti/2,.02>
        translate <-ta_eti/2,-ta_eti/2,-.01>
      }
      finish {ambient .3 diffuse .7}
      normal {N_Etiquettes}
    }
    texture {T_Etiquettes}   
    rotate an_eti/2*x
  }
  box {<-ta_eti/2,0,-.02> <ta_eti/2,-ta_eti/2,.02>
    texture {
      pigment {rgb 1} 
      finish {ambient .3 diffuse .7} 
      normal {N_Etiquettes}
    }
    texture {T_Etiquettes}
    rotate -an_eti/2*x
  }
  cylinder {<-ta_eti/2,0,0> <ta_eti/2,0,0> .02
    texture {T_Etiquettes}
  }
  translate ta_eti/2*cosd(an_eti/2)*y
}#end


#declare Etiquettes = union {
  
  object {Etiquette("Etiquette_Rubik.png") 
    rotate 3*(rand(mseed)-.5)*y
    translate <x_mon+ec_mon/2+4.5,hm_eta,-p_eta*.3+.5>}

  object {Etiquette("Etiquette_Echecs.png") 
    rotate 1*(rand(mseed)-.5)*y
    translate <x_mon+3*ec_mon/2+7.1,hm_eta-dh_eta,-p_eta*.25+.2>}
  
  object {Etiquette("Etiquette_Go.png") 
    rotate 3*(rand(mseed)-.5)*y
    translate <x_mon+ec_mon/2+7.2,hm_eta-2*dh_eta,-p_eta*.25+.4>}

  object {Etiquette("Etiquette_Abalone.png") 
    rotate 1*(rand(mseed)-.5)*y
    translate <x_mon+3*ec_mon/2+7.3,hm_eta-3*dh_eta,-p_eta*.25>+.6}

  object {Etiquette("Etiquette_Dames.png") 
    rotate 3*(rand(mseed)-.5)*y
    translate <x_mon+ec_mon/2+7.3,hm_eta-4*dh_eta,-p_eta*.25+.3>}
  
  object {Etiquette("Etiquette_Othello.png") 
    rotate 3*(rand(mseed)-.5)*y
    translate <x_mon+3*ec_mon/2+7.1,hm_eta-5*dh_eta,-p_eta*.25-.5>}
}

// --------------- //
// --- Lumire --- //
// --------------- //

/* //test

light_source {
  <-100,90,-45> rgb 250
  fade_power 2 fade_distance 5  
  area_light 200*x 15*z 10 10 jitter
}
*/


light_source {
  <-70,90,-50> rgb 1 
  fade_power 2 fade_distance 40
  area_light 10*x 10*z 6 6 jitter
}
light_source {
  <120,90,-50> rgb 1
  fade_power 2 fade_distance 45
  area_light 10*x 10*z 6 6 jitter
}
light_source {
  <-40,90,-100> rgb 1 
  fade_power 2 fade_distance 40
  area_light 10*x 10*z 6 6 jitter
}
light_source {
  <35,90,-45> rgb 1
  fade_power 2 fade_distance 35  
  area_light 12*x 12*z 6 6 jitter
}


// ------------- //
// --- Scne --- //
// ------------- //

object {Magasin}
object {Montants}
object {Etageres}
object {Jeux}
object {Etiquettes}

#declare l_vue = .78 ;
#declare loc = <74,74,-35>;
#declare look = <x_mon+ec_mon+3,49,0> ;
camera {
  location loc
  look_at look
  up l_vue*y
  right l_vue*4/3*x
}


global_settings {
  ambient_light 0
  radiosity {
    count 150
    error_bound 1 
    recursion_limit 5
    pretrace_end .01
  }
}

background {<1,1,1>}
