#include "shapes.inc"

// ---------------- //
// --- textures --- //
// ---------------- //

#declare T_Plastique = texture {
  pigment {rgb .06}
  finish {
    ambient .3 diffuse .7
    specular 1 roughness .1
    brilliance 2
    crand .1
  }
}

#declare F_Pastille = finish {
  ambient .5 diffuse.5
  specular .6 roughness .2
}

#declare T_Pastille_verte = texture {
  pigment {rgb <.118,1.0,.278>}
  finish {F_Pastille}
}
#declare T_Pastille_rouge = texture {
  pigment {rgb <1.0,.051,.035>}
  finish {F_Pastille}
}
#declare T_Pastille_jaune = texture {
  pigment {rgb <1.0,.945,.000>}
  finish {F_Pastille}
}
#declare T_Pastille_bleue = texture {
  pigment {rgb <.208,.651,1.0>}
  finish {F_Pastille}
}
#declare T_Pastille_orange = texture {
  pigment {rgb <1.0,.408,.004>}
  finish {F_Pastille}
}
#declare T_Pastille_blanche = texture {
  pigment {rgb <1.0,1.0,1.0>}
  finish {F_Pastille}
}

// ------------ //
// --- Cube --- //
// ------------ //

// ---------------- //
// -- Paramtres -- //

#declare la=.8 ;
#declare er=.04 ;
#declare ec=.01 ;
#declare ep=.002 ;
#declare pp=.95*(la-2*er)/la ;
#declare pr=.15*pp ;

// --------------- //
// -- Gomtrie -- //

#declare Cube = Round_Box(<1,1,1>*(ec-la)/2,<1,1,1>*(la-ec)/2,er,no)

#declare Pastille = union {
  difference {
    box {<-pp*la/2,-pp*la/2,-(la/2+ep)> <pp*la/2,pp*la/2,-la/2+ep>}
    box {<-pp*la/2+pr,-pp*la/2+pr,-la/2+2*ep> <-pp*la/1.9,-pp*la/1.9,-(la/2+2*ep)>}
    box {<-pp*la/2+pr,-pp*la/2+pr,-la/2+2*ep> <-pp*la/1.9,-pp*la/1.9,-(la/2+2*ep)> rotate 90*z}
    box {<-pp*la/2+pr,-pp*la/2+pr,-la/2+2*ep> <-pp*la/1.9,-pp*la/1.9,-(la/2+2*ep)> rotate 180*z}
    box {<-pp*la/2+pr,-pp*la/2+pr,-la/2+2*ep> <-pp*la/1.9,-pp*la/1.9,-(la/2+2*ep)> rotate 270*z}
  }
  cylinder {<-pp*la/2+pr,-pp*la/2+pr,-la/2+2*ep> <-pp*la/2+pr,-pp*la/2+pr,-(la/2+ep)> pr}
  cylinder {<-pp*la/2+pr,-pp*la/2+pr,-la/2+2*ep> <-pp*la/2+pr,-pp*la/2+pr,-(la/2+ep)> pr rotate 90*z}
  cylinder {<-pp*la/2+pr,-pp*la/2+pr,-la/2+2*ep> <-pp*la/2+pr,-pp*la/2+pr,-(la/2+ep)> pr rotate 180*z}
  cylinder {<-pp*la/2+pr,-pp*la/2+pr,-la/2+2*ep> <-pp*la/2+pr,-pp*la/2+pr,-(la/2+ep)> pr rotate 270*z}
}

#declare Rubik = union {
  union {
    object {Cube texture {T_Plastique}}
    object {Pastille texture {T_Pastille_blanche}}
    object {Pastille texture {T_Pastille_rouge} rotate 90*x}
    object {Pastille texture {T_Pastille_verte} rotate -90*y}
  
    translate la/2*<1,1,-1>
  }
  union {
    object {Cube texture {T_Plastique}}
    object {Pastille texture {T_Pastille_blanche}}
    object {Pastille texture {T_Pastille_orange} rotate -90*x}
    object {Pastille texture {T_Pastille_verte} rotate -90*y}
  
    translate la/2*<1,-1,-1>
  }
  union {
    object {Cube texture {T_Plastique}}
    object {Pastille texture {T_Pastille_blanche}}
    object {Pastille texture {T_Pastille_orange} rotate -90*x}
    object {Pastille texture {T_Pastille_bleue} rotate 90*y}
  
    translate la/2*<-1,-1,-1>
  }
  union {
    object {Cube texture {T_Plastique}}
    object {Pastille texture {T_Pastille_blanche}}
    object {Pastille texture {T_Pastille_rouge} rotate 90*x}
    object {Pastille texture {T_Pastille_bleue} rotate 90*y}
  
    translate la/2*<-1,1,-1>
  }
  union {
    object {Cube texture {T_Plastique}}
    object {Pastille texture {T_Pastille_jaune} rotate 180*y}
    object {Pastille texture {T_Pastille_rouge} rotate 90*x}
    object {Pastille texture {T_Pastille_verte} rotate -90*y}
  
    translate la/2*<1,1,1>
  }
  union {
    object {Cube texture {T_Plastique}}
    object {Pastille texture {T_Pastille_jaune} rotate 180*y}
    object {Pastille texture {T_Pastille_orange} rotate -90*x}
    object {Pastille texture {T_Pastille_verte} rotate -90*y}
  
    translate la/2*<1,-1,1>
  }
  union {
    object {Cube texture {T_Plastique}}
    object {Pastille texture {T_Pastille_jaune} rotate 180*y}
    object {Pastille texture {T_Pastille_orange} rotate -90*x}
    object {Pastille texture {T_Pastille_bleue} rotate 90*y}
  
    translate la/2*<-1,-1,1>
  }
   union {
    object {Cube texture {T_Plastique}}
    object {Pastille texture {T_Pastille_jaune} rotate 180*y}
    object {Pastille texture {T_Pastille_rouge} rotate 90*x}
    object {Pastille texture {T_Pastille_bleue} rotate 90*y}
  
    translate la/2*<-1,1,1>
  }
  translate (la+ep)*y
}

/*
// ------------- //
// --- Scne --- //
// ------------- //

object {Rubik rotate 180*y}
light_source {<5,6,8> rgb .5}
light_source {<-5,6,8> rgb .5}
light_source {<5,-6,8> rgb .5}
light_source {<5,6,-8> rgb .5}

camera {location <1.8,2,-3> look_at <0,0,0>}

background {<1,1,1>}
*/  
  