// Persistence of Vision Ray Tracer Scene Description File
// File: balancer.pov
// Vers: 3.6
// Desc: script for m
// Date: 24/08/05
// Auth: IMBJR
//

//==================================================
// Control

// +FN +AM2 +A0.01 -J +R2 +W1024 +H512

// POV
#version 3.6;
global_settings {
  assumed_gamma 1.0
}
      
// Scene      
#declare show_figure = on;
 

//==================================================
// Backdrop
 
background { color rgb 1  }

fog {
  fog_type   2
  distance   10
  color      rgb 1
  fog_offset 1
  fog_alt    0.2
  turbulence 2 //0.8
}

//==================================================
// Camera

camera {
  location  <-2.5, 1.25, -10>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <-2.5, 1.25,  0.0>
}

//==================================================
// Light/s

light_source {
  <0, 0, 0>  
  color rgb <1, 1, 1>
  area_light
  <1, 0, 0> <0, 0, 1> // lights spread out across this distance (x * z)
  8, 8                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate <-15, 30, -30>
}

//==================================================
// Ground
plane {
    y, 0
    texture{
        pigment {
            color rgb 1
        }
        finish {
            diffuse 0.5 
            ambient 0.5
        }
    }
}
 
//==================================================
// Figure

#if (show_figure = on)

#include "balancer_pov.inc" //Geometry

#declare od = max_extent(balancer_)-min_extent(balancer_);

#declare the_balancer = 
object {
    balancer_ 
    translate -min_extent(balancer_)
    translate -od/2
    translate <0,od.y/2,0>
    scale 2
    scale <-1,1,1>
    rotate <0,180,0>
}

object{the_balancer}

#else
    #warning "Figure not included in this render. Placeholder used\n"
    box {
        <-0.1,-0.1,-0.1>
        <0.1,3,0.1>
        pigment {color rgb <1,0.5,0.5>}
    }
#end