// Persistence of Vision Ray Tracer Scene Description File
// File: sks_peri.pov
// Vers: 3.6
// Desc: IRTC--scene file--July/August 2005 ("Minimalism")
// Date: 08/06/2005
// Auth: Copyright  2005 by Sherry K. Shaw


//------------------------------------------------------------------------------
//  "Pericynthion"
//
//  SCALE:  1 POV unit = 1 inch
//------------------------------------------------------------------------------


//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// Initialization
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

////////////////////////////////////////////////////////////////////////////////
// Scene files and settings
////////////////////////////////////////////////////////////////////////////////

//------------------------------------------------------------------------------
// Global settings
//------------------------------------------------------------------------------

//  Radiosity settings;
//    0 = No radiosity
//    1 = Save radiosity file
//    2 = Load radiosity file

#declare _RADIOSITY_MODE_ = 0 ;

global_settings {
  assumed_gamma 1.0
  #if ( _RADIOSITY_MODE_ > 0 )
    ambient_light 0
    radiosity {
      error_bound 0.4
      recursion_limit 1
      brightness 4.5
      #if ( _RADIOSITY_MODE_ = 1 )
        pretrace_start 0.08
        pretrace_end   0.01
        count 180
        nearest_count 6
        low_error_factor 0.8
        gray_threshold 0
        minimum_reuse 0.02
        adc_bailout 0.01/2
        normal off
        media off
        save_file "sks_peri.rad"
      #else
        load_file "sks_peri.rad"
        pretrace_start 1
        pretrace_end 1
        always_sample off 
      #end
    }
  #end
}


//------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------

#include "functions.inc"


////////////////////////////////////////////////////////////////////////////////
// Declarations
////////////////////////////////////////////////////////////////////////////////

//------------------------------------------------------------------------------
// The objet d'art
//------------------------------------------------------------------------------

#declare WEATHERED_WOOD_TEX =
texture {
  pigment {
    color rgb < 0.90, 0.90, 0.85 >
  }
  finish {
    ambient 0.3
    diffuse 0.6
    specular 0.25
    roughness 0.1
  }
}

#declare BOARD_FUN =
function( x, y, z ) {                                                                
  f_rounded_box( x, y, z, 0.05, 3, 5, 0.5 )
}

#declare WEATHERED_WOOD_FUN =
function( x, y, z ) {                                                             
  f_noise3d( x*20, y/15, z*20 ) - 0.5
}

#declare WEATHERED_BOARD_FUN =
function( x, y, z ) {                                                              
  BOARD_FUN ( x, y, z ) + WEATHERED_WOOD_FUN( x*2, y*2, z*2 )
}


//----------------------------------------
#if ( _RADIOSITY_MODE_ = 1 )
//----------------------------------------

#declare WEATHERED_BOARD_SHAPE_OBJ =
isosurface {
  function {
    WEATHERED_BOARD_FUN( x, y, z )
  }
  threshold 0.0
  contained_by {
    box {
      < -3.1, -5.1, -0.6 >, < 3.1, 5.1, 0.6 >
    }
  }
  accuracy 0.01
  max_gradient 8.0
}

#declare ART_OBJ =
difference {
  object {
    WEATHERED_BOARD_SHAPE_OBJ
  }
  difference {
    cylinder {
      < -0.5, 0, -3.1 >, < -0.5, 0, 3.1 >, 2
    }
    cylinder {
      < -2.0, 0, -3.1 >, < -2.0, 0, 3.1 >, 2
    }
  }
  texture {
    WEATHERED_WOOD_TEX
  }
}

//----------------------------------------
#else
//----------------------------------------

#declare CYL_1_FUN =
function( x, y, z ) {
  sqrt( pow( ( x + 0.5 ), 2 ) + pow( y, 2 ) ) - 2
}

#declare CYL_2_FUN =
function( x, y, z ) {
  sqrt( pow( ( x + 2.0 ), 2 ) + pow( y, 2 ) ) - 2
}

#declare CRESCENT_FUN =
function( x, y, z ) {                                                                 
  max( CYL_1_FUN( x, y, z ), -CYL_2_FUN( x, y, z ) )
}

#declare WEATHERED_CRESCENT_FUN =
function( x, y, z ) {                                                                 
  min( CRESCENT_FUN ( x*0.9, y*0.9, z ) + WEATHERED_WOOD_FUN( x*1.5, y*1.5, z*1.5 ),
       CRESCENT_FUN( x, y, z ) )
}

#declare CRESCENT_BOARD_FUN =
function( x, y, z ) {                                                                 
  max( WEATHERED_BOARD_FUN ( x, y, z ), -WEATHERED_CRESCENT_FUN( x, y, z ) )
}

#declare CRESCENT_BOARD_SHAPE_OBJ =
isosurface {
  function {
    CRESCENT_BOARD_FUN( x, y, z )
  }
  threshold 0.0
  contained_by {
    box {
      < -3.1, -5.1, -0.6 >, < 3.1, 5.1, 0.6 >
    }
  }
  accuracy 0.01
  max_gradient 16.0
}

#declare ART_OBJ =
object {
  CRESCENT_BOARD_SHAPE_OBJ
  texture {
    WEATHERED_WOOD_TEX
  }
} 

//----------------------------------------
#end    // #if ( _RADIOSITY_MODE_ = 1 )
//----------------------------------------


//------------------------------------------------------------------------------
// The plaque describing the objet d'art
//------------------------------------------------------------------------------

#declare PLAQUE_TEX =
texture {
  pigment {
    color rgb < 0.60, 0.30, 0.15 >
  }
  finish {
    ambient 0.15
    diffuse 0.7
    metallic
    brilliance 6
    specular 0.80
    roughness 0.05
    reflection {
      0.45
      metallic
    }
  }
}

//----------------------------------------
#if ( _RADIOSITY_MODE_ = 1 )
//----------------------------------------

#declare PLAQUE_OBJ =
box {
  < -2.5, -0.5, -0.0625 >, < 2.5, 0.5, 0.0625 >
  texture {
    PLAQUE_TEX
  }
}

//----------------------------------------
#else
//----------------------------------------

#declare INSCRIPTION_TEX =
texture {
  pigment {
    color rgb < 0.60, 0.30, 0.15 >
  }
  finish {
    ambient 0.15
    diffuse 0.7
    metallic
    brilliance 6
    specular 0.8
    roughness 0.05
  }
}

#declare LINE_1_OBJ =
text {
  ttf "LSANSD.ttf"
  "PERICYNTHION"
  1, 0
  scale < 0.1875, 0.1875, 0.05 >
}

#declare LINE_2_OBJ =
text {
  ttf "LSANSD.ttf"
  "Sherry K. Shaw, 2005"
  1, 0
  scale < 0.1875, 0.1875, 0.05 >
}

#declare LINE_3_OBJ =
text {
  ttf "LSANSD.ttf"
  "15.24 cm x 25.4 cm, weathered oak"
  1, 0
  scale < 0.1875, 0.1875, 0.05 >
}

#declare LINE_4_OBJ =
text {
  ttf "LSANSD.ttf"
  "Donated by The Ernest T. Bass Foundation"
  1, 0
  scale < 0.1875, 0.1875, 0.1 >
}

#declare INSCRIPTION_OBJ =
union {
  object {
    LINE_1_OBJ
    translate < -( max_extent( LINE_1_OBJ ).x * 0.5 ), 0, 0 >
  }
  object {
    LINE_2_OBJ
    translate < -( max_extent( LINE_2_OBJ ).x * 0.5 ), -0.2, 0 >
  }
  object {
    LINE_3_OBJ
    translate < -( max_extent( LINE_3_OBJ ).x * 0.5 ), -0.4, 0 >
  }
  object {
    LINE_4_OBJ
    translate < -( max_extent( LINE_4_OBJ ).x * 0.5 ), -0.6, 0 >
  }
}

#declare PLAQUE_OBJ =
difference {
  box {
    < -2.5, -0.5, -0.0625 >, < 2.5, 0.5, 0.0625 >
    texture {
      PLAQUE_TEX
      normal {
        bozo
        scale < 2, 1, 0.5 >
      }
    }
  }
  object {
    INSCRIPTION_OBJ
    translate < 0, ( ( max_extent(INSCRIPTION_OBJ).y + min_extent(INSCRIPTION_OBJ).y ) * -0.5 ), -0.063 >
    texture {
      INSCRIPTION_TEX
    }
  }
}

//----------------------------------------
#end    // #if ( _RADIOSITY_MODE_ = 1 )
//----------------------------------------


//------------------------------------------------------------------------------
// The room surrounding the objet d'art
//------------------------------------------------------------------------------

#declare ROOM_SHAPE_OBJ =
box {
  < -144, 0, -144 >, < 144, 144, 0 >
  hollow
}

#declare WALL_TEX =
texture {
  pigment {
    color rgb < 1.00, 1.00, 0.75 >
  }
  finish {
    ambient 0.3
    diffuse 0.6
  }
  normal {
    agate 0.04
    scale 0.75
  }
}

#declare ROOM_OBJ =
object {
  ROOM_SHAPE_OBJ
  texture {
    WALL_TEX
  }
}


//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// The Scene
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

////////////////////////////////////////////////////////////////////////////////
// Environment
////////////////////////////////////////////////////////////////////////////////

//------------------------------------------------------------------------------
// Cameras
//------------------------------------------------------------------------------

camera {
  right x*image_width/image_height
  location < 0, 64.1, -23.1 >
  look_at < 0, 64.1, 0 >
  angle 50
}


//------------------------------------------------------------------------------
// Light sources
//------------------------------------------------------------------------------

light_source {
  < -36, 120, -72 >
  color rgb < 0.37, 0.36, 0.35 >
  area_light
  < 12, 0, 0 >, < 0, 0, 12 >, 7, 7
  adaptive 0
  circular
  orient
}

#local Ix = -4.5 ;
#while ( Ix < 5 )
  #local LightColor = 0.05 + ( abs( Ix ) * 0.1 ) ;
  light_source {
    < Ix, 82.5, -6 >
    color rgb LightColor
    area_light
    < 1.5, 0, 0 >, < 0, 0, 1.5 >, 3, 3
    adaptive 0
    spotlight
    point_at < Ix, 67.5, -1 >
    radius 16
    falloff 24
  }
  #local Ix = Ix + 1.5 ;
#end

light_source {
  < 0, 36, -70 >
  color rgb < 0.31, 0.30, 0.29 >
  spotlight
  point_at < 0, 57.0, 0 >
  radius 0.075
  falloff 6.5
}


////////////////////////////////////////////////////////////////////////////////
// Items
////////////////////////////////////////////////////////////////////////////////


object {
  ART_OBJ
  translate < 0, 65, -0.51 >
}

object {
  PLAQUE_OBJ
  translate < 0, 57.0, -0.0626 >
}

object {
  ROOM_OBJ
}
