// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//                 

// Thanks to Gilles Tran  for the mkgrass and water effects.


#version 3.5;

#include "colors.inc"   
#include "shapes.inc"
#include "mgrass.pov"     


// radiosity (global illumination) settings
// radiosity (global illumination) settings

#declare use_rad=1;  // radiosity: 0=no rad, 1=load, 2=save 
#declare rad_quality = 10; // 1 = low 10 = high        
#declare useGrass = 1;       
#declare useTestTex = 0;        
#declare showBuilding = 1;


global_settings{
 assumed_gamma 1.0
 ambient_light 0.0 
 #if (use_rad)
 radiosity{ 
  // save settings: modified Outdoor settings from rad_def.inc
  #if (use_rad=2) 
    pretrace_start 0.08
    pretrace_end   0.01
    count 35*rad_quality
    nearest_count 2*rad_quality
    error_bound 0.08
    recursion_limit 2
    low_error_factor .5+(0.4*rad_quality)
    gray_threshold 0
    minimum_reuse 0.015
    brightness 1.0
    adc_bailout 0.01/2                 
    normal on
    save_file "tate.rad"      
  #else
    // load settings  
    pretrace_start 1 pretrace_end 1 
    load_file "tate.rad" 
    error_bound 0.08    // it's important to specify the same value used to save data
    recursion_limit 2  // also the same if specified
    always_sample off  // no more samples: specially useful with focal blur       
    normal on
  #end
 }
 #end
}

// ----------------------------------------


camera {
  location  <-1175.0, -450, -2200.0>
  direction 2*z
  right     x*image_width/image_height
  look_at   <0.0, 260.0,  0.0>         
  aperture 0.1           // [0...N] larger is narrower depth of field (blurrier)
  blur_samples 100        // number of rays per pixel for sampling
  focal_point <0,260,0>    // point that is in focus <X,Y,Z>
  confidence 0.975           // [0...<1] when to move on while sampling (smaller is less accurate)
  variance 1/20000            // [0...1] how precise to calculate (smaller is more accurate)
}

/*
camera {
  location  <0, 250, -1000.0>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <0.0, 250.0,  0.0>  
  rotate <0, 54, 0>
}
*/

sky_sphere { 
  pigment {
  rgb <0.5, 0.6, 1> 
  }

pigment {
    bozo
    scallop_wave
    omega 0.635
    lambda 4
    turbulence 0.275
    color_map {
      [0.0 rgbt <1, 1, 1, 1>]
      [0.9 rgbt <1, 1, 1, 1>]
      [0.97 rgbt <1, 1, 1, 0.2>]
      [0.99 rgbt <1, 1, 1, 1>]
      [1.0 rgbt <1,1,1, 1>]
    }      
    scale <4, 1, 1> 
    rotate <0, 40, 0>
  }

  pigment {
    wrinkles
    
    omega 0.625
    lambda 4
    turbulence 0.275
    color_map {
      [0.0 rgbt <1, 1, 1, 1>]
      [0.6 rgbt <1, 1, 1, 1>]
      [0.775 rgbt <1, 1, 1, 0.4>]
      [1.0 rgbt <1,1,1, 0.1>]
    }      
    scale <2, 0.2, 0.2>
    rotate <0, 40, 0>
  }  
 
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color (White+Gold)*2.5  // light's color
  area_light
  <1000, 0, 0> <0, 0, 1000> // lights spread out across this distance (x * z)
  15, 15                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 1          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate <0, 250000, 0>
  rotate <-10, 0, -10> 

  fade_distance 100000
  fade_power 2

}


 /*********************************************************************************************************************************
**************** 
****************        MKGRASS Macro written by Gilles Tran (not my own work..)
****************
*********************************************************************************************************************************/

//#declare Green1=rgb<0.4,1,0.3>*0.4;
//#declare Green2=rgb<60,160,8>/255;
#declare Green1=rgb<0.02,0.185, 0.001>;
#declare Green2=rgb<0.05,0.3,0.01>;
// --------------------------------------
// Grass texture
// --------------------------------------
#declare pigSpotted =pigment {
spotted
    color_map {
        [0.0, 0.2   color Tan*0.1 color Tan*0.4]
        [0.2, 0.3   color Tan*0.4 color Green1]
        [0.3, 1.01   color Green1 color Green1*1.2]
    }
}

#declare pigEarth =pigment {
    spotted
    color_map {
        [0 color Tan*0.3]
        [0.6 color Tan*0.3]
        [0.6 color Green1*0.4]
        [1   color Green1*0.4]
    }
}
#declare pigGreen=pigment{Green2*1.3}
//#declare pigSpotted=pigment{Red}
//#declare pigEarth=pigment{Blue}
#declare txtGrass=texture {                  

                pigment {
                        gradient y
                        turbulence 0.2
                                pigment_map {                                
                                    [0.0 pigEarth]
                                    [0.3 pigGreen]
                                    [0.9 pigSpotted]
                                    [1.00 pigEarth]
                                }
                        }

        finish{ambient 0.001 diffuse 0.4 specular 0.2 roughness 0.015}
        scale <0.001,1,0.001>
 
} 
// --------------------------------------
// Patch parameters
// --------------------------------------
// Final number of triangles = nBlade x nBlade x segBlade x 2 (or 4 if dofold = true)
// --------------------------------------
#declare lPatch=5;               // size of patch
#declare nBlade=8;                // number of blades per line (there will be nBlade x nBlade blades)
//#declare nBlade=4;                // number of blades per line (there will be nBlade x nBlade blades)
#declare ryBlade = 0;            // initial y rotation of blade
#declare segBlade= 10;            // number of blade segments
#declare lBlade = 2.5;             // length of blade
#declare wBlade = 0.2;            // width of blade at start
#declare wBladeEnd = 0.01;         // width of blade at the end
#declare doSmooth=true;          // true makes smooth triangles
#declare startBend = <0,1,0.3>;   // bending of blade at start (<0,1,0>=no bending)
#declare vBend = <0,1,0>;         // force bending the blade (<0,1,1> = 45)
#declare pwBend = 4;              // bending power (how slowly the curve bends)
#declare rd = 459;                // seed
#declare stdposBlade = 1;         // standard deviation of blade position 0..1
#declare stdrotBlade = 360;       // standard deviation of rotation
#declare stdBlade = 1.2;           // standard deviation of blade scale
#declare stdBend = 3;            // standard deviation of blade bending
#declare dofold = true;          // true creates a central fold in the blade (twice more triangles)
#declare dofile = true;          // true creates a mesh file
#declare fname = "tateGrass.inc"     // name of the mesh file to create



// --------------------------------------
// Prairie parameters
// --------------------------------------
#declare nxPrairie=65;             // number of patches for the first line
#declare addPatches=0;            // number of patches to add at each line
#declare nzPrairie=46;             // number of lines of patches
#declare rd=seed(779);            // random seed
#declare stdscale=1;              // stddev of scale
#declare stdrotate=1;             // stddev of rotation
#declare doTest=false;            // replaces the patch with a sphere

// --------------------------------------
// Create the patch and the prairie
// --------------------------------------
#if(useGrass)    
#if (dofile=true) // if the patch is already created, turn off the next line
//       MakeGrassPatch(lPatch,nBlade,ryBlade,segBlade,lBlade,wBlade,wBladeEnd,doSmooth,startBend,vBend,pwBend,rd,stdposBlade,stdrotBlade,stdBlade,stdBend,dofold,dofile,fname)
        #declare objectPatch=#include fname
#else        
        #declare objectPatch=object{MakeGrassPatch(lPatch,nBlade,ryBlade,segBlade,lBlade,wBlade,wBladeEnd,doSmooth,startBend,vBend,pwBend,rd,stdposBlade,stdrotBlade,stdBlade,stdBend,dofold,dofile,fname)}
#end        


                        //box { <-170, -1, 0> <155, 1, 230> }


// Grass on balcony side

#declare tateGrass = union
{ 
        object{MakePrairie(lPatch,nxPrairie,addPatches,nzPrairie,objectPatch,rd,stdscale,stdrotate,doTest)
        texture{txtGrass } 
        }


} 

#end


#declare cementThickness = 0.1;

#if(useTestTex)
#declare cementTex = texture
{
        pigment 
        { 
                rgb <0.8, 0.75, 0.4>
        }
        finish { ambient 0 }
        normal { granite 0.25 scale 0.1 }
}                      

#declare glassBrickTex = texture
        {
                pigment { rgbf <0.8, 0.925, 0.8, 0.95> }
                finish { ambient 0 diffuse 0 }      
                normal { dents scale 5 }
        }
#else                
#declare glassBrickTex = material
{
        texture
        {
                pigment { rgbf <0.8, 0.925, 0.8, 0.95> }
                finish { ambient 0 diffuse 0 specular 0.4 roughness 0.025 reflection { 0.025, 0.1 fresnel on } conserve_energy }
                normal { dents scale 4 }
        }
        interior
        {
                ior 1.65      
        }
}
#declare cementTex = texture
{
        pigment 
        { 
                granite                                                                 
                omega 0.6
                turbulence 0.3
                colour_map { [ 0 rgb <0.8, 0.75, 0.4> ] [ 1 rgb <0.9, 0.88, 0.4> ] }    
                scale 0.1
        }
        finish { ambient 0 }
        normal { granite 0.25 scale 0.1 }
}                      
#end
                

#declare glassBrick = union
{       
        // cement
        difference
        {
                box { <-1, -1, 0.1> <1, 1, 0.9> } 
                box { <-1+cementThickness, -1+cementThickness, 0> <1-cementThickness, 1-cementThickness, 1.1> } 
                texture  { cementTex }
        }       
        // glass
        union
        {
                box { <-1+cementThickness, -1+cementThickness, 0> <1-cementThickness, 1-cementThickness, 0.2> }
                box { <-1+cementThickness, -1+cementThickness, 0.9> <1-cementThickness, 1-cementThickness, 1> }
                #if(useTestTex)
                        texture { glassBrickTex }
                #else
                        material { glassBrickTex }
                #end
        }      
}  

#macro placeBricks(w, h)
        #declare bw = w/6;
        #declare by = 0;
        #while(by < h-bw)
                #declare bx = -bw*2;
                #while(bx < bw*3)
                        object { glassBrick scale bw translate <bx, by+bw, 0> }
                        #declare bx=bx+(bw*2);
                #end                      
                #declare by=by+(bw*2);                
        #end                          
        // add Cement around whole window             
        union
        {
                box { <-(w/2)-1, -1, 0.1> <-(w/2), by+1, 0.9> }
                box { <(w/2), -1, 0.1> <(w/2)+1, by+1, 0.9> }
                box { <(-(w/2))-1, -1, 0.1> <(w/2)+1, 0, 0.9> }
                box { <-(w/2)-1, by, 0.1> <(w/2)+1, by+1, 0.9> }    
                texture { cementTex  } 
                scale <1, 1, bw>
        }
#end

#declare WhiteStone = texture {
        pigment { White }
        finish { phong 0.0 ambient 0 } 

        normal 
        { 
                average 
                normal_map
                {
                        [ 0.2 wrinkles 0.3 scale 2.0 ] 
                        [ 0.1 granite 0.1 scale .5 ]
                }
        }       
        
}

#declare SmoothWhiteStone = texture {
        pigment { White }
        finish { phong 0.3 ambient 0 }         
}

#declare InteriorWhitePaint = texture {
        pigment { White }
        finish { phong 0.3 ambient 0 }         
} 


#declare railSection = union     // wall attached hand rail
{
        cylinder { <0, 0, 0> <0, 0, 60> 2.5 }     
        sphere { <0, 0, 60> 2.5 } 
        sphere { <0, 0, 0> 2.5 }   
        
        // bracket        
        cylinder { <0, 0, 27.5> <0, 0, 32.5> 3 }   
        union
        {
                Round_Box_Union(<0, -0.75, -2>, <10, 0.75, 2>, 0.15)
                Round_Cylinder_Union(<9, 0, 0>, <15, 0, 0>, 5, 1)        
                translate <0, 0, 30>
        }

} 

#if(useTestTex)
#declare handRailTex = texture
{
        pigment { rgb <0.2, 0.2, 0.2> }
        finish { ambient 0 diffuse 0.4 }
}
#else
#declare handRailTex = texture
{
        pigment { rgb <0.2, 0.2, 0.2> }
        finish { specular 0.9 roughness 0.01 ambient 0 diffuse 0.4 brilliance 4 metallic reflection 0.55 }
}
        
#end

#declare HandRail = union
{
        //cylinder { <0, 0, 0> <0, 500, 0> 2 } 
        object { railSection }
        object { railSection 
                rotate <-45, 0, 0>
                translate <0, 0, 60>
        }   
        object { railSection 
                rotate <45, 0, 0>
                translate <0, 0, 60>  
                rotate <-45, 0 ,0>
                translate <0, 0, 60>
        }   
        object { railSection 
                rotate <-45, 0, 0>
                translate <0, 0, 60>  
                rotate <45, 0, 0>
                translate <0, 0, 60>  
                rotate <-45, 0 ,0>
                translate <0, 0, 60>
        }   
        object { railSection 
                rotate <45, 0, 0>
                translate <0, 0, 60>  
                rotate <-45, 0, 0>
                translate <0, 0, 60>  
                rotate <45, 0, 0>
                translate <0, 0, 60>  
                rotate <-45, 0 ,0>
                translate <0, 0, 60>
        }
        object { railSection 
                rotate <-45, 0, 0>
                translate <0, 0, 60>  
                rotate <45, 0, 0>
                translate <0, 0, 60>  
                rotate <-45, 0, 0>
                translate <0, 0, 60>  
                rotate <45, 0, 0>
                translate <0, 0, 60>  
                rotate <-45, 0 ,0>
                translate <0, 0, 60>
        }   
        object { railSection 
                rotate <45, 0, 0>
                translate <0, 0, 60>  
                rotate <-45, 0, 0>
                translate <0, 0, 60>  
                rotate <45, 0, 0>
                translate <0, 0, 60>  
                rotate <-45, 0, 0>
                translate <0, 0, 60>  
                rotate <45, 0, 0>
                translate <0, 0, 60>  
                rotate <-45, 0 ,0>
                translate <0, 0, 60>
        }                
        texture { handRailTex }
}   


#declare midRailSection = union     // wall attached hand rail
{
        cylinder { <0, 0, 0> <0, 0, 60> 2.5 }     
        sphere { <0, 0, 60> 2.5 } 
        sphere { <0, 0, 0> 2.5 }   
        
        // bracket        
        cylinder { <0, 0, 5> <0, 0, 10> 3 }   
        cylinder { <0, 0, 50> <0, 0, 55> 3 }   
        Round_Box_Union(<-1, -180, 7>, <1, 0, 8>, 0.15)   
        Round_Box_Union(<-1, -180, 52>, <1, 0, 53>, 0.15)          

}

#declare midRailSectionSloped = union     // wall attached hand rail
{
        cylinder { <0, 0, 0> <0, 0, 60> 2.5 }     
        sphere { <0, 0, 60> 2.5 } 
        sphere { <0, 0, 0> 2.5 }   
}

#declare middleHandRail = union
{
        object { midRailSection }
        object { midRailSectionSloped 
                rotate <-45, 0, 0>
                translate <0, 0, 60>
        }   
        object { midRailSection 
                rotate <45, 0, 0>
                translate <0, 0, 60>  
                rotate <-45, 0 ,0>
                translate <0, 0, 60>
        }   
        object { midRailSectionSloped 
                rotate <-45, 0, 0>
                translate <0, 0, 60>  
                rotate <45, 0, 0>
                translate <0, 0, 60>  
                rotate <-45, 0 ,0>
                translate <0, 0, 60>
        }   
        object { midRailSection 
                rotate <45, 0, 0>
                translate <0, 0, 60>  
                rotate <-45, 0, 0>
                translate <0, 0, 60>  
                rotate <45, 0, 0>
                translate <0, 0, 60>  
                rotate <-45, 0 ,0>
                translate <0, 0, 60>
        }
        object { midRailSectionSloped 
                rotate <-45, 0, 0>
                translate <0, 0, 60>  
                rotate <45, 0, 0>
                translate <0, 0, 60>  
                rotate <-45, 0, 0>
                translate <0, 0, 60>  
                rotate <45, 0, 0>
                translate <0, 0, 60>  
                rotate <-45, 0 ,0>
                translate <0, 0, 60>
        }   
        object { midRailSection 
                rotate <45, 0, 0>
                translate <0, 0, 60>  
                rotate <-45, 0, 0>
                translate <0, 0, 60>  
                rotate <45, 0, 0>
                translate <0, 0, 60>  
                rotate <-45, 0, 0>
                translate <0, 0, 60>  
                rotate <45, 0, 0>
                translate <0, 0, 60>  
                rotate <-45, 0 ,0>
                translate <0, 0, 60>
        }   
        texture { handRailTex }
}

#declare Bolt = sphere 
{ 
        <0, 0, 0> 1.1 scale <1, 1, 0.6> 
        texture 
        {
                pigment 
                {
                        wood
                        color_map 
                        {
                                [ 0.0 rgb <0.2, 0.2, 0.2> ]
                                [ 1.0 rgb <0.5, 0.5, 0.5> ]
                        }
                        scale 0.02 
                }                 
                finish { ambient 0 specular 1 roughness 0.01 metallic brilliance 3 reflection 0.02 }
        }
}

#declare balconySection = union
{
        union
        {
                Round_Box_Union(<-50, 20, 0>, <50, 80, 1>, 0.25)
                #if(useTestTex)
                        texture
                        {
                                pigment { rgbf <0.9, 0.925, 0.9, 0.9> }
                                finish { ambient 0 diffuse 0 }
                        }
                #else                
                material
                {
                        texture
                        {
                                pigment { rgbf <0.95, 0.975, 0.95, 0.99> }
                                finish { ambient 0 diffuse 0 specular 0.8 roughness 0.005 reflection { 0.05, 0.25 fresnel on } conserve_energy }
                        }
                        interior
                        {
                                ior 1.5      
                        }
                }
                #end
                
        }       
        union
        {
                Round_Box_Union(<-58, 0, -1>, <-53, 90, 3>, 0.5)
                Round_Box_Union(<53, 0, -1>, <58, 90, 3>, 0.5)
                
                // left side brackets
                Round_Box_Union(<-58, 32, -1>, <-45, 36, 0>, 0.1)
                Round_Box_Union(<-58, 32, 1>, <-45, 36, 2>, 0.1)

                Round_Box_Union(<-58, 64, -1>, <-45, 68, 0>, 0.1)
                Round_Box_Union(<-58, 64, 1>, <-45, 68, 2>, 0.1)
                
                // bolts
                object { Bolt translate <-47, 34, -1> }
                object { Bolt translate <-47, 34, 2> }

                object { Bolt translate <-47, 66, -1> }
                object { Bolt translate <-47, 66, 2> }
                
               
                // right side brackets
                Round_Box_Union(<45, 32, -1>, <58, 36, 0>, 0.1)
                Round_Box_Union(<45, 32, 1>, <58, 36, 2>, 0.1)

                Round_Box_Union(<45, 64, -1>, <58, 68, 0>, 0.1)
                Round_Box_Union(<45, 64, 1>, <58, 68, 2>, 0.1)
                
                // bar across top
                Round_Cylinder_Union(<-60, 90, 1>, <60, 90, 1>, 2.5, 1)

                // bolts
                object { Bolt translate <47, 34, -1> }
                object { Bolt translate <47, 34, 2> }

                object { Bolt translate <47, 66, -1> }
                object { Bolt translate <47, 66, 2> }
                
                #if(useTestTex)
                        texture
                        {
                                pigment { rgb <0.2, 0.2, 0.2> }
                                finish { ambient 0 diffuse 0.4 }
                        }
                #else
                        texture
                        {
                                pigment { rgb <0.2, 0.2, 0.2> }
                                finish { specular 0.9 roughness 0.01 ambient 0 diffuse 0.4 brilliance 4 metallic reflection 0.55 }
                        }
                
                #end
        }
}

#declare innerSection = difference
{
        //box { <-100, -200, 0> <100, 700, 2500> }
        cylinder { <0, -200, 0> <0, 800, 0> 2500 } 
        box { <-3000, -201, -3000> <0, 801, 3000> rotate <0, -6, 0> }
        box { <0, -201, -3000> <3000, 801, 3000> rotate <0, 6, 0> }     
        
        // temp let some light in 
        box { <-50, 0, 1000> <50, 900, 2000> }
        // end temp   
        cylinder { <0, -100, 0> <0, 500, 0> 2450 }
        cylinder { <0, 499, 0> <0, 750, 0> 900 }
        cylinder { <0, 599, 0> <0, 801, 0> 499.9 }
        
        difference
        {
                cylinder { <0, 499, 0> <0, 750, 0> 2450 }
                cylinder { <0, 498, 0> <0, 751, 0> 935 }                        
        }                                               
        
        // windows
        box { <-12, -12, -10> <12, 12, 40> translate <0, 550, 900> rotate <0, -2.5, 0> }
        box { <-12, -12, -10> <12, 12, 40> translate <0, 550, 900> rotate <0, 2.5, 0> }
        bounded_by { box { <-300, -200, 0> <300, 800, 2500> }  }
        texture { InteriorWhitePaint }
               
}


#if(showBuilding)
union
{                             
        // top of round roof  

        difference
        {
                cylinder { <0, -0.01, 0> <0, 110, 0> 500 translate <0, 500, 0> }  
                cylinder { <0, -0.02, 0> <0, 0, 0> 500.1 translate <0, 500, 0> texture { SmoothWhiteStone } }   
                difference
                {       
                        cylinder { <0, -1, 0> <0, 75, 0> 480 translate <0, 500, 0> }
                        cylinder { <0, -1.1, 0> <0, 75.1, 0> 400 translate <0, 500, 0> }
                }   
                difference
                {       
                        cylinder { <0, -1, 0> <0, 75, 0> 380 translate <0, 500, 0> }
                        cylinder { <0, -1.1, 0> <0, 75.1, 0> 300 translate <0, 500, 0> }
                }   
                cylinder { <0, -1.1, 0> <0, 30, 0> 280 translate <0, 500, 0> }
                cylinder { <0, -1.1, 0> <0, 35, 0> 275 translate <0, 500, 0> }
                cylinder { <0, -1.1, 0> <0, 40, 0> 270 translate <0, 500, 0> }
                cylinder { <0, -1.1, 0> <0, 45, 0> 265 translate <0, 500, 0> }
                cylinder { <0, -1.1, 0> <0, 111, 0> 260 translate <0, 500, 0> }
        }                                

        // dome part

        difference
        {
                sphere { <0, 0, 0> 260.001 }
                union
                {
                        box { <-261, -261, -261> <261, 0, 261> }                
                        sphere { <0, 0, 0> 255 }     
                        cylinder { <0, 0, 0> <0, 261, 0> 85 }
                } 
                scale <1, 0.75, 1>
                translate <0, 545, 0>   
        }   
        
        // roof bottom trim part
        union
        {
                difference
                {
                        cylinder { <0, 0, 0> <0, 15, 0> 508 }
                        cylinder { <0, -0.1, 0> <0, 15.1, 0> 499.999 }
                        torus { 508, 5 translate <0, 15, 0> }           
                }
                torus { 508, 5 translate <0, 5, 0>}                           
                translate <0, 500, 0> 
                texture { SmoothWhiteStone }   
        }
        // roof top trim part
        union
        {
                difference
                {
                        cylinder { <0, 0, 0> <0, 15, 0> 508 }
                        cylinder { <0, -0.1, 0> <0, 15.1, 0> 499.999 }
                        torus { 508, 5 }           
                }
                torus { 508, 5 translate <0, 10, 0>}                           
                translate <0, 595, 0> 
                texture { SmoothWhiteStone }   
        }   
        
         
        // lower part of circular building
        union
        {
                // beams going in circular roof
                union
                {
                        union  // beam at left side that merges with wall
                        {
                                Round_Box_Union(<-499.9, 0.001, -15>, <-280.01, 100, 15>, 0.1)  
                                rotate <0, 30, 0>
                        }  
                        union  // beam at right side that merges with wall
                        {
                                Round_Box_Union(<-499.9, 0.001, -15>, <-280.01, 100, 15>, 0.1)  
                                rotate <0, -133, 0>
                        }  
                        
                        union  // beams at top of left side pillars
                        {
                                Round_Box_Union(<-499.9, 0.001, -12.5>, <-280.01, 100, 12.5>, 0.1)  
                                rotate <0, -2, 0>
                        } 
                        union
                        {
                                Round_Box_Union(<-499.9, 0.001, -12.5>, <-280.01, 100, 12.5>, 0.1)  
                                rotate <0, -12, 0>
                        }                              
                        union  // beams at top of right side pillars
                        {
                                Round_Box_Union(<-499.9, 0.001, -12.5>, <-280.01, 100, 12.5>, 0.1)  
                                rotate <0, -92, 0>
                        } 
                        union
                        {
                                Round_Box_Union(<-499.9, 0.001, -12.5>, <-280.01, 100, 12.5>, 0.1)  
                                rotate <0, -102, 0>
                        }                              
                        // smaller higher beams
                        union
                        {
                                Round_Box_Union(<-499.9, 20, -10>, <-280.01, 100, 10>, 0.1)  
                                rotate <0, -38.6, 0>
                        }                              
                        union
                        {
                                Round_Box_Union(<-499.9, 20, -10>, <-280.01, 100, 10>, 0.1)  
                                rotate <0, -65.2, 0>
                        }                              
                        
                        translate <0, 500, 0>
                        texture { SmoothWhiteStone }   
                }

                difference
                {
                        cylinder { <0, -400, 0> <0, 100, 0> 400 } 
                        cylinder { <0, -75, 0> <0, 101, 0> 370 }
                        box { <-410, -75, 0> <410, 101, 401> }
                        box { <-410, -75, 0> <410, 101, 401> rotate <0, 75, 0> } // cut right side entrance
                }    
                difference
                {
                        cylinder { <0, 95, 0> <0, 100, 0> 408 } 
                        cylinder { <0, 89, 0> <0, 101, 0> 370 }
                        box { <-410, 88, 5> <410, 102, 410> } 
                        box { <-410, 88, 5> <410, 102, 410> rotate <0, 75, 0> } // cut right side entrance
                        texture { SmoothWhiteStone } 
                }    
                // pillars with glass squares
                // left side
                object { Round_Box_Union(<-400, 99.999, -12.5>, <-375, 500.001, 12.5>, 0.1) rotate <0, -2, 0> }
                object { Round_Box_Union(<-400, 99.999, -12.5>, <-375, 500.001, 12.5>, 0.1) rotate <0, -12, 0> }
                // bars across

                difference
                {
                        object { Round_Box_Union(<-398, 231.666-5, -40>, <-380, 231.666+5, 30>, 0.1) }
                        cylinder { <-398, 231.666, -41> <-398, 231.666, 41> 2.5 } 
                        rotate <0, -7, 0>  
                }
                difference
                {
                        object { Round_Box_Union(<-398, 368.333-5, -40>, <-380, 368.333+5, 30>, 0.1) } 
                        cylinder { <-398, 368.333, -41> <-398, 368.333, 41> 2.5 } 
                        rotate <0, -7, 0>  
                }   

                // place glass brick windows
                union { placeBricks(42, 133.333-5) rotate <0, 90, 0> translate <-390, 100.25, 0> rotate <0, -7, 0> }
                union { placeBricks(42, 133.333-5) rotate <0, 90, 0> translate <-390, 231.91+5, 0> rotate <0, -7, 0> }
                union { placeBricks(42, 133.333-5) rotate <0, 90, 0> translate <-390, 368.58+5, 0> rotate <0, -7, 0> }

                // right side
                object { Round_Box_Union(<-400, 99.999, -12.5>, <-375, 500.001, 12.5>, 0.1) rotate <0, -92, 0> }
                object { Round_Box_Union(<-400, 99.999, -12.5>, <-375, 500.001, 12.5>, 0.1) rotate <0, -102, 0> }
                // bars across
                difference
                {
                        object { Round_Box_Union(<-398, 231.666-5, -40>, <-380, 231.666+5, 30>, 0.1) } 
                        cylinder { <-398, 231.666, -41> <-398, 231.666, 41> 2.5 } 
                        rotate <0, -97, 0>  
                }
                difference
                {
                        object { Round_Box_Union(<-398, 368.333-5, -40>, <-380, 368.333+5, 30>, 0.1) } 
                        cylinder { <-398, 368.333, -41> <-398, 368.333, 41> 2.5 } 
                        rotate <0, -97, 0>  
                }

                // place glass brick windows
                union { placeBricks(42, 133.333-5) rotate <0, 90, 0> translate <-390, 100.25, 0> rotate <0, -97, 0> }
                union { placeBricks(42, 133.333-5) rotate <0, 90, 0> translate <-390, 231.91+5, 0> rotate <0, -97, 0> }
                union { placeBricks(42, 133.333-5) rotate <0, 90, 0> translate <-390, 368.58+5, 0> rotate <0, -97, 0> }

                
                rotate <0, -30, 0>
        } 
                // wall at top of right side steps
        union
        {
                box { <-1075, -400, -245> <-435, 50, -215> }   
                Round_Box_Union(<-1075, 45, -250> <-435, 55, -210>, 0.15)   
                
                rotate <0, -137, 0>                 
//                pigment { Blue }
        
        }
  
        
        // steps
        union   
        {
                // Left side steps
                // wall attached to building
                box { <-515, -400, -200> <-320, 5, -160> }  
                Round_Box_Union(<-515, 5, -205> <-320, 15, -155>, 0.15 )

                // stepped wall  
                union
                {
                        box { <-20, 0, 0> <20, 300, 100> }
                        Round_Box_Union(<-25, 300, -5> <25, 310, 100>, 0.15)
                        translate <-500, -275, -260>
                }
                union
                {
                        box { <-20, 0, 0> <20, 300, 100> }
                        Round_Box_Union(<-25, 300, -5> <25, 310, 100>, 0.15)
                        translate <-500, -325, -360>
                }
                union
                {
                        box { <-20, 0, 0> <20, 300, 100> }
                        Round_Box_Union(<-25, 300, -5> <25, 310, 100>, 0.15)
                        translate <-500, -375, -460>
                }
                union
                {
                        box { <-20, 0, 0> <20, 300, 150> }
                        Round_Box_Union(<-25, 300, -5> <25, 310, 150>, 0.15)
                        translate <-500, -425, -610>
                } 
                
                // steps
                union
                {      
                        // first flight
                        #declare sc = 0;
                        #while(sc < 9)
                               // object { Round_Box_Union(<-550, -200, -25>, <150, 0, 125>, 0.1) translate <-650, -375+(sc*20), -550+(sc*50)> }
                                intersection
                                {
                                        union
                                        {
                                                object { Round_Cylinder_Union(<150, -200, 525>, <150, 0, 525>, 500, 0.1) translate <-650, -375+(sc*20), -600+(sc*50)> }
                                                object { Round_Cylinder_Union(<150, -5, 525>, <150, 0.1, 525>, 502.5, 0.1) translate <-650, -375+(sc*20), -600+(sc*50)> }
                                        }
                                        box { <-1150, -201, -35>, <150, 1, 325> translate <-650, -375+(sc*20), -600+(sc*50)> }
                                }
                                #declare sc=sc+1;
                        #end 
                        // second flight
                        #declare sc = 0;
                        #while(sc < 6)
                                object { Round_Box_Union(<150, -200, -160>, <250, 0, 125>, 0.1) translate <-665+(sc*25), -195+(sc*20), 0> }
                                object { Round_Box_Union(<145, -5, -160>, <250, 0.1, 125>, 0.1) translate <-665+(sc*25), -195+(sc*20), 0> }
                                #declare sc=sc+1;
                        #end
                        
                        // Stair rail at right side of steps
                        object
                        {
                                HandRail 
                                translate <-530, -300, -575>
                                
                        }   
                        // Stair rail in middle of steps                        
                        object 
                        {       
                                middleHandRail
                                translate <-675, -300, -515>     
                                
                        }
                        

                } 
                
                // right side steps
                union
                {
                        // wall attached to building
                        box { <-515, -400, -20> <-320, 5, 20> }  
                        Round_Box_Union(<-515, 5, -25> <-320, 15, 25>, 0.15 )
        
                        // stepped wall  
                        union
                        {
                                box { <-20, 0, 0> <20, 300, 100> }
                                Round_Box_Union(<-25, 300, -5> <25, 310, 100>, 0.15)
                                translate <-500, -275, -20>
                        }
                        union
                        {
                                box { <-20, 0, 0> <20, 300, 100> }
                                Round_Box_Union(<-25, 300, -5> <25, 310, 100>, 0.15)
                                translate <-500, -325, 80>
                        }
                        union
                        {
                                box { <-20, 0, 0> <20, 300, 100> }
                                Round_Box_Union(<-25, 300, -5> <25, 310, 100>, 0.15)
                                translate <-500, -375, 180>
                        }
                        union
                        {
                                box { <-20, 0, 0> <20, 300, 150> }
                                Round_Box_Union(<-25, 300, -5> <25, 310, 150>, 0.15)
                                translate <-500, -425, 280>
                        } 
                        
                        // stepped wall at right side of right stepsl  
                        union
                        {
                                box { <-20, 0, 0> <20, 300, 300> }
                                Round_Box_Union(<-25, 300, -5> <25, 310, 300>, 0.15)
                                translate <-1010, -275, -220>
                        }
                        union
                        {
                                box { <-20, 0, 0> <20, 300, 100> }
                                Round_Box_Union(<-25, 300, -5> <25, 310, 100>, 0.15)
                                translate <-1010, -325, 80>
                        }
                        union
                        {
                                box { <-20, 0, 0> <20, 300, 100> }
                                Round_Box_Union(<-25, 300, -5> <25, 310, 100>, 0.15)
                                translate <-1010, -375, 180>
                        }
                        union
                        {
                                box { <-20, 0, 0> <20, 300, 150> }
                                Round_Box_Union(<-25, 300, -5> <25, 310, 150>, 0.15)
                                translate <-1010, -425, 280>
                        } 
                        

                        // steps
                        union
                        {      
                                // first flight
                                #declare sc = 0;
                                #while(sc < 9)
                                        object { Round_Box_Union(<-350, -200, -95>, <150, 0, 125>, 0.1) translate <-650, -375+(sc*20), 280-(sc*50)> }
                                        object { Round_Box_Union(<-350, -5, -95>, <150, 0.1, 130>, 0.1) translate <-650, -375+(sc*20), 280-(sc*50)> }
                                        #declare sc=sc+1;
                                #end 
                                // second flight
                                #declare sc = 0;
                                #while(sc < 6)
                                        object { Round_Box_Union(<150, -200, -250>, <250, 0, -20>, 0.1) translate <-665+(sc*25), -195+(sc*20), 0> }
                                        object { Round_Box_Union(<145, -5, -250>, <250, 0.1, -20>, 0.1) translate <-665+(sc*25), -195+(sc*20), 0> }
                                        #declare sc=sc+1;
                                #end
        
                          //      pigment { Orange }
                        } 
                        translate <-40, 0, 0>
                        rotate <0, -137, 0>
                } 
                // left side steps hand rail
                object
                {
                        HandRail                      
                        scale <-1, 1, 1>   
                        rotate <0, 180, 0>
                        translate <-570, -300, 400>
                        rotate <0, -137, 0> 
                        //rotate <0, 43, 0> 
                        //translate <150, -300, -1320>
                        
                        texture { handRailTex }
                }   
                // right side hand rail
                object
                {
                        HandRail  
//                        rotate <0, 43, 0> 
//                        translate <150, -300, -670>
                        rotate <0, 180, 0>
                        translate <-1020, -300, 400>
                        rotate <0, -137, 0> 
                        
                        texture { handRailTex }
                }   
                // middle hand rail
                object 
                {       
                        middleHandRail 
                        rotate <0, 180, 0>
                        translate <-795, -300, 400>     
                        rotate <0, -137, 0> 
                        
                        texture { handRailTex }
                }

             

//                pigment { Yellow }
        }                                               
        
        
        // Left side wall
        union
        {
                difference
                {
                        box { <-400, -400, 0> <0, 800, 200> }
                
                        box { <0, 0, -1> <600, 300, 201> rotate <0, 0, -20> translate <-350, 800, 0> }   
                        cylinder { <-1000, -1, 100> <-1000, 801, 100> 610 }  
                        
                }                  
                // add trim to top of roof
                // top straight bit
                union
                {       
                        difference
                        {
                                union
                                {
                                        difference
                                        {
                                                box { <-418, 785, -8> <-345, 800, 0.01> }
                                                cylinder { <-419, 785, -8> <-344, 785, -8> 5 }
                                        }
                                        cylinder { <-418, 795, -8> <-345, 795, -8> 5 } 
                                }
                                union
                                {
                                        box { <-25, -1, 0> <25, 16, 25> rotate <0, -41.0, 0> translate <-398.5, 785, 0> } 
                                        box { <0, -1, -19> <10, 20, 1> rotate <0, 0, -10> translate <-350, 785, 0> }
                                }
                        }
                }  
                // other side top straight bit                                                   
                union
                {       
                        difference
                        {
                                union
                                {
                                        difference
                                        {
                                                box { <-418, 785, -0.01> <-350, 800, 8> }
                                                cylinder { <-419, 785, 8> <-349, 785, 8> 5 }
                                        }
                                        cylinder { <-418, 795, 8> <-350, 795, 8> 5 } 
                                }
                                union
                                {
                                        box { <-25, -1, -25> <25, 16, 0> rotate <0, 41.0, 0> translate <-398.5, 785, 0> }                                         
                                }                                                                                      
                                translate <0, 0, 200>
                        }
                }     
                // long straight slope part
                union
                {       
                        difference
                        {    
                                union
                                {
                                        difference
                                        {
                                                box { <-5, 0, -8> <370, 15, 0.01> }
                                                cylinder { <-6, 0, -8> <371, 0, -8> 5 } 
                                        }
                                        cylinder { <-5, 10, -8> <370, 10, -8> 5 }
                                        rotate <0, 0, -20>
                                        translate <-350, 785, 0>
                                }
                                box { <-10, -1, -19> <0, 20, 1> rotate <0, 0, -10> translate <-350, 785, 0> }

                        }
                        
                }                                                

                // curved part
                difference
                {
                        intersection
                        {       
                                union
                                {
                                        difference
                                        {
                                                cylinder { <-1000, 0, 0> <-1000, 15, 0> 610.1 }
                                                cylinder { <-1000, -0.1, 0> <-1000, 15.1, 0> 602 }
                                                torus { 602, 5 translate <-1000, 0, 0> }
                                                translate <0, 0, 100>
                                        }                                            
                                        torus { 602, 5 translate <-1000, 10, 100> }                        
                                }
                                box { <-418, -1, -18> <-350, 16, 218> }
                                translate <0, 785, 0>        
                        }

                        union
                        {
                                box { <-25, -1, -25> <25, 16, 0> rotate <0, -41.0, 0> translate <-398.5, 785, 0> }
                                box { <-25, -1, 0> <25, 16, 25> rotate <0, 41.0, 0> translate <-398.5, 785, 200> }
                        }      
                        translate <0.5, 0, 0>
                }    
                // lower wall at side of steps
                difference
                {
                        cylinder { <0, 0, 0> <0, 550, 0> 500 translate <-900, -500, 0> }
                        cylinder { <0, -1, 0> <0, 551, 0> 480 translate <-900, -500, 0> }
                }                        
                difference
                {
                        cylinder { <0, 550, 0> <0, 560, 0> 505 translate <-900, -500, 0> }
                        cylinder { <0, 549, 0> <0, 561, 0> 475 translate <-900, -500, 0> }
                }
                translate <-380, 0, 0> // move the left wall into position
                rotate <0, 0, 0>
        }   
        
        // right side wall  
        union
        {
                difference
                {
                        box { <-120, -400, -100>, <0, 800, 2500> rotate <0, 20, 0> }
                        box { <-150, -401, -200>, <100, 801, 0> }
                        box { <-200, 0, -200> <200, 500, 3000> rotate <-20, 20, 0> translate <0, 625, 0>}
                }     
                // add trim
                union
                {            
                        // slope part
                        difference
                        {
                                union
                                {
                                        difference
                                        {
                                                box { <0, -15, -100> <8, 0, 530> }
                                                cylinder { <8, -15, -101> <8, -15, 531> 5 }
                                        }
                                        cylinder { <8, -5, -100> <8, -5, 530> 5 }   
                                        rotate <-20, 20, 0>   
                                        translate <0, 625, 0>
                                }                                              
                                union
                                {
                                        box { <-150, -201, -200>, <100, 801, 0> }   
                                        box { <-20, -30, 0> <20, 20, 20> rotate <20, -20, 0> translate <0, 0, 509> 
                                                rotate <-20, 20, 0> translate <0, 625, 0> 
                                                }
                                }
                        }      
                        // straight part
                        union
                        {
                                difference
                                {       
                                        union
                                        {
                                                difference
                                                {
                                                        box { <0, -15, 480> <8, 0, 590> }
                                                        cylinder { <8, -15, 479> <8, -15, 591> 5 }
                
                                                }
                                                cylinder { <8, -5, 480> <8, -5, 590> 5 }   
                                                rotate <0, 20, 0>   
                                                translate <0, 800, 0>
                                        }
                                        box 
                                        { 
                                                <-20, -30, -20> <20, 20, 0> rotate <20, -20, 0> translate <0, 0, 509> 
                                                rotate <-20, 20, 0> translate <0, 625, 0> 
                                        }
                                }
                        }   
                        texture { SmoothWhiteStone }
                }  
                           
                translate <500, 0, 0> 
                rotate <0, 16, 0>
        }
        
        // inner wall section
        union
        {
                object { innerSection rotate <0, -24, 0>}
                object { innerSection rotate <0, -12, 0> }
                object { innerSection }
                object { innerSection rotate <0, 12, 0> }
                object { innerSection rotate <0, 24, 0> }
                object { innerSection rotate <0, 36, 0> }
                object { innerSection rotate <0, 48 0> }
                object { innerSection rotate <0, 60 0> }  
                
                // outside walls of inner section                     
                

                union
                {
                        Round_Box_Union(<0, -200, 880>, <30, 800, 2500>, 0.1) 
                         
                        rotate <0, 66, 0>
                }    
                // trim
                union
                {    
                        union
                        {
                                difference
                                {
                                        box { <30, -15, 885> <38, 0, 2500> }
                                        cylinder { <38, -15, 879> <38, -15, 2501> 5 }

                                }
                                cylinder { <38, -5, 885> <38, -5, 2500> 5 }   
                                rotate <0, 66, 0>
                        }
                        translate <0, 800, 0>    
                        
                        texture { SmoothWhiteStone }
                }   
                
                // left side wall
                union
                {
                        Round_Box_Union(<0, -200, 500>, <30, 800, 2500>, 0.1) 
                         
                        rotate <0, -30, 0>
                        
                }

                // trim
                union
                {    
                        union
                        {
                                difference
                                {
                                        box { <-8, -15, 500> <0, 0, 2500> }
                                        cylinder { <-8, -15, 499> <-8, -15, 2501> 5 }

                                }
                                cylinder { <-8, -5, 500> <-8, -5, 2500> 5 }   
                                rotate <0, -30, 0>
                        }
                        translate <0, 800, 0>    
                        
                        texture { SmoothWhiteStone }
                }   
                
        }    
        
        // stepped first floor part
        union
        {
                
                difference
                {
                        difference
                        {
                                cylinder { <0, 0, 0> <0, 12, 0> 500 }
                                cylinder { <0, -1, 0> <0, 14, 0> 350 }                        
                        } 
                        box { <-501, -1, -501> <0, 14, 0> rotate <0, -3, 0> }
                        box { <-501, -1, -501> <0, 14, 0> rotate <0, -70, 0> }
                
                } 
                difference
                {
                        difference
                        {
                                cylinder { <0, 0, 0> <0, 12, 0> 500 }
                                cylinder { <0, -1, 0> <0, 14, 0> 360 }                        
                        }                                   
                        box { <-501, -1, -501> <0, 14, 0> rotate <0, -1.5, 0> }
                        box { <-501, -1, -501> <0, 14, 0> rotate <0, -71.5, 0> }
                        translate <0, -12, 0>                
                } 
                difference
                {
                        difference
                        {
                                cylinder { <0, 0, 0> <0, 12, 0> 500 }
                                cylinder { <0, -1, 0> <0, 14, 0> 370 }                        
                        } 
                        box { <-501, -1, -501> <0, 14, 0> rotate <0,  0, 0> }
                        box { <-501, -1, -501> <0, 14, 0> rotate <0, -73, 0> }
                        translate <0, -24, 0>                
                } 
                // flat part at either end
                union
                {
                        Round_Box_Union(<-500.1, -450, -27>, <-480, 12.1, 10>, 0.1)   
                        object { Round_Box_Union(<-500.1, -450, -27>, <-480, 12.1, 10>, 0.1) rotate <0, -161.15, 0> }   
                }       
                
                // balcony part
                // glass pane   
                union
                {
                #declare bPos = -83;
                #while(bPos < 110)
                        object { balconySection translate <0, 0, 360> rotate <0, bPos, 0> }
                        #declare bPos=bPos+20.1;
                #end
                
                }
                translate <0, 175, 0>                                                    
                texture { InteriorWhitePaint }
        }      
        
        // Wall/Grass in front of building
        union
        {    
                difference
                {
                        box { <-235, -300, 0> <300, 0, 30> rotate <0, 0, 6> } 
                        union
                        {
                                box { <-50, -450, -0.1> <0, 50, 31> translate <-200, 0, 0> }
                                box { <0, -450, -0.1> <50, 150, 31> translate <300, 0, 0> }                                
                        }
                }
                // top of wall
                difference
                {
                        union 
                        {
                                Round_Box_Union(<-235, 0, -5>, <300, 10, 35>, 0.1)
                                rotate <0, 0, 6> 
                        }
                        union
                        {
                                box { <-50, -50, -5.1> <0, 60, 36> translate <-200, 0, 0> }
                                box { <0, 0, -5.1> <50, 175, 36> translate <300, 0, 0> }                                
                        }
                }  
                // side wall
                box { <-200, -300, -200> <-170, -20, 30> } 
                Round_Box_Union(<-205, -20, -205>, <-165, -10, 35>, 0.1)
                
                // wall in front of grass
                Round_Box_Union(<-170, -300, -200>, <175, -125, -180>, 0.1)  
                object 
                {
                        Round_Box_Union(<155, -300, 0>, <175, 0, 290>, 0.1)
                        rotate <-15, 0, 0>
                        translate <0, -125, -190>
                }  

                // Grass
                #if(useGrass)
                union
                {       
                        object { tateGrass }  
                        
                        box { <-162.5, -1, 0> <162.5, 0, 230> pigment { rgb <0.05, 0.023, 0.001> } finish { ambient 0 diffuse 0.2 } }
                        rotate <-15, 0, 0>      
                        translate <-7.5, -125, -180>
                }    
                #end
                
                
                translate <0, -160, -600>   
                rotate <0, 15, 0>            
                //pigment { Red } 
        }

 texture { WhiteStone }   
// rotate <0, -35, 0>      
// translate <600, 0, 400>
}
#end

// Add the ground

sphere { <0, 0, 0> 1 

pigment { rgb <0.25, 0.25, 0.245> }  
finish { ambient 0 }
normal { wrinkles 0.1 scale 0.01 }
scale 15000
translate <0, -15375, 0>
}