/*
"RIGGED GAME"

You may be the asketic of asketics, you may live from air and love
alone, but there still are some things that you can't just do away with
if you still want to be part of the game.

Tools used: Povray 3.50c-10, my trusty FTE programmers' editor and
whatever imagination I could spare :-)

Copyright (c) 2005 Thorsten Thielen <thth@c2226.de>

This work is licensed under the Creative Commons
Attribution-NonCommercial License. To view a copy of this license,
visit http://creativecommons.org/licenses/by-nc/2.5/ or send a letter
to Creative Commons, 543 Howard Street, 5th Floor, San Francisco,
California, 94105, USA.
*/

#include "shapes.inc"


// ******************************************************************
// *** Configuration                                              ***
// ******************************************************************

#declare USE_RADIOSITY   = 0;  // Not really necessary with this scene
#declare USE_AREALIGHTS  = 1;  // Makes rendering a little slower
#declare USE_FOCALBLUR   = 0;  // Makes rendering much slower


// ******************************************************************
// *** Global settings                                            ***
// ******************************************************************

global_settings {
    assumed_gamma 1.0
    #declare LIGHT_FACTOR = 1.5;

    max_trace_level 20

#if( USE_RADIOSITY )
    ambient_light 0.00001

    radiosity {
        // All on defaults:
        //pretrace_start 0.08
        //pretrace_end   0.04
        //count 35
        //error_bound 1.8
        //adc_bailout 0.01
        //gray_threshold 0.0
        //low_error_factor 0.5
        //minimum_reuse 0.015
        //nearest_count 5
        //recursion_limit 3
        brightness 0.2
    }
#else
    ambient_light 0.6
#end
}

background {
    color rgb <1.0,1.0,1.0>
}


// ******************************************************************
// *** Camera                                                     ***
// ******************************************************************

#declare C_Default =
camera {
    location    < 0.00, 0.17,-0.195>
    up          <0,1,0>
    right       <1,0,0>
    look_at     <-0.01, 0.00, 0.015>

#if( USE_FOCALBLUR )
    focal_point <-0.01, 0.00,-0.015>
    aperture 0.0035
/*    blur_samples 10
    confidence 0.9
    variance 1/100 */
    blur_samples 100
    confidence 0.95
    variance 1/10000
#end
}

#declare C_Wide =
camera {
    location  < 0.05, 0.17, -0.25>
    up        <0,1,0>
    right     <4/3,0,0>
    look_at   <0.04, 0.0, 0.0>
}

#declare C_Tall =
camera {
    location  < 0.0, 0.17, -0.19>
    up        <0,4/3,0>
    right     <1,0,0>
    look_at   <-0.01, 0.0,  0.01>

#if( USE_FOCALBLUR )
    focal_point <-0.01, 0.0, 0.0>
    aperture 0.005
    blur_samples 100
    confidence 0.9
    variance 1/10000
#end
}

#declare C_Back =
camera {
    location  < 0.0, 0.17, 0.39>
    up        <0,1,0>
    right     <1,0,0>
    look_at   <-0.05, 0.0, 0.15>
}

camera { C_Default }
//camera { C_Tall }
//camera { C_Wide }


// ******************************************************************
// *** Light sources                                              ***
// ******************************************************************

light_source {
    <-2.0, 1.5, 2.0>
    color rgb<0.7,0.7,1.0> * LIGHT_FACTOR

#if( USE_AREALIGHTS )
    area_light <0.10,0,0>, <0,0,0.10>, 6, 6
    adaptive 1
    jitter
#end
}

light_source {
    < 1.5, 0.5,-0.5>
    color rgb<0.7,1.0,1.0> * LIGHT_FACTOR * 0.85

#if( USE_AREALIGHTS )
    area_light <0.10,0,0>, <0,0,0.10>, 6, 6
    adaptive 1
    jitter
#end
}


// ******************************************************************
// *** Textures                                                   ***
// ******************************************************************

#declare T_White = texture {
    pigment { rgb<1.0,1.0,1.0> }
    finish {
        specular 0.5
        reflection 0.075
    }
}
#declare T_Black = texture {
    pigment { rgb<0.0,0.0,0.0> }
    finish {
        specular 0.5
        reflection 0.075
    }
}


// ******************************************************************
// *** Object definitions                                         ***
// ******************************************************************

// Note: These models assume that textures named T_White and T_Black
// are declared! Some of them also assume that shapes.inc is included.

#include "models/m_cardaceofspades.inc"
#include "models/m_chesspieces.inc"
#include "models/m_domino.inc"
#include "models/m_millsboard.inc"
#include "models/m_oneeyeddie.inc"
#include "models/m_pawn.inc"
#include "models/m_whiteonlychessboard.inc"


// ******************************************************************
// *** Object placement                                           ***
// ******************************************************************

// pawns (from left to right, top to bottom)
union {
    object {
        M_Pawn
        rotate <17,170,0>
        translate <-0.162,0.0064,0.300>
    }
    object {
        M_Pawn
        translate <-0.160,0.0031,0.320>
    }
    object {
        M_Pawn
        translate <-0.125,0.0031,0.310>
    }
    // stacked ones 1
    object {
        M_Pawn
        translate <-0.075,0.0031,0.300>
    }
    // stacked ones 2
    object {
        M_Pawn
        translate <-0.078,0.0092,0.302>
    }
    // stacked ones 3
    object {
        M_Pawn
        translate <-0.077,0.0153,0.305>
    }
    object {
        M_Pawn
        translate <-0.050,0.0031,0.250>
    }
    object {
        M_Pawn
        translate <-0.040,0.0031,0.280>
    }
    // stacked on the two ones before
    object {
        M_Pawn
        translate <-0.045,0.0092,0.267>
    }
    object {
        M_Pawn
        translate < 0.003,0.0031,0.285>
    }
    object {
        M_Pawn
        translate <-0.010,0.0031,0.313>
    }
    object {
        M_Pawn
        translate < 0.037,0.0031,0.306>
    }
    object {
        M_Pawn
        translate < 0.100,0.0031,0.305>
    }
    translate <0.00,0.0,0.01>
}

// dominos
union {
    object {
        M_Domino
        translate <-0.14        ,0.0031,0.22>
    }
    // left up branch
    object {
        M_Domino
        rotate <0,87,0>
        translate <-0.14 - 0.040,0.0031,0.22 + 0.013>
    }
    object {
        M_Domino
        rotate <0,-4,0>
        translate <-0.14 - 0.079,0.0031,0.22 + 0.026>
    }
    object {
        M_Domino
        rotate <0,89,0>
        translate <-0.14 - 0.092,0.0031,0.22 + 0.064>
    }
    object {
        M_Domino
        rotate <0,-6,0>
        translate <-0.14 - 0.083,0.0031,0.22 + 0.11>
    }
    // right up branch
    object {
        M_Domino
        rotate <0,-3,0>
        translate <-0.14 + 0.025,0.0031,0.22 + 0.027>
    }
    // middle down branch
    object {
        M_Domino
        rotate <0,87,0>
        translate <-0.14 - 0.012,0.0031,0.22 - 0.038>
    }
    object {
        M_Domino
        rotate <0,88,0>
        translate <-0.14 - 0.012,0.0031,0.22 - 0.089>
    }
    object {
        M_Domino
        rotate <0,86,0>
        translate <-0.14 - 0.038,0.0031,0.22 - 0.110>
    }
    object {
        M_Domino
        rotate <0,87,0>
        translate <-0.14 - 0.035,0.0041,0.22 - 0.163>
    }
    // angled one
    object {
        M_Domino
        rotate <-3,1,-9>
        translate <-0.14 + 0.021,0.0067,0.22 - 0.079>
    }
    translate <0.0,-0.0005,0.0>
}

// dice (from top to bottom, left to right)
union {
    object {
        O_OneEyedDie
        rotate <0,-10,0>
        translate < 0.010,0.000, 0.0500>
    }
    object {
        O_OneEyedDie
        rotate <0,20,0>
        translate < 0.020,0.000, 0.0300>
    }
    object {
        O_OneEyedDie
        rotate <0,72,0>
        translate <-0.010,0.001, 0.0100>
    }
    object {
        O_OneEyedDie
        rotate <0,102,0>
        translate < 0.013,0.001, 0.0020>
    }
    object {
        O_OneEyedDie
        rotate <0,40,0>
        translate <-0.010,0.001,-0.0100>
    }
    object {
        O_OneEyedDie
        rotate <0,90,0>
        translate < 0.035,0.001,-0.0185>
    }
    object {
        O_OneEyedDie
        rotate <0,65,0>
        translate < 0.020,0.001,-0.0470>
    }
    // on chessboard
    object {
        O_OneEyedDie
        rotate <0,-30,21>
        translate <0.075,0.0017,-0.03>
    }
    translate <-0.115,0.5 * 0.013,0.04>
}

#local s_rand = seed( 13 );

#macro Offset()
rand( s_rand ) * 0.006 - 0.003
#end

#macro Rotate()
rand( s_rand ) * 10 - 5
#end

// chessboard
object {
    union {
        object { M_WhiteOnlyChessboard }

        // Note: No need to Rotate() the pawns, they look the same
        // from all sides anyway :-)
        object {
            M_ChessPawn
            translate <0.00 + 0.025 - 0.20 + Offset(),0.0052,-0.025 + 0.20 - 0.05+ Offset()> * 0.75
        }
        object {
            M_ChessPawn
            translate <0.05 + 0.025 - 0.20 + Offset(),0.0052,-0.025 + 0.20 - 0.05+ Offset()> * 0.75
        }
        object {
            M_ChessPawn
            translate <0.10 + 0.025 - 0.20 + Offset(),0.0052,-0.025 + 0.20 - 0.15+ Offset()> * 0.75
        }
        object {
            M_ChessPawn
            translate <0.15 + 0.025 - 0.20 + Offset(),0.0052,-0.025 + 0.20 - 0.05+ Offset()> * 0.75
        }
        object {
            M_ChessPawn
            translate <0.20 + 0.025 - 0.20 + Offset(),0.0052,-0.025 + 0.20 - 0.05+ Offset()> * 0.75
        }
        object {
            M_ChessPawn
            translate <0.25 + 0.025 - 0.20 + Offset(),0.0052,-0.025 + 0.20 - 0.05+ Offset()> * 0.75
        }
        object {
            M_ChessPawn
            translate <0.30 + 0.025 - 0.20 + Offset(),0.0052,-0.025 + 0.20 - 0.05+ Offset()> * 0.75
        }
        object {
            M_ChessPawn
            translate <0.35 + 0.025 - 0.20 + Offset(),0.0052,-0.025 + 0.20 - 0.05+ Offset()> * 0.75
        }

        object {
            M_ChessPawn
            translate <0.00 + 0.025 - 0.20 + Offset(),0.0052, 0.025 - 0.20 + 0.05+ Offset()> * 0.75
        }
        object {
            M_ChessPawn
            translate <0.05 + 0.025 - 0.20 + Offset(),0.0052, 0.025 - 0.20 + 0.10+ Offset()> * 0.75
        }
        object {
            M_ChessPawn
            translate <0.10 + 0.025 - 0.20 + Offset(),0.0052, 0.025 - 0.20 + 0.15+ Offset()> * 0.75
        }
        object {
            M_ChessPawn
            translate <0.15 + 0.025 - 0.20 + Offset(),0.0052, 0.025 - 0.20 + 0.05+ Offset()> * 0.75
        }
        object {
            M_ChessPawn
            translate <0.20 + 0.025 - 0.20 + Offset(),0.0052, 0.025 - 0.20 + 0.05+ Offset()> * 0.75
        }
        object {
            M_ChessPawn
            translate <0.25 + 0.025 - 0.20 + Offset(),0.0052, 0.025 - 0.20 + 0.05+ Offset()> * 0.75
        }
        object {
            M_ChessPawn
            translate <0.30 + 0.025 - 0.20 + Offset(),0.0052, 0.025 - 0.20 + 0.05+ Offset()> * 0.75
        }
        object {
            M_ChessPawn
            translate <0.35 + 0.025 - 0.20 + Offset(),0.0052, 0.025 - 0.20 + 0.05+ Offset()> * 0.75
        }

        object { M_ChessTower  rotate y * (  0 + Rotate()) translate <0.00 + 0.025 - 0.20+ Offset(),0.0052,-0.025 + 0.20> * 0.75 }
        object { M_ChessTower  rotate y * (  0 + Rotate()) translate <0.35 + 0.025 - 0.20+ Offset(),0.0052,-0.025 + 0.20> * 0.75 }
        object { M_ChessTower  rotate y * (180 + Rotate()) translate <0.00 + 0.025 - 0.20+ Offset(),0.0052, 0.025 - 0.20> * 0.75 }
        object { M_ChessTower  rotate y * (180 + Rotate()) translate <0.35 + 0.025 - 0.20+ Offset(),0.0052, 0.025 - 0.20> * 0.75 }

        object { M_ChessKnight rotate y * (  0 + Rotate()) translate <0.20 + 0.025 - 0.20+ Offset(),0.0052,-0.025 + 0.05> * 0.75 }
        object { M_ChessKnight rotate y * (  0 + Rotate()) translate <0.30 + 0.025 - 0.20+ Offset(),0.0052,-0.025 + 0.20> * 0.75 }
        object { M_ChessKnight rotate y * (180 + Rotate()) translate <0.05 + 0.025 - 0.20+ Offset(),0.0052, 0.025 - 0.20> * 0.75 }
        object { M_ChessKnight rotate y * (180 + Rotate()) translate <0.30 + 0.025 - 0.20+ Offset(),0.0052, 0.025 - 0.20> * 0.75 }

        object { M_ChessBishop rotate y * (  0 + Rotate()) translate <0.10 + 0.025 - 0.20+ Offset(),0.0052,-0.025 + 0.20+ Offset()> * 0.75 }
        object { M_ChessBishop rotate y * (  0 + Rotate()) translate <0.25 + 0.025 - 0.20+ Offset(),0.0052,-0.025 + 0.20+ Offset()> * 0.75 }
        object { M_ChessBishop rotate y * (180 + Rotate()) translate <0.10 + 0.025 - 0.20+ Offset(),0.0052, 0.025 - 0.20+ Offset()> * 0.75 }
        object { M_ChessBishop rotate y * (180 + Rotate()) translate <0.25 + 0.025 - 0.20+ Offset(),0.0052, 0.025 - 0.20+ Offset()> * 0.75 }

        object { M_ChessQueen  rotate y * (  0 + Rotate()) translate <0.15 + 0.025 - 0.20+ Offset(),0.0052,-0.025 + 0.20+ Offset()> * 0.75 }
        object { M_ChessKing   rotate y * (  0 + Rotate()) translate <0.20 + 0.025 - 0.20+ Offset(),0.0052,-0.025 + 0.20+ Offset()> * 0.75 }

        object { M_ChessQueen  rotate y * (180 + Rotate()) translate <0.10 + 0.025 - 0.20+ Offset(),0.0052, 0.025 - 0.15+ Offset()> * 0.75 }
        object { M_ChessKing   rotate y * (180 + Rotate()) translate <0.20 + 0.025 - 0.20+ Offset(),0.0052, 0.025 - 0.20+ Offset()> * 0.75 }
    }
    rotate y * -20
    translate <0.1,0.0,0.1>
}

// millsboard
object {
    M_Millsboard
    rotate y * 8
    translate <-0.20,0.0,-0.06>
}

// cards (left to right)
object {
    O_CardAceOfSpades
    rotate <-90.5,-27,-0.7>
    translate <-0.09,0.0012,-0.095>
}
object {
    O_CardAceOfSpades
    rotate <-91.0,-20,-1.0>
    translate <-0.07,0.0016,-0.085>
}
object {
    O_CardAceOfSpades
    rotate <-91.5,-13,-1.3>
    translate <-0.05,0.0020,-0.075>
}

// name block
object {
    difference {
        object {
            Round_Box_Union(
                <-0.025,-0.0013,-0.010>,
                < 0.025, 0.0013, 0.010>,
                0.0006
            )
            texture { T_White }
        }
        union {
            // long lines
            cylinder {
                <-0.021, 0.0013, 0.006>,
                < 0.021, 0.0013, 0.006>,
                0.0010
            }
            cylinder {
                <-0.021, 0.0013,-0.006>,
                < 0.021, 0.0013,-0.006>,
                0.0010
            }
            // short lines
            cylinder {
                <-0.021, 0.0013,-0.006>,
                <-0.021, 0.0013, 0.006>,
                0.0010
            }
            cylinder {
                < 0.021, 0.0013,-0.006>,
                < 0.021, 0.0013, 0.006>,
                0.0010
            }
            // round corner correction
            sphere { < 0.021, 0.0013,-0.006> 0.0011 }
            sphere { < 0.021, 0.0013, 0.006> 0.0011 }
            sphere { <-0.021, 0.0013,-0.006> 0.0011 }
            sphere { <-0.021, 0.0013, 0.006> 0.0011 }

            text {
                ttf "crystal.ttf" "Thorsten Thielen" 1.0, 0
                scale <0.0035,0.0035,1.0>
                rotate <90,0,0>
                translate <-0.0150,0.002, 0.001>
            }
            text {
                ttf "crystal.ttf" "<thth@c2226.de>" 1.0, 0
                scale <0.0035,0.0035,1.0>
                rotate <90,0,0>
                translate <-0.0142,0.002,-0.003>
            }

            texture { T_Black }
        }
    }
    rotate <0,-3,-1.4>
    translate <-0.040,0.0023,-0.119>
    scale 0.75
}

// table
plane {
    y, 0.0
    texture { T_Black }
    normal {
        crackle 1.0 form <-0.9,1.1,0.1>
        scale 0.001
    }
}

