#include "colors.inc"
#include "stones.inc"
#include "finish.inc"
#include "textures.inc"
#include "metals.inc"
#include "golds.inc"
#include "glass.inc"
#include "consts.inc"
#include "functions.inc"
#include "rand.inc"

global_settings {
    radiosity {
      pretrace_start 0.08
      pretrace_end   0.04
      count 35

      nearest_count 20
      error_bound 1.8
      recursion_limit 3
  
      low_error_factor 0.5
      gray_threshold 0.0
      minimum_reuse 0.015 
      brightness 1
  
      adc_bailout 0.01/2
    }
  photons {
      spacing 0.075
    }
  }

#declare mega_map = color_map {
	[0.000000 color rgbt <0.036578, 0.159091, 0.015374, 0.000000>]
	[0.055556 color rgbt <0.022239, 0.234849, 0.007687, 0.000000>]
	[0.085142 color rgbt <0.007899, 0.310606, 0.000000, 0.000000>]
	[0.085142 color rgbt <0.007899, 0.310606, 0.000000, 0.000000>]
	[0.138564 color rgbt <0.101896, 0.443182, 0.042827, 0.000000>]
	[0.193656 color rgbt <0.195893, 0.575758, 0.085655, 0.000000>]
	[0.193656 color rgbt <0.195893, 0.575758, 0.085655, 0.000000>]
	[0.233723 color rgbt <0.560068, 0.663178, 0.139025, 0.000000>]
	[0.276572 color rgbt <0.924242, 0.750598, 0.192395, 0.000000>]
	[0.276572 color rgbt <0.924242, 0.750598, 0.192395, 0.000000>]
	[0.332128 color rgbt <0.939393, 0.495226, 0.162308, 0.000000>]
	[0.387683 color rgbt <0.954545, 0.239854, 0.132221, 0.000000>]
	[0.387683 color rgbt <0.954545, 0.239854, 0.132221, 0.000000>]
	[0.510851 color rgbt <0.742424, 0.279602, 0.184117, 0.000000>]
	[0.555556 color rgbt <0.530303, 0.319349, 0.236012, 0.000000>]
	[0.555556 color rgbt <0.530303, 0.319349, 0.236012, 0.000000>]
	[0.611111 color rgbt <0.501476, 0.307570, 0.618006, 0.000000>]
	[0.666667 color rgbt <0.472649, 0.295792, 1.000000, 0.000000>]
	[0.666667 color rgbt <0.472649, 0.295792, 1.000000, 0.000000>]
	[0.772955 color rgbt <0.558401, 0.647896, 0.978872, 0.000000>]
	[0.826377 color rgbt <0.644153, 1.000000, 0.957743, 0.000000>]
	[0.826377 color rgbt <0.644153, 1.000000, 0.957743, 0.000000>]
	[0.866444 color rgbt <0.526438, 0.935000, 0.618071, 0.000000>]
	[0.884808 color rgbt <0.408723, 0.870000, 0.278400, 0.000000>]
	[0.884808 color rgbt <0.408723, 0.870000, 0.278400, 0.000000>]
	[0.953255 color rgbt <0.386140, 0.685000, 0.139200, 0.000000>]
	[1.000000 color rgbt <0.363558, 0.500000, 0.000000, 0.000000>]
}

#declare Media = media {
  emission 0.05
  intervals 1
  samples 5
  method 3
  density {
    bozo
    ramp_wave
    turbulence 0.51
    color_map { mega_map }
  }
}

#declare verre1 = material {
  interior {
    media { Media scale 20 }
    ior 1.33
    caustics 1.0
  }
  texture {
    finish {
      ambient 0.1 
      diffuse 0.0 
      reflection .20 
      roughness 0.000001
    }
    pigment { 
      color rgbf <0.90, .90, 0.90, .90>
    }
  }
}

camera {
  location <-5, 20, -25>
  look_at <0, 0, 0>
  focal_point <0, 5, 0>
  aperture 1.4
  blur_samples 50
}

light_source { 
  <-10, 9, -1>, color White*2.5
  area_light <4, 0, 0>, <0, 0, 4>, 9, 9
  adaptive 1
  jitter
  photons {
    refraction on
    reflection on
  }
}

plane {
  y, -2.4
  photons {
    target 1.0
    refraction on
    reflection on
  }
  texture {
    finish {
      reflection .25
      diffuse 0.2
      ambient 0.1
      }
    pigment {
      color White
      }
    }
}

#declare tube = merge {
  cylinder { <0,-2.400001,0>, <0, 10,0>,3 }
  sphere { <0,0,0>, 3 scale <1, 0.35, 1> translate <0,-2.400001,0> }
  sphere { <0,0,0>, 3 scale <1, 0.35, 1> translate <0, 10,0> }
}

#declare R1 = seed(1);
#declare bubulles = 4000;
#declare fact = 12;

#declare pochoire1 = merge {
#declare i=0;
#while(i<bubulles)
  #declare posX = SRand(R1)*fact;
  #declare posY = SRand(R1)*fact;
  #declare posZ = SRand(R1)*fact;
  #declare rayon = rand(R1)/3+0.15;
  #if(inside (tube, <posX+rayon,posY,posZ>) >= 1.0)
    #if(inside (tube, <posX-rayon,posY,posZ>) >= 1.0)
      #if(inside (tube, <posX,posY+rayon,posZ>) >= 1.0)
        #if(inside (tube, <posX,posY-rayon,posZ>) >= 1.0)
	  #if(inside (tube, <posX,posY,posZ+rayon>) >= 1.0)
	    #if(inside (tube, <posX,posY,posZ-rayon>) >= 1.0)
	      sphere { <posX,posY,posZ>,rayon }
	    #end
	  #end
	#end
      #end
    #end
  #end
  #declare i=i+1;
#end
}

#declare pochoire2 = merge {
#declare i=0;
#while(i<bubulles)
  #declare posX = SRand(R1)*fact;
  #declare posY = SRand(R1)*fact;
  #declare posZ = SRand(R1)*fact;
  #declare rayon = rand(R1)/3+0.15;
  #if(inside (tube, <posX+rayon,posY,posZ>) >= 1.0)
    #if(inside (tube, <posX-rayon,posY,posZ>) >= 1.0)
      #if(inside (tube, <posX,posY+rayon,posZ>) >= 1.0)
        #if(inside (tube, <posX,posY-rayon,posZ>) >= 1.0)
	  #if(inside (tube, <posX,posY,posZ+rayon>) >= 1.0)
	    #if(inside (tube, <posX,posY,posZ-rayon>) >= 1.0)
	      sphere { <posX,posY,posZ>,rayon }
	    #end
	  #end
	#end
      #end
    #end
  #end
  #declare i=i+1;
#end
}

#declare pochoire3 = merge {
#declare i=0;
#while(i<bubulles)
  #declare posX = SRand(R1)*fact;
  #declare posY = SRand(R1)*fact;
  #declare posZ = SRand(R1)*fact;
  #declare rayon = rand(R1)/3+0.15;
  #if(inside (tube, <posX+rayon,posY,posZ>) >= 1.0)
    #if(inside (tube, <posX-rayon,posY,posZ>) >= 1.0)
      #if(inside (tube, <posX,posY+rayon,posZ>) >= 1.0)
        #if(inside (tube, <posX,posY-rayon,posZ>) >= 1.0)
	  #if(inside (tube, <posX,posY,posZ+rayon>) >= 1.0)
	    #if(inside (tube, <posX,posY,posZ-rayon>) >= 1.0)
	      sphere { <posX,posY,posZ>,rayon }
	    #end
	  #end
	#end
      #end
    #end
  #end
  #declare i=i+1;
#end
}

#declare pochoire4 = merge {
#declare i=0;
#while(i<bubulles)
  #declare posX = SRand(R1)*fact;
  #declare posY = SRand(R1)*fact;
  #declare posZ = SRand(R1)*fact;
  #declare rayon = rand(R1)/3+0.15;
  #if(inside (tube, <posX+rayon,posY,posZ>) >= 1.0)
    #if(inside (tube, <posX-rayon,posY,posZ>) >= 1.0)
      #if(inside (tube, <posX,posY+rayon,posZ>) >= 1.0)
        #if(inside (tube, <posX,posY-rayon,posZ>) >= 1.0)
	  #if(inside (tube, <posX,posY,posZ+rayon>) >= 1.0)
	    #if(inside (tube, <posX,posY,posZ-rayon>) >= 1.0)
	      sphere { <posX,posY,posZ>,rayon }
	    #end
	  #end
	#end
      #end
    #end
  #end
  #declare i=i+1;
#end
}

#declare tubeA = difference {
  object { tube }
  object { pochoire1 }
  translate <0,0,-1>
}

#declare tubeB = difference {
  object { tube }
  object { pochoire2 }
  rotate z*90
  rotate y*-9
  translate <24,0.599999,18>
}

#declare tubeC = difference {
  object { tube }
  object { pochoire3 }
  rotate z*90
  rotate y*-3
  translate <-1,0.599999,-16>
}

#declare tubeD = difference {
  object { tube }
  object { pochoire4 }
  rotate z*90
  rotate y*43
  translate <-10,0.599999,12>
}

union {
  object { tubeA hollow }
  object { tubeB hollow }
  object { tubeC hollow }
  object { tubeD hollow }
  photons {
    target 1.0
    refraction on
    reflection on
  }
  material { verre1 }
}

