// compose or Pose  female robot
//
#ifndef(Get)
 global_settings{ max_trace_level 50 }

 #include "colors.inc"
 #include "textures.inc"
 #include "metals.inc"

 camera{location <15,5,0>
       right x*image_width/image_height
       look_at <0,5,0>
       }

 light_source{ <0,10,-10> color White }//parallel}
 light_source{ <20,10,0> color White }//parallel}
 light_source{ <-10,20,0> color White shadowless}//parallel}
 plane{y,0 pigment{Green}}  
 background{Blue*.5}
  #declare BodFile= "FB3p.txt";//main body
 #declare FacFile="Smile1.txt";//Face (eyes & mouth)
 #include "ReadPose.inc"
 #include "BotCol3.inc"
//#include "FRobotC.inc"//contact points
 //#include "FRcog.inc"//center of gravity
// #include "FRobot.inc"//calc translate point using 'Reff'

 #declare Nav=<0,0,0>;//Rotate around Reff
#end// of get
  #include "BotJoints.inc"//joint lenghts
  #include "BotCref.inc"//contact points
  #declare NRep=ConPnt[Reff];//Reff
#ifndef(Get) #declare Get=1; #declare Getp=1; #end
 #include "head.pov"
#ifdef(Getp) #undef Get #end
//Neck
#declare Neck=union{
 #declare Cnt=0;
 #while(Cnt<5)
  torus{.15,.1  translate-y*(.2*Cnt)}
  #declare Cnt=Cnt+1;
 #end
texture{Mtex}} 

//------- body----------------
#declare Bod=
union{ 
   torus{.5,.25 scale<2,.5,.45> translate-y*.125}
   cylinder{y*.23,-y*.25,.5 scale<2,.5,.5> translate-y*.125}
   torus{.5,.25 scale<1.6,.55,.3> translate-y*.5}

   cone{0,1,-y*2,.5 scale<1.4,.5,.3> }
   cylinder{-y*1.5,-y*4,.5 scale<1.4,.5,.4> }
   
   sphere{0,.4 translate <-1.27,-.28,0>}
   sphere{0,.4 translate <1.27,-.28,0> }

   // gut
   cone{-y,.2,-y*4,.7 scale<1,.5,.5> }

texture{Mtex}}

// butt
#declare Butt=
union{
   //cone{0,.65,-y*.475,.9 scale<1.1,1,.5> }
   cylinder{-y*.475,-y*.875,.9 scale<1.1,1,.5> }
   cone{-y*.875,.9,-y*1.25,.4 scale<1.1,1,.5> }
   sphere{0,.4 translate<-.6,-1.25,0> }
   sphere{0,.4 translate<.6,-1.25,0> }
texture{Mtex}}

// Gut
#declare Ep=-y*.45;
#declare Ev=vrotate(Ep,ButtA);
#declare Sp=y*.2;
#declare Sv=vrotate(Sp,BodA);

#declare Cp1=Sv/3;
#declare Cp2=Ev/3;
#declare Guts=spline{natural_spline 
                   0,Sv,
                   .3,Cp1,
                   .6,Cp2,
                   1,Ev}

#declare R=(ButtA-BodA);

#declare Cnt=0;
#declare Gut=union{
 #while(Cnt<1.1)
  sphere{0,.65 scale <1,.5,.5>+Cnt*<.45,0,.2> rotate BodA+Cnt*R 
   translate Guts(Cnt)}
 #declare Cnt=Cnt+.2;
 #end 
texture{Mtex}}

//-------------legs----------------------
#declare Heal= union{sphere{0,.3 scale<1,.6,1> translate -z*.05}
            cone{0,.15,<0,-.1,-.6>,.1 scale<2,1,1>}  
            sphere{<0,-.1,-.6>,.1 scale<2,1,1>}  
            texture{Htex}}
#declare Toes= union{cone{<0,-.1,0>,.1 <0,-.1,-.2>,.1}  
            sphere{<0,-.1,0>,.1 }  
            sphere{<0,-.1,-.2>,.1 }  
            scale<2,1,1>texture{Htex}}

#declare LegH= cone{0,.4,WHLegJ,.25 texture{Mtex}}
#declare LegL= cone{0,.3,WLLegJ,.15 texture{Mtex}}
  
// Right Knee
#declare Ep=-y*.1;
#declare Ev=vrotate(Ep,RlegLA);
#declare Sp=y*.1;
#declare Sv=vrotate(Sp,RlegHA);
#declare Cp1=Sv/3;
#declare Cp2=Ev/3;
#declare Guts=spline{natural_spline 0,Sv,.3,Cp1,.6,Cp2,1,Ev}
#declare R=(RlegLA-RlegHA);

#declare Cnt=0;
#declare RKnee=union{
 #while(Cnt<1.1)
  sphere{0,.35 scale <1,.5,1> rotate RlegHA+Cnt*R 
   translate Guts(Cnt)}
 #declare Cnt=Cnt+.3;
 #end 
texture{Mtex}}
// Left Knee
#declare Ep=-y*.1;
#declare Ev=vrotate(Ep,LlegLA);
#declare Sp=y*.1;
#declare Sv=vrotate(Sp,LlegHA);
#declare Cp1=Sv/3;
#declare Cp2=Ev/3;
#declare Guts=spline{natural_spline 0,Sv,.3,Cp1,.6,Cp2,1,Ev}
#declare R=(LlegLA-LlegHA);

#declare Cnt=0;
#declare LKnee=union{
 #while(Cnt<1.1)
  sphere{0,.35 scale <1,.5,1> rotate LlegHA+Cnt*R 
   translate Guts(Cnt)}
 #declare Cnt=Cnt+.3;
 #end 
texture{Mtex}}


#declare RLeg= union{union{
                    union{object{Toes rotate x*RToesA translate WToesJ} 
                     object{Heal} rotate RFootHA translate WLLegJ }
                     object {LegL } object {RKnee rotate -RlegLA}
                      rotate RlegLA  translate WHLegJ}
                     object {LegH} rotate RlegHA }
#declare LLeg= union{union{
                  union{object{Toes rotate x*LToesA translate WToesJ} 
                     object{Heal }rotate LFootHA translate WLLegJ}
                     object {LegL} object {LKnee rotate -LlegLA}
                       rotate LlegLA translate WHLegJ}
                     object {LegH }rotate LlegHA }

//------- arms-----------
#declare ArmH= cone{0,.25,WHArmJ,.15 texture{Mtex}}
#declare ArmL= cone{0,.16,WLArmJ,.15 texture{Mtex}}
                         
//-------- Hands---------

#declare Finger=union{
  box{<.1,0,.08>,<-.1,-.6,-.08>}
  cylinder {<0,0,.08>,<0,0,-.08>,.1}
  cylinder {<0,-.6,.08>,<0,-.6,-.08>,.1}
  box{<.1,0,.08>,<-.1,-.5,-.08> rotate z*40 translate -y*.6 }
  cylinder {<0,-.5,.08>,<0,-.5,-.08>,.1 rotate z*40 translate -y*.6}
  scale .8 texture{Htex}}

#declare RHand=
union{
 object{Finger rotate <0,0,-RFinA> translate -y*.3}
 object{Finger rotate <0,180,RFinA> translate <0,-.3,-.2> }
 object{Finger rotate <0,180,RFinA> translate <0,-.3,.2> }
 cylinder{-z*.3,z*.3,.1 translate -y*.3}
 cone{0,.125,-y*.3,.1}
 sphere{0,.15}
 texture{Htex}}

#declare LHand=
union{
 object{Finger rotate <0,180,LFinA> translate -y*.3}
 object{Finger rotate <0,0,-LFinA> translate <0,-.3,-.2> }
 object{Finger rotate <0,0,-LFinA> translate <0,-.3,.2> }
 cylinder{-z*.3,z*.3,.1 translate -y*.3}
 cone{0,.125,-y*.3,.1}
 sphere{0,.15}
 texture{Htex}}
 
// Right elbow
#declare Ep=-y*.15;
#declare Ev=vrotate(Ep,Rlarm);
#declare Sp=y*.15;
#declare Sv=vrotate(Sp,0);
#declare Cp1=Sv/3;
#declare Cp2=Ev/3;
#declare Guts=spline{natural_spline 0,Sv,.3,Cp1,.6,Cp2,1,Ev}
//#declare R=(Rlarm-0);

#declare Cnt=0;
#declare Relbow=union{
 #while(Cnt<1.1)
  sphere{0,.22 scale <1,.5,1> rotate Rlarm*Cnt
   translate Guts(Cnt)}
 #declare Cnt=Cnt+.3;
 #end 
texture{Mtex}}
// Left elbow
#declare Ep=-y*.15;
#declare Ev=vrotate(Ep,Llarm);
#declare Sp=y*.15;
#declare Sv=vrotate(Sp,0);
#declare Cp1=Sv/3;
#declare Cp2=Ev/3;
#declare Guts=spline{natural_spline 0,Sv,.3,Cp1,.6,Cp2,1,Ev}
//#declare R=(Rlarm-0);

#declare Cnt=0;
#declare Lelbow=union{
 #while(Cnt<1.1)
  sphere{0,.22 scale <1,.5,1> rotate Llarm*Cnt
   translate Guts(Cnt)}
 #declare Cnt=Cnt+.3;
 #end 
texture{Mtex}}
 
#declare RArm=
 union{
  union{object{RHand rotate RhandA translate WLArmJ}
       object{ArmL} object{Relbow rotate -Rlarm}
        rotate Rlarm translate WHArmJ} 
       object{ArmH } rotate Rharm translate RArmJ}

#declare LArm=
 union{
  union{object{LHand rotate LhandA translate WLArmJ}
     object{ArmL} object{Lelbow rotate -Llarm}
      rotate Llarm translate WHArmJ} 
     object{ArmH }rotate Lharm translate LArmJ}

//---------- 5 reffrence points------------------------

//#include "FRobot.inc"

//----------------- put it all togather------------------
#declare Robot=
union{
union{
 union{
  union{ object{Head rotate HeadA}object{Neck} translate NeckJ rotate NeckA}
  object{Bod} translate BodJ}
 object{RArm}
 object{LArm}rotate BodA }
 union{object{Butt translate ButtJ}
       object{RLeg translate RLegJ}
       object{LLeg translate LLegJ}
       translate -ButtJ rotate ButtA}
object{Gut}
translate -NRep
//rotate Nav
}
#ifndef(Get)
#debug concat("NRep= <",vstr(3,NRep,",",3,3),">\n")
#debug concat("LHealV= <",vstr(3,LHealV,",",3,5),">\n")
#debug concat("RtoeV= <",vstr(3,RtoeV,",",3,5),">\n")
// object{Robot rotate -y*90 translate -x*6}
 object{Robot }
//vector points
 sphere{RhandV-NRep,.1 pigment{Gold} finish{ambient .75}}
 sphere{LhandV-NRep,.1 pigment{Gold} finish{ambient .75}}
 sphere{HeadV-NRep,.1 pigment{Gold} finish{ambient .75}}
 sphere{RHealV-NRep,.05 pigment{Gold} finish{ambient .75}}
 sphere{RtoeV-NRep,.1 pigment{Gold} finish{ambient .75}}
 sphere{LHealV-NRep,.05 pigment{Gold} finish{ambient .75}}
 sphere{LtoeV-NRep,.05 pigment{Gold} finish{ambient .75}}
// sphere{RhandV,.25 pigment{Gold}}
// sphere{LhandV,.25 pigment{Red}}

// object{Robot rotate y*90 translate x*6}
//cylinder{<-12,0,-.5>,<12,0,-.5>,.05 pigment{Red}}
cylinder{<0,-12,0>,<0,12,0>,.01 pigment{Red}}
cylinder{<-1,0,0>,<1,0,0>,.01 pigment{Red}}
cylinder{<0,0,-10>,<0,0,10>,.01 pigment{Red}}

#end