// Twin ribbons as mesh2
#ifndef(Get)
 #include "colors.inc"
 global_settings{assumed_gamma 1.0  
                 max_trace_level 50 }
 camera{ location <0,0,-5>
        right x*image_width/image_height
        look_at <0,0,0>
        }
 background{Pink}
 light_source{ <40,200,-300> color White}
 light_source{ <-60,100,-20> color White}
 plane{y,-4 pigment{Green}}
#end

#declare Fs=seed(1065486);
#declare FlagP=
spline {
  natural_spline
 0,<-.51, 9.1, 19>
  .050,<-8.008,8.188,19.524>
  .100,<-15.762,3.275,20.047>
  .200,<-8.997,1.529,22.818>
  .300,<-9.602,2.835,16.096>
  .400,<-3.869,-3.529,5.893>
  .500,<-17.970,0.801,17.080>
  .600,<-4.389,3.656,26.437>
  .700,<-3.124,-3.438,14.471>
  .800,<-14.602,-1.180,16.982>
  .900,<-3.485,-2.600,10.748>
  .950,<-6.555,-3.333,7.138>
 1.000,<-5.5,1.45,25.5>
 }
#declare Rs=seed(45176);
#declare FlagQ=
spline {
  natural_spline
 0,<-.51, 9.1, 19>-y*1.2
  .050,<-8.008,8.188,19.524>-y*1.082
  .100,<-15.762,3.275,20.047>-y*1.082
  .200,<-8.997,1.529,22.818>-0.964*vnormalize(<rand(Rs)*4-2,rand(Rs)*4-2,rand(Rs)*4-2>)
  .300,<-9.602,2.835,16.096>-0.846*vnormalize(<rand(Rs)*4-2,rand(Rs)*4-2,rand(Rs)*4-2>)
  .400,<-3.869,-3.529,5.893>-0.728*vnormalize(<rand(Rs)*4-2,rand(Rs)*4-2,rand(Rs)*4-2>)
  .500,<-17.970,0.801,17.080>-0.610*vnormalize(<rand(Rs)*4-2,rand(Rs)*4-2,rand(Rs)*4-2>)
  .600,<-4.389,3.656,26.437>-0.492*vnormalize(<rand(Rs)*4-2,rand(Rs)*4-2,rand(Rs)*4-2>)
  .700,<-3.124,-3.438,14.471>-0.374*vnormalize(<rand(Rs)*4-2,rand(Rs)*4-2,rand(Rs)*4-2>)
  .800,<-14.602,-1.180,16.982>-0.256*vnormalize(<rand(Rs)*4-2,rand(Rs)*4-2,rand(Rs)*4-2>)
  .900,<-3.485,-2.600,10.748>-0.138*vnormalize(<rand(Rs)*4-2,rand(Rs)*4-2,rand(Rs)*4-2>)
  .950,<-6.555,-3.333,7.138>-0.10*vnormalize(<rand(Rs)*4-2,rand(Rs)*4-2,rand(Rs)*4-2>)
 1.000,<-5.5,1.45,24.5>-0.074*vnormalize(<rand(Rs)*4-2,rand(Rs)*4-2,rand(Rs)*4-2>)
 }

/*
#declare Cnt = 0;
#while (Cnt <= 1)
#declare Sd=y*(1.2-1.18*Cnt);
union{
  sphere{FlagP(Cnt),.05 }
  sphere{FlagP(Cnt)-Sd,.05 }
  cylinder{FlagP(Cnt),FlagP(Cnt)-Sd,.05}
  pigment{Red}}
union{
  sphere{FlagP(Cnt)*<-1,1,1>,.05 }
  sphere{(FlagP(Cnt)-Sd)*<-1,1,1>,.05 }
  cylinder{FlagP(Cnt)*<-1,1,1>,(FlagP(Cnt)-Sd)*<-1,1,1>,.05}
  pigment{Blue}}
#declare Cnt = Cnt+.001; 
#end
*/
#ifndef(Get) //show control pnts
 #declare Cnt = 0;
 #while (Cnt <= 1)
  sphere{FlagP(Cnt),.2 pigment{rgb 1-Cnt}}
  #declare Su=FlagP(Cnt);
  #declare Sv=FlagQ(Cnt);
  #declare Sx=Su-Sv;
   #debug concat("Su=<"vstr(3,Su,",",4,4),"> ")
   #debug concat("Sv=<"vstr(3,Sv,",",4,4),">\n")
   #debug concat("Su-v=<"vstr(3,Sx,",",4,4),">\n")
 #declare Cnt = Cnt+.1; 
 #end
#end

#declare Pnts=array[2002]
#declare Tris=array[2000]
#declare Norms=array[2002]

//------points----
#declare N = 0;
#declare Cnt = 0;
#while (Cnt <= 1)
 //#declare Sd=y*(1.2-1.19*Cnt);
 #declare Pnts[N]=FlagP(Cnt);
 #declare Pnts[N+1001]=FlagQ(Cnt);//-Sd;
#declare N = N+1; 
#declare Cnt = Cnt+.001; 
#end
#debug concat("\nN="str(N+1001,0,0),"\n")

//----------Triangles--------------
#declare N = 0;
 #declare Cnt = 0;
 #while (Cnt <1000)
  #declare Tris[N]=<Cnt,Cnt+1001,Cnt+1>; #declare N=N+1;
  #declare Tris[N]=<Cnt+1,Cnt+1001,Cnt+1002>; #declare N=N+1;
 #declare Cnt=Cnt+1;
 #end
#debug concat(" N="str(N,0,0),"\n\n")

//-----------MESH-----------------

#declare Ribon=
#mesh2{
     vertex_vectors{2002 
       #declare Cnt = 0;
       #while (Cnt <2002)
        Pnts[Cnt]
       #declare Cnt = Cnt+1; 
       #end}
    face_indices {2000
       #declare Cnt = 0;
       #while (Cnt <2000)
        Tris[Cnt]
       #declare Cnt = Cnt+1; 
       #end}
       }
#ifndef(Get)
   object{Ribon pigment{Red}} 
   object{Ribon scale<-1,1,1> pigment{Blue}}             
#end