#include "mes_textures.inc"

#macro plaque_verre ()


#local epa_verre = 0.3;
#local largeur_verre = 10;
#local prof_verre = 9;                                                  
#local ecrasement = 0.5;


merge { //Plaque de verre

box { 
  <0,0,0>
  <largeur_verre , -epa_verre,prof_verre>
}     

cylinder {0*x,  largeur_verre*x, epa_verre /2 translate -(epa_verre/2)*y scale 1*x+1*y+ecrasement*z}
cylinder {0*x,  largeur_verre*x, epa_verre /2 translate -(epa_verre/2)*y+prof_verre*z scale 1*x+1*y+ecrasement*z}
cylinder {0*z,  prof_verre*z   , epa_verre /2 translate -(epa_verre/2)*y scale 1*z+1*y+ecrasement*x}
cylinder {0*z,  prof_verre*z   , epa_verre /2 translate -(epa_verre/2)*y+largeur_verre*x scale ecrasement*x+1*y+1*z} 

sphere {<0				 , 0, 0			 > epa_verre/2 translate -(epa_verre/2)*y scale ecrasement*x+1*y+ecrasement*z}
sphere {<largeur_verre, 0, 0		    > epa_verre/2 translate -(epa_verre/2)*y scale ecrasement*x+1*y+ecrasement*z}
sphere {<0				 , 0, prof_verre> epa_verre/2 translate -(epa_verre/2)*y scale ecrasement*x+1*y+ecrasement*z}
sphere {<largeur_verre, 0, prof_verre> epa_verre/2 translate -(epa_verre/2)*y scale ecrasement*x+1*y+ecrasement*z}
 
pigment {color rgbt <0.3,0.8,0.3,0.9>}

	interior {ior 1.5}
	   finish {
      ambient .2
      diffuse 0.8
      brilliance 5
      reflection 0.05
      }
translate <-3,0,-6> //-(largeur_verre/2)*x
}
                                     
                                                                           
                                       
#end