#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "metals.inc"
#include "woods.inc"
#include "./plaque_verre.inc"

global_settings { assumed_gamma 2.2 

radiosity {             // --- Settings 3 (high quality) ---
    	pretrace_start 0.08
    	pretrace_end   0.005
    	count 400
    	error_bound 0.1
    	recursion_limit 1
  	}
  //ambient_light <1,1,1>/2
  
  }
  
//background {color <0.3,0.3,1>}
background {Black}    

//fog{distance 100000 color rgb <0.8,0.8,1>}  // Gnre le brouillard distant pour la notion de profondeur



light_source {    
  
  0*x                  // light's position (translated below)
  color rgb <0.9,1,0.9>*1    // light's color
  translate <-20, 30, -20>
}                        

// An area light (creates soft shadows)
// WARNING: This special light can significantly slow down rendering times!
light_source {
  0*x                 // light's position (translated below)
  color rgb 0.5       // light's color
  area_light
  <-8, 0, -8> <8, 0, 8> // lights spread out across this distance (x * z)
  8, 8                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  rotate -45*x
  translate <3, 10, -4>   // <x y z> position of light
}

    

#declare ma_camera=0; //vue quasi face
#declare ma_camera=1; //vue 3/4 dessus
#declare ma_camera=2; //vue globale
#declare ma_camera=3; //face       
#declare ma_camera=4; //plan large

#declare ma_camera=4; //plan large

#if (ma_camera=0) camera {location  <-2, 6, -10> look_at   <2, 1,  1> focal_point <0,0,0> } #end
#if (ma_camera=1) camera {location  <0, 8, -6> look_at   <0, 2,  0> focal_point <0,0,0>} #end
#if (ma_camera=2) camera {perspective location  <1, 6, -12> look_at   <2.5, 0,  1> } #end
// perspective (default) camera
#if (ma_camera=3) camera {location  <2, 6, -12> look_at   <2, 0,  1> right     x*image_width/image_height} #end
#if (ma_camera=4) camera {perspective location  <1, 7, -14> look_at   <2.5, 0,  1> } #end                                                                                                

// Construction du d  coudre
// *********************************************************************************************************************

// Dfinition des paramtres
#local bit_dac = 1;
#local bit_aig = 1;
#local bit_trou_corps = 1;
#local bit_trou_tete = 1;   
#local bit_fil = 1;
#local ray_bas = 2;
#local ray_haut = 1.6;
#local haut_total = 5;
#local haut_bombe = 1.3;
#local ray_tore = 0.2;

#object {plaque_verre ()}

#if (bit_dac=1) //debut du dac
difference{
	union {

		cone { // Corps du d  coudre
  			0*y,  ray_bas,
  			(haut_total-haut_bombe)*y, ray_haut
			}

		// "Tte du d  coudre
		sphere { <0, 0, 0>, 1  scale ray_haut*x+(haut_bombe)/2*y+ray_haut*z translate (haut_total-haut_bombe)*y} 
		// Surplus en bas du d  coudre
		torus { ray_bas, ray_tore}


		
	}	

// Trous sur l'ensemble de la priphrie du d  coudre
// *********************************************************************************************************************

#if (bit_trou_corps = 1)	
	#local nb_blob = 20; // Nombre de blob par circonference
	#local nb_haut = 8; // Nombre de hauteur de blob
	#local pct_depart = 0.3; //Evaluation de la hauteur de depart en pourcentage
	#local haut_blob_depart = (haut_total-haut_bombe)*pct_depart; // Calcul de la hauteur de depart reelle          
	
	
	#local ray_trou = 0.18; // Rayon des trous effectus
	
	#local j=0; // paramtrage de boucle
	
	
	#while (j<nb_haut)
		#local i=0; // paramtrage de boucle
		#local rot_j= 360/nb_blob/2;
		#while (i<nb_blob)           
			  	#local haut_blob = haut_blob_depart+j*(haut_total-haut_blob_depart)/nb_haut*2/3;
			  	#local ray_blob = ray_haut-(ray_haut-ray_bas)*(1-pct_depart);
			  	#local ray_blob = ray_haut-(haut_total-haut_blob)*(ray_haut-ray_bas)/haut_total;
           	sphere {<0, 0, 0>  ray_trou scale <1,1.1,1> translate <ray_blob*cos (radians(360/nb_blob*i+rot_j*j)),haut_blob,ray_blob*sin (radians(360/nb_blob*i+rot_j*j))>}
		#local i = i+1;
		#end           
		#local j=j+1;
	#end
#end  
// Trous sur l'ensemble de la tete du d  coudre
// *********************************************************************************************************************

#if (bit_trou_tete=1)
	//Premiere rosace           
	#local nb_blob =5;
	#local ray_R1 = ray_haut/4;
	#local ray_trou = 0.18; // Rayon des trous effectus 
	
	#local i=0;
	#while (i<nb_blob)                                                                                
		sphere {<0, 0, 0> ray_trou scale 1*x+0.5*y+1*z translate <ray_R1*cos(radians(360/nb_blob*i)),(haut_total-haut_bombe)+haut_bombe/2*sin(acos(ray_R1/ray_haut)) ,ray_R1*sin(radians(360/nb_blob*i))> }
		#local i = i+1;
	#end
	
	//Deuxieme rosace           
	#local nb_blob =12;
	#local ray_R1 = ray_haut/2;
	#local ray_trou = 0.18; // Rayon des trous effectus 
	
	#local i=0;
	#while (i<nb_blob)                                                                                
		sphere {<0, 0, 0> ray_trou scale 1*x+0.5*y+1*z translate <ray_R1*cos(radians(360/nb_blob*i)),(haut_total-haut_bombe)+haut_bombe/2*sin(acos(ray_R1/ray_haut)) ,ray_R1*sin(radians(360/nb_blob*i))> }
		#local i = i+1;
	#end
	
	//Troisieme rosace           
	#local nb_blob =16;
	#local ray_R1 = ray_haut*3/4;
	#local ray_trou = 0.18; // Rayon des trous effectus 
	
	#local i=0;
	#while (i<nb_blob)                                                                                
		sphere {<0, 0, 0> ray_trou scale 1*x+0.5*y+1*z translate <ray_R1*cos(radians(360/nb_blob*i)),(haut_total-haut_bombe)+haut_bombe/2*sin(acos(ray_R1/ray_haut)) ,ray_R1*sin(radians(360/nb_blob*i))> }
		#local i = i+1;
	#end

#end

// *********************************************************************************************************************

  // texture ferraille pour le d

texture {
  pigment {          // (---surface color---)
    marble           // some pattern
    color_map {      // color map
      [0.1 color rgb <1,1,1>*0.5]
      [0.1 color rgb <1,1,1>*0.4]
      [0.5 color rgb <1,1,1>*0.45]
      [0.6 color rgb <1,1,1>*0.5]
      [1 color rgb <1,1,1>*0.5]
    }
    turbulence 1   // some turbulence
    //scale <1,3,1>    // transformations
    rotate 45*x+45*y+60*z
  }
  normal {           // (---surface bumpiness---)
    marble 0.3       // some pattern (and intensity)
    turbulence 0.5   // some turbulence
  }
  normal {bumps scale 0.2}
  finish {           // (---surface finish---)
    ambient 0.2
    specular 0.6     // shiny
  }
}
                                 
	translate ray_tore/2*y
//	rotate 90*y	
}    
#end //fin du dac

// debut de l'aiguille
#if (bit_aig =1)
difference {
	union {
	#local ray_max = 0.2;
	#local ray_min = 0.15;
	#local long_aig = 4;    
	#local long_pointe = 1;
	cone {
	  	0*x,    ray_max,
	  	long_aig*x, ray_min} //Fin du cone
	cone {
  		long_aig*x,  ray_min,
  		(long_aig+long_pointe)*x, 0
		} // Fin du cone
	#declare RadiusVal   = 0.35;
	#declare StrengthVal = 1.0;
	blob {
 	 	threshold 0.6
		#local i=0;
  		#while (i<10)
	  		sphere { < -i*0.1,   0,    0>, RadiusVal, StrengthVal }  	
			#local i = i+1;
		#end
		} //Fin du blob
	} //Fin de l'union               
	box {
 		<-0.1, -2/3*ray_max, -1>  
  		< -0.8,  2/3*ray_max,  1>     
	  } //Fin de la box
	
	scale <1,0.2,0.2>  
	rotate 20*x-0.25*z+20*y    
	translate  0.046*y
	translate 1*x-4*z
	texture {T_Chrome_5C}
	} //Fin de la difference
#end 




// create a TrueType text shape
text {
  ttf             
  //"courbd.ttf",
  "cour.ttf",
  "Protective/Agressive",      
  0,              
  0              
  scale 0.30
  pigment {White}      
  rotate 90*x
  translate <0.2,0,0.2>
  translate <-3,0.01,-6>
}


// Mise en place du fil 
#if (bit_fil = 1)
sphere_sweep {
  #local rayon_fil =0.03;	
  //#local rayon_fil =0.03;
  //linear_spline                 // linear curve
  //cubic_spline                // alternative spline curves
  b_spline
  10,                            // number of specified sphere positions
  <1.5, -0, -6>, rayon_fil
  <1.5, -0, -6>, rayon_fil
  //< -0.5, 0, -5>, rayon_fil
  < 0.5, 0.15, -5>, rayon_fil                                
  < -0.5, 0, -5>, rayon_fil                                
  < 4.5, 0, 0>, rayon_fil
  < 4.5, 0, -5>, rayon_fil
  < 7.3,0, -3>, rayon_fil
  < 7.3,0, -3>, rayon_fil
  < 9.3,-10, -3>, rayon_fil
  < 9.3,-20, -3>, rayon_fil
  //tolerance 0.001             // optional
  translate rayon_fil*y
  //pigment{color <0.8,0,0>}
  pigment {
  spiral2 4
      color_map {
      [0.0  color Orange]
      [0.8  color <0.8,0.5,0>]
      [0.9  color Red]
      [1.0  color Red]
    }
    rotate 90*y
    scale 0.1
    }

  }
#end //Fin du fil de couture...