// Persistence of Vision Ray Tracer Scene Description File
// File: rf_bathroom
// Vers: 3.6
// Desc: Bathroom items
// Date: 10/17/2005
// Auth: Rob Fitzel
// Units: Inches

#declare incl_rf_bathroom = 1;

// conditional includes
#ifndef(Metals_Inc_Temp)
  #include "metals.inc"
#end

#ifndef(Woods_Inc_Temp) 
  #include "colors.inc"
  #include "woods.inc"
#end

#ifndef(SHAPES_INC_TEMP)
  #include "shapes.inc"
#end 

#ifndef(Stones1_Inc_Temp)
  #include "stones1.inc"
#end


// -----------------------------------------------------------------------------
// Textures 
// -----------------------------------------------------------------------------
#declare t_mirror = texture {pigment {rgb 0} finish { reflection {0.8} ambient 0 diffuse 0 } };
#declare t_shower_tile = texture {pigment {image_map {png "st_ceramic_tile_gr4.png"}} finish {ambient 0.2} rotate <0,0,0> scale 12};
#declare t_counter_wood = texture {T_Wood10 rotate <0,0,0>}; //20 good //7   candidates: 7,10,13,16*,
#declare t_sink_ceramic =        texture {pigment {rgb 0.9} finish {ambient 0.3 phong 1 phong_size 90} };
#declare t_sink_ceramic_inside = texture {pigment {rgb 0.9} finish {ambient 0.3 phong 1 phong_size 90} };
#declare t_faucet = texture { T_Chrome_3B }; 
#declare t_countertop = 
texture {
  pigment {
    bozo
    color_map {
      [0.0 rgb  0.80]
      [0.5 rgb  0.85]
      [1.0 rgb  0.75]
    }
  }
  scale 0.1  
}; 
#declare t_frosted_shower_door = 
texture {
  pigment {
    bozo
    pigment_map {
      [0  rgbt <1,1,1,0.7>]
      [1  rgbt <1,1,1,0.3>]
    } 
    scale <0.1,1,1>/5
  }
  
};
#declare t_countertop = texture {T_Grnt12 scale 1};



// -----------------------------------------------------------------------------
// Objects 
// -----------------------------------------------------------------------------

// Sink ////////////////////////////////////////////////////////////////////////


#declare faucet_pipe = 
union {
  superellipsoid {<0.8,0.5>  scale <0.5,0.4,3>} // base
  difference {
    superellipsoid {<0.8,0.5>  scale <0.5,1,2.5> translate <0,-0.75,-0.2>}
    cylinder {<2,-2,0>,<-2,-2,0> 2 scale <1,0.6,2.5> translate <0,-0.25-0.2,1.5+1> }
  } 
  cylinder {<0,0.2,0>,<0,-0.3,0> 0.4 rotate <15,0,0> translate <0,-0.20,2>}
  cylinder {<0,0,0>  ,<0,-0.3,0> 0.3 rotate <15,0,0> translate <0,-0.25,2>} 
  
  rotate <-15,0,0>
};

#declare sink_handle = 
union {
  superellipsoid {<0.5,0.5> scale <0.3,0.1,1.5>} 
  difference {
    superellipsoid {<0.5,0.5> scale <0.3,0.5,1.5> translate <0,-0.5,0>} 
    cylinder {<1,0,0>,<-1,0,0> 1 scale <1,0.5,1.5> translate <0,-0.5,0.5> }
  }
  rotate <-10,0,0>
};


#declare faucet =
union {
  superellipsoid {<0.9,0.7> scale <4,1,2> clipped_by {plane {-y,0}} }
  cone {<0,0,0> 0.9 <0,2,0> 0.7 scale <1,1,1.3>}
  cylinder {<0,2,0> <0,2.5,0> 0.7 scale <1,1,1.3>} 
  sphere {0 1 scale <1,1.3,1.1> translate <0,2.5,0.2> } 
  
  union {
    cylinder{ <0,0,0>,<0,3,0> 0.1} 
    cylinder{ <0,3,0>,<0,3.3,0> 0.25}
    cone {<0,3.3,0>,0.3,<0,3.6,0> 0.2}
    sphere {0 0.2 scale <1,0.5,1> translate <0,3.6,0>}
    rotate <-10,0,0>
    translate <0,0,-1>
  }
  
  union {faucet_pipe translate <0,3.2,3>} 
  union {sink_handle translate <0,4,1.5>} 
  scale 0.7
  texture {t_faucet}
};

// for some reason using clipped_by spheres also clips the entire countertop
#declare sink_cutout = 
union {
  difference {
    sphere {0,6 scale <1,0.5,0.8>}
    plane {z,0}
  }
  difference {
    sphere {0,6 scale <1,0.5,0.6>}
    plane {-z,-1}
  }
};


#declare sink = 
union {

  // ring around the sink
  torus {6.5 0.5 scale <1,0.5,0.8> clipped_by {plane{-z,0} } } 
  torus {6.5 0.5 scale <1,0.5,0.6> clipped_by {plane{z,0} } }
  // yucky brute force to make ring wider near the faucet
  #local i=0;
  #while (i<10)          
    torus {6.5 0.5 scale <1,0.5,0.6+0.05*i> clipped_by {plane{z,0} } }        
    #local i=i+1;
  #end
  
  // stopper
  sphere {0 1 scale <0.75,0.1,0.75> texture {T_Chrome_1A} translate <0,-3,0>}
  cylinder {<0,0,0>,<0,0.05,0> 1.25 texture {T_Chrome_1A} translate <0,-3,0>}
  object {faucet translate <0,0,-5.5>}
  
  texture {t_sink_ceramic}  
  
}; 
/*
#declare sink_cutout = sphere {0, 6 scale <1,1,0.8> rotate <25,0,0>};  
#declare sink_cutout= intersection {
  sphere {0, 6 scale <1,1,0.8> rotate <0,0,0> }
  sphere {0,10 scale <1,1,0.8> translate <0,0,4> }   
}; 

#declare sink_cutout_half1 = sphere {0, 6 scale <1,0.5,0.8> bounded_by {box{<-6,-6,6>,<6,6,0>}  } };
#declare sink_cutout_half2 = sphere {0, 6 scale <1,0.5,0.5> bounded_by {box{<-6,-6,-6>,<6,6,0>}  } };

*/


/*
#declare sink_cutout = 
union {
  sphere {0, 6 scale <1,0.5,0.8> clipped_by {plane {-z,0}} }
  sphere {0, 6 scale <1,0.5,0.5> clipped_by {plane {z,0}} }
  //pigment {rgbt <1,0,0,0.5>} 
};
*/


// Counter ////////////////////////////////////////////////////////////////////
#ifndef (counter_height)
  #declare counter_height =30;
#end
 
#declare counter = 
union {
  #local cy=counter_height;
  #local cx=60;
  #local cz=20; 

  #declare counter_door_inner = 
  union {
    box {<0,0,0>,<1,3,0.5>}
    box {<0,3,0>,<1,3.5,0.35> /*pigment {rgb <1,0,0>} */ }
   // cylinder {<0,3,0.35>,<1,3,0.35> 0.1 /*pigment {rgb <0,1,0>}*/ }
  };
 

  #declare counter_door = 
    #local dw = 19.9;
    union {
      //box {<1,4,cz>,<19.9,cy-2,cz+0.25>  texture {t_counter_wood scale 6 rotate <90+90,0,3>  } } // backing
      box {<1,4,cz>,<19.9,cy-2,cz+0.25>  texture {t_counter_wood rotate <85,0,0>   scale 4 } } // backing
      object {counter_door_inner scale <cy-2-4,1,1> texture {t_counter_wood rotate <0,91,0> scale 6} rotate <0,0,-90> translate <1,cy-2,cz>  } 
      object {counter_door_inner scale <cy-2-4,1,1> texture {t_counter_wood rotate <0,91,0> scale 6} rotate <0,0,90> translate <dw,4,cz>  }
      object {counter_door_inner scale <dw-3-4,1,1> translate  <4,4,cz>    texture {t_counter_wood rotate <0,91,0> scale 6} } // bot      
      object {counter_door_inner scale <dw-3-4,-1,1> translate <4,cy-2,cz> texture {t_counter_wood rotate <0,91,0> scale 6} } // top     
      // handle
      torus {2 0.2 rotate <0,0,90> scale <1,1,0.7>  translate <2,cy-7,cz> texture {T_Chrome_1A} }
  }; 
  #local dy = (counter_height - 5 -4 )/4;
  #declare counter_drawer = 
  union {

    box {<0,0,0>,<18,dy,0.5> texture {t_counter_wood scale 7 rotate <91,0,90> }  }
    //handle
    torus {2 0.2 rotate <0,0,0> scale <1,1,0.7>  translate <9,dy-1,0.5> texture {T_Chrome_1A} }
  };
  

  // base
  box {<2,0,0>,<cx-2,3,cz-2> texture {t_counter_wood scale 7 rotate <89,0,0>} } 
  
  
  // body
  difference {
    union {
      box {<0,3,0>,<cx,cy-1,cz> texture {t_counter_wood scale 7-5 rotate <85,0,0>} }
     
      Round_Box_Merge(<0,cy-1,0>,<cx,cy,cz>, 0.2)   // countertop 
      union {Round_Box_Merge(<0,cy-1,-1>,<cx,cy+2,1.5>,0.2) clipped_by {plane {z,0}} }  // backsplash 
      box {<0,cy+2,0>,<cx,cy+2+0.2,0.01> texture {pigment {rgbt <1,1,1,0.6>} /*finish {ambient 0.5}*/}  }// backsplash caulking
      
      texture {t_countertop} 
      }
    object {sink_cutout translate <35,cy,10> texture {t_sink_ceramic_inside} }
    texture {t_sink_ceramic_inside}
  }  
  
  // temp
  //object {sink_cutout translate <35,cy,10> texture {pigment {rgbt <1,0,0,0.5>} }}
  
  
  
//  object {sink_cutout2  translate <35,cy,10> }
  // sink
   object {sink translate <35, cy, 10>}
  // doors - need more detail
  object {counter_door scale <-1,1,1> translate <20,0,0>}
  object {counter_door translate <20,0,0>} 
  #local i=0;
  #while (i<4)
    object {counter_drawer translate <41,4+(dy+1)*i,cz>}
    #local i=i+1;
  #end
  
  //box {<1,4,cz>,<19.9,cy-2,cz+0.5> texture {t_counter_wood rotate <0,90,90> scale 0.5}  }
  //box {<1,4,cz>,<19.9,cy-2,cz+0.5> texture {t_counter_wood rotate <0,90,90> scale 0.5}  translate <20,0,0>} 
  
  // drawers
//  box {< 
//  rotate <0,45,0>
};


// Mirror /////////////////////////////////////////////////////////////////////
 
#declare mirror_clip = 
union {
  box {<0,0,-0.1>,<1.5,0.05,0.1>}
  box {<0,0,-0.1>,<1.5,0.2,-0.1>}
  box {<0,0, 0.1>,<1.5,0.2, 0.1>}
  //pigment {rgb 0.3} 
  texture {T_Chrome_3D}
};


#declare mirror = 
union {
  intersection {
    Round_Box_Merge(<0,0,-1>,<48,36,1>, 2)
    box {<0,0,0>,<48,36,0.2> } 
    } 
  texture {t_mirror}
  };
  
// Vanity lights / (needs work) /////////////////////////////////////////////

#ifndef(bulb_light)
  #declare bulb_light = 0;
#end

#declare light_bulb = 
union {
  sphere {0,1 texture {pigment {rgb 0.95} finish {ambient 0.7} }  no_shadow}
  cylinder {<0,0,0>,<0,0,-3>, 0.25 texture {T_Chrome_1A} } 
  #if (bulb_light>0)
    light_source {<0,0,5> rgb bulb_light}
  #end
  translate <0,0,3>
}

#declare light_bulb_sppt = 
union {
  Round_Box_Merge (<0,0,0>,<36,5,1>,1)
  #local i=1;
  #while (i<5)
    object {light_bulb translate <9+i*7,2.5,0>}
    #local i=i+1;
  #end
  texture {T_Chrome_1E} 
}

// toothbrush (low res) and cup ///////////////////////////////////////////////
#declare toothbrush = 
union {
  Round_Box_Merge (<-0.2,0,0>,<0.2,0.2,7>,0.1) 
  box {<-0.2,0.2,6>,<0.2,0.5,7> texture {pigment {rgbt <1,1,1,0.3> } }}
  texture {pigment {rgb <0.7,0.5,0.5>}}
};

#declare toothbrush_cup = 
union {
  difference {
    cone {<0,0,0>,1.2,<0,4,0>,1.4}
    cone {<0,0,0>,1.2,<0,4,0>,1.4 translate <0,0.1,0>}
  }
 object {toothbrush  rotate <-70,0,0>} 
 rotate <0,30,0>
 texture { pigment {rgb <0.98,0.941,0.741>}}
};


// Shower stall /////////////////////////////////////////////////////////////// 
#declare t_shower_white = texture { pigment {rgb 0.95} finish {ambient rgb 0.3 phong 1 phong_size 100} };
#declare shower_door_side_frame = 
union {
  Round_Box_Union(<0,0,0>,<4,67,2>,0.5)
  box {<4,4,1>,<5,65,1.5> texture {T_Chrome_3A} }
  box {<5,4,1.25>,<5.5,65,1.5> texture {T_Chrome_3A} } 
  texture  {t_shower_white}
}  
  
#declare shower_door =
union {
   // sides
  object {shower_door_side_frame translate <0,0,0>} // door opening from 5.5 to 22.5
  object {shower_door_side_frame scale <-1,1,1> translate <28,0,0>}
  
  // bottom
  union {    
    Round_Box_Union(<0,-1,-0.2>,<28,4,2>,0.5) 
    texture  {t_shower_white}
     
  }
  
  // frosted glass door
  box {<5.5,4,1.5>,<22.5,65,2> texture {t_frosted_shower_door} } 
  // door top
  box {<4,65,1.5>,<24,65.1,2> pigment {rgb 0} }
  box {<4,65.1,1.5>,<24,65.5,2> texture {T_Chrome_3A} }
};

#declare shower_stall =
union {
  union {shower_door translate <0,0,2>}
  box {<0,0,3>,<0.2,80,36>   texture {t_shower_tile rotate <0,90,0>} }
  box {<0,0,36>,<28,80,37> texture {t_shower_tile} }
  box {<28,0,36>,<27.8,80,3> texture {t_shower_tile rotate <0,90,0>} }  
  box {<0,0,3>,<28,-1,36>    texture {t_shower_tile rotate <90,0,0>} } // floor
  box {<0,80,3>,<28,81,36>   texture {t_shower_tile rotate <90,0,0>} } // ceiling
  pigment {rgb 0.5}
};

// unfinished toilet //////////////////////////////////////////////////////////
#declare t_toilet = texture {pigment {rgb 1} finish {phong 1 phong_size 40}};
#declare toilet = 
union {
  union {Round_Box_Merge (<-9,0,0>,<9,2,12>,0.5)  translate <0,28,0>}
  union {Round_Box_Merge (<-8.5,0,0.5>,<8.5,10,11.5>,0.5) translate <0,19,0>}
  
  sphere {0 1 scale <7,6,8> clipped_by { plane{y,0} } translate <0,15,-5>}

  texture {t_toilet}

}
 
#declare p_toilet_paper_roll = 
pigment {
  cylindrical
  pigment_map {
     [0    rgb 1]
     [0.6  rgb 1]
     [0.6  rgb <0.573,0.443,0.286>]
     [0.65 rgb <0.573,0.443,0.286>]
     [0.65 rgbt 1]
     [1    rgbt 1]  
  }
};

// Toilet Paper Roll //////////////////////////////////////////////////////////
#declare toilet_paper_roll =
union {
  cylinder {<0,0,0>,<0,4.13,0> 1.97 pigment {p_toilet_paper_roll scale 1.97}  }
};

#declare toilet_paper_roll =
union { 
 // cylinder {<0,0,0>,<0,4.13,0> 0.78 open pigment {rgb <0.573,0.443,0.286>}}
  difference {
    cylinder {<0,0,0>,<0,4.13,0> 1.97 pigment {p_toilet_paper_roll scale 1.97}  }
    cylinder {<0,-1,0>,<0,5,0> 0.78} 
    pigment {rgb <0.573,0.443,0.286>}
  }
};



// soap and dish //////////////////////////////////////////////////////////////
#declare t_soap_dish =  texture {pigment {rgb <0.969,0.918,0.749>}};
#declare soap_dish = 
union {
  difference {
    intersection {
      sphere {0,1 scale <1.5,1,2.5> texture {t_soap_dish}}   
      box {<5,-0.25,5>,<-5,0.1,-5>  }
      texture {t_soap_dish}
    }
  cylinder {<0,0,0>,<0,1,0> 1 scale <1.5,1,2.5>*0.9 translate <0,0.05,0>} 
  texture {t_soap_dish}
  }
  
    
  // soap
  union {
   // Round_Box_Union (<0,0,0>,<1.75,0.7,3>,0.1)
    superellipsoid {<0.5,0.5> scale <0.8,0.2,1.5>}
   // translate <-0.75,0.1,-1.5>
    texture {pigment {rgb <1,1,0.95>}}
  }  
  translate <0,0.25,0>
  
};



// towelbar ///////////////////////////////////////////////////////////////////
#declare t_towel1 = texture {pigment {image_map  {png "towel_pink2.png"}}
                             //normal  {bump_map {png "b_towel_pink.png"}}
                             normal {waves 5/*scale <0.5,2,0.5>*/} 
                             //normal {ripples 1 rotate <45,0,0> scale <1,2,1>}
                             scale 2 };  //5

                                            
#declare towel_bar = 
union {
  cylinder {<0,0,0>,<0,0,-3> 1 }
  cylinder {<24,0,0>,<24,0,-3> 1}
  box {<0,-0.5,-3>,<24,0.5,-3> rotate <0,0,0>} 
  
  // towel
  box {<2,0.7,-3.5>,<20,-26,-3.4> texture {t_towel1}
      }
  texture {T_Chrome_3C}

};

#declare t_towel_bar_pewter = texture {pigment {rgb 0.4} };
#declare towel_bar_support = 
union {
  cylinder {<0,0,0>,<0,0,-0.2> 1}
  #local i=0;
  #while (i<3)
    sphere {0 0.1 scale <1,1,0.25> translate <0,0,-0.2> rotate <90*i,0,0>} // bolts
    #local i=i+1;
  #end 
  difference {
    cylinder {<0,0,-0.2>,<0,0,-3.5> 0.75 texture {t_towel_bar_pewter}}
    torus {5,4.7 rotate <90,0,0> scale <1,1,1.2> translate <0,0,-2.5>  }
    texture {t_towel_bar_pewter}
 }
 sphere {0,0.75 clipped_by {plane {x,0}} translate <0.25,0,-3.5> } 
 texture {t_towel_bar_pewter}
};
 
#declare towel = 
union {
  box {<0,0,0>,<18,-20,-0.05> texture {t_towel1} rotate <0,0,3> clipped_by {plane {y,0}} }
  box {<0,5,-0.6>,<-18,-24,-0.65> texture {t_towel1 translate <-12,0,0>} rotate <0,0,3> scale <-1,1,1> clipped_by {plane {y,0}} }
};

#declare towel_bar =
union {
  union {towel_bar_support}
  union {towel_bar_support scale <-1,1,1> translate <24,0,0>}
  box {<0.25,0.4,-3.9>, <24,-0.4,-3.1> pigment {rgbt <1,1,1,0.8>}}
  object {towel translate <3,0.3,-3.5> }  // don't forget to throw in the towel!
};