// Persistence of Vision Ray Tracer Scene Description File
// File: kleenex.inc
// Vers: 3.6
// Desc: kleenex box 
// Date: Sept 10, 2005
// Auth: Rob Fitzel
// Units: inches

#declare kleenex_box_top    = box {<0,2.74,0>,<9,2.75,4.5>  texture {pigment {image_map{png "kleenex_box_top.png"}  rotate <90,0,0>  scale <9,1,4.5>}}    finish {ambient 0.5}};
#declare kleenex_box_bottom = box {<0,0,0>,<0,0.1,0>        texture {pigment {rgb 1}}};
#declare kleenex_box_front  = box {<0,0,0>,<9,2.75,0.001>   texture {pigment {image_map{png "kleenex_box_front.png"}                 scale <9,2.75,1>}}   finish {ambient 0.3}};
#declare kleenex_box_back   = box {<0,0,4.499>,<9,2.75,4.5> texture {pigment {image_map{png "kleenex_box_back.png"}                  scale <9,2.75,1>}}   finish {ambient 0.3}};
#declare kleenex_box_left   = box {<0,0,0>,<0.001,2.75,4.5> texture {pigment {image_map{png "kleenex_box_left.png"}  rotate <0,90,0> scale <1,2.75,4.5>}} finish {ambient 0.3}};
#declare kleenex_box_right  = box {<9,0,0>,<8.999,2.75,4.5> texture {pigment {image_map{png "kleenex_box_right.png"} rotate <0,90,0> scale <1,2.75,4.5>}} finish {ambient 0.3}};

#include "rand.inc"
#declare kleenex_seed = seed(3);
#macro a()
  RRand(-5,5,kleenex_seed)
#end
#macro b(i)
  i+RRand(-0.5,0.5,kleenex_seed)
#end

#declare tissue = 
  bicubic_patch {
   type 1 flatness 0.001
   u_steps 4 v_steps 4
   <0,0,0>,<1,0,0>,<2,0.0,0>,<3,0.3,0>
   <0,0,1>,<1,0,1>,<2,0.01,1>,<3,0.1,1>
   <0,0,2>,<1,0,2>,<2,0,2>,<3,0,2>
   <0,-10,3>,<1,a(),3>,<2,0,3>,<3,0,3>
   scale <1.5,0.2,1> 
   rotate <-90,0,0> 
   texture {pigment {rgbt <1,1,1,0.1>} }
   };
  
#declare tissue = 
  bicubic_patch {
   type 1 flatness 0.001
   u_steps 4 v_steps 4
   <b(0),a(),0>,<b(1),a(),0>,<b(2),a(),0>,<b(3),a(),b(0)>
   <b(0),a(),1>,<b(1),a(),1>,<b(2),a(),1>,<b(3),a(),b(1)>
   <b(0),a(),2>,<b(1),a(),2>,<b(2),a(),2>,<b(3),a(),b(2)>
   <b(0),a(),3>,<b(1),a(),3>,<b(2),a(),3>,<b(3),a(),b(3)/2>
   scale <1.5,0.5,0.3> 
   rotate <-90,0,0> 
   texture {pigment {rgbt <1,1,1,0.1>} finish  {phong 0 ambient 0.2} }
   };
  
  
#declare kleenex_box =
union {
  object {kleenex_box_top}
  object {kleenex_box_bottom}
  object {kleenex_box_front}
  object {kleenex_box_back}
  object {kleenex_box_left}
  object {kleenex_box_right}
  
  object {tissue translate <2,2.75,2.25>}
  //box {<2,2.75,2.25>,<7,4,2.26>}
  
  translate <-4.5,0,-2.25> // center the box
};


#undef a
#undef b
