// Persistence of Vision Ray Tracer Scene Description File
// File: rfmadeup.pov
// Vers: 3.6
// Desc: Two made up women
// Date: Sept 23, 2005
// Auth: Rob Fitzel
// Units: inches

// includes /////////////////////////////////////////////////////////////////// 
#include "rand.inc"
#include "rf_arch_int.inc" 
#include "rf_bathroom.inc"

// Scene Controls /////////////////////////////////////////////////////////////
// Camera Angle  
#declare view = 1;

// Scene elements
#declare draw_ceiling = 1;
#declare draw_counter = 1;
#declare draw_clutter = 1; 
#declare draw_shower  = 1;
#declare draw_vic     = 0; // young woman in mirror 
#declare draw_olga    = 0; // old woman 

// positions
#declare counter_height = 30;
#declare pos_window     = <62,30,0>; 
#declare doorPos        = <96,0,50>;

// lights
#declare sun_light = 5;
#declare sun_area  = 2; // 1=basic area 2= hi qual area
#declare SunPos    = <-110,50,10>;
#declare cam_light = 0.5;
#declare top_light = 0; // make 0 in non-radiosity scenes
#declare bulb_light= 0;

// special effects
#declare rad       = 3;
#declare draw_blur = 0; // need better settings


#if (top_light >0)
  #declare draw_ceiling = 0;
#end

// random seeds
#declare tcr = seed(155); // curtain waves

global_settings {
  max_trace_level 100
  
  #if (rad>0)
    #include "rad_def.inc"
    radiosity {    
      #switch (rad)
        #case (3)                                  
        Rad_Settings(Radiosity_IndoorHQ, off, off) 
        count 100
        brightness 1.2 
        save_file "rfmirror_hq3.rca"
      //load_file "rfmirror_hq3.rca"
        #break      
      
      #case (2)
        Rad_Settings(Radiosity_IndoorLQ, off, off) 
        //pretrace_end   0.004 // use HQ setting 
        pretrace_end   0.001
        //count 200 // v.v. slow
        count 100
        error_bound 0.15
        brightness 1.2 //1.5 is too bright
       // save_file "mirror_hq.rca"
       // load_file "mirror_hq.rca" 
       #break
      #else
        Rad_Settings(Radiosity_IndoorLQ, off, off) 
        brightness 1.2
        //save_file "mirror_lq.rca"             
        //load_file "mirror_lq.rca" 
      #end

    }
  #end
  

}

// Camera /////////////////////////////////////////////////////////////////////
#declare camang = 90;
#switch (view)
  #case (0)  // top view
    #declare CamPos    = <-48, 250, 48> ;
    #declare CamLookAt = <-48,0,48>; 
    #declare draw_ceiling = 0;
    #break
  #case (1) // front action 
    #declare CamPos    = <30, 50, -15>;
    #declare CamLookAt = <0,30,100>;
    #declare camang = 120;
     
    #declare CamPos    = <35, 50, -15>;
    #declare CamLookAt = <-10,30,100>;
          
    
    #break 
  #case (2) // shower stall              
    #declare CamPos    = <60,60,10>;
    #declare CamLookAt = <60,50,94>;
    #break
  #case(3) // counter
    #declare CamPos    = <80,30,20>;
    #declare CamLookAt = <0, 10,20>;
    #break 
  #case(4) // window view
    #declare CamPos    = <80,50,70>;
    #declare CamLookAt = < 0,50,70>;
    #break
  #case(5) // window side view
    #declare CamPos    = <2,80,50>;
    #declare CamLookAt = <0,80,100>;
    #break
    
  #else  
    #declare CamPos    = <0, 5, -50>; 
    #declare CamLookAt = <0,5,0>; 

#end


camera {
  location  CamPos 
  look_at   CamLookAt

  #if (draw_blur)
    focal_point <30,50,45>    
    aperture 5
    blur_samples 10     // more samples, higher quality image  
    variance 1/10000 
    confidence 0.95
  #end

}





// Textures ///////////////////////////////////////////////////////////////////
#declare c_wall = <0.9,1,1>;
#declare t_wall = texture {pigment {rgb c_wall} normal {bumps 0.1 scale 0.1} finish {ambient 0.3} };
#declare t_floor = texture {pigment {image_map {png "st_ceramic_tile_gr3.png"}} finish {ambient 0.2} rotate <90,0,0> scale 12};
#declare t_ceiling = texture {pigment {rgb 0.9} finish {ambient 0.7 /*0.4*/} }; 
#declare t_curtains = 
texture {
  pigment {
    bozo
    pigment_map {
      [0.0 rgbt <0.7,0.6,0.6,0.3>]
    //  [0.5 rgbt <0,0,0,0.5>]
    //  [0.5 rgbt <1,1,1,0.4>]
      [1.0 rgbt <0.7,0.6,0.6,0.4>]
    } 
    scale <1,50,1> 
    rotate <5,0,5>
  } 
  finish {ambient rgb 0.7}
}; 


#declare t_curtains = 
texture {
  pigment {
    bozo
    pigment_map {
      [0.0 rgbt <0.7,0.6,0.6,0.1>]
    //  [0.5 rgbt <0,0,0,0.5>]
    //  [0.5 rgbt <1,1,1,0.4>]
      [1.0 rgbt <0.7,0.6,0.6,0.2>]
    } 
    scale <1,50,1> 
    rotate <5,0,5>
  } 
  finish {ambient rgb 0.7}
}; 

#declare t_baseboard = texture {pigment {rgb 1} finish {ambient 0.3} };


// Scene Objects /////////////////////////////////////////////////////////////
//Bathroom walls
// 8 feet * 8 feet = 96 inches



#declare wall = box {<0,0,0>,<96,96,0.001> texture {t_wall} }; 
#declare inner_window_cutout = box {<2,2,-1>,<28,46,1>};
#declare window_cutout = box {<0,0,-1>,<30,48,1>}; 
#declare curtains =      box {<0,0,0.499>,<31,51,0.501>  texture {t_curtains} /*double_illuminate*/} 

#declare curtains = 
union {
  #local cx = 10; // curtain width
  #local cs = 3;  // max curtain wave size
  #local i=0;
    #while (i<cx) 
      #local wave_size = RRand(1,3,tcr);
      cone {<0,51,0>,0.1*wave_size,<0,0+RRand(-0.05,0.05,tcr),0>,wave_size clipped_by {plane {-z,0} } translate <i,0,0> }
      #local i = i+RRand(0.3,1,tcr);
    #end  
 
    texture {t_curtains}

};


#declare t_curtain_rod_gold = texture {pigment {rgb <0.929,0.757,0.31>} finish {phong 1 phong_size 100} };
#declare curtain_rod = union {
  cylinder {<0,0,0>,<34,0,0>, 0.25 texture {pigment {rgb 0.8}} }
  sphere {0 0.35 scale <2,1,1> clipped_by {plane {x,0}} texture {t_curtain_rod_gold} }
  sphere {0 0.35 scale <2,1,1> clipped_by {plane {-x,0}} translate <34,0,0> texture {t_curtain_rod_gold}}  
  //cylinder {<2,0,0>,<32,0,0> 0.3 texture {t_curtains} } 
  object {curtains  translate <3,-51,-0.5> }
  object {curtains  translate <21,-51,-0.5> }
};


#declare shower_cutout = box {<0,0,-5>,<27,80,5>}
#declare mirror_hole =  Round_Box_Merge(<0,0,-1>,<48,36,1>, 2);


#declare window_wall = 
union {
  difference {
    object {wall }   // window wall
    object {window_cutout  translate pos_window} 
    object {mirror_hole  translate <1,34,0> /*<1,36,0>*/  }
  } 
  
  union {mirror_clip translate <10,36,0>}
  union {mirror_clip translate <32,36,0>}
    
  window_casing(30,48,texture {pigment {rgb 1}}, transform {scale <1,1,1> translate pos_window})
};

#declare back_wall = 
  difference {
    object {wall }   
   // object {window_cutout  translate pos_window} // fake window
  };




#declare far_wall =  
difference {
  object {wall translate <0,0,96>}  
  object {shower_cutout translate <50,0,96>} 
  texture {t_wall} 
  }; 


 

// Lights ///////////////////////////////////////////////////////////////////// 

#declare sun = 
//#if (sun_light>0)
  light_source { <-100,50,-50>  rgb sun_light 
  #if (sun_area>0)
    area_light
    <10, 0, 0> <0, 0, 10> // lights spread out across this distance (x * z)
    #if (sun_area=1)
      4, 4                // total number of lights in grid (4x*4z = 16 lights)
    #else
      16, 16
    #end
    adaptive 0          // 0,1,2,3...
    jitter              // adds random softening of light
    circular            // make the shape of the light circular
    orient              // orient light
  #end
  
  projected_through { inner_window_cutout translate pos_window rotate <0,-90,0> }   
   
  }
        

#if (cam_light) 
  light_source {0*x rgb cam_light translate CamPos}
#end 
  
#if (top_light>0) 
  light_source {0*x rgb top_light translate <50,10000,50>}
#end  

// makes things too bright - perhaps won't need cam_light
background {c_wall}


// bathroom walls
 
#declare bathroom = 
union {

  object {far_wall  }  // with shower
  
  
  object {baseboard  scale <50,1,1>  translate <0,0,95>  texture {t_baseboard} } 
  #if (draw_shower)
    object {shower_stall translate <50,0,94>} 
  #end
  object {towel_bar    translate <20,36,96>}  
  
  
  object {wall rotate <0,90,0> translate <96,0,96>}  // backwall 
  union {
    object {door scale <-1,1,1> rotate <0,-90,0> translate doorPos+<0,0,30+2.375> texture{pigment {rgb 1} finish {ambient 0.3}}}
    window_casing(29.75+2.375*2,80+2.375,texture {t_baseboard}, transform {rotate <0,-90,0> translate doorPos})
    translate <-0.5,0,0>
  }
  
  object {window_wall rotate <0,-90,0>} 
  
  
  
   
  box {<0,0,0>,<96,-1,96> texture {t_floor} }
  #if (draw_ceiling)
    box {<0,96,0>,<96,97,96> texture {t_ceiling} }
  #end
  #declare pos_toilet = <4,0,75>;
  object {toilet rotate <0,270,0> translate pos_toilet }
  object {toilet_paper_roll translate pos_toilet+<0,30,5>}
  #if (draw_counter) 
    #include "rf_kleenex.inc"    
    #include "toothpaste_tube.inc"
    object {counter rotate <0,90,0>  translate <0,0,60> }
  
    #if (draw_clutter) 
      #include "rf_cosmetics.inc"
     // object {light_bulb_sppt rotate <0,90,0> translate <0,70,48>}  
      
      object {kleenex_box rotate <0,-25,0> translate <10,counter_height,50>}
      object {white_comb rotate <0,170,0>  translate <18,counter_height,37>}  
      object {toothpaste_tube_ rotate <0,250,180> scale <1,0.75,1> translate <7,counter_height,43>} 
      object {gel_bottle3 rotate <0,0,0> translate <15, counter_height, 43>} 
      object {gel_bottle1 rotate <0,220,0> translate <17, counter_height, 46>}
      object {cream_bottle3 translate <10, counter_height, 44>}
      object {toothbrush_cup translate <5, counter_height, 40>}
      object {lipstick2 translate <4,counter_height, 37>}
      object {lipstick3 translate <3.2,counter_height, 34.2>}
      object {lipstick4 translate <2.9 counter_height, 33>}
      object {lipstick1 rotate <0,0,90> rotate <0,30,0>  translate <6,counter_height+0.25, 37>}
      object {soap_dish rotate <0,45,0> translate <6.5, counter_height,33>}  
     
      object {tube_bottle2_ rotate <0,160,0> translate <11, counter_height, 37>} 
      cylinder {<0,0,0>,<0,0.3,0> 0.3 translate <14, counter_height, 38> pigment {rgb 1} } // tube_bottle2_'s cap
      object {compact   rotate <0,70+40,0> translate <15,counter_height,33>} 
      
      object {hair_dryer rotate <0,0,90> rotate <0,0,-10> rotate <0,15,0> translate <11, counter_height+1.2,7>} 
      object {curling_iron rotate <0,290,0>  translate <6, counter_height, 8>}
      object {hair_pick    rotate <0,-120,0> translate <18, counter_height,15>}
      object {nivea_jar translate <3, counter_height,15>}
      object {vaseline_jar rotate <0,80,0> translate <4, counter_height,50>} 
      object {gel_bottle4 rotate <0,180,0> translate <4, counter_height, 17>}  
      object {cream_bottle1 rotate <0,300,0> translate <3, counter_height, 12> }
      
    #end
  #end  

};



// The Scene //////////////////////////////////////////////////////////////////
light_group {
  light_source {sun}
  object {bathroom}
  object {curtain_rod translate  pos_window+ <-2,50,-1> rotate <0,-90,0>} 
  object {inner_window_cutout translate pos_window rotate <0,-90,0> texture {pigment {rgb 1} finish {ambient 1} } }                               
}

light_group {
  light_source {sun scale <-1,1,1>}                                
  object {bathroom scale <-1,1,1>} 
}

#if (draw_olga)
  #include "BathroomOlgaFatPoseG.inc"  
  object {BathroomOlgaFatPoseG_ scale <-1,1,1> rotate <0,-100,0> scale 7*12 translate <32,0,45> }
     
#end 
 

#if (draw_vic)
  #include "BathroomVicPoseG.inc" 
  object {BathroomVicPoseG_ scale <-1,1,-1>  rotate <0,-80,0> scale 7*12 translate <-32,0,45>}
#end 



// experiment: lighting doesn't look right
/*
  #include "BathroomOlgaFatPoseD.inc"  
  object {BathroomOlgaFatPoseD_ scale <-1,1,1> rotate <0,-120,0> scale 7*12 translate <32,0,45> no_reflection} 
  #include "BathroomVicPoseD.inc" 
  light_group {
    light_source {CamPos rgb 2 }
    object {BathroomVicPoseD_     scale <-1,1,1> rotate <0,-120,0> scale 7*12 translate <32,0,45> no_image no_shadow}   
  }
*/  
