/*
  #####################################
  IRTC Contest october 2005 - Opposites
  #####################################
  
  *****************************************
  *                                       * 
  *   Seoul street - by Pierre Schwartz   *
  *                                       *
  *****************************************
  
  
  join me -> pierre.schwartz@gmail.com 
  
  source code made on POV-Ray 3.6 
  parsed and rendered without error (only the radiosity warning)
  
  My .inc files
   - roof_basic.inc         : mesh made on Rhinoceros          
   - lampadaire.inc         :     "      
   - lampadaire_panneau.inc :     "
   - cherry.inc             : tree made with POV-Tree java applet (a simple cherry tree without folliage)  
   
   
  Image files needed : 
   - road.png
   - panneau.png
   - triyinyang.png
   - phone.png 



  If you want a short render, set the 2 following options to false, 
  and you won't render nor the trees nor the radiosity.
  If you want to use them, ok, but you'll need much more time to render the image (~ 100 h for me in 1024*768)



*/

#declare high_qual = true; 
#declare trees_on = true;

global_settings {
	max_trace_level 5
	ambient_light  1.2
        #if (high_qual)
        radiosity {
                brightness 1.2
                count 100
                error_bound .15
                low_error_factor .2
                minimum_reuse .015
                nearest_count 10
                recursion_limit 5
                adc_bailout .01
                max_sample .5
                normal off
                always_sample 1
                pretrace_start .08
                pretrace_end .01
        }              
        #end
}


#debug "* parsing opposite\n"
#debug " * reading include files\n"

#include "colors.inc"      
#include "skies.inc"   
#include "shapes.inc"  
#include "stones1.inc"
#include "stones2.inc"      
#include "textures.inc"
#include "woods.inc"

#declare cam_pos = <-15,10,-30>;
camera{
        location cam_pos
        look_at <13,20,1>
      }    

#declare srand=seed(5);
      
  
light_source{cam_pos, White 
                shadowless
                fade_distance 50
                fade_power 2
            }      

light_source{
        <-200,300,-200>, White
        #if (high_qual) 
                area_light <50,0,0>,<0,0,50>,5,5
                jitter
                circular
                orient
        #end
}


sky_sphere{S_Cloud2 scale 2}      

#declare srand=seed(5);

/************************************
               TEXTURES
************************************/
                       
#declare tex_road=texture{
        pigment{wrinkles
                color_map { 
                [ .0 color <172,172,172>/255 ] 
                [ .3 color <168,168,166>/255 ]
                [ .6 color <155,154,153>/255 ]
                [ 1. color <154,152,153>/255 ] }
                frequency 1  
            scale 5
        } 
        normal{
               agate 
               bump_size .1 
        }
}  
#declare tex_road_lines = texture{
        pigment{
             image_map{png "road.png"}        
             //transmit .2   
        }
        rotate x*-90
        scale <30,1,200>
        translate <17,0,0>
}
                                            
#declare tex_pavement=texture{
        pigment{wrinkles
                color_map { 
                [ .0 color <172,172,172>/200 ] 
                [ .3 color <168,168,166>/200 ]
                [ .6 color <155,154,153>/200 ]
                [ 1. color <154,152,153>/200 ] }
                frequency 1  
            scale 5
        } 
        normal{
               agate 
               bump_size .1 
        }
}        

#declare tex_temple_cylinder=texture{T_Wood23 scale <1,10,1>}
#declare tex_temple_wooden_box=texture{T_Wood1} 
#declare tex_temple_pelpeing=texture{Cork}                
#declare tex_stone_barriere=texture{T_Stone35}
#declare tex_roof_basic=texture{Sandalwood}  
#declare tex_roof_tuiles=texture{Sandalwood}    
#declare tex_temple_steps=texture{T_Stone32}       

#declare tex_building_glass1=texture{
                pigment{color <.1,.05,.05> transmit .2}
                finish{ 
                        reflection .7
                        brilliance .1
                        phong .3
                        phong_size 2
                }
}  

#declare tex_building_glass2=texture{Polished_Chrome}   
#declare tex_building_glass3=texture{NBoldglass}  
#declare tex_building_glass4=texture{Dark_Green_Glass}           

#declare tex_building_wall1=texture{T_Stone12} 
        
#declare tex_building_wall2=texture{DMFWood6} 
#declare tex_building_wall3=texture{Bright_Bronze} 
#declare tex_building_wall4=texture{Copper_Metal}  

#declare tex_metro_beton1=texture{pigment{Blue}}  
#declare tex_escalators=texture{pigment{Red}}   

#declare tex_lampadaire=texture{Aluminum}    
#declare tex_panneau=texture{pigment{image_map{png "panneau.png"} scale <12,5.5,12>} translate <6.8,2.2,0>}  
#declare tex_flag=texture{uv_mapping pigment{image_map{png "triyinyang.png"}} }

#declare tex_barriere_metal = texture{Chrome_Metal}  
#declare tex_cabine=texture {
    pigment {
            color rgb<30,130,150>/255
    }
    finish {
        metallic
        reflection .2
        brilliance 1
        phong .75
        phong_size 5
    } 
}
                 

/*****************************************
                MACROS
*****************************************/




#macro temple()
      #debug "* parsing temple\n"
      
      #debug " * reading roof basics\n"
      #include "roof_basic.inc"
      
      #local half_door=
      union{
            #local j=0;
            #while (j<2)
                #local i=0;
                #while (i<3)
                    cylinder{<9+14*i,0,6.25+12*j>,<9+14*i,20,6.25+12*j>,2 texture{tex_temple_cylinder}}   
                    #local i=i+1;
                #end
                #local j=j+1;
            #end  
            
            union{
                box{<8,0,5.25> ,<10,1,19.25> } 
                box{<8,19,5.25>,<10,20,19.25>} 
                box{<8,5,5.25> ,<10,6,19.25> }
                box{<8,9,7.25> ,<10,9.5,19.25> }  
                box{<8,14,5.25>,<10,15,19.25>} 
                
                box{<8.25,0,5.25> ,<36,1,7> } 
                box{<8.25,19,5.25>,<36,20,7>} 
                box{<8.25,9,5.25>,<36,9.5,7>}
                box{<8.25,5,5.25> ,<36,6,7> } 
                box{<8.25,14,5.25>,<36,15,7>}                               
            
                texture{tex_temple_wooden_box}
            }   
            
            union{
                box{<8.5,0,5.5> ,<35.5,9.5,19> } 
                box{<8.5,15,5.5> ,<35.5,19,19> } 
                texture{tex_temple_pelpeing}
            }  
            
            translate z*2 
                    
      }  
      
      #local roof=union{
             // roof base
             box{<6,20,-25>,<40,21,22> texture{tex_temple_wooden_box}}   
                box{<10,21,-21>,<36,31,15> texture{tex_temple_wooden_box}}
             
             
             // decoration
             #local i=0;
             #while (i<6)
                object{roof_basic scale <1,2,1>  translate <8,20,-21+8*i>}
                #local i=i+1;
             #end     
             
             #local i=0;
             #while (i<4)
                object{roof_basic scale <1,2,1> rotate y*-90 translate <8+8*i,20,-23>}
                #local i=i+1;
             #end
      
      }  
      
      #local tuiles=union{
              // front side
              #local i=1;
              #while(i<15)
                    cylinder{<i,22,-30>,<i,22+i,-30+i>,.7}
                    cylinder{<46-i,22,-30>,<46-i,22+i,-30+i>,.7}
                    #local i=i+2;
              #end 
              
              #local i=0;
              #while (i<18)
                    cylinder{ <15+i,22,-30>,<15+i,37,-15>,.7}
                    #local i=i+2;
              #end      
              
              
              // back side, only to allow the reflections
              #local i=1;
              #while(i<15)
                    cylinder{<i,22,25>,<i,22+i,25-i>,.7}
                    cylinder{<46-i,22,25>,<46-i,22+i,25-i>,.7}
                    #local i=i+2;
              #end 
              
              #local i=0;
              #while (i<18)
                    cylinder{ <15+i,22,25>,<15+i,37,10>,.7}
                    #local i=i+2;
              #end  
              
              // side side
              #local i=1;
              #while(i<15)
                    cylinder{<0,22,-30+i>,<i,22+i,-30+i>,.7 }
                    cylinder{<0,22,25-i>,<i,22+i,25-i>,.7 }
                    #local i=i+2;
              #end 
              
              #local i=0;
              #while (i<26)
                    cylinder{ <0,22,-15+i>,<15,37,-15+i>,.7 }
                    #local i=i+1.8;
              #end         
              
              //egdes
              cylinder{<0,22,-30>,<15,37,-15>,.7}
              cylinder{<0,22,25>,<15,37,10>,.7}
              cylinder{<47,22,25>,<32,37,10>,.7}      
              
              texture{tex_roof_tuiles}
      }      
      
      #local pancarte=union{
              difference{
                     box{<3,20,-8>,<3.5,24,5>}
                     box{<2,20.5,-7.5>,<4,23.5,4.5>}
                     texture{Sandalwood}
              } 
              box{<3.2,20.5,-7.5>,<3.4,23.5,4.5> pigment{Yellow}} 
              text {
                ttf "arial.ttf" "Seoul's street"  1, 0
                texture{tex_roof_tuiles} 
                scale 1.8
                rotate y*90
                translate <2.4,21.5,3.6>
              }
                
              rotate z*20
              translate <7.5,0,0>  
      }    
      
      #local step=union{
              box{<-10,0,-35>,<45,-2,32>} 
              
              box{<-15,-2,-18>  ,<-10,-1.5,12>}  
              box{<-13.5,-1.5,-18>,<-10,-1,12>} 
              box{<-12,-1,-18>,<-10,-.5,12>}
              box{<-11,-.5,-18>,<-10,0,12>}
      
              texture{tex_temple_steps}
      } 
      
      #declare stone_barriere=union{
           box{<-1,0,-1>,<1,5,1>}
           box{<-1.3,5,-1.3>,<1.3,5.3,1.3>} 
           box{<-1.1,5.3,-1.3>,<1.3,5.6,1.1>}
           box{<-.6,5.6,-.6>,<.6,5.8,.6>}
      }

      #local barriere=union{
             #local i=0;
             #while (i<3)
                 object{stone_barriere scale .4 translate <-7,0,-33.5+8*i>}  
                 object{stone_barriere scale .4 translate <-7,0,30-8*i>}
                 #local i=i+1;
             #end
             
                
                texture{tex_stone_barriere}
      }
      
      union{
            object{half_door}
            object{half_door translate z*-30} 
            object{roof}   
            object{tuiles translate y*2} 
            object{pancarte} 
            object{step} 
            object{barriere}     
      }
      
#end // macro temple               

 
#macro building1(pt1,pt2,stair_height,tex1,tex2) 
    #debug "* parsing building 1\n"
    union{
       
       #local nb_stairs = (pt2.y-pt1.y)/stair_height;
       #local stair_width = pt2.x - pt1.x;
       #local cylinder_radius = 3; 
       
       //#debug concat("##### width ", str(stair_width,3,1), " #####\n") 
       
       #macro one_stair()
          union{
             union{
             Round_Cylinder(<pt1.x,0,pt1.z>  ,<pt1.x,stair_height/4,pt1.z>, cylinder_radius, .3, true)        Round_Cylinder(<pt1.x,stair_height/4,pt1.z>  ,<pt1.x,2*stair_height/4,pt1.z>, cylinder_radius, .3, true)               
             Round_Cylinder(<pt1.x,0,pt2.z>  ,<pt1.x,stair_height/4,pt2.z>, cylinder_radius, .3, true)        Round_Cylinder(<pt1.x,stair_height/4,pt2.z>  ,<pt1.x,2*stair_height/4,pt2.z>, cylinder_radius, .3, true) 
             Round_Cylinder(<pt2.x,0,pt2.z>  ,<pt2.x,stair_height/4,pt2.z>, cylinder_radius, .3, true)        Round_Cylinder(<pt2.x,stair_height/4,pt2.z>  ,<pt2.x,2*stair_height/4,pt2.z>, cylinder_radius, .3, true)
             Round_Cylinder(<pt2.x,0,pt1.z>  ,<pt2.x,stair_height/4,pt1.z>, cylinder_radius, .3, true)        Round_Cylinder(<pt2.x,stair_height/4,pt1.z>  ,<pt2.x,2*stair_height/4,pt1.z>, cylinder_radius, .3, true)
                
             Round_Box(<pt1.x,0,pt1.z-cylinder_radius>,<pt2.x,stair_height/4,pt2.z+cylinder_radius>,.3, true) Round_Box(<pt1.x,stair_height/4,pt1.z-cylinder_radius>,<pt2.x,2*stair_height/4,pt2.z+cylinder_radius>,.3, true)  
             Round_Box(<pt1.x-cylinder_radius,0,pt1.z>,<pt2.x+cylinder_radius,stair_height/4,pt2.z>,.3, true) Round_Box(<pt1.x-cylinder_radius,stair_height/4,pt1.z>,<pt2.x+cylinder_radius,2*stair_height/4,pt2.z>,.3, true)     
                 texture{tex1}     
             }      
                   
             // glasses 
             union{
             Round_Cylinder(<pt1.x,stair_height/2,pt1.z>  ,<pt1.x,stair_height,pt1.z>, cylinder_radius, .1, true)        //Round_Cylinder(<pt1.x,3*stair_height/4,pt1.z>  ,<pt1.x,stair_height,pt1.z>, cylinder_radius, .1, true)               
             Round_Cylinder(<pt1.x,stair_height/2,pt2.z>  ,<pt1.x,stair_height,pt2.z>, cylinder_radius, .1, true)        //Round_Cylinder(<pt1.x,3*stair_height/4,pt2.z>  ,<pt1.x,stair_height,pt2.z>, cylinder_radius, .1, true) 
             Round_Cylinder(<pt2.x,stair_height/2,pt2.z>  ,<pt2.x,stair_height,pt2.z>, cylinder_radius, .1, true)        //Round_Cylinder(<pt2.x,3*stair_height/4,pt2.z>  ,<pt2.x,stair_height,pt2.z>, cylinder_radius, .1, true)
             Round_Cylinder(<pt2.x,stair_height/2,pt1.z>  ,<pt2.x,stair_height,pt1.z>, cylinder_radius, .1, true)        //Round_Cylinder(<pt2.x,3*stair_height/4,pt1.z>  ,<pt2.x,stair_height,pt1.z>, cylinder_radius, .1, true)
                
             #local i=pt1.x;
             #while (i<pt2.x)
                 #if(rand(srand)<.95)
                      Round_Box(<i   ,stair_height/2   ,pt1.z-cylinder_radius>,<i+5 ,stair_height ,pt1.z>,.3, true)
                      Round_Box(<i   ,stair_height/2   ,pt2.z+cylinder_radius>,<i+5 ,stair_height ,pt2.z>,.3, true)
                 #else
                      box{<0,0,pt1.z-cylinder_radius>,<5,stair_height/2,pt1.z-cylinder_radius+.1>  translate x*i  translate y*stair_height/2}
                 #end
                 #local i=i+5;
             #end  
             
             #local i=pt1.z;
             #while (i<pt2.z)
                 #if(rand(srand)<.95)
                       Round_Box(<pt1.x-cylinder_radius,stair_height/2   ,i>,<pt1.x ,stair_height ,i+5>,.3, true)  
                 #else
                       box{<pt1.x-cylinder_radius,stair_height/2   ,i>,<pt1.x-cylinder_radius+.1 ,stair_height ,i+5>}
                 #end
                 #local i=i+5;
             #end
             
             
             texture{tex2}
             } 
                
       }
       #end // macro one_stair
       
       // rez de chausse
       union{
       Round_Cylinder(<pt1.x,0,pt1.z>  ,<pt1.x,-10,pt1.z>, cylinder_radius, .3, true)     
       Round_Cylinder(<pt1.x,0,pt2.z>  ,<pt1.x,-10,pt2.z>, cylinder_radius, .3, true)    
       Round_Cylinder(<pt2.x,0,pt2.z>  ,<pt2.x,-10,pt2.z>, cylinder_radius, .3, true)    
       Round_Cylinder(<pt2.x,0,pt1.z>  ,<pt2.x,-10,pt1.z>, cylinder_radius, .3, true)    
                
       Round_Box(<pt1.x,0,pt1.z-cylinder_radius>,<pt2.x,-10,pt2.z+cylinder_radius>,.3, true) 
       Round_Box(<pt1.x-cylinder_radius,0,pt1.z>,<pt2.x+cylinder_radius,-10,pt2.z>,.3, true)  
       texture{tex1} 
       }  
       
       #local nb_stairs_done=0;
       #while(nb_stairs_done < nb_stairs)
           object{ one_stair() translate y*nb_stairs_done*stair_height }
           #local nb_stairs_done = nb_stairs_done+1;
       #end   
    }
#end // macro building1

#macro building2(pt1,pt2,stair_height,tex1,tex2) 
    #debug "* parsing building 2\n"
    union{
       
       
       //box{pt1,pt2 pigment{Red}}         // to make the building opaque
       #local nb_stairs = (pt2.y-pt1.y)/stair_height;
       #local stair_width = pt2.x - pt1.x;
       #local cylinder_radius = 3; 
       
       
       #macro one_stair(prop)
          #local dep=0;
          
          union{
             union{   
             Round_Box(<pt1.x+dep,0,pt1.z-cylinder_radius>,<pt2.x-dep,stair_height/2,pt2.z+cylinder_radius>,.3, true) //Round_Box(<pt1.x+dep,stair_height/4,pt1.z-cylinder_radius>,<pt2.x-dep,2*stair_height/4,pt2.z+cylinder_radius>,.3, true)  
             Round_Box(<pt1.x-cylinder_radius,0,pt1.z-dep>,<pt2.x+cylinder_radius,stair_height/2,pt2.z+dep>,.3, true) //Round_Box(<pt1.x-cylinder_radius,stair_height/4,pt1.z-dep>,<pt2.x+cylinder_radius,2*stair_height/4,pt2.z+dep>,.3, true)     
                 texture{tex1}     
             }      
                   
             // glasses 
             union{             
             #local i=pt1.x;
             #while (i<pt2.x)
                 Round_Box(<i   ,stair_height/2   ,pt1.z-cylinder_radius>,<i+2.5 ,stair_height ,pt1.z>,.3, true)
                 #local i=i+2.5;
             #end  
             
             #local i=pt1.z;
             #while (i<pt2.z)
                  Round_Box(<pt1.x-cylinder_radius,stair_height/2   ,i>,<pt1.x ,stair_height ,i+2.5>,.3, true) 
                 #local i=i+2.5;
             #end
             
             
             texture{tex2}
             }  
       }
       #end // macro one_stair
       
       // rez de chausse
       union{ 
                
       Round_Box(<pt1.x,0,pt1.z-cylinder_radius>,<pt2.x,-10,pt2.z+cylinder_radius>,.3, true) 
       Round_Box(<pt1.x-cylinder_radius,0,pt1.z>,<pt2.x+cylinder_radius,-10,pt2.z>,.3, true)  
       texture{tex1} 
       } 

       #local nb_stairs_done=0;
       #while(nb_stairs_done < nb_stairs)
           object{ one_stair(nb_stairs_done/nb_stairs) translate y*nb_stairs_done*stair_height }
           #local nb_stairs_done = nb_stairs_done+1;
       #end   
    }
#end // macro building2

#macro building3(pt1,pt2,stair_height,tex1,tex2) 
    #debug "* parsing building 3\n"
    union{
       
       
       //box{pt1,pt2 pigment{Red}}         // to make the building opaque
       #local nb_stairs = (pt2.y-pt1.y)/stair_height;
       #local stair_width = pt2.x - pt1.x;
       #local cylinder_radius = 3; 
       
       //#debug concat("##### width ", str(stair_width,3,1), " #####\n") 
       
       #macro one_stair(prop)
         
          union{
             union{   
             Round_Box(<pt1.x-cylinder_radius,0,pt1.z-cylinder_radius>,<pt2.x+cylinder_radius,stair_height/2,pt2.z+cylinder_radius>,.3, true) //Round_Box(<pt1.x+dep,stair_height/4,pt1.z-cylinder_radius>,<pt2.x-dep,2*stair_height/4,pt2.z+cylinder_radius>,.3, true)  
             Round_Box(<pt1.x-cylinder_radius,0,pt1.z-cylinder_radius>,<pt2.x+cylinder_radius,stair_height/2,pt2.z+cylinder_radius>,.3, true) //Round_Box(<pt1.x-cylinder_radius,stair_height/4,pt1.z-dep>,<pt2.x+cylinder_radius,2*stair_height/4,pt2.z+dep>,.3, true)     
                 texture{tex1}     
             }      
                   
             // glasses 
             union{             
             #local i=pt1.x-cylinder_radius/2;
             #while (i<pt2.x+cylinder_radius/2)
                 Round_Box(<i   ,stair_height/2   ,pt1.z-cylinder_radius>,<i+2.5 ,stair_height ,pt1.z>,.3, true)
                 #local i=i+2.5;
             #end  
             
             #local i=pt1.z-cylinder_radius/2;//cylinder_radius;
             #while (i<pt2.z+cylinder_radius/2)
                  Round_Box(<pt1.x-cylinder_radius,stair_height/2   ,i>,<pt1.x ,stair_height ,i+2.5>,.3, true) 
                 #local i=i+2.5;
             #end
             
             
             texture{tex2}
             }  
       }
       #end // macro one_stair
       
       // rez de chausse
       union{ 
                
       Round_Box(<pt1.x,0,pt1.z-cylinder_radius>,<pt2.x,-10,pt2.z+cylinder_radius>,.3, true) 
       Round_Box(<pt1.x-cylinder_radius,0,pt1.z>,<pt2.x+cylinder_radius,-10,pt2.z>,.3, true)  
       texture{tex1} 
       } 

       #local nb_stairs_done=0;
       #while(nb_stairs_done < nb_stairs)
           object{ one_stair(nb_stairs_done/nb_stairs) translate y*nb_stairs_done*stair_height }
           #local nb_stairs_done = nb_stairs_done+1;
       #end   
    }
#end // macro building3


#macro metro()
   #debug "* parsing metro\n"
   union{

        #debug " * reading metro_beton\n"
        #include "metro_beton.inc"
        object{metro_beton}  
        
        #debug " * reading metro_escalator\n"
        #include "metro_escalator.inc"
        object{metro_escalator}  
        
        #debug " * reading metro_roof\n"
        #include "metro_roof.inc"
        object{ metro_roof}  
       

} 
#end // metro


 

#macro street_stuff()
    #debug "* parsing street stuff\n"    
        
        #debug " * reading lampadaire\n"
        #include "lampadaire.inc"  
        #include "lampadaire_panneau.inc"   
        
        
        #if (trees_on)
        #debug " * reading cherry tree\n"
        #include "cherry.inc"
           
           // trees along the street    
           object{CHERRY scale 30 translate <25,0,52>}
           object{CHERRY scale 25 translate <27,0,70>}
           object{CHERRY scale 25 translate <28,0,83>}
           object{CHERRY scale 28 translate <25,0,96>}  
           object{CHERRY scale 23 translate <26,0,110>}
           object{CHERRY scale 30 translate <28,0,122>}
           object{CHERRY scale 24 translate <25,0,143>}
           object{CHERRY scale 28 translate <28,0,160>}
           object{CHERRY scale 22 translate <27,0,175>}  
           
           // trees between building & temple
           object{CHERRY scale 30 translate <70,0,68>}
           object{CHERRY scale 25 translate <85,0,70>}
           object{CHERRY scale 27 translate <100,0,67>}
                
        #end
        
        object{lampadaire  translate <25,0,60>} 
        object{lampadaire  translate <25,0,20>}
        object{lampadaire  translate <25,0,100>}  
        
        object{lampadaire_panneau translate <25,0,60>}  
        
        #local barriere_metal = union{
                 sphere_sweep{
                       b_spline
                       4+8+5
                       
                       #local i=0;
                       #while (i<.8)
                           <0,i,-1>,.08
                           #local i=i+.2;
                       #end 
                       
                       #local i=-.8;
                       #while (i<.8)
                           <0,1,i>,.08
                           #local i=i+.2;
                       #end                 
                 
                       #local i=.8;
                       #while (i>0)
                           <0,i,1>,.08
                           #local i=i-.2;
                       #end    
                 }
                 cylinder{<0,.5,-1>,<0,.5,1>,.08} 
                 texture{tex_barriere_metal}              
        }
        
        #local i=-50;
        #while(i<250)
            object{ barriere_metal scale 3 translate <20,0,i>}
            #local i=i+7;
        #end
             
        #declare func1 = function {sin((x+2.5)/5)+1.2*sin(z/5)+.1*sin(x*x+6*z)}  
        #declare func2 = function {sin((x+2.5)/2.5)+sin(z/3)+.1*cos(x*x+6*z)}
        
        #macro drapeau(n)
        union{
             union{
                cylinder{<0,0,0>,<0,50,0>,.2}
                cylinder{<0,50,-2>,<0,50,2>,.2}
                sphere{<0,50,-2>,.3} 
                sphere{<0,50,2>,.3}   
                texture{tex_lampadaire}
             }    
             
             /*union{
                cylinder{<0,50,0>,<func1(-2.5,0,25),49,0>,.2}
                cylinder{<0,50,0>,<func1(2.5,0,25),49,0>,.2}
                texture{tex_corde}
             }  */
             
             mesh{
                #declare i=-2.5;
                #declare pasi = .25;
                #declare pasj = 1;  
                #declare taillei = 5;
                #declare taillej = 25;
                #while(i<2.5)
                    #declare j=0;
                    #while (j<25)
                        #if(n=1)                        
                           triangle{           <i,func1(i,0,j),j>           ,<i+pasi,func1(i+pasi,0,j),j>      ,<i,func1(i,0,j+pasj),j+pasj>
                                    uv_vectors -<(i+2.5)/taillei,j/taillej>,-<(i+pasi+2.5)/taillei,j/taillej>,-<(i+2.5)/taillei,(j+pasj)/taillej>
                           } 
                           triangle{           <i+pasi,func1(i+pasi,0,j+pasj),j+pasj>   ,<i+pasi,func1(i+pasi,0,j),j>      ,<i,func1(i,0,j+pasj),j+pasj>
                                    uv_vectors -<(i+2.5+pasi)/taillei,(j+pasj)/taillej>,-<(i+pasi+2.5)/taillei,j/taillej>,-<(i+2.5)/taillei,(j+pasj)/taillej>
                           }  
                        #else
                           triangle{           <i,func2(i,0,j),j>           ,<i+pasi,func2(i+pasi,0,j),j>      ,<i,func2(i,0,j+pasj),j+pasj> 
                                    uv_vectors -<(i+2.5)/taillei,j/taillej>,-<(i+pasi+2.5)/taillei,j/taillej>,-<(i+2.5)/taillei,(j+pasj)/taillej>
                                    
                           } 
                           triangle{           <i+pasi,func2(i+pasi,0,j+pasj),j+pasj>   ,<i+pasi,func2(i+pasi,0,j),j>      ,<i,func2(i,0,j+pasj),j+pasj>
                                    uv_vectors -<(i+pasi+2.5)/taillei,(j+pasj)/taillej>,-<(i+pasi+2.5)/taillei,j/taillej>,-<(i+2.5)/taillei,(j+pasj)/taillej>
                           }                          
                        #end
                        
                        
                        #declare j=j+pasj;
                    #end
                    #declare i=i+pasi;
                #end
                rotate y*-90
                rotate z*70
                translate y*49.5
                translate x*-.4
             texture{tex_flag}
             }   
        }     
        #end // macro drapeau   
         
         
        #debug " * parsing flags\n" 
        object{drapeau(1) translate <60,0,55>}
        object{drapeau(2) translate <60,0,-7>}
        
        
        #declare phone_wall=
        union{
 
                difference{
                  cylinder{<-2,8,-.5>,<-2,8,0>,.5}
                  cylinder{<-2,8,-.6>,<-2,8,.1>,.15}
                  box{<-2.5,8,-1>,<-1,6,1>}
                  box{<-2,6,-1><0,10,1>}   
                }     

                difference{
                   cylinder{<-2,8,-.5>,<-2,8,0>,.5}
                   cylinder{<-2,8,-.6>,<-2,8,.1>,.15}
                   box{<-2.5,8,-1>,<-1,6,1>}
                   box{<-2,6,-1><0,10,1>} 
                   scale <-1,1,1>  
                }

                // horizontal
                box{<-2.3,7.6,-.5>,<2.3,7.8,0>}
                box{<-2,8.15,-.5>,<2,8.5,0>}    
                box{<-2.3,0,-.5>,<2.3,.3,0>}  
                box{<-2.3,4,-.5>,<2.3,4.3,0>}

                // vertical
                box{<-2.5,8,-.5>,<-2.15,0,0>}   
                box{<2.5,8,-.5>,<2.15,0,0>}    

                // little verticals
                box{<-.5,7.8,-.6>,<-.6,0,0>} 
                box{<-1.5,7.8,-.6>,<-1.6,0,0>}  
                box{<.5,7.8,-.6>,<.6,0,0>} 
                box{<1.5,7.8,-.6>,<1.6,0,0>}


                // glass
                box{<-2.2,0,-.3>,<2.2,8.15,-.4> texture{NBglass  }}
   
                   translate z*-2
                   texture{ tex_cabine}
        }          

        #declare cabine_telephonique = union{
             object{phone_wall} 
             object{phone_wall rotate y*90} 
             object{phone_wall rotate y*180}
             object{phone_wall rotate y*270}
             polygon{5,           <-.5,6,-2.8>,<.5,6,-2.8>,<.5,5,-2.8>,<-.5,5,-2.8>,<-.5,6,-2.8> 
                      //uv_vectors  <0,0>,       <1,0>      ,<1,1>      ,<0,1>       ,<0,0>
                      pigment{
                        image_map{png "phone.png"} translate x*.5       
                      }
             rotate y*90 }
        }   

        object{cabine_telephonique scale <1,1.5,1> translate <28,0,40>} 
        object{cabine_telephonique scale <1,1.5,1> translate <28,0,34.5>} 
        object{cabine_telephonique scale <1,1.5,1> translate <28,0,29>} 
        
#end // street_stuff





/*****************************************
                    SCENE
*****************************************/                    


// road en longueur
box{<-20,-.5,-20>,<20,-1.2,300> texture{tex_road}}                       

// thin transarent plane with the road lines
box{<-20,-.5,-20>,<20,-.49,300> texture{tex_road_lines}}     

// road en profondeur
box{<-20,-.5,205>,<100,-1.2,240> texture{tex_road}}                       

// pavement du premier bloc
box{<20,0,-20>,<300,-1.2,205> texture{tex_pavement}}
 
// paement du second bloc
box{<15,0,240>,<300,-1.2,500> texture{tex_pavement}} 

 
// temple
object{temple() translate <80,2,35> }

 
// buildings
object{building1(<60,0,80>,<145,200,165>,10,tex_building_wall1, tex_building_glass1) translate y*10}
object{building2(<50,0,280>,<125,300,360>,10,tex_building_wall2,tex_building_glass2) translate y*10}

// buildings derrire
object{building3(<180,0,80>,<245,250,165>,10,tex_building_wall3,tex_building_glass3) translate y*10}
object{building2(<180,0,0>,<245,240,40>,10,tex_building_wall4,tex_building_glass4) translate y*10}
    
// reflections buildings
object{building3(<-40,0,400>,<40,350,700>,10,tex_building_wall1, tex_building_glass1) scale <-1,1,1> translate <-130,10,0>}   
object{building2(<-100,0,-140>,<300,100,-120>,10,tex_building_wall2, tex_building_glass2) translate y*10}    
               
 
street_stuff() 
  


