//==========================================  
// Copyright 2003 Gilles Tran http://www.oyonale.com
// -----------------------------------------
// This work is licensed under the Creative Commons Attribution License. 
// To view a copy of this license, visit http://creativecommons.org/licenses/by/2.0/ 
// or send a letter to Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
// You are free:
// - to copy, distribute, display, and perform the work
// - to make derivative works
// - to make commercial use of the work
// Under the following conditions:
// - Attribution. You must give the original author credit.
// - For any reuse or distribution, you must make clear to others the license terms of this work.
// - Any of these conditions can be waived if you get permission from the copyright holder.
// Your fair use and other rights are in no way affected by the above. 
//==========================================  
#include "colors.inc"
#include "functions.inc"

#declare Intervals=3; // cloud media intervals 1 for tests and higher values (2-5) for smoother results

#declare C_Sun  =  rgb <237,194,117>/255;

    #declare Cloud=cylinder{<-0.5, 0, 0><0.55, 0, 0> 0.5
        texture{pigment{Clear}finish{ambient 0 diffuse 0}}
        hollow
        interior{
            media{
                scattering{2, C_Sun * 1.5} 
                absorption 0.2
                intervals Intervals
                density{
                    density_file df3 "makecloud.df3"
                    turbulence 0.1
                    lambda 3
                    interpolate 1
                    translate -0.5
                    scale <1,-1,1>
                }
            }
        }
        scale <4/3,1,1>
    }


object{Cloud scale 5*<1.1,1,1> translate <-3,-1.35,-8> } 
 
