#include "colors.inc" 

#declare BigStarPoint = cone{ <0,0,0>1<0,1,0>0}

#declare BigStar =
union{
  
  object{BigStarPoint scale <0.4,4,0.5>              }
  object{BigStarPoint scale <0.4,4,0.5> rotate 180*z }
  object{BigStarPoint scale <0.4,3,0.5> rotate  90*z }
  object{BigStarPoint scale <0.4,3,0.5> rotate -90*z }
  
  object{BigStarPoint scale <0.25,2,0.5> rotate   45*z}
  object{BigStarPoint scale <0.25,2,0.5> rotate  135*z}
  object{BigStarPoint scale <0.25,2,0.5> rotate  -45*z}
  object{BigStarPoint scale <0.25,2,0.5> rotate -135*z}
  
  pigment{
    cylindrical
      
    color_map{
      [0     rgbt<1,1,1,  1> ]
      [0.5   rgbt<1,1,1,0.9> ]
      [1     rgbt<1,1,1,  0> ] 
    }          
    scale 4
    rotate 90*x
  }
  
  scale 1/6
}

#ifndef (SEED)
  #declare SEED = 4;
#end
    
#declare R = seed(SEED); 

union{

  #declare N = 0;
  #while (N < 75)
    object{BigStar   scale (1.5+1.5*rand(R)) scale 1.4 translate<38*1.425*(1-rand(R)*rand(R)), 32*1.425*(1-2*rand(R)), 150> }
    #declare N = N + 1;
  #end

   translate <7,-0.25,0>    
}    
  
 
