
#declare decalx = 35.5 ;
#declare decaly = 6 ;

// -- Nuages -- //
#declare coeff = 1 ;

#declare Nuages = light_group {
box {
  <-150,-50,0> <150,50,20>
  pigment {rgbt 1}
  hollow
  interior {media {
    scattering {1 color <.96,.96,1>*.15}
    emission <.92,.92,1>*.04
    intervals 3
    density {
      bumps
      turbulence .3
      octaves 6
      omega .6
      lambda 2.6
      scale <7,4,30>*2.4
      translate <-10,-2,0>
      
      warp {
        black_hole <-decalx-2.8,3.3,10> 25 inverse falloff 1 strength 1 turbulence 2.5
      }
      
      density_map {
        [0 rgb 0]
        [.3 rgb 0]
        [1 rgb 1]
      }
    }
    density {
      gradient x+.1*y
      turbulence .3
      scale 160
      translate -90*x
      density_map {
        [0 rgb 1]
        [1 rgb 0]
      }
    }
  }}
}
light_source {
  <50,-10,-150>
  rgb 1
}
}


// -- Fond -- //

#declare Fond =
plane {
  -z 0-100
  pigment {
    gradient x
    color_map {
//      [0 rgb <1,.9,.5>*.7]
      [0 rgb <.64,.84,1>]
      [1 rgb <0,.02,.1>]
    }
    sine_wave
    scale 120
    rotate -38*z rotate 50*y
  }
  finish {ambient 1 diffuse 0}
}


// -- Lune -- //

#declare puiss = 3.3*coeff*3 ;

#declare Lune = union {
  sphere {
    0 1
    
    pigment {image_map {jpeg "moonmap_flou.jpg" map_type 1}}
    finish {diffuse .5 ambient 1.42}
//    normal {bump_map {jpeg "moonbump4k.jpg" map_type 1 bump_size .6}}
    
//    rotate -30*y
  }
  sphere {
    0 1
    
    pigment {rgbt 1}
    finish {ambient 0 diffuse 0}
    hollow
    interior{media {
      emission <.98,.97,1>*.2
      density {
        spherical
        density_map {
          [0 rgb 0]
          [.3 rgb 1]
          [1 rgb 1]
        }
      }
    }}
  scale 1.2
  }
    
  scale 6.6    
  translate <-decalx,8.8,35>
}

// -- Soleil -- //

#declare F_densite = function {
  pattern {
    dents
    turbulence .1
    octaves 3
    scale .03
  }
}
#declare dist = function {sqrt(x*x+y*y+z*z)}
#declare F_DensiteSpherique = function {
  pow(1-dist(x,y,z),4)*F_densite(x/dist(x,y,z),y/dist(x,y,z),z/dist(x,y,z))
}
#declare F_densite2 = function {
  pattern {
    dents
    turbulence .3
    octaves 3
    scale .2
  }
}
#declare F_DensiteSpherique2 = function {
  pow(1-dist(x,y,z),4)*F_densite2(x/dist(x,y,z),y/dist(x,y,z),z/dist(x,y,z))
}

#declare rds=seed(56) ;
#declare Soleil = sphere {
  0 1.01
  pigment {rgbt 1}
  hollow
  interior {
    media {
      emission <1,.99,.6>*6*coeff
      absorption 5
      intervals 1
      density {
        function {F_DensiteSpherique(x,y,z)}
        turbulence 0
        octaves 6
        lambda 1.7
        omega .1
        density_map {
          [0 rgb 0]
          [1 rgb 1]
        }
      }
      density {
        spherical
        density_map {
          [0 rgb 1]
          [.6 rgb 1]
          [.7 rgb 0]
          [1 rgb 0]
        }
      }
    }
    media {
      emission <1,.15,.05>*.5*coeff
      intervals 1
      density {
        function {F_DensiteSpherique2(x,y,z)}
        turbulence .06
        octaves 9
        lambda 2.1
        omega .47
        rotate rand(rds)*360*y rotate rand(rds)*360*z rotate rand(rds)*360*x
        density_map {
          [0 rgb 0]
          [1 rgb 1]
        }
      } 
      density {
        spherical
        density_map {
          [0 rgb 1]
          [.6 rgb 1]
          [.7 rgb 0]
          [1 rgb 0]
        }
      }

    }
/*     media {
      emission <.65,1,.65>*2
      intervals 4
      density {
        function {F_DensiteSpherique(x,y,z)}
        turbulence .32
        octaves 9
        lambda 2.1
        omega .47
        rotate rand(rds)*360*y rotate rand(rds)*360*z rotate rand(rds)*360*x
        density_map {
          [0 rgb 0]
          [1 rgb 1]
        }
      }
    }*/
     
  }

  scale 17
  translate <decalx,-4.5,50>
}


// -- Objets -- //
object {Lune}
object {Soleil}
object {Fond}
object {Nuages}

// -- Camera -- //

camera {
  orthographic
  location <0,0,-50>
  look_at <0,0,0>
  up 40*y
  right 120*x
}
