// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.6
// Desc: Radiosity Scene Template
// Date: mm/dd/yy
// Auth: ?

#version 3.6;
#include "rand.inc"
#include "colors.inc"
#include "woods.inc"

#declare Radiosity=on;

global_settings {
  assumed_gamma 1.0
  //max_trace_level 25
  #if (Radiosity)
    radiosity {
      pretrace_start 0.08           // start pretrace at this size
      pretrace_end   0.04           // end pretrace at this size
      count 45                      // higher -> higher quality (1..1600) [35]
      nearest_count 5               // higher -> higher quality (1..10) [5]
      error_bound 1.8               // higher -> smoother, less accurate [1.8]
      recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
      low_error_factor .5           // reduce error_bound during last pretrace step
      gray_threshold 0.0            // increase for weakening colors (0..1) [0]
      minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
      brightness 1                  // brightness of radiosity effects (0..1) [1]

      adc_bailout 0.01/2
      //normal on                   // take surface normals into account [off]
      //media on                    // take media into account [off]
      //save_file "file_name"       // save radiosity data
      //load_file "file_name"       // load saved radiosity data
      //always_sample off           // turn sampling in final trace off [on]
      //max_sample 1.0              // maximum brightness of samples
    }
  #end
}

#default {
  texture{                  
        pigment{bozo
                color_map {
                        [0 color Brown]
                        [1 color Black]
                }
                scale 0.1 
                turbulence 0.3
        }
  }
}

// ----------------------------------------

camera {
  right x*image_width/image_height
  //location  <-3,-5,-8> 
  location  <-3,0,-13>
  look_at   <0,-8,0>
  normal{bumps 0.1}
  focal_point <3,-8,0>
  aperture 0.8
  variance 1/10000
  blur_samples 100
}

light_source {
  <0,0,0>       // light's position
  color rgb <0.7, 0.7, 1>  // light's color
  area_light 5*x 5*y 5 5
}


light_source {
  <0,40,-50>       // light's position
  color rgb <1, 1, 1>  // light's color
  area_light 5*x 5*y 5 5
  adaptive 0
  circular
  jitter
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

/******************************/
/*  TEXTURES                  */
/******************************/
#declare Grass=texture{
        pigment{color Green*0.3}
        finish{
                ambient 0
                diffuse 1
                reflection 0
                specular 0
                crand 0.3
        }
}

#declare TreeSnow=texture{
        pigment{bozo
                color_map{
                [0 color White]      
                [0.6 color White]
                [0.7 color Brown]
                [1 color Brown]
                }                  
                scale 3
                turbulence 2
        }
        finish{
                ambient 0.0
                diffuse 0.7
                specular 0.2
                reflection 0.0
        }
}

#declare TreeGreen=texture{
        pigment{wood
                color_map{
                [0 color Brown*0.1]
                [0.1 color Brown*0.2]      
                [0.6 color Brown*0.2]
                [0.7 color Brown*0.5]
                [1 color Brown*0.5]
                }                  
                scale 5
                turbulence 1.3
        }
        finish{
                ambient 0.0
                diffuse 1
                specular 0.0
                reflection 0.0
                metallic
        }
}

#declare TreeGreenTop=texture{
       pigment{bozo 
              color_map {
                     [0 color Green*0.1]
                     [1 color Green*0.3]
              }
       }
       finish{
            ambient 0
            diffuse 0.6
            specular 0.4
            reflection 00
       }
}

#declare Snow=texture{           
        pigment{color White}
        finish{
              ambient 0
              diffuse 0.6
              reflection 0.3
              specular 0.1
              crand 0.04
        }              
}


#macro Tree(L,S,D,G,DD,DG,V,SNOW,DEG)
    union{
        Trivtree(L,S,D,G,DD,DG,SNOW)
        rotate DEG*y
        translate V
    }
#end

// LEVEL of reccurence
// SEED
// Lenght of bunches
//  off bunches
#declare SXXX=seed(234324);                          
#macro Trivtree(L,S,D,G,DD,DG,SNOW)
  #if (L=0)     
        #if(SNOW)
        #else
        cone{
                <0,0,0>,0.05
                <0,0.08,0>0.03
                texture{TreeGreenTop}
        }       
        #end
  #else 
        union{
                cone{
                    <0,0,0>,G
                    <0,D,0>,G/DG
                    #if(SNOW)
                        texture{TreeSnow}
                    #else 
                        texture{TreeGreen}
                    #end
                                
                }
                
                union{
                        Trivtree(L-1,S,D/DD,G/DG,DD,DG,SNOW)
                        rotate (30+SRand(SXXX)*20)*z
                        translate y*(D-0.04)
                }
                union{
                        Trivtree(L-1,S,D/DD,G/DG,DD,DG,SNOW)
                        rotate (30+SRand(SXXX)*20)*z
                        rotate (120+SRand(SXXX)*50)*y
                        translate y*(D-0.04)
                }
                union{
                        Trivtree(L-1,S,D/DD,G/DG,DD,DG,SNOW)
                        rotate (30+SRand(SXXX)*20)*z
                        rotate (240+SRand(SXXX)*20)*y
                        translate y*(D-0.04)
                }
        }               
        
        
  #end

#end





#declare FORREST_SIZE=10;
#macro Height(X,Z)                                           
     -8*cos(X/FORREST_SIZE*(pi/2))+sin(Z/FORREST_SIZE*pi/2*cos(X))
#end


plane{
      y,-8
      pigment{color Red}
}

plane
{
        y,-7.6
        pigment{color rgbf <0.3,0.3,1,0.5>}
        normal
        {
                ripples
                frequency 10
                turbulence 0.3
                scale z*3+x*2+1*y                
        }       
        finish
        {
                reflection 0.4
                ambient 0
                diffuse 0.3
                specular 0.3
        }
}


#declare DF=0.2;
#declare SS=seed(30);
#declare Z=-FORREST_SIZE;
#while(Z<2*FORREST_SIZE)
        #declare X=-10;
        #while(X<10)                
                union{
                   triangle{
                    <X,Height(X,Z),Z>
                    <X+DF,Height(X+DF,Z),Z>
                    <X+DF,Height(X+DF,Z+DF),Z+DF>
                   }
                   triangle{
                    <X,Height(X,Z),Z>
                    <X+DF,Height(X+DF,Z+DF),Z+DF>
                    <X,Height(X,Z+DF),Z+DF>
                   }
                   #if(X<0)
                     texture{Grass}
                   #else 
                     texture{Snow}
                   #end
                }
        #declare X=X+DF;
        #end
#declare Z=Z+DF;
#end




#declare SS=seed(50);
#declare Z=-FORREST_SIZE;
#while(Z<2*FORREST_SIZE)
        #declare X=-9;
        #while(X<10)                
        #declare DEC=5*sin(2*pi*Z/FORREST_SIZE); // DO WE PAINT IT WHITE OR GREEN?
        #declare XN=X*(1.4+0.2*SRand(SS));
        #declare ZN=Z*(1.3+0.3*SRand(SS));
        #declare H=Height(XN,ZN); // THE HEIGHT
        #declare V=XN*x+ZN*z+H*y;
        
        #if(XN<FORREST_SIZE & XN>-FORREST_SIZE & (XN<-1 | XN >1) & Height(XN,ZN)>-7.6 & ZN < 2*FORREST_SIZE )
                        #if(X>DEC)
                         Tree(6,seed(X+XN),0.5,0.2,1.2,1.5,V-0.1*y,true,RRand(0,360,SS))
                        #else                 
                         Tree(6,seed(X+XN),0.5,0.2,1.2,1.5,V-0.1*y,false,RRand(0,360,SS)) 
                        #end
                        //(L,S,D,G,DD,DG,V)
        #end // koniec if'a z drzewami
        #declare X=X+2.5;
        #end
#declare Z=Z+2.5;
#end 
        



#macro MyGrass(X,Z,S)
  cylinder{
     <0,0,0>
     <0,RRand(1,3,S)/7,0>
     0.02
     texture{Grass}
     rotate SRand(S)*10*z
     rotate SRand(S)*360*y
     translate x*X+Z*z+y*Height(X,Z)
  }
#end


#declare S=seed(3430);

/** GRASSS **/           
 #declare Z=-4;
#while(Z<5)
        #declare X=-3;
        #while(X<0)                
            #if(Height(X,Z)>-7.8) 
             MyGrass(X+SRand(S)*0.1,Z+SRand(S)*0.1,S)
            #end 
        #declare X=X+0.2;
        #end
#declare Z=Z+0.2;
#end  
  
/** STONES */  
#declare Z=-2*FORREST_SIZE;
#while(Z<2*FORREST_SIZE)
        #declare X=-6;
        #while(X<0)                
            #if(Height(X,Z)>-7.65 & Height(X,Z)<-7.55) 
            #declare NZ=Z+SRand(S)*0.4;
              sphere{
                <0,0,0>,0.2
                texture{
                        pigment{
                                bozo
                                color_map{
                                [0 color rgb RRand(1,10,S)/10]
                                [1 color rgb RRand(1,10,S)/10]}
                                turbulence 0.4
                                scale 0.1
                        }                
                        finish{
                                ambient 0
                                diffuse 0.7
                                specular 0.2
                                reflection 0.1
                        }
                }
                scale RRand(4,20,S)/20*z+x+y
                rotate RRand(4,30,S)*y
                translate <X,Height(X,NZ),NZ>
              }
            #end 
        #declare X=X+0.1;
        #end
#declare Z=Z+0.2;
#end      

#declare SNOWFLAKE=0;
#while (SNOWFLAKE<1200)
      sphere{               
        <RRand(0,10,S),-RRand(1,8,S),RRand(-10,10,S)>,0.03
        pigment{color red 1 green 1 blue 1 transmit 0.7} 
        finish{
                ambient 0.9
                diffuse 0.1    
                
        }
        no_shadow
      }
#declare SNOWFLAKE=SNOWFLAKE+1;
#end          

//Tree(7,seed(3454),0.5,0.2,1.2,1.4,-7*y,false,RRand(0,330,SS))