
// POV-Ray Object File - Bridge
// created 14-Dec-05
// last update 14-Dec-05
// 2005 Glenn McCarter  ( glenn@mccarters.net )
//
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// BridgeS // a simple iron bridge
// 
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Seat origin is at the intersection of base and back,
// with the height of the seat in +Z,
// and the pilot facing +X
//

#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here

//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare BridgeIronTex =
	texture {
		pigment { color rgb<.967,.877,.596>*0.30 }
		normal { bumps 0.24 scale 2.3 }
		finish { specular 0.2 roughness 0.24 }
	}


//===============================================
//             Macros
//===============================================


//===============================================
//             Objects
//===============================================

//#declare TruckShape = // origin at back of cab
//	union {
		

//===============================================
//             Bridge
//===============================================

#declare BridgeSide =
	height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
		png "BridgeHF1.png"
		smooth
		water_level 1/255
//		rotate x*90
		scale <1,-1,1>
		scale <400*Feet,8*Feet,100*Feet>
		texture { BridgeIronTex }
	}


#declare BridgeS =
	union {
		object { BridgeSide translate <0, 12*Feet,0>  }
		object { BridgeSide translate <0,-12*Feet,0> }
	} // end union

#declare Bridge2S = // double-size
	union {
		object { BridgeS }
		object { BridgeS scale <-1,1,1> translate <795*Feet,0,0> }
	} // end union

//===============================================
//             Viewpoint 01
//===============================================

#if (RenderMe = 1)

#declare TestSphere = sphere{ 0,12 pigment { color rgb<1,1,1> } }

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>

		angle 34
//		location  <-2*Feet, -450*Feet, 5*Feet> // overall
//		look_at <3*Feet,0*Feet,30*Feet>
		location  <23*Feet, -750*Feet, 250*Feet> // top down
		look_at <1*Feet,00*Feet,18*Feet>

	}

background { color rgb <0.276,0.567,0.982>*.97 } // sky blue
light_source
{ <140*Feet,-300*Feet,250*Feet>, 1.2
//  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}
light_source
{ <-140*Feet,-200*Feet,130*Feet>, <1.13,1.08,0.83>*.8
//  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}
plane { z,-0 pigment { checker rgb <.8,.8,1.0>, rgb <.8,.8,1.0>*.75 } scale 100*Feet }

//#include "GRuler.inc" // for testing only
//object { TestSphere scale 1 translate <0,0,10> }

object { Bridge2S rotate z*0 translate <-500*Feet,0,0> }


#end

