
// POV-Ray Object File - Hydroplane 01
// created 10-Dec-05
// last update 31-Dec-05
// 2005 Glenn McCarter  ( glenn@mccarters.net )
//
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// Hydroplane01
// 
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Boat origin is at the waterline at the back of the cockpit
// with the height of the tailfins in +Z,
// and the pilot facing +X
//

#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here
#include "Hydroplane01mesh.pov"

//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare BrightPaintTex =
	texture {
//		pigment { color rgb<.997,.831,.236>*1.4 }
		pigment { color rgb<.237,0.831,.036>*0.16 }
//		finish { specular 0.93 roughness 0.04 ambient 0.4 }
		finish { specular 0.93 roughness 0.04 ambient 0.4 reflection {0.18} }
	}
#declare WhitePaintTex =
	texture {
		pigment { color rgb<.997,.983,.997>*1.9 }
		finish { specular 0.93 roughness 0.04 ambient 0.2 }
	}
#declare GreyPaintTex =
	texture {
		pigment { color rgb<.997,.983,.997>*.5 }
		finish { specular 0.93 roughness 0.04 ambient 0.2 }
	}
#declare PlasticCanopyTex =
	texture {
		pigment { color rgbt<.967,.977,1.296,.854> }
		finish { specular 0.83 roughness 0.04 reflection 0.16 }
	}
#declare FirewallTex =
	texture {
		pigment { color rgb<.91,.91,1>*.42 }
		finish { specular 0.67 roughness .028 metallic }
	}
#declare ExhaustTubeTex =
	texture {
		pigment { color rgb<1,1,1>*.32 }
		normal { bumps 0.4 scale <20,5,5> }
		finish { specular 0.67 roughness .028 metallic }
	}
#declare BlackWireTex =
	texture {
		pigment { color rgb<.997,.983,.997>*.15 }
		normal { bumps 0.5 scale 0.6 }
		finish { specular 0.63 roughness 0.05 ambient 0.2 }
	}
#declare Steel1Tex =
	texture {
		pigment { color rgb<.91,.91,1>*.58 }
		finish { specular 0.27 roughness .028 metallic }
	}
#declare Steel2Tex =
	texture {
		pigment { color rgb<.943,.822,1.00>*.83 }
		finish { specular 0.67 roughness .018 metallic }
	}
#declare Steel2bTex =
	texture {
		pigment { color rgb<.943,.822,1.00>*.53 }
		normal { bumps 0.3 scale 4 }
		finish { specular 0.67 roughness .018 metallic }
	}
#declare Steel3Tex =
	texture {
		pigment { color rgb<.943,.822,1.00>*.22 }
		finish { specular 0.10 roughness .048 metallic }
	}
#declare Chrome1Tex =
	texture {
		pigment { color rgb<.943,.822,1.00>*.22 }
		finish { specular 0.10 roughness .048 metallic reflection 0.58 }
	}
#declare Bronze1Tex =
	texture {
		pigment { color rgb<.943,.822,.300>*.22 }
		finish { specular 0.10 roughness .048 metallic }
	}

#declare BodyTex = texture { WhitePaintTex }
#declare EngineShroudTex = texture { BrightPaintTex }
#declare CockpitTex = texture { BrightPaintTex }
#declare WindshieldTex = texture { PlasticCanopyTex }
#declare PontoonLTex = texture { BrightPaintTex }
#declare PontoonRTex = texture { BrightPaintTex }
#declare TailfinRTex = texture { BrightPaintTex }
#declare TailfinLTex = texture { BrightPaintTex }
#declare StabilizerTex = texture { BrightPaintTex }

#declare Hydroplane01_PaintPig =
	pigment {
		image_map { // image is always projected from -z, with front facing +z
		png "Hydroplane01_Paint.png"
		once
		}
		rotate z*-90
		translate <0,0.5,0>
	}
#declare Hydroplane01_PaintTex =
	texture {
		pigment { Hydroplane01_PaintPig
//			rotate <0,0,0>
//			translate <0,0,0>
			scale <34*Feet,20*Feet,1>
			translate <-4.5*Feet,1.5,0>
		}
		normal { bumps 0.03 scale 0.3 }
//		finish { specular 0.93 roughness 0.04 ambient 0.4 }
		finish { specular 0.93 roughness 0.04 ambient 0.4 reflection {0.15} }
	}
/*
#declare Hydroplane01_PaintTex =
	texture {
		pigment { color rgb<1,.9,.3> }
	}
*/

#declare StabilizerDecalTex =
	texture {
		pigment {
			image_map { // image is always projected from -z, with front facing +z
//			png "test_HX.png"
			png "Hydroplane01StabilizerDecals.png"
			once
			}
		rotate <90,-4,0>
		translate <0,-0.5,-0.5>
		}
		scale <2.6*Feet,1,2.6*Feet*640/320>
		translate <-14*Feet,0,0>
		scale 1/0.42 // match boat scaling
	}
#declare SideDecalTex =
	texture {
		pigment {
			image_map { // image is always projected from -z, with front facing +z
//			png "SideDecals.png"
			png "Hydroplane01SideDecals.png"
			once
			}
		rotate x*90
		translate <0,-0.5,-0.5>
		}
		scale <16*Feet,1,16*Feet*200/1000>
//		translate <-14*Feet,0,0>
//		scale 1/0.42 // match boat scaling
	}

//------------- Test only -----------------
#declare TTopTex =
	texture {
		pigment {
			image_map { // image is always projected from -z, with front facing +z
			png "test.png"
			once
			}
//		rotate z*-90
		translate <0,-0.5,0>
		}
		scale <6*Feet,4.01*Feet,1>
		translate <-0.5*Feet,0,0>
	}
#declare TDecalTex =
	texture {
		pigment {
			image_map { // image is always projected from -z, with front facing +z
//			png "test.png"
			png "test_HX.png"
			once
			}
		rotate x*90
		translate <0,-0.5,-0.5>
		}
		scale <1.8*Feet,1,1.1*Feet>
		translate <1.5*Feet,0,9>
	}
#declare TestBox =
	box {
		<0,-2*Feet,0>,<4*Feet,2*Feet,18>
		texture { TTopTex }
		texture { TDecalTex }
	}
//object { TestBox rotate x*24 translate <0,0,6> }
//object { TestBox rotate z*34 translate <-50,48,6> }


//===============================================
//             Macros
//===============================================


//===============================================
//             Objects
//===============================================

#declare ExhaustTube =
	difference {
		cylinder { <0,0,0>,<8*Feet,0,0>,15 }
		cylinder { <-1,0,0>,<8.1*Feet,0,0>,14.6 }
		box { <-20,-20,-20>,<0,20,20> rotate y*55 }
		texture { ExhaustTubeTex }
		scale <1,1,.9>
		translate <-12*Feet,0,-6>
//		rotate x*-90
		scale 1/0.42
	} // end difference

#declare Scoop =
	object { ScoopShape
		texture {
			pigment {
				gradient x
				color_map {
					[ 0.34 rgb<0.00,0.34,0,00>*.1 ]
					[ 0.85 rgb<0.00,0.34,0,00> ]
				}
				scale 130
				translate <-14.5*Feet,0,0>
			}
		}
	}

#declare FrontWindshield =
	difference {
//	union {
		object { Windshield }
		box { <6*Feet,-50,-50>,<17*Feet,50,50> }
		translate <0,0,-6>
	} // end difference


//------------ Cockpit Details ------------------

#declare Gage1 =
	union {
		cylinder { <0,0,0>,<4,0,0>,2.8 texture { Steel3Tex }}
		torus { 2.9,0.3 rotate z*90 scale <2,1,1> texture { Steel2Tex }}
	} // end union
#declare DashboardGroup =
	union {
		difference {
			sphere {
				<0,0,0>,15
				scale <1.8,1,.1>
			}
			box {
				<-28,-20,-6>,<-2,20,6>
			}
			texture { Steel1Tex }
		} // end difference
		object { Gage1 translate <4,4,5> }
		object { Gage1 translate <4,-4,5> }
		object { Gage1 scale 0.6 rotate z*20 translate <4,7.4,4> }
		box { <0,0,0>,<4,7,4> texture { pigment {rgb<1,1,1>*.08}} translate <12,0,0> }
		cylinder { <4,3,5.5>,<10,0,5.5>,0.5 texture { pigment {rgb<1,1,1>*.38}} translate <12,0,0> }
		cylinder { <4,5,5.5>,<10,5,5.5>,0.5 texture { pigment {rgb<1,1,1>*.38}} translate <12,0,0> }
		translate <8.2*Feet,0,-10> scale 1/.42 
	} // end union

#macro WhippingWire1(WRad)  // no x movement
	sphere_sweep {
		cubic_spline
		8,
		< 0, 0.0,-4>,WRad
		< 0, 0.0, 0>,WRad
		< 0,-2.0, 8>,WRad
		< 0,-3.0, 12>,WRad
		< 0, 3.0, 16>,WRad
		< 0, 5.3, 19>,WRad
		< 0, 3.1, 22>,WRad
		< 0,-1.4, 23>,WRad
		translate <4,4,-8>
		texture { BlackWireTex }
	}
#end
#macro WhippingWire2(WRad) // no x movement
	sphere_sweep {
		cubic_spline
		8,
		< 0, 0.0,-4>,WRad
		< 0, 0.0, 0>,WRad
		< 0, 1.4, 6>,WRad
		< 0,-2.2, 9>,WRad
		< 0,-1.6, 14>,WRad
		< 0, 3.9, 19>,WRad
		< 0, 4.6, 20>,WRad
		< 0, 0.4, 24>,WRad
		translate <4,4,-8>
		texture { BlackWireTex }
	}
#end

#macro LightIBeam(Length)
	union {
		difference {
			box { <-0.3,-2,0>,<0.3,2.0,Length> }
			#local N=4;
			#while (N<Length)
				cylinder { <-1,0,0>,<1,0,0>,1.2 translate <0,0,N> }
				#local N=N+4;
			#end
		} // end difference
		box { <-1.1,-0.2,0>,<1.1,0.2,Length> translate <0,-2,0> }
		box { <-1.1,-0.2,0>,<1.1,0.2,Length> translate <0, 2,0> }
		texture { Steel1Tex }
	} // end union
#end

#declare BigCyl =
	union {
		cylinder { <0,0,0>,<0,0,3.1>,2.9 texture { Steel3Tex } }
		cylinder { <0,0,0>,<0,0,22>,1.1 texture { Chrome1Tex } }
		cylinder { <0,0,18>,<0,0,30>,2.3 texture { Bronze1Tex } }
		cylinder { <0,0,30>,<0,0,32>,1.7 texture { Steel3Tex } }
	} // end union


#declare SeatRailGroup =
	union {
		object { LightIBeam(33) translate <0,-8,0> }
		object { LightIBeam(33) translate <0, 8,0> }
		object { LightIBeam(34) rotate y*95 translate <0,-4,3> }
		object { LightIBeam(34) rotate y*95 translate <0, 4,3> }
		object { BigCyl translate <2,-11,0> }
		object { BigCyl translate <2, 11,0> }
		box { <-12,-13,0>,<28, 13,0.5> texture { Steel3Tex } } // baseplate
		box { <-12, 13.6,0>,<54, 15.3,15> rotate <-6,8,-3> texture { Steel2Tex } } // side stiffener L
		box { <-12, 13.2,10>,<54, 15.0,13> rotate <-6,8,-3> texture { Steel2bTex } } // side stiffener L
		box { <-12, 13.2,5>,<54, 15.0,8> rotate <-6,8,-3> texture { Steel2bTex } } // side stiffener L
		box { <-12,-13.6,0>,<54,-15.3,15> rotate < 6,8, 3> texture { Steel2Tex } } // side stiffener R
		object { WhippingWire1(0.82) scale <1,1,1.22> rotate <5,0,74> translate <9,6,1> }
		object { WhippingWire1(0.41) scale <1,1,.80> rotate <-16,12,-120> translate <9,-6,1> }
		object { WhippingWire2(0.41) scale <1,1,.92> rotate <-18,12,-70> translate <10,-6,1> }
		object { WhippingWire2(0.41) scale <6,1,.32> rotate <-16,3,0> translate <4,-1,1> } // belt

		object { WhippingWire2(1.41) scale .34 rotate <-18,12, -70> translate <6.0,-2.0,1> } //cluster
		object { WhippingWire2(1.41) scale .34 rotate <-11, 0,  50> translate <6.2,-2.2,1> } //cluster
		object { WhippingWire2(1.41) scale .34 rotate < -8,42, 120> translate <6.4,-1.4,1> } //cluster
		object { WhippingWire2(1.41) scale .34 rotate < -3,12, 210> translate <6.6,-1.0,1> } //cluster

//     RoundedHalfBox2(Xlength,Ylength,Zlength,Radius) starts at <0,0,0> extending into positive zone
		object { RoundedHalfBox2(8,8,8,1.04) translate <-9,-4,24> texture { Steel1Tex } } // circuitbox
		cylinder { <0,0,-2>,<0,0,2>,1.3 translate <-4,1.5,24+8> texture { Steel1Tex } } // boxtop
		cylinder { <0,0,-2>,<0,0,2>,1.3 translate <-4,-2,24+8> texture { Steel1Tex } } // boxtop
		cylinder { <0,0,-29>,<0,0,2>,0.9 translate <-4,-1,24> texture { Steel1Tex } } // boxfeed

		cylinder { <-10,0,0>,<2,0,0>,2.3 translate <0,1.5,11> texture { Steel3Tex } }
		cylinder { <-10,4,0>,<2,4,0>,0.8 translate <0,0,14> texture { Steel3Tex } }
		rotate y*-8
		translate <3.8*Feet,0,-25> scale 1/.42 
	} // end union                          

//===============================================
//             Object Groups
//===============================================

#declare Hydroplane01 =
	union {

		#object { Body }
		#object { EngineShroud }
		#object { EngineShroud2 }

		#object { Scoop }
		#object { Cockpit }
		#object { Firewall texture { FirewallTex } }
		#object { SeatRailGroup }
		#object { DashboardGroup }


		#object { FrontWindshield texture { PlasticCanopyTex }}
		#object { FrontWindshield translate <0,0,-0.56> texture { PlasticCanopyTex }}

		#object { LeftPontoon }
		#object { RightPontoon }

//		box { <-56*Feet,-1,-80>,<8*Feet,1,12*Feet> texture { GreyPaintTex } texture { SideDecalTex }} // test vertical decals
//		box { <-56*Feet,-16*Feet,-80>,<8*Feet,16*Feet,12*Feet> texture { GreyPaintTex } texture { SideDecalTex }} // test vertical decals
//		box { <-56*Feet,-16*Feet,-80>,<8*Feet,16*Feet,12*Feet> } // test vertical decals
//		box { <-56*Feet,-16*Feet,-80>,<8*Feet,16*Feet,12*Feet> texture { Hydroplane01_PaintTex } texture { SideDecalTex } } // test vertical decals

		#object { LeftStabilizer texture { WhitePaintTex } texture { StabilizerDecalTex }}
		#object { LeftStabilizer2 }
		#object { RightStabilizer texture { WhitePaintTex } texture { StabilizerDecalTex }}
		#object { RightStabilizer2 }
		#object { HorizontalStabilizer }
		#object { ExhaustTube }

		scale 0.42 translate <12.5*Feet,0,40>
		texture { Hydroplane01_PaintTex }
		texture { SideDecalTex translate <-1*Feet,0,25> }
	} // end union


//===============================================
//             Viewpoint 01
//===============================================

#if (RenderMe = 1)
global_settings {	max_trace_level 150 }
#declare TestSphere = sphere{ 0,12 pigment { color rgb<1,1,1> } }

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>

		angle 40
		location  <14*Feet, -62*Feet, 32*Feet> // overall
		look_at <12*Feet,0*Feet,6*Feet>
//		location  <23*Feet, -224*Feet, 5235*Feet> // top down
//		look_at <30*Feet,20*Feet,18*Feet>
//		location  <13, -14*Feet, 5*Feet> // detail
//		look_at <0,0,24>
//		location  <3, -24*Feet, 5*Feet> // main wing
//		look_at <0,0,14*Feet>
//		location  <23*Feet,-5*Feet, 19*Feet> // upper RW
//		look_at <21*Feet,8*Feet,14*Feet>
//		location  <23*Feet,-25*Feet, 5*Feet> // lower RW
//		look_at <21*Feet,8*Feet,7*Feet>
//		location  <20*Feet, -20*Feet, 1*Feet> // down up view
//		look_at <10*Feet,0,4*Feet>

	}

background { color rgb <0.276,0.567,0.982>*.97 } // sky blue
light_source
{ <140*Feet,-300*Feet,250*Feet>, 1.2
//  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}
light_source
{ <-140*Feet,-200*Feet,130*Feet>, <1.13,1.08,0.83>*.8
//  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}
plane { z,-0 pigment { checker rgb <.8,.8,1.0>, rgb <.8,.8,1.0>*.75 } scale 10*Feet }

//#include "GRuler.inc" // for testing only
//object { TestSphere scale 1 translate <0,0,10> }
//object { Hydroplane01 rotate <0,0,0> translate <0,0,0> }

object { Hydroplane01 rotate <36,0,-40> translate <-5*Feet,0,76> }
object { Hydroplane01 rotate z*140 translate <-10*Feet,50*Feet,4*Feet> }
object { Hydroplane01 rotate z*20 translate <10*Feet,0*Feet,5*Feet> }
object { Hydroplane01 rotate <0,-10,-70> translate <20*Feet,30*Feet,7*Feet> }

#end

