
// POV-Ray Object File - Hydroplane 02
// created 10-Dec-05
// last update 30-Dec-05
// 2005 Glenn McCarter  ( glenn@mccarters.net )
//
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// Hydroplane02
// 
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Boat origin is at the waterline at the back of the cockpit
// with the height of the tailfins in +Z,
// and the pilot facing +X
//

#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here
#include "Hydroplane03mesh.pov"

//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare BrightPaintTex =
	texture {
		pigment { color rgb<.967,.077,.096>*0.783 }
		finish { specular 0.93 roughness 0.04 }
	}
#declare WhitePaintTex =
	texture {
		pigment { color rgb<.967,.977,.996>*0.93 }
		finish { specular 0.93 roughness 0.04 }
	}
#declare PlasticCanopyTex =
	texture {
		pigment { color rgbf<.967,.977,.996,.854> }
		finish { specular 0.83 roughness 0.04 reflection 0.36 }
	}
#declare FirewallTex =
	texture {
		pigment { color rgb<.91,.91,1>*.42 }
		finish { specular 0.67 roughness .028 metallic }
	}

#declare BodyTex = texture { WhitePaintTex }
#declare EngineShroudTex = texture { BrightPaintTex }
#declare CockpitTex = texture { BrightPaintTex }
#declare WindshieldTex = texture { PlasticCanopyTex }
#declare PontoonLTex = texture { BrightPaintTex }
#declare PontoonRTex = texture { BrightPaintTex }
#declare TailfinRTex = texture { WhitePaintTex }
#declare TailfinLTex = texture { WhitePaintTex }
#declare StabilizerTex = texture { WhitePaintTex }


//===============================================
//             Macros
//===============================================


//===============================================
//             Objects
//===============================================

#declare PilotS =
	union {
		sphere {
			<0,0,0>,7
			scale <1,.78,1>
		}
		cylinder {
			<0,0,-20>,<0,0,-6>,10
			scale <.5,1,1>
		}
		texture { pigment { rgb<1,1,1>*.22 } }
		rotate y*-20
		translate <3.2*Feet,0,-10>
		scale 1/13
	} // end union

#declare Scoop1T =
	object { Scoop
		texture {
			pigment {
				gradient x
				color_map {
					[ 0.34 rgb<0.60,0.34,0.33>*.1 ]
					[ 0.85 rgb<0.99,0.094,0.093> ]
				}
				scale 4.3
				translate <-10.2*Feet,0,0>
			}
		}
	}
#declare Scoop2T =
	object { Scoop2
		texture {
			pigment {
				gradient x
				color_map {
					[ 0.34 rgb<0.60,0.34,0.33>*.1 ]
					[ 0.85 rgb<0.99,0.094,0.093> ]
				}
				scale 4.3
				translate <-10.2*Feet,0,0>
			}
		}
	}

#declare Hydroplane02 =
	union {

		#object { Body texture { BodyTex }}
		#object { EngineShroud texture { EngineShroudTex }}
		#object { CockpitShape texture { CockpitTex }}
		#object { PilotS }
		#object { WindshieldSurf texture { WindshieldTex }}
		#object { LeftPontoon texture { PontoonLTex }}
		#object { RightPontoon texture { PontoonLTex }}
		#object { EngineShroud texture { EngineShroudTex } }
		#object { EngineShroud2 texture { EngineShroudTex } }
		#object { Firewall texture { FirewallTex } }
		#object { Scoop1T }
		#object { Scoop2T }
		#object { VWing texture { TailfinRTex }}
		scale 14 translate <0,0,3.6*Feet>
		texture { WhitePaintTex }
	} // end union


//===============================================
//             Viewpoint 01
//===============================================

#if (RenderMe = 1)

#declare TestSphere = sphere{ 0,12 pigment { color rgb<1,1,1> } }

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>

		angle 40
		location  <-2*Feet, -62*Feet, 15*Feet> // overall
		look_at <3*Feet,0*Feet,3*Feet>
//		location  <23*Feet, -224*Feet, 5235*Feet> // top down
//		look_at <30*Feet,20*Feet,18*Feet>
//		location  <3, -14*Feet, 5*Feet> // detail
//		look_at <0,0,46>
//		location  <3, -24*Feet, 5*Feet> // main wing
//		look_at <0,0,14*Feet>
//		location  <23*Feet,-5*Feet, 19*Feet> // upper RW
//		look_at <21*Feet,8*Feet,14*Feet>
//		location  <23*Feet,-25*Feet, 5*Feet> // lower RW
//		look_at <21*Feet,8*Feet,7*Feet>
//		location  <20*Feet, -20*Feet, 1*Feet> // down up view
//		look_at <10*Feet,0,4*Feet>

	}

background { color rgb <0.276,0.567,0.982>*.97 } // sky blue
light_source
{ <140*Feet,-300*Feet,250*Feet>, 1.2
//  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}
light_source
{ <-140*Feet,-200*Feet,130*Feet>, <1.13,1.08,0.83>*.8
//  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}
plane { z,-0 pigment { checker rgb <.8,.8,1.0>, rgb <.8,.8,1.0>*.75 } scale 10*Feet }

//#include "GRuler.inc" // for testing only
//object { TestSphere scale 1 translate <0,0,10> }

//object { Hydroplane02 scale .02 rotate z*0 translate <0,0,4*Feet> }
object { Hydroplane02 scale 1.00 rotate z*-110 translate < 10*Feet,20*Feet,4*Feet> }
object { Hydroplane02 scale 1.00 rotate <0,-0,-14> translate <0*Feet,0*Feet,0*Feet> }

#end

