
// POV-Ray Object File - Hydroplane 03
// created 10-Dec-05
// last update 31-Dec-05
// 2005 Glenn McCarter  ( glenn@mccarters.net )
//
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// Hydroplane03
// 
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Boat origin is at the waterline at the back of the cockpit
// with the height of the tailfins in +Z,
// and the pilot facing +X
//

#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here
#include "Hydroplane01mesh.pov"

//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare BrightPaintTex =
	texture {
//		pigment { color rgb<.997,.831,.236>*1.4 }
		pigment { color rgb<.237,0.831,.036>*0.16 }
//		finish { specular 0.93 roughness 0.04 ambient 0.4 }
		finish { specular 0.93 roughness 0.04 ambient 0.4 reflection {0.18} }
	}
#declare WhitePaintTex =
	texture {
		pigment { color rgb<.997,.983,.997>*1.9 }
		finish { specular 0.93 roughness 0.04 ambient 0.2 }
	}
#declare GreyPaintTex =
	texture {
		pigment { color rgb<.997,.983,.997>*.5 }
		finish { specular 0.93 roughness 0.04 ambient 0.2 }
	}
#declare PlasticCanopyTex =
	texture {
		pigment { color rgbt<.967,.977,1.296,.854> }
		finish { specular 0.83 roughness 0.04 reflection 0.16 }
	}
#declare FirewallTex =
	texture {
		pigment { color rgb<.91,.91,1>*.42 }
		finish { specular 0.67 roughness .028 metallic }
	}
#declare ExhaustTubeTex =
	texture {
		pigment { color rgb<1,1,1>*.32 }
		normal { bumps 0.4 scale <20,5,5> }
		finish { specular 0.67 roughness .028 metallic }
	}

#declare BodyTex = texture { WhitePaintTex }
#declare EngineShroudTex = texture { BrightPaintTex }
#declare CockpitTex = texture { BrightPaintTex }
#declare WindshieldTex = texture { PlasticCanopyTex }
#declare PontoonLTex = texture { BrightPaintTex }
#declare PontoonRTex = texture { BrightPaintTex }
#declare TailfinRTex = texture { BrightPaintTex }
#declare TailfinLTex = texture { BrightPaintTex }
#declare StabilizerTex = texture { BrightPaintTex }

#declare Hydroplane03_PaintPig =
	pigment {
		image_map { // image is always projected from -z, with front facing +z
		png "Hydroplane03_Paint.png"
		once
		}
		rotate z*-90
		translate <0,0.5,0>
	}
#declare Hydroplane03_PaintTex =
	texture {
		pigment { Hydroplane03_PaintPig
//			rotate <0,0,0>
//			translate <0,0,0>
			scale <34*Feet,20*Feet,1>
			translate <-4.5*Feet,1.5,0>
		}
		normal { bumps 0.03 scale 0.3 }
//		finish { specular 0.93 roughness 0.04 ambient 0.4 }
		finish { specular 0.93 roughness 0.04 ambient 0.14 reflection {0.15} }
	}

#declare StabilizerDecalTex =
	texture {
		pigment {
			image_map { // image is always projected from -z, with front facing +z
//			png "test_HX.png"
//			png "StabilizerDecalsH3.png"
			png "Hydroplane03StabilizerDecals.png"
			once
			}
		rotate x*90
		translate <0,-0.5,-0.5>
		}
		scale <5*Feet,1,5*Feet*3/4>
		translate <-16*Feet,0,10>
		scale 1/0.42 // match boat scaling
	}
#declare SideDecalTex =
	texture {
		pigment {
			image_map { // image is always projected from -z, with front facing +z
//			png "SideDecalsH3.png"
			png "Hydroplane03SideDecals.png"
			once
			}
		rotate x*90
		translate <0,-0.5,-0.5>
		}
		scale <16*Feet,1,16*Feet*200/1000>
//		translate <-14*Feet,0,0>
//		scale 1/0.42 // match boat scaling
	}

//------------- Test only -----------------
#declare TTopTex =
	texture {
		pigment {
			image_map { // image is always projected from -z, with front facing +z
			png "test.png"
			once
			}
//		rotate z*-90
		translate <0,-0.5,0>
		}
		scale <6*Feet,4.01*Feet,1>
		translate <-0.5*Feet,0,0>
	}
#declare TDecalTex =
	texture {
		pigment {
			image_map { // image is always projected from -z, with front facing +z
//			png "test.png"
			png "test_HX.png"
//			png "StabilizerDecalsH3.png"
			once
			}
		rotate x*90
		translate <0,-0.5,-0.5>
		}
		scale <1.8*Feet,1,1.1*Feet>
		translate <1.5*Feet,0,9>
	}
#declare TestBox =
	box {
		<0,-2*Feet,0>,<4*Feet,2*Feet,18>
		texture { TTopTex }
		texture { TDecalTex }
	}
//object { TestBox rotate x*24 translate <0,0,6> }
//object { TestBox rotate z*34 translate <-50,48,6> }


//===============================================
//             Macros
//===============================================


//===============================================
//             Objects
//===============================================

#declare ExhaustTube =
	difference {
		cylinder { <0,0,0>,<8*Feet,0,0>,15 }
		cylinder { <-1,0,0>,<8.1*Feet,0,0>,14.6 }
		box { <-20,-20,-20>,<0,20,20> rotate y*55 }
		texture { ExhaustTubeTex }
		scale <1,1,.9>
		translate <-12*Feet,0,-6>
//		rotate x*-90
		scale 1/0.42
	} // end difference

#declare Scoop =
	object { ScoopShape
		texture {
			pigment {
				gradient x
				color_map {
					[ 0.34 rgb<0.00,0.34,0.33>*.1 ]
					[ 0.85 rgb<0.30,0.34,0.63> ]
				}
				scale 130
				translate <-14.5*Feet,0,0>
			}
		}
	}

#declare FrontWindshield =
//	difference {
//	union {
		object { Windshield
//		box { <6*Feet,-50,-50>,<17*Feet,50,50> }
		translate <0,0,-6>
	} // end difference
#declare PilotS =
	union {
		sphere {
			<0,0,0>,7
			scale <1,.78,1>
		}
		cylinder {
			<0,0,-20>,<0,0,-6>,10
			scale <.5,1,1>
		}
		texture { pigment { rgb<1,1,1>*.22 } }
		rotate y*-20
		scale 1/.42
	} // end union

#declare Hydroplane03 =
	union {

		#object { Body }
		#object { EngineShroud }
		#object { EngineShroud2 }

		#object { Scoop }
		#object { Cockpit }
		#object { PilotS translate <10.5*Feet,0,0> }

		#object { Firewall texture { FirewallTex } }

		#object { FrontWindshield texture { PlasticCanopyTex }}
		#object { FrontWindshield translate <0,0,-0.56> texture { PlasticCanopyTex }}

		#object { LeftPontoon }
		#object { RightPontoon }

//		box { <-56*Feet,-1,-80>,<8*Feet,1,12*Feet> texture { GreyPaintTex } texture { SideDecalTex }} // test vertical decals
//		box { <-56*Feet,-16*Feet,-80>,<8*Feet,16*Feet,12*Feet> texture { GreyPaintTex } texture { SideDecalTex }} // test vertical decals
//		box { <-56*Feet,-16*Feet,-80>,<8*Feet,16*Feet,12*Feet> } // test vertical decals
//		box { <-56*Feet,-16*Feet,-80>,<8*Feet,16*Feet,12*Feet> texture { Hydroplane01_PaintTex } texture { SideDecalTex } } // test vertical decals

		#object { LeftStabilizer texture { WhitePaintTex } texture { StabilizerDecalTex }}
		#object { LeftStabilizer2 }
		#object { RightStabilizer texture { WhitePaintTex } texture { StabilizerDecalTex }}
		#object { RightStabilizer2 }
		#object { HorizontalStabilizer }
		#object { ExhaustTube }

		scale 0.42 translate <12.5*Feet,0,40>
		texture { Hydroplane03_PaintTex }
		texture { SideDecalTex translate <-1*Feet,0,25> }
	} // end union


//===============================================
//             Viewpoint 01
//===============================================

#if (RenderMe = 1)
global_settings {	max_trace_level 150 }
#declare TestSphere = sphere{ 0,12 pigment { color rgb<1,1,1> } }

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>

		angle 40
		location  <14*Feet, -62*Feet, 32*Feet> // overall
		look_at <12*Feet,0*Feet,6*Feet>
//		location  <23*Feet, -224*Feet, 5235*Feet> // top down
//		look_at <30*Feet,20*Feet,18*Feet>
//		location  <13, -14*Feet, 5*Feet> // detail
//		look_at <0,0,24>
//		location  <3, -24*Feet, 5*Feet> // main wing
//		look_at <0,0,14*Feet>
//		location  <23*Feet,-5*Feet, 19*Feet> // upper RW
//		look_at <21*Feet,8*Feet,14*Feet>
//		location  <23*Feet,-25*Feet, 5*Feet> // lower RW
//		look_at <21*Feet,8*Feet,7*Feet>
//		location  <20*Feet, -20*Feet, 1*Feet> // down up view
//		look_at <10*Feet,0,4*Feet>

	}

background { color rgb <0.276,0.567,0.982>*.97 } // sky blue
light_source
{ <140*Feet,-300*Feet,250*Feet>, 1.2
//  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}
light_source
{ <-140*Feet,-200*Feet,130*Feet>, <1.13,1.08,0.83>*.8
//  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}
plane { z,-0 pigment { checker rgb <.8,.8,1.0>, rgb <.8,.8,1.0>*.75 } scale 10*Feet }

//#include "GRuler.inc" // for testing only
//object { TestSphere scale 1 translate <0,0,10> }
//object { Hydroplane03 rotate <0,0,0> translate <0,0,0> }

//object { Hydroplane03 rotate <60,0,-40> translate <-5*Feet,0,76> }
object { Hydroplane03 rotate z*140 translate <-10*Feet,50*Feet,4*Feet> }
object { Hydroplane03 rotate z*180 translate <25*Feet,0*Feet,5*Feet> }
object { Hydroplane03 rotate <0,-10,-70> translate <20*Feet,30*Feet,7*Feet> }

#end

