
// Glenn's POV-Ray Scene File - Sea Surface
// created 21-Dec-05
// last update 25-Dec-05
//
// Copyright 2005 Glenn McCarter (glenn@mccarters.net). Some rights reserved.
// This work is licensed under the Creative Commons Attribution License. 
// To view a copy of this license, visit http://creativecommons.org/licenses/by/2.0/ 
// You are free:
// - to copy, distribute, display, and perform the work
// - to make derivative works
// - to make commercial use of the work
// Under the following conditions:
// - Attribution. You must give the original author credit.
// - For any reuse or distribution, you must make clear to others the license terms of this work.
// - Any of these conditions can be waived if you get permission from the copyright holder.
// Your fair use and other rights are in no way affected by the above. 
//
//
// This file creates a rough sea surface for use as height_field image map
//
//
// Scene uses LH coordinate system, Y = up.
// Scene origin is same location as origin in main scene
// with +X towards the right, and +y up


//===============================================
//             Scene Switches
//===============================================

// Set these to 1 for best render
#declare ThisIsMaster = 1; // declares this the Master File, leave at 1

// Leave these at 0
#declare RenderMe     = 0; // supresses self-rendering of the include files, leave at 0


#declare My_Cam = 1;
// 1=	Render_Cam
// 8=	Special_Cam

//===============================================
//             Global Settings
//===============================================

#version 3.5;
global_settings {
	adc_bailout 1/255 // default 1/255
	ambient_light <1.0,1.0,1.0> // default <1,1,1>, use 0 for radiosity
	assumed_gamma 1.0
	hf_gray_16 off
	irid_wavelength <0.25,0.18,0.14>
	max_intersections 64
	max_trace_level 150
	number_of_waves 13 // for ripple texture
	noise_generator 2
}


//===============================================
//             Includes
//===============================================

#include "GIncludeRH.inc" // Glenn's standard includes


//===============================================
//             Variables
//===============================================


//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
		orthographic
		direction <0.0,  0.0,  1.0> // default
		sky       <0.0,     0.0,  1.0>  // Use right handed-system
		up        <0.0,     0.0,  200*Feet>  // Where Z is up, ortho
		right     < -200*Feet, 0, 0>  // aspect ratio  1:1=1.00 square, ortho
	location <0,0,9999>
	look_at <0,0,0> // main render
}
#declare Special_Cam =
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <4/3,     0.0,  0.0>
//	angle 45 // render view
//	location CamPos
//	look_at <45*Feet,280*Feet,61*Feet> // right of main render
	angle 55
//	location <100*Feet,1200*Feet,200*Feet> // reverse angle
//	look_at <18*Feet,20*Feet,50*Feet>
//	angle 55
	location <0*Feet,-400*Feet,50*Feet> // backup from origin
	look_at <1*Feet,1*Feet,4*Feet>
//	angle 55
//	location <0*Feet,-2000*Feet,500*Feet> // backup overview
//	look_at <1*Feet,1*Feet,200*Feet>
//	angle 55
//	location <0*Feet,-5000*Feet,5000*Feet> // blimp
//	look_at <1*Feet,500*Feet,500*Feet>
	}

camera {
#switch (My_Cam)
#case (1) Render_Cam
#break
#else Special_Cam
#end
}

//===============================================
//             Textures
//===============================================


//===============================================
//             Lighting
//===============================================


#declare Sun =
	light_source {
		<0,0,0>
		color rgb <0.584,0.539,0.543>*2.3 // bluish
	}
/*
object { Sun
	translate <0,0,5*Miles> // noon at Equator: directly overhead
	rotate y*-33 // towards left
  rotate z*40 // behind camera
}
*/

//===============================================
//             Environment
//===============================================

background { color rgb <0.576,0.667,0.832>*.97 } // deep blue grey

#declare GroundPlane =
	plane { z,-0.1 pigment { checker rgb 1, rgb .75 } scale 10*Feet }
//object { GroundPlane }


#declare WaveNorm = // this is the boat chop
	normal {
//		ripples 0.1
//		frequency 10
//		scale 900
//			granite 0.2 scale 8*Feet
			granite 0.2 scale 24*Feet
	}
/*
#declare RippleNormOLD = // this is the nearby flatter area
	normal {
			granite 0.4 scale 3*Feet
//		function {
//			f_noise3d(x*3,y*3,z*3)*0.15
//			+f_noise3d(x*30,y*30,z*30)*0.3
//		}
//		scale <97,126,.2>
		scale <7,6,.2>
	}
*/
/*
#declare FlatNorm = // for testing
	normal {
		bumps 0.05
		scale <24*Feet,24*Feet,1>
	}
*/
#declare RippleNorm = // this is wake tracks
	normal {
//		function {
//			f_noise3d(x*3,y*3,z*3)*1.5 // *.15 invisible, *1.5 big ripply waves (needs smaller size & lower depth), *15 huge graininess
//			+f_noise3d(x*30,y*30,z*30)*0.2 //*30*1.5 quite small but deep, *30*0.2 quite small slightly too deep
//			+f_noise3d(x*6,y*6,z*6)*0.2 // nice quiet chop
//			+f_noise3d(x*6,y*6,z*6)*0.6 // best
//			+f_ripples(x*1,y*1,z*1)*1 // x*30*.5=teeny aliased dias, x*3*.5=small dia, x*.03*.5=none, 1*5=aliased, 1*50=aliased, 1*500=uniformly grainy
//			+f_ripples(x*1,y*1-100,z*1)*1 // large flat ripples
//			ripples 0.76
//			scale 400*Feet frequency 70
			bumps 0.24 scale 5*Feet
		}
//		scale <47,56,2>
//		scale <7,6,.2>
//	}
/*
#declare WaveNormTEST = // test
	normal {
		ripples 0.1
		frequency 50
		scale 900*3
		translate <350*Feet,800*Feet,0>
	}
*/

/*
		normal { 
//			WaveNorm scale 1
//			RippleNorm scale 1

			average
			normal_map {
				[ 1.0 RippleNorm ]
				[ 1.0 WaveNorm ]
			}
//			scale 6*Feet
*/

#declare ChoppyPig = // this is the boat chop
	pigment {
		granite
		color_map {
			[ 0.4 rgb<0,0,0> ]
			[ 1.0 rgb<1,1,1>*.34 ]
			}
		warp { turbulence 1.4 }
		scale 8*Feet

	}

#declare WavyPig = // this is wake tracks
	pigment {
		bumps
		color_map {
			[ 0.0 rgb<0,0,0> ]
			[ 1.0 rgb<1,1,1>*.5 ]
		}
		scale <10*Feet,18*Feet,1>
		rotate z*-30
	}

#declare SeaWaterHFTex =
	texture {
		pigment {
			average
			pigment_map {
				[ 1.0 WavyPig ]
				[ 1.0 ChoppyPig ]
			}
		}
		finish { ambient 1.0 }
	}
#declare SeaWaterHFTex2= // for testing
	texture {
		pigment { color rgb<1,1,.2> }
		normal { bumps 0.4 }
	}

#declare SeaWater =
	box {
//		<0*Feet,0*Feet,-10>,<51*Feet,51*Feet,0> // test
		<-101*Feet,-101*Feet,-10>,<101*Feet,101*Feet,0>
		texture { SeaWaterHFTex }
	}
//cone { <0,0,0>,30,<0,0,100>,0 texture { pigment { color rgb<1,.2,.2>}}} // test pointer

//===============================================
//             Object Groups
//===============================================




//===============================================
//             Object Placement
//===============================================

//object { GroundPlane }
object { SeaWater }


