
// POV-Ray Object File - Test Viewpoints
// created 15-Nov-05
// last update 16-Nov-05
// 2005 Glenn McCarter  ( glenn@mccarters.net )
//
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// FakeRoosterTail()
// HydroplaneS
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// RoosterTail origin is at the start of the tail,
// with the height of the plume in +Z,
// and the length of the plume in +X
//

//#declare ThisIsMaster = 1;
//	#include "GIncludeRH.inc"

#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
#include "Hydroplane01.inc"
#include "Hydroplane02.inc"
#include "Hydroplane03.inc"

#include "Canopy.inc"
#include "EjectionSeat.inc"

	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here

//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare FakeWaterTex =
	texture {
		pigment { color rgb<.967,.977,.996>*1.0 }
		normal { granite 0.35 scale 5 }
		finish { specular 0.3 roughness 0.24 diffuse 0.4 ambient 0.6 }
	}


//===============================================
//             Macros
//===============================================

// Rooster Tail Macro
// Variables
// TotNum = total number of spheres in the tail
// TurnRad = radius of plan-view curvature of boat path (meters)
// TTime = max time to calculate (seconds) (2.5 is good)
//     decrease to avoid having too much tail underwater
//     increase if tail ends before reaching water level
// Velocity = speed of the boat (m/s)
// RandomSeed makes this tail different than the next

#macro FakeRoosterTail(TurnRad,TotNum,TTime,Velocity,RandomSeed)
// RoosterTail is in XZ plane, with height in +Z and length in +X
// Boat makes left turns only!
//	#local RS = seed(20951);
	#local RS = seed(RandomSeed);
	union {
		#declare SphereNum = 1;
		#while (SphereNum<TotNum)
			#local Time = rand(RS)*TTime; // the instant for this sphere
			#local UpVel = (0.3+rand(RS)*.7)*Velocity*0.3; // upwards velocity
			// Max upwards velocity is some fraction boat speed; 0.4 factor corrects for this
			sphere { <0,0,0>,15+Time*20+Time*Time*15
				scale <1,1,3/(Time+1)>
//				translate <Time*UpVel*39.4,Time*Time*Time*(-100),(UpVel*Time-9.8*Time*Time)*39.4>
				// 39.4 is conversion factor to scene units (inches)

//				translate <0, TurnRad*39.4+(UpVel*Time*20),(UpVel*Time-9.8*Time*Time)*39.4>
//				translate <0, TurnRad*39.4,(UpVel*Time-9.8*Time*Time)*39.4>
//				translate <0, TurnRad*39.4+rand(RS)*Time*120,(UpVel*Time-9.8*Time*Time)*39.4>
				translate <
						0,
						TurnRad*39.4-rand(RS)*Time*150+(UpVel*Time-9.8*Time*Time)*9,
						(UpVel*Time-9.8*Time*Time)*39.4>

				rotate -z*1000*Time/TurnRad
				translate <0,-TurnRad*39.4,0>

			}
			#declare SphereNum = SphereNum+1;
		#end
		texture { FakeWaterTex }
	} // end union
#end


//===============================================
//             Boat
//===============================================

#declare HydroplaneS = // for testing
	union {
		box { <0,-20,-8>,<18*Feet,20,42> } // engine
		box { <30,-70,6>,<18*Feet,70,20> } // hull
		box { <12*Feet, 16,-8>,<26*Feet, 90,24> } // pontoon
		box { <12*Feet,-16,-8>,<26*Feet,-90,24> } // pontoon
		texture { pigment { rgb<1,.9,0.4> } }
	} // end union

//===============================================
//             Viewpoint 01
//===============================================
/*
#if (RenderMe = 1)

#declare TestSphere = sphere{ 0,12 texture { FakeWaterTex } }

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.12,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>

		angle 34
		location  <-23*Feet, -100*Feet, 10*Feet> // overall
		look_at <-2*Feet,0*Feet,10*Feet>
//		location  <23*Feet, -224*Feet, 5235*Feet> // top down
//		look_at <30*Feet,20*Feet,18*Feet>
//		location  <3, -14*Feet, 5*Feet> // detail
//		look_at <0,0,46>
//		location  <3, -24*Feet, 5*Feet> // main wing
//		look_at <0,0,14*Feet>
//		location  <23*Feet,-5*Feet, 19*Feet> // upper RW
//		look_at <21*Feet,8*Feet,14*Feet>
//		location  <23*Feet,-25*Feet, 5*Feet> // lower RW
//		look_at <21*Feet,8*Feet,7*Feet>
//		location  <20*Feet, -20*Feet, 1*Feet> // down up view
//		look_at <10*Feet,0,4*Feet>

	}

background { color rgb <0.576,0.667,0.832>*.97 } // deep blue grey
light_source
{ <140*Feet,-300*Feet,250*Feet>, 1.2
//  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}
light_source
{ <-140*Feet,-200*Feet,130*Feet>, <1.13,1.08,0.83>*.8
//  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}
plane { z,-0 pigment { rgb<.8,.8,1.0>*.75 } normal { bumps 0.3 scale .7*Feet} finish { reflection 0.14 } }

//#include "GRuler.inc" // for testing only
//object { TestSphere scale 1 translate <0,0,10> }
// FakeRoosterTail(TurnRad,TotNum,TTime,Velocity,RandomSeed)
object { HydroplaneS rotate x*-5 rotate z*(180+90)  translate <0*Feet,0*Feet,0>}
object { FakeRoosterTail(195,200,2.5,58,30495) rotate z*90 translate <0*Feet,0*Feet,0>}

object { HydroplaneS rotate z*(180+80) translate <-20*Feet,60*Feet,0>}
object { FakeRoosterTail(120,200,2.5,38,20394) rotate z*80 translate <-20*Feet,60*Feet,0>}

object { HydroplaneS rotate z*(180+45) translate <80*Feet,160*Feet,0>}
object { FakeRoosterTail(75,200,2.5,48,51056) rotate z*45 translate <80*Feet,160*Feet,0>}

#end
*/
/*
//===============================================
//             Viewpoint 02
//       Parallel paths
//===============================================

#if (RenderMe = 1)

#declare TestSphere = sphere{ 0,12 texture { FakeWaterTex } }

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>

		angle 24
		location  <33*Feet, -200*Feet, 10*Feet> // overall
		look_at <20*Feet,0*Feet,10*Feet>
//		location  <23*Feet, -224*Feet, 5235*Feet> // top down
//		look_at <30*Feet,20*Feet,18*Feet>
//		location  <3, -14*Feet, 5*Feet> // detail
//		look_at <0,0,46>
//		location  <3, -24*Feet, 5*Feet> // main wing
//		look_at <0,0,14*Feet>
//		location  <23*Feet,-5*Feet, 19*Feet> // upper RW
//		look_at <21*Feet,8*Feet,14*Feet>
//		location  <23*Feet,-25*Feet, 5*Feet> // lower RW
//		look_at <21*Feet,8*Feet,7*Feet>
//		location  <20*Feet, -20*Feet, 1*Feet> // down up view
//		look_at <10*Feet,0,4*Feet>

	}

background { color rgb <0.576,0.667,0.832>*.97 } // deep blue grey
light_source
{ <140*Feet,-300*Feet,250*Feet>, 1.2
//  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}
light_source
{ <-140*Feet,-200*Feet,130*Feet>, <1.13,1.08,0.83>*.8
//  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}
plane { z,-0 pigment { rgb<.4,.9,1.0>*.35 } normal { bumps 0.3 scale <9.7*Feet,.7*Feet,.7*Feet>} finish { reflection 0.14 } }

//#include "GRuler.inc" // for testing only
//object { TestSphere scale 1 translate <0,0,10> }
// FakeRoosterTail(TurnRad,TotNum,TTime,Velocity,RandomSeed)
object { HydroplaneS rotate x*-5 rotate z*(0)  translate <0*Feet,0*Feet,0>}
object { FakeRoosterTail(195,200,2.5,58,30495) rotate z*180 translate <0*Feet,0*Feet,0>}

object { HydroplaneS rotate z*(0) translate <10*Feet,60*Feet,0>}
object { FakeRoosterTail(120,200,2.5,38,20394) rotate z*180 translate <10*Feet,60*Feet,0>}

object { HydroplaneS rotate z*(0) translate <40*Feet,160*Feet,0>}
object { FakeRoosterTail(75,200,2.5,48,51056) rotate z*180 translate <40*Feet,160*Feet,0>}

#end
*/

//===============================================
//             Viewpoint 03
//       Impending wreck
//===============================================

#if (RenderMe = 1)


#declare TestSphere = sphere{ 0,12 texture { FakeWaterTex } }

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.12,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>

		angle 34
		location  <-23*Feet, -100*Feet, 10*Feet> // overall
		look_at <-2*Feet,0*Feet,16*Feet>
//		location  <23*Feet, -224*Feet, 5235*Feet> // top down
//		look_at <30*Feet,20*Feet,18*Feet>
//		location  <3, -14*Feet, 5*Feet> // detail
//		look_at <0,0,46>
//		location  <3, -24*Feet, 5*Feet> // main wing
//		look_at <0,0,14*Feet>
//		location  <23*Feet,-5*Feet, 19*Feet> // upper RW
//		look_at <21*Feet,8*Feet,14*Feet>
//		location  <23*Feet,-25*Feet, 5*Feet> // lower RW
//		look_at <21*Feet,8*Feet,7*Feet>
//		location  <20*Feet, -20*Feet, 1*Feet> // down up view
//		look_at <10*Feet,0,4*Feet>

	}

background { color rgb <0.576,0.667,0.832>*.97 } // deep blue grey

light_source // sun
//{ <-2400*Feet,-1300*Feet,2500*Feet>, 1.2 // too light
{ <-1100*Feet,-1800*Feet,2500*Feet>, 1.2 // just right!
//{ <-300*Feet,-2400*Feet,2500*Feet>, 1.2 // too dark
//  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}


light_source // fill
{ <-140*Feet,-140*Feet,3*Feet>, <1.13,1.08,0.83>*.4
	area_light
	<-40*Feet,40*Feet,0>, <0,0,40*Feet>,4,4
//  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}

plane { z,-0 pigment { rgb<.8,.8,1.0>*.75 } normal { bumps 0.3 scale .7*Feet} finish { reflection 0.14 } }


//#include "GRuler.inc" // for testing only
//object { TestSphere scale 1 translate <0,0,10> }
// FakeRoosterTail(TurnRad,TotNum,TTime,Velocity,RandomSeed)
object { Hydroplane01 rotate x*125 rotate y*-20 rotate z*(180+90)  translate <6*Feet,-6*Feet,11*Feet>}
object { FakeRoosterTail(195,200,2.5,58,30495) rotate z*90 translate <0*Feet,0*Feet,0>}

object { Hydroplane02 rotate z*(180+80) translate <-20*Feet,60*Feet,0>}
object { FakeRoosterTail(120,200,2.5,38,20394) rotate z*80 translate <-20*Feet,60*Feet,0>}

object { Hydroplane03 rotate z*(180+45) translate <80*Feet,160*Feet,0>}
object { FakeRoosterTail(75,200,2.5,48,51056) rotate z*45 translate <80*Feet,160*Feet,0>}

object { EjectionSeatS rotate <18,-18,-120> translate <-14*Feet,0*Feet,38*Feet> }
object { CanopyS rotate <120,0,120> translate <-10*Feet,38*Feet,19*Feet> }

#end
